/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.controllers.desktop.support;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.controllers.ControllerListener;
import com.badlogic.gdx.controllers.desktop.JamepadControllerManager;
import com.badlogic.gdx.controllers.desktop.support.JamepadController;
import com.badlogic.gdx.controllers.desktop.support.JamepadControllerMonitor$Tuple;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntMap;
import com.studiohartman.jamepad.ControllerIndex;
import com.studiohartman.jamepad.ControllerManager;

public class JamepadControllerMonitor
implements Runnable {
    private final ControllerManager controllerManager;
    private final ControllerListener listener;
    private final IntMap<JamepadControllerMonitor$Tuple> indexToController = new IntMap();
    private final IntArray disconnectedControllers = new IntArray();

    public JamepadControllerMonitor(ControllerManager controllerManager, ControllerListener controllerListener) {
        this.controllerManager = controllerManager;
        this.listener = controllerListener;
    }

    @Override
    public void run() {
        this.controllerManager.update();
        this.checkForNewControllers();
        this.update();
        Gdx.app.postRunnable(this);
    }

    private void checkForNewControllers() {
        int n2 = JamepadControllerManager.jamepadConfiguration.maxNumControllers;
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                ControllerIndex controllerIndex = this.controllerManager.getControllerIndex(i2);
                if (this.indexToController.containsKey(controllerIndex.getIndex()) || !controllerIndex.isConnected()) continue;
                JamepadControllerMonitor$Tuple jamepadControllerMonitor$Tuple = new JamepadControllerMonitor$Tuple(this, controllerIndex);
                jamepadControllerMonitor$Tuple.controller.addListener(this.listener);
                this.indexToController.put(controllerIndex.getIndex(), jamepadControllerMonitor$Tuple);
                this.listener.connected(jamepadControllerMonitor$Tuple.controller);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    private void update() {
        this.disconnectedControllers.clear();
        for (JamepadControllerMonitor$Tuple jamepadControllerMonitor$Tuple : this.indexToController.values()) {
            JamepadController jamepadController = jamepadControllerMonitor$Tuple.controller;
            boolean bl = jamepadController.update();
            if (bl) continue;
            this.disconnectedControllers.add(jamepadControllerMonitor$Tuple.index.getIndex());
        }
        for (int i2 = 0; i2 < this.disconnectedControllers.size; ++i2) {
            this.indexToController.remove(this.disconnectedControllers.get(i2));
        }
    }
}

