/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.CubemapLoader$CubemapParameter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Cubemap$1;
import com.badlogic.gdx.graphics.CubemapData;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.TextureData$Factory;
import com.badlogic.gdx.graphics.glutils.FacedCubemapData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Cubemap
extends GLTexture {
    private static AssetManager assetManager;
    static final Map<Application, Array<Cubemap>> managedCubemaps;
    protected CubemapData data;

    public Cubemap(CubemapData cubemapData) {
        super(34067);
        this.data = cubemapData;
        this.load(cubemapData);
        if (cubemapData.isManaged()) {
            Cubemap.addManagedCubemap(Gdx.app, this);
        }
    }

    public Cubemap(FileHandle fileHandle, FileHandle fileHandle2, FileHandle fileHandle3, FileHandle fileHandle4, FileHandle fileHandle5, FileHandle fileHandle6) {
        this(fileHandle, fileHandle2, fileHandle3, fileHandle4, fileHandle5, fileHandle6, false);
    }

    public Cubemap(FileHandle fileHandle, FileHandle fileHandle2, FileHandle fileHandle3, FileHandle fileHandle4, FileHandle fileHandle5, FileHandle fileHandle6, boolean bl) {
        this(TextureData$Factory.loadFromFile(fileHandle, bl), TextureData$Factory.loadFromFile(fileHandle2, bl), TextureData$Factory.loadFromFile(fileHandle3, bl), TextureData$Factory.loadFromFile(fileHandle4, bl), TextureData$Factory.loadFromFile(fileHandle5, bl), TextureData$Factory.loadFromFile(fileHandle6, bl));
    }

    public Cubemap(Pixmap pixmap, Pixmap pixmap2, Pixmap pixmap3, Pixmap pixmap4, Pixmap pixmap5, Pixmap pixmap6) {
        this(pixmap, pixmap2, pixmap3, pixmap4, pixmap5, pixmap6, false);
    }

    public Cubemap(Pixmap pixmap, Pixmap pixmap2, Pixmap pixmap3, Pixmap pixmap4, Pixmap pixmap5, Pixmap pixmap6, boolean bl) {
        this(pixmap == null ? null : new PixmapTextureData(pixmap, null, bl, false), pixmap2 == null ? null : new PixmapTextureData(pixmap2, null, bl, false), pixmap3 == null ? null : new PixmapTextureData(pixmap3, null, bl, false), pixmap4 == null ? null : new PixmapTextureData(pixmap4, null, bl, false), pixmap5 == null ? null : new PixmapTextureData(pixmap5, null, bl, false), pixmap6 == null ? null : new PixmapTextureData(pixmap6, null, bl, false));
    }

    public Cubemap(int n2, int n3, int n4, Pixmap$Format pixmap$Format) {
        this(new PixmapTextureData(new Pixmap(n4, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n4, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n4, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n4, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true), new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true));
    }

    public Cubemap(TextureData textureData, TextureData textureData2, TextureData textureData3, TextureData textureData4, TextureData textureData5, TextureData textureData6) {
        this(new FacedCubemapData(textureData, textureData2, textureData3, textureData4, textureData5, textureData6));
    }

    public void load(CubemapData cubemapData) {
        if (!cubemapData.isPrepared()) {
            cubemapData.prepare();
        }
        this.bind();
        Cubemap cubemap = this;
        cubemap.unsafeSetFilter(cubemap.minFilter, this.magFilter, true);
        Cubemap cubemap2 = this;
        cubemap2.unsafeSetWrap(cubemap2.uWrap, this.vWrap, true);
        Cubemap cubemap3 = this;
        cubemap3.unsafeSetAnisotropicFilter(cubemap3.anisotropicFilterLevel, true);
        cubemapData.consumeCubemapData();
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    public CubemapData getCubemapData() {
        return this.data;
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload an unmanaged Cubemap");
        }
        this.glHandle = Gdx.gl.glGenTexture();
        Cubemap cubemap = this;
        cubemap.load(cubemap.data);
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedCubemaps.get(Gdx.app) != null) {
            managedCubemaps.get(Gdx.app).removeValue(this, true);
        }
    }

    private static void addManagedCubemap(Application application, Cubemap cubemap) {
        Array<Cubemap> array = managedCubemaps.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(cubemap);
        managedCubemaps.put(application, array);
    }

    public static void clearAllCubemaps(Application application) {
        managedCubemaps.remove(application);
    }

    public static void invalidateAllCubemaps(Application object) {
        if ((object = managedCubemaps.get(object)) == null) {
            return;
        }
        if (assetManager == null) {
            for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
                Cubemap cubemap = (Cubemap)((Array)object).get(i2);
                cubemap.reload();
            }
            return;
        }
        assetManager.finishLoading();
        Array array = new Array(object);
        for (Cubemap cubemap : array) {
            String string = assetManager.getAssetFileName(cubemap);
            if (string == null) {
                cubemap.reload();
                continue;
            }
            int n2 = assetManager.getReferenceCount(string);
            assetManager.setReferenceCount(string, 0);
            cubemap.glHandle = 0;
            CubemapLoader$CubemapParameter cubemapLoader$CubemapParameter = new CubemapLoader$CubemapParameter();
            new CubemapLoader$CubemapParameter().cubemapData = cubemap.getCubemapData();
            cubemapLoader$CubemapParameter.minFilter = cubemap.getMinFilter();
            cubemapLoader$CubemapParameter.magFilter = cubemap.getMagFilter();
            cubemapLoader$CubemapParameter.wrapU = cubemap.getUWrap();
            cubemapLoader$CubemapParameter.wrapV = cubemap.getVWrap();
            cubemapLoader$CubemapParameter.cubemap = cubemap;
            cubemapLoader$CubemapParameter.loadedCallback = new Cubemap$1(n2);
            assetManager.unload(string);
            cubemap.glHandle = Gdx.gl.glGenTexture();
            assetManager.load(string, Cubemap.class, cubemapLoader$CubemapParameter);
        }
        ((Array)object).clear();
        ((Array)object).addAll(array);
    }

    public static void setAssetManager(AssetManager assetManager) {
        Cubemap.assetManager = assetManager;
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed cubemap/app: { ");
        for (Application application : managedCubemaps.keySet()) {
            stringBuilder.append(Cubemap.managedCubemaps.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedCubemaps() {
        return Cubemap.managedCubemaps.get((Object)Gdx.app).size;
    }

    static {
        managedCubemaps = new HashMap<Application, Array<Cubemap>>();
    }
}

