/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.Texture$TextureWrap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.TextureData$TextureDataType;
import com.badlogic.gdx.graphics.glutils.MipMapGenerator;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public abstract class GLTexture
implements Disposable {
    public final int glTarget;
    protected int glHandle;
    protected Texture$TextureFilter minFilter = Texture$TextureFilter.Nearest;
    protected Texture$TextureFilter magFilter = Texture$TextureFilter.Nearest;
    protected Texture$TextureWrap uWrap = Texture$TextureWrap.ClampToEdge;
    protected Texture$TextureWrap vWrap = Texture$TextureWrap.ClampToEdge;
    protected float anisotropicFilterLevel = 1.0f;
    private static float maxAnisotropicFilterLevel = 0.0f;

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract int getDepth();

    public GLTexture(int n2) {
        this(n2, Gdx.gl.glGenTexture());
    }

    public GLTexture(int n2, int n3) {
        this.glTarget = n2;
        this.glHandle = n3;
    }

    public abstract boolean isManaged();

    protected abstract void reload();

    public void bind() {
        Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    public void bind(int n2) {
        Gdx.gl.glActiveTexture(n2 + 33984);
        Gdx.gl.glBindTexture(this.glTarget, this.glHandle);
    }

    public Texture$TextureFilter getMinFilter() {
        return this.minFilter;
    }

    public Texture$TextureFilter getMagFilter() {
        return this.magFilter;
    }

    public Texture$TextureWrap getUWrap() {
        return this.uWrap;
    }

    public Texture$TextureWrap getVWrap() {
        return this.vWrap;
    }

    public int getTextureObjectHandle() {
        return this.glHandle;
    }

    public void unsafeSetWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2) {
        this.unsafeSetWrap(texture$TextureWrap, texture$TextureWrap2, false);
    }

    public void unsafeSetWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2, boolean bl) {
        if (texture$TextureWrap != null && (bl || this.uWrap != texture$TextureWrap)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10242, texture$TextureWrap.getGLEnum());
            this.uWrap = texture$TextureWrap;
        }
        if (texture$TextureWrap2 != null && (bl || this.vWrap != texture$TextureWrap2)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10243, texture$TextureWrap2.getGLEnum());
            this.vWrap = texture$TextureWrap2;
        }
    }

    public void setWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2) {
        this.uWrap = texture$TextureWrap;
        this.vWrap = texture$TextureWrap2;
        this.bind();
        Gdx.gl.glTexParameteri(this.glTarget, 10242, texture$TextureWrap.getGLEnum());
        Gdx.gl.glTexParameteri(this.glTarget, 10243, texture$TextureWrap2.getGLEnum());
    }

    public void unsafeSetFilter(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2) {
        this.unsafeSetFilter(texture$TextureFilter, texture$TextureFilter2, false);
    }

    public void unsafeSetFilter(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2, boolean bl) {
        if (texture$TextureFilter != null && (bl || this.minFilter != texture$TextureFilter)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10241, texture$TextureFilter.getGLEnum());
            this.minFilter = texture$TextureFilter;
        }
        if (texture$TextureFilter2 != null && (bl || this.magFilter != texture$TextureFilter2)) {
            Gdx.gl.glTexParameteri(this.glTarget, 10240, texture$TextureFilter2.getGLEnum());
            this.magFilter = texture$TextureFilter2;
        }
    }

    public void setFilter(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2) {
        this.minFilter = texture$TextureFilter;
        this.magFilter = texture$TextureFilter2;
        this.bind();
        Gdx.gl.glTexParameteri(this.glTarget, 10241, texture$TextureFilter.getGLEnum());
        Gdx.gl.glTexParameteri(this.glTarget, 10240, texture$TextureFilter2.getGLEnum());
    }

    public float unsafeSetAnisotropicFilter(float f2) {
        return this.unsafeSetAnisotropicFilter(f2, false);
    }

    public float unsafeSetAnisotropicFilter(float f2, boolean bl) {
        float f3 = GLTexture.getMaxAnisotropicFilterLevel();
        if (f3 == 1.0f) {
            return 1.0f;
        }
        f2 = Math.min(f2, f3);
        if (!bl && MathUtils.isEqual(f2, this.anisotropicFilterLevel, 0.1f)) {
            return this.anisotropicFilterLevel;
        }
        Gdx.gl20.glTexParameterf(3553, 34046, f2);
        this.anisotropicFilterLevel = f2;
        return this.anisotropicFilterLevel;
    }

    public float setAnisotropicFilter(float f2) {
        float f3 = GLTexture.getMaxAnisotropicFilterLevel();
        if (f3 == 1.0f) {
            return 1.0f;
        }
        if (MathUtils.isEqual(f2 = Math.min(f2, f3), this.anisotropicFilterLevel, 0.1f)) {
            return f2;
        }
        this.bind();
        Gdx.gl20.glTexParameterf(3553, 34046, f2);
        this.anisotropicFilterLevel = f2;
        return this.anisotropicFilterLevel;
    }

    public float getAnisotropicFilter() {
        return this.anisotropicFilterLevel;
    }

    public static float getMaxAnisotropicFilterLevel() {
        if (maxAnisotropicFilterLevel > 0.0f) {
            return maxAnisotropicFilterLevel;
        }
        if (Gdx.graphics.supportsExtension("GL_EXT_texture_filter_anisotropic")) {
            FloatBuffer floatBuffer = BufferUtils.newFloatBuffer(16);
            ((Buffer)floatBuffer).position(0);
            FloatBuffer floatBuffer2 = floatBuffer;
            ((Buffer)floatBuffer2).limit(floatBuffer2.capacity());
            Gdx.gl20.glGetFloatv(34047, floatBuffer);
            maxAnisotropicFilterLevel = floatBuffer.get(0);
            return maxAnisotropicFilterLevel;
        }
        maxAnisotropicFilterLevel = 1.0f;
        return 1.0f;
    }

    protected void delete() {
        if (this.glHandle != 0) {
            Gdx.gl.glDeleteTexture(this.glHandle);
            this.glHandle = 0;
        }
    }

    @Override
    public void dispose() {
        this.delete();
    }

    protected static void uploadImageData(int n2, TextureData textureData) {
        GLTexture.uploadImageData(n2, textureData, 0);
    }

    public static void uploadImageData(int n2, TextureData textureData, int n3) {
        Object object;
        if (textureData == null) {
            return;
        }
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        if ((object = textureData.getType()) == TextureData$TextureDataType.Custom) {
            textureData.consumeCustomData(n2);
            return;
        }
        object = textureData.consumePixmap();
        boolean bl = textureData.disposePixmap();
        if (textureData.getFormat() != ((Pixmap)object).getFormat()) {
            Pixmap pixmap = new Pixmap(((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), textureData.getFormat());
            pixmap.setBlending(Pixmap$Blending.None);
            pixmap.drawPixmap((Pixmap)object, 0, 0, 0, 0, ((Pixmap)object).getWidth(), ((Pixmap)object).getHeight());
            if (textureData.disposePixmap()) {
                ((Pixmap)object).dispose();
            }
            object = pixmap;
            bl = true;
        }
        Gdx.gl.glPixelStorei(3317, 1);
        if (textureData.useMipMaps()) {
            Object object2 = object;
            MipMapGenerator.generateMipMap(n2, (Pixmap)object2, ((Pixmap)object2).getWidth(), ((Pixmap)object).getHeight());
        } else {
            Gdx.gl.glTexImage2D(n2, n3, ((Pixmap)object).getGLInternalFormat(), ((Pixmap)object).getWidth(), ((Pixmap)object).getHeight(), 0, ((Pixmap)object).getGLFormat(), ((Pixmap)object).getGLType(), ((Pixmap)object).getPixels());
        }
        if (bl) {
            ((Pixmap)object).dispose();
        }
    }
}

