/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Net$HttpRequest;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Pixmap$1;
import com.badlogic.gdx.graphics.Pixmap$Blending;
import com.badlogic.gdx.graphics.Pixmap$DownloadPixmapResponseListener;
import com.badlogic.gdx.graphics.Pixmap$Filter;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.g2d.Gdx2DPixmap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class Pixmap
implements Disposable {
    private Pixmap$Blending blending;
    private Pixmap$Filter filter;
    final Gdx2DPixmap pixmap;
    int color;
    private boolean disposed;

    public static Pixmap createFromFrameBuffer(int n2, int n3, int n4, int n5) {
        Gdx.gl.glPixelStorei(3333, 1);
        Pixmap pixmap = new Pixmap(n4, n5, Pixmap$Format.RGBA8888);
        ByteBuffer byteBuffer = pixmap.getPixels();
        Gdx.gl.glReadPixels(n2, n3, n4, n5, 6408, 5121, byteBuffer);
        return pixmap;
    }

    public void setBlending(Pixmap$Blending pixmap$Blending) {
        this.blending = pixmap$Blending;
        this.pixmap.setBlend(pixmap$Blending == Pixmap$Blending.None ? 0 : 1);
    }

    public void setFilter(Pixmap$Filter pixmap$Filter) {
        this.filter = pixmap$Filter;
        this.pixmap.setScale(pixmap$Filter == Pixmap$Filter.NearestNeighbour ? 0 : 1);
    }

    public Pixmap(int n2, int n3, Pixmap$Format pixmap$Format) {
        this.blending = Pixmap$Blending.SourceOver;
        this.filter = Pixmap$Filter.BiLinear;
        this.color = 0;
        this.pixmap = new Gdx2DPixmap(n2, n3, Pixmap$Format.toGdx2DPixmapFormat(pixmap$Format));
        this.setColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.fill();
    }

    public Pixmap(byte[] byArray, int n2, int n3) {
        this.blending = Pixmap$Blending.SourceOver;
        this.filter = Pixmap$Filter.BiLinear;
        this.color = 0;
        try {
            this.pixmap = new Gdx2DPixmap(byArray, n2, n3, 0);
            return;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load pixmap from image data", iOException);
        }
    }

    public Pixmap(ByteBuffer byteBuffer, int n2, int n3) {
        this.blending = Pixmap$Blending.SourceOver;
        this.filter = Pixmap$Filter.BiLinear;
        this.color = 0;
        if (!byteBuffer.isDirect()) {
            throw new GdxRuntimeException("Couldn't load pixmap from non-direct ByteBuffer");
        }
        try {
            this.pixmap = new Gdx2DPixmap(byteBuffer, n2, n3, 0);
            return;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Couldn't load pixmap from image data", iOException);
        }
    }

    public Pixmap(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2 = byteBuffer;
        this(byteBuffer2, byteBuffer2.position(), byteBuffer.remaining());
    }

    public Pixmap(FileHandle fileHandle) {
        this.blending = Pixmap$Blending.SourceOver;
        this.filter = Pixmap$Filter.BiLinear;
        this.color = 0;
        try {
            byte[] byArray = fileHandle.readBytes();
            this.pixmap = new Gdx2DPixmap(byArray, 0, byArray.length, 0);
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't load file: " + fileHandle, exception);
        }
    }

    public Pixmap(Gdx2DPixmap gdx2DPixmap) {
        this.blending = Pixmap$Blending.SourceOver;
        this.filter = Pixmap$Filter.BiLinear;
        this.color = 0;
        this.pixmap = gdx2DPixmap;
    }

    public static void downloadFromUrl(String string, Pixmap$DownloadPixmapResponseListener pixmap$DownloadPixmapResponseListener) {
        Net$HttpRequest net$HttpRequest = new Net$HttpRequest("GET");
        net$HttpRequest.setUrl(string);
        Gdx.net.sendHttpRequest(net$HttpRequest, new Pixmap$1(pixmap$DownloadPixmapResponseListener));
    }

    public void setColor(int n2) {
        this.color = n2;
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        this.color = Color.rgba8888(f2, f3, f4, f5);
    }

    public void setColor(Color color) {
        this.color = Color.rgba8888(color.r, color.g, color.b, color.a);
    }

    public void fill() {
        this.pixmap.clear(this.color);
    }

    public void drawLine(int n2, int n3, int n4, int n5) {
        this.pixmap.drawLine(n2, n3, n4, n5, this.color);
    }

    public void drawRectangle(int n2, int n3, int n4, int n5) {
        this.pixmap.drawRect(n2, n3, n4, n5, this.color);
    }

    public void drawPixmap(Pixmap pixmap, int n2, int n3) {
        this.drawPixmap(pixmap, n2, n3, 0, 0, pixmap.getWidth(), pixmap.getHeight());
    }

    public void drawPixmap(Pixmap pixmap, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pixmap.drawPixmap(pixmap.pixmap, n4, n5, n2, n3, n6, n7);
    }

    public void drawPixmap(Pixmap pixmap, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.pixmap.drawPixmap(pixmap.pixmap, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void fillRectangle(int n2, int n3, int n4, int n5) {
        this.pixmap.fillRect(n2, n3, n4, n5, this.color);
    }

    public void drawCircle(int n2, int n3, int n4) {
        this.pixmap.drawCircle(n2, n3, n4, this.color);
    }

    public void fillCircle(int n2, int n3, int n4) {
        this.pixmap.fillCircle(n2, n3, n4, this.color);
    }

    public void fillTriangle(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.pixmap.fillTriangle(n2, n3, n4, n5, n6, n7, this.color);
    }

    public int getPixel(int n2, int n3) {
        return this.pixmap.getPixel(n2, n3);
    }

    public int getWidth() {
        return this.pixmap.getWidth();
    }

    public int getHeight() {
        return this.pixmap.getHeight();
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            Gdx.app.error("Pixmap", "Pixmap already disposed!");
            return;
        }
        this.pixmap.dispose();
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void drawPixel(int n2, int n3) {
        this.pixmap.setPixel(n2, n3, this.color);
    }

    public void drawPixel(int n2, int n3, int n4) {
        this.pixmap.setPixel(n2, n3, n4);
    }

    public int getGLFormat() {
        return this.pixmap.getGLFormat();
    }

    public int getGLInternalFormat() {
        return this.pixmap.getGLInternalFormat();
    }

    public int getGLType() {
        return this.pixmap.getGLType();
    }

    public ByteBuffer getPixels() {
        if (this.disposed) {
            throw new GdxRuntimeException("Pixmap already disposed");
        }
        return this.pixmap.getPixels();
    }

    public void setPixels(ByteBuffer byteBuffer) {
        ByteBuffer byteBuffer2;
        if (!byteBuffer.isDirect()) {
            throw new GdxRuntimeException("Couldn't setPixels from non-direct ByteBuffer");
        }
        ByteBuffer byteBuffer3 = byteBuffer2 = this.pixmap.getPixels();
        BufferUtils.copy(byteBuffer, byteBuffer3, byteBuffer3.limit());
    }

    public Pixmap$Format getFormat() {
        return Pixmap$Format.fromGdx2DPixmapFormat(this.pixmap.getFormat());
    }

    public Pixmap$Blending getBlending() {
        return this.blending;
    }

    public Pixmap$Filter getFilter() {
        return this.filter;
    }
}

