/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureParameter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.Texture$1;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.TextureData$Factory;
import com.badlogic.gdx.graphics.glutils.FileTextureData;
import com.badlogic.gdx.graphics.glutils.PixmapTextureData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Texture
extends GLTexture {
    private static AssetManager assetManager;
    static final Map<Application, Array<Texture>> managedTextures;
    TextureData data;

    protected Texture() {
        super(0, 0);
    }

    public Texture(String string) {
        this(Gdx.files.internal(string));
    }

    public Texture(FileHandle fileHandle) {
        this(fileHandle, null, false);
    }

    public Texture(FileHandle fileHandle, boolean bl) {
        this(fileHandle, null, bl);
    }

    public Texture(FileHandle fileHandle, Pixmap$Format pixmap$Format, boolean bl) {
        this(TextureData$Factory.loadFromFile(fileHandle, pixmap$Format, bl));
    }

    public Texture(Pixmap pixmap) {
        this(new PixmapTextureData(pixmap, null, false, false));
    }

    public Texture(Pixmap pixmap, boolean bl) {
        this(new PixmapTextureData(pixmap, null, bl, false));
    }

    public Texture(Pixmap pixmap, Pixmap$Format pixmap$Format, boolean bl) {
        this(new PixmapTextureData(pixmap, pixmap$Format, bl, false));
    }

    public Texture(int n2, int n3, Pixmap$Format pixmap$Format) {
        this(new PixmapTextureData(new Pixmap(n2, n3, pixmap$Format), null, false, true));
    }

    public Texture(TextureData textureData) {
        this(3553, Gdx.gl.glGenTexture(), textureData);
    }

    protected Texture(int n2, int n3, TextureData textureData) {
        super(n2, n3);
        this.load(textureData);
        if (textureData.isManaged()) {
            Texture.addManagedTexture(Gdx.app, this);
        }
    }

    public void load(TextureData textureData) {
        if (this.data != null && textureData.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = textureData;
        if (!textureData.isPrepared()) {
            textureData.prepare();
        }
        this.bind();
        Texture.uploadImageData(3553, textureData);
        Texture texture = this;
        texture.unsafeSetFilter(texture.minFilter, this.magFilter, true);
        Texture texture2 = this;
        texture2.unsafeSetWrap(texture2.uWrap, this.vWrap, true);
        Texture texture3 = this;
        texture3.unsafeSetAnisotropicFilter(texture3.anisotropicFilterLevel, true);
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload unmanaged Texture");
        }
        this.glHandle = Gdx.gl.glGenTexture();
        Texture texture = this;
        texture.load(texture.data);
    }

    public void draw(Pixmap pixmap, int n2, int n3) {
        if (this.data.isManaged()) {
            throw new GdxRuntimeException("can't draw to a managed texture");
        }
        this.bind();
        Gdx.gl.glTexSubImage2D(this.glTarget, 0, n2, n3, pixmap.getWidth(), pixmap.getHeight(), pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return 0;
    }

    public TextureData getTextureData() {
        return this.data;
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    public void dispose() {
        if (this.glHandle == 0) {
            return;
        }
        this.delete();
        if (this.data.isManaged() && managedTextures.get(Gdx.app) != null) {
            managedTextures.get(Gdx.app).removeValue(this, true);
        }
    }

    public String toString() {
        if (this.data instanceof FileTextureData) {
            return this.data.toString();
        }
        return super.toString();
    }

    private static void addManagedTexture(Application application, Texture texture) {
        Array<Texture> array = managedTextures.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(texture);
        managedTextures.put(application, array);
    }

    public static void clearAllTextures(Application application) {
        managedTextures.remove(application);
    }

    public static void invalidateAllTextures(Application object) {
        if ((object = managedTextures.get(object)) == null) {
            return;
        }
        if (assetManager == null) {
            for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
                Texture texture = (Texture)((Array)object).get(i2);
                texture.reload();
            }
            return;
        }
        assetManager.finishLoading();
        Array array = new Array(object);
        for (Texture texture : array) {
            String string = assetManager.getAssetFileName(texture);
            if (string == null) {
                texture.reload();
                continue;
            }
            int n2 = assetManager.getReferenceCount(string);
            assetManager.setReferenceCount(string, 0);
            texture.glHandle = 0;
            TextureLoader$TextureParameter textureLoader$TextureParameter = new TextureLoader$TextureParameter();
            new TextureLoader$TextureParameter().textureData = texture.getTextureData();
            textureLoader$TextureParameter.minFilter = texture.getMinFilter();
            textureLoader$TextureParameter.magFilter = texture.getMagFilter();
            textureLoader$TextureParameter.wrapU = texture.getUWrap();
            textureLoader$TextureParameter.wrapV = texture.getVWrap();
            textureLoader$TextureParameter.genMipMaps = texture.data.useMipMaps();
            textureLoader$TextureParameter.texture = texture;
            textureLoader$TextureParameter.loadedCallback = new Texture$1(n2);
            assetManager.unload(string);
            texture.glHandle = Gdx.gl.glGenTexture();
            assetManager.load(string, Texture.class, textureLoader$TextureParameter);
        }
        ((Array)object).clear();
        ((Array)object).addAll(array);
    }

    public static void setAssetManager(AssetManager assetManager) {
        Texture.assetManager = assetManager;
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed textures/app: { ");
        for (Application application : managedTextures.keySet()) {
            stringBuilder.append(Texture.managedTextures.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextures() {
        return Texture.managedTextures.get((Object)Gdx.app).size;
    }

    static {
        managedTextures = new HashMap<Application, Array<Texture>>();
    }
}

