/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture$TextureWrap;
import com.badlogic.gdx.graphics.Texture3DData;
import com.badlogic.gdx.graphics.glutils.CustomTexture3DData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.util.HashMap;
import java.util.Map;

public class Texture3D
extends GLTexture {
    static final Map<Application, Array<Texture3D>> managedTexture3Ds = new HashMap<Application, Array<Texture3D>>();
    private Texture3DData data;
    protected Texture$TextureWrap rWrap = Texture$TextureWrap.ClampToEdge;

    public Texture3D(int n2, int n3, int n4, int n5, int n6, int n7) {
        this(new CustomTexture3DData(n2, n3, n4, 0, n5, n6, n7));
    }

    public Texture3D(Texture3DData texture3DData) {
        super(32879, Gdx.gl.glGenTexture());
        if (Gdx.gl30 == null) {
            throw new GdxRuntimeException("Texture3D requires a device running with GLES 3.0 compatibilty");
        }
        this.load(texture3DData);
        if (texture3DData.isManaged()) {
            Texture3D.addManagedTexture(Gdx.app, this);
        }
    }

    private void load(Texture3DData texture3DData) {
        if (this.data != null && texture3DData.isManaged() != this.data.isManaged()) {
            throw new GdxRuntimeException("New data must have the same managed status as the old data");
        }
        this.data = texture3DData;
        this.bind();
        if (!texture3DData.isPrepared()) {
            texture3DData.prepare();
        }
        texture3DData.consume3DData();
        Texture3D texture3D = this;
        texture3D.setFilter(texture3D.minFilter, this.magFilter);
        Texture3D texture3D2 = this;
        texture3D2.setWrap(texture3D2.uWrap, this.vWrap, this.rWrap);
        Gdx.gl.glBindTexture(this.glTarget, 0);
    }

    public Texture3DData getData() {
        return this.data;
    }

    public void upload() {
        this.bind();
        this.data.consume3DData();
    }

    @Override
    public int getWidth() {
        return this.data.getWidth();
    }

    @Override
    public int getHeight() {
        return this.data.getHeight();
    }

    @Override
    public int getDepth() {
        return this.data.getDepth();
    }

    @Override
    public boolean isManaged() {
        return this.data.isManaged();
    }

    @Override
    protected void reload() {
        if (!((GLTexture)this).isManaged()) {
            throw new GdxRuntimeException("Tried to reload an unmanaged TextureArray");
        }
        this.glHandle = Gdx.gl.glGenTexture();
        Texture3D texture3D = this;
        texture3D.load(texture3D.data);
    }

    private static void addManagedTexture(Application application, Texture3D texture3D) {
        Array<Texture3D> array = managedTexture3Ds.get(application);
        if (array == null) {
            array = new Array();
        }
        array.add(texture3D);
        managedTexture3Ds.put(application, array);
    }

    public static void clearAllTextureArrays(Application application) {
        managedTexture3Ds.remove(application);
    }

    public static void invalidateAllTextureArrays(Application object) {
        if ((object = managedTexture3Ds.get(object)) == null) {
            return;
        }
        for (int i2 = 0; i2 < ((Array)object).size; ++i2) {
            Texture3D texture3D = (Texture3D)((Array)object).get(i2);
            texture3D.reload();
        }
    }

    public static String getManagedStatus() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Managed TextureArrays/app: { ");
        for (Application application : managedTexture3Ds.keySet()) {
            stringBuilder.append(Texture3D.managedTexture3Ds.get((Object)application).size);
            stringBuilder.append(" ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static int getNumManagedTextures3D() {
        return Texture3D.managedTexture3Ds.get((Object)Gdx.app).size;
    }

    public void setWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2, Texture$TextureWrap texture$TextureWrap3) {
        this.rWrap = texture$TextureWrap3;
        super.setWrap(texture$TextureWrap, texture$TextureWrap2);
        Gdx.gl.glTexParameteri(this.glTarget, 32882, texture$TextureWrap3.getGLEnum());
    }

    public void unsafeSetWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2, Texture$TextureWrap texture$TextureWrap3, boolean bl) {
        this.unsafeSetWrap(texture$TextureWrap, texture$TextureWrap2, bl);
        if (texture$TextureWrap3 != null && (bl || this.rWrap != texture$TextureWrap3)) {
            Gdx.gl.glTexParameteri(this.glTarget, 32882, texture$TextureWrap.getGLEnum());
            this.rWrap = texture$TextureWrap3;
        }
    }

    public void unsafeSetWrap(Texture$TextureWrap texture$TextureWrap, Texture$TextureWrap texture$TextureWrap2, Texture$TextureWrap texture$TextureWrap3) {
        this.unsafeSetWrap(texture$TextureWrap, texture$TextureWrap2, texture$TextureWrap3, false);
    }
}

