/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes$ReadonlyIterable;
import java.util.Iterator;

public final class VertexAttributes
implements Comparable<VertexAttributes>,
Iterable<VertexAttribute> {
    private final VertexAttribute[] attributes;
    public final int vertexSize;
    private long mask = -1L;
    private int boneWeightUnits = -1;
    private int textureCoordinates = -1;
    private VertexAttributes$ReadonlyIterable<VertexAttribute> iterable;

    public VertexAttributes(VertexAttribute ... vertexAttributeArray) {
        if (vertexAttributeArray.length == 0) {
            throw new IllegalArgumentException("attributes must be >= 1");
        }
        VertexAttribute[] vertexAttributeArray2 = new VertexAttribute[vertexAttributeArray.length];
        for (int i2 = 0; i2 < vertexAttributeArray.length; ++i2) {
            vertexAttributeArray2[i2] = vertexAttributeArray[i2];
        }
        this.attributes = vertexAttributeArray2;
        this.vertexSize = this.calculateOffsets();
    }

    public final int getOffset(int n2, int n3) {
        VertexAttribute vertexAttribute = this.findByUsage(n2);
        if (vertexAttribute == null) {
            return n3;
        }
        return vertexAttribute.offset / 4;
    }

    public final int getOffset(int n2) {
        return this.getOffset(n2, 0);
    }

    public final VertexAttribute findByUsage(int n2) {
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (this.get((int)i2).usage != n2) continue;
            return this.get(i2);
        }
        return null;
    }

    private int calculateOffsets() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            VertexAttribute vertexAttribute = this.attributes[i2];
            this.attributes[i2].offset = n2;
            n2 += vertexAttribute.getSizeInBytes();
        }
        return n2;
    }

    public final int size() {
        return this.attributes.length;
    }

    public final VertexAttribute get(int n2) {
        return this.attributes[n2];
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            stringBuilder.append("(");
            stringBuilder.append(this.attributes[i2].alias);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i2].usage);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i2].numComponents);
            stringBuilder.append(", ");
            stringBuilder.append(this.attributes[i2].offset);
            stringBuilder.append(")");
            stringBuilder.append("\n");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VertexAttributes)) {
            return false;
        }
        object = (VertexAttributes)object;
        if (this.attributes.length != ((VertexAttributes)object).attributes.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            if (this.attributes[i2].equals(((VertexAttributes)object).attributes[i2])) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        long l2 = 61 * this.attributes.length;
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            l2 = l2 * 61L + (long)this.attributes[i2].hashCode();
        }
        long l3 = l2;
        return (int)(l3 ^ l3 >> 32);
    }

    public final long getMask() {
        if (this.mask == -1L) {
            long l2 = 0L;
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                l2 |= (long)this.attributes[i2].usage;
            }
            this.mask = l2;
        }
        return this.mask;
    }

    public final long getMaskWithSizePacked() {
        return this.getMask() | (long)this.attributes.length << 32;
    }

    public final int getBoneWeights() {
        if (this.boneWeightUnits < 0) {
            this.boneWeightUnits = 0;
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                VertexAttribute vertexAttribute = this.attributes[i2];
                if (vertexAttribute.usage != 64) continue;
                this.boneWeightUnits = Math.max(this.boneWeightUnits, vertexAttribute.unit + 1);
            }
        }
        return this.boneWeightUnits;
    }

    public final int getTextureCoordinates() {
        if (this.textureCoordinates < 0) {
            this.textureCoordinates = 0;
            for (int i2 = 0; i2 < this.attributes.length; ++i2) {
                VertexAttribute vertexAttribute = this.attributes[i2];
                if (vertexAttribute.usage != 16) continue;
                this.textureCoordinates = Math.max(this.textureCoordinates, vertexAttribute.unit + 1);
            }
        }
        return this.textureCoordinates;
    }

    @Override
    public final int compareTo(VertexAttributes vertexAttributes) {
        long l2;
        if (this.attributes.length != vertexAttributes.attributes.length) {
            return this.attributes.length - vertexAttributes.attributes.length;
        }
        long l3 = this.getMask();
        if (l3 != (l2 = vertexAttributes.getMask())) {
            if (l3 < l2) {
                return -1;
            }
            return 1;
        }
        for (int i2 = this.attributes.length - 1; i2 >= 0; --i2) {
            VertexAttribute vertexAttribute = this.attributes[i2];
            VertexAttribute vertexAttribute2 = vertexAttributes.attributes[i2];
            if (vertexAttribute.usage != vertexAttribute2.usage) {
                return vertexAttribute.usage - vertexAttribute2.usage;
            }
            if (vertexAttribute.unit != vertexAttribute2.unit) {
                return vertexAttribute.unit - vertexAttribute2.unit;
            }
            if (vertexAttribute.numComponents != vertexAttribute2.numComponents) {
                return vertexAttribute.numComponents - vertexAttribute2.numComponents;
            }
            if (vertexAttribute.normalized != vertexAttribute2.normalized) {
                if (vertexAttribute.normalized) {
                    return 1;
                }
                return -1;
            }
            if (vertexAttribute.type == vertexAttribute2.type) continue;
            return vertexAttribute.type - vertexAttribute2.type;
        }
        return 0;
    }

    @Override
    public final Iterator<VertexAttribute> iterator() {
        if (this.iterable == null) {
            this.iterable = new VertexAttributes$ReadonlyIterable<VertexAttribute>(this.attributes);
        }
        return this.iterable.iterator();
    }
}

