/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.Animation$PlayMode;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.reflect.ArrayReflection;

public class Animation<T> {
    T[] keyFrames;
    private float frameDuration;
    private float animationDuration;
    private int lastFrameNumber;
    private float lastStateTime;
    private Animation$PlayMode playMode = Animation$PlayMode.NORMAL;

    public Animation(float f2, Array<? extends T> array) {
        this.frameDuration = f2;
        Object[] objectArray = array.items.getClass().getComponentType();
        objectArray = (Object[])ArrayReflection.newInstance(objectArray, array.size);
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = array.get(i2);
        }
        this.setKeyFrames(objectArray);
    }

    public Animation(float f2, Array<? extends T> array, Animation$PlayMode animation$PlayMode) {
        this(f2, array);
        this.setPlayMode(animation$PlayMode);
    }

    public Animation(float f2, T ... TArray) {
        this.frameDuration = f2;
        this.setKeyFrames(TArray);
    }

    /*
     * Unable to fully structure code
     */
    public T getKeyFrame(float var1_1, boolean var2_3) {
        block4: {
            block3: {
                var3_4 = this.playMode;
                if (!var2_3 || this.playMode != Animation$PlayMode.NORMAL && this.playMode != Animation$PlayMode.REVERSED) break block3;
                if (this.playMode == Animation$PlayMode.NORMAL) ** GOTO lbl-1000
                this.playMode = Animation$PlayMode.LOOP_REVERSED;
                break block4;
            }
            if (!var2_3 && this.playMode != Animation$PlayMode.NORMAL && this.playMode != Animation$PlayMode.REVERSED) {
                ** if (this.playMode != Animation$PlayMode.LOOP_REVERSED) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    this.playMode = Animation$PlayMode.REVERSED;
                    ** GOTO lbl13
                }
            }
            break block4;
lbl-1000:
            // 2 sources

            {
                this.playMode = Animation$PlayMode.LOOP;
            }
        }
        var1_2 = this.getKeyFrame(var1_1);
        this.playMode = var3_4;
        return var1_2;
    }

    public T getKeyFrame(float f2) {
        int n2 = this.getKeyFrameIndex(f2);
        return this.keyFrames[n2];
    }

    public int getKeyFrameIndex(float f2) {
        if (this.keyFrames.length == 1) {
            return 0;
        }
        int n2 = (int)(f2 / this.frameDuration);
        switch (this.playMode) {
            case NORMAL: {
                n2 = Math.min(this.keyFrames.length - 1, n2);
                break;
            }
            case LOOP: {
                n2 %= this.keyFrames.length;
                break;
            }
            case LOOP_PINGPONG: {
                if ((n2 %= (this.keyFrames.length << 1) - 2) < this.keyFrames.length) break;
                n2 = this.keyFrames.length - 2 - (n2 - this.keyFrames.length);
                break;
            }
            case LOOP_RANDOM: {
                int n3 = (int)(this.lastStateTime / this.frameDuration);
                if (n3 != n2) {
                    n2 = MathUtils.random(this.keyFrames.length - 1);
                    break;
                }
                n2 = this.lastFrameNumber;
                break;
            }
            case REVERSED: {
                n2 = Math.max(this.keyFrames.length - n2 - 1, 0);
                break;
            }
            case LOOP_REVERSED: {
                n2 %= this.keyFrames.length;
                n2 = this.keyFrames.length - n2 - 1;
            }
        }
        this.lastFrameNumber = n2;
        this.lastStateTime = f2;
        return n2;
    }

    public T[] getKeyFrames() {
        return this.keyFrames;
    }

    protected void setKeyFrames(T ... TArray) {
        this.keyFrames = TArray;
        this.animationDuration = (float)TArray.length * this.frameDuration;
    }

    public Animation$PlayMode getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(Animation$PlayMode animation$PlayMode) {
        this.playMode = animation$PlayMode;
    }

    public boolean isAnimationFinished(float f2) {
        int n2 = (int)(f2 / this.frameDuration);
        return this.keyFrames.length - 1 < n2;
    }

    public void setFrameDuration(float f2) {
        this.frameDuration = f2;
        this.animationDuration = (float)this.keyFrames.length * f2;
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public float getAnimationDuration() {
        return this.animationDuration;
    }
}

