/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.BitmapFont$Glyph;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;

public class BitmapFont
implements Disposable {
    private static final int LOG2_PAGE_SIZE = 9;
    private static final int PAGE_SIZE = 512;
    private static final int PAGES = 128;
    final BitmapFont$BitmapFontData data;
    Array<TextureRegion> regions;
    private final BitmapFontCache cache;
    private boolean flipped;
    boolean integer;
    private boolean ownsTexture;

    public BitmapFont() {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/lsans-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/lsans-15.png"), false, true);
    }

    public BitmapFont(boolean bl) {
        this(Gdx.files.classpath("com/badlogic/gdx/utils/lsans-15.fnt"), Gdx.files.classpath("com/badlogic/gdx/utils/lsans-15.png"), bl, true);
    }

    public BitmapFont(FileHandle fileHandle, TextureRegion textureRegion) {
        this(fileHandle, textureRegion, false);
    }

    public BitmapFont(FileHandle fileHandle, TextureRegion textureRegion, boolean bl) {
        this(new BitmapFont$BitmapFontData(fileHandle, bl), textureRegion, true);
    }

    public BitmapFont(FileHandle fileHandle) {
        this(fileHandle, false);
    }

    public BitmapFont(FileHandle fileHandle, boolean bl) {
        this(new BitmapFont$BitmapFontData(fileHandle, bl), (TextureRegion)null, true);
    }

    public BitmapFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        this(fileHandle, fileHandle2, bl, true);
    }

    public BitmapFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl, boolean bl2) {
        this(new BitmapFont$BitmapFontData(fileHandle, bl), new TextureRegion(new Texture(fileHandle2, false)), bl2);
        this.ownsTexture = true;
    }

    public BitmapFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, TextureRegion textureRegion, boolean bl) {
        this(bitmapFont$BitmapFontData, textureRegion != null ? Array.with(textureRegion) : null, bl);
    }

    public BitmapFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, Array<TextureRegion> array, boolean n2) {
        this.flipped = bitmapFont$BitmapFontData.flipped;
        this.data = bitmapFont$BitmapFontData;
        this.integer = n2;
        if (array == null || array.size == 0) {
            if (bitmapFont$BitmapFontData.imagePaths == null) {
                throw new IllegalArgumentException("If no regions are specified, the font data must have an images path.");
            }
            int n3 = bitmapFont$BitmapFontData.imagePaths.length;
            this.regions = new Array(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                FileHandle fileHandle = bitmapFont$BitmapFontData.fontFile == null ? Gdx.files.internal(bitmapFont$BitmapFontData.imagePaths[n2]) : Gdx.files.getFileHandle(bitmapFont$BitmapFontData.imagePaths[n2], bitmapFont$BitmapFontData.fontFile.type());
                this.regions.add(new TextureRegion(new Texture(fileHandle, false)));
            }
            this.ownsTexture = true;
        } else {
            this.regions = array;
            this.ownsTexture = false;
        }
        this.cache = this.newFontCache();
        this.load(bitmapFont$BitmapFontData);
    }

    protected void load(BitmapFont$BitmapFontData bitmapFont$BitmapFontData) {
        BitmapFont$Glyph[][] bitmapFont$GlyphArray = bitmapFont$BitmapFontData.glyphs;
        int n2 = bitmapFont$BitmapFontData.glyphs.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            BitmapFont$Glyph[] bitmapFont$GlyphArray2 = bitmapFont$GlyphArray[i2];
            if (bitmapFont$GlyphArray2 == null) continue;
            for (BitmapFont$Glyph bitmapFont$Glyph : bitmapFont$GlyphArray2) {
                if (bitmapFont$Glyph == null) continue;
                bitmapFont$BitmapFontData.setGlyphRegion(bitmapFont$Glyph, this.regions.get(bitmapFont$Glyph.page));
            }
        }
        if (bitmapFont$BitmapFontData.missingGlyph != null) {
            BitmapFont$BitmapFontData bitmapFont$BitmapFontData2 = bitmapFont$BitmapFontData;
            bitmapFont$BitmapFontData2.setGlyphRegion(bitmapFont$BitmapFontData2.missingGlyph, this.regions.get(bitmapFont$BitmapFontData.missingGlyph.page));
        }
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f2, float f3) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f2, f3);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f2, float f3, float f4, int n2, boolean bl) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f2, f3, f4, n2, bl);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f2, float f3, int n2, int n3, float f4, int n4, boolean bl) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f2, f3, n2, n3, f4, n4, bl);
        this.cache.draw(batch);
        return object;
    }

    public GlyphLayout draw(Batch batch, CharSequence object, float f2, float f3, int n2, int n3, float f4, int n4, boolean bl, String string) {
        this.cache.clear();
        object = this.cache.addText((CharSequence)object, f2, f3, n2, n3, f4, n4, bl, string);
        this.cache.draw(batch);
        return object;
    }

    public void draw(Batch batch, GlyphLayout glyphLayout, float f2, float f3) {
        this.cache.clear();
        this.cache.addText(glyphLayout, f2, f3);
        this.cache.draw(batch);
    }

    public Color getColor() {
        return this.cache.getColor();
    }

    public void setColor(Color color) {
        this.cache.getColor().set(color);
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        this.cache.getColor().set(f2, f3, f4, f5);
    }

    public float getScaleX() {
        return this.data.scaleX;
    }

    public float getScaleY() {
        return this.data.scaleY;
    }

    public TextureRegion getRegion() {
        return this.regions.first();
    }

    public Array<TextureRegion> getRegions() {
        return this.regions;
    }

    public TextureRegion getRegion(int n2) {
        return this.regions.get(n2);
    }

    public float getLineHeight() {
        return this.data.lineHeight;
    }

    public float getSpaceXadvance() {
        return this.data.spaceXadvance;
    }

    public float getXHeight() {
        return this.data.xHeight;
    }

    public float getCapHeight() {
        return this.data.capHeight;
    }

    public float getAscent() {
        return this.data.ascent;
    }

    public float getDescent() {
        return this.data.descent;
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    @Override
    public void dispose() {
        if (this.ownsTexture) {
            for (int i2 = 0; i2 < this.regions.size; ++i2) {
                ((GLTexture)this.regions.get(i2).getTexture()).dispose();
            }
        }
    }

    public void setFixedWidthGlyphs(CharSequence charSequence) {
        BitmapFont$Glyph bitmapFont$Glyph;
        int n2;
        BitmapFont$BitmapFontData bitmapFont$BitmapFontData = this.data;
        int n3 = 0;
        int n4 = charSequence.length();
        for (n2 = 0; n2 < n4; ++n2) {
            bitmapFont$Glyph = bitmapFont$BitmapFontData.getGlyph(charSequence.charAt(n2));
            if (bitmapFont$Glyph == null || bitmapFont$Glyph.xadvance <= n3) continue;
            n3 = bitmapFont$Glyph.xadvance;
        }
        n4 = charSequence.length();
        for (n2 = 0; n2 < n4; ++n2) {
            bitmapFont$Glyph = bitmapFont$BitmapFontData.getGlyph(charSequence.charAt(n2));
            if (bitmapFont$Glyph == null) continue;
            bitmapFont$Glyph.xoffset += (n3 - bitmapFont$Glyph.xadvance) / 2;
            bitmapFont$Glyph.xadvance = n3;
            bitmapFont$Glyph.kerning = null;
            bitmapFont$Glyph.fixedWidth = true;
        }
    }

    public void setUseIntegerPositions(boolean bl) {
        this.integer = bl;
        this.cache.setUseIntegerPositions(bl);
    }

    public boolean usesIntegerPositions() {
        return this.integer;
    }

    public BitmapFontCache getCache() {
        return this.cache;
    }

    public BitmapFont$BitmapFontData getData() {
        return this.data;
    }

    public boolean ownsTexture() {
        return this.ownsTexture;
    }

    public void setOwnsTexture(boolean bl) {
        this.ownsTexture = bl;
    }

    public BitmapFontCache newFontCache() {
        BitmapFont bitmapFont = this;
        return new BitmapFontCache(bitmapFont, bitmapFont.integer);
    }

    public String toString() {
        if (this.data.name != null) {
            return this.data.name;
        }
        return super.toString();
    }

    static int indexOf(CharSequence charSequence, char c2, int n2) {
        int n3 = charSequence.length();
        while (n2 < n3) {
            if (charSequence.charAt(n2) == c2) {
                return n2;
            }
            ++n2;
        }
        return n3;
    }
}

