/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.BitmapFontCache;
import com.badlogic.gdx.graphics.g2d.DistanceFieldFont$DistanceFieldFontCache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class DistanceFieldFont
extends BitmapFont {
    private float distanceFieldSmoothing;

    public DistanceFieldFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, Array<TextureRegion> array, boolean bl) {
        super(bitmapFont$BitmapFontData, array, bl);
    }

    public DistanceFieldFont(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, TextureRegion textureRegion, boolean bl) {
        super(bitmapFont$BitmapFontData, textureRegion, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, boolean bl) {
        super(fileHandle, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl, boolean bl2) {
        super(fileHandle, fileHandle2, bl, bl2);
    }

    public DistanceFieldFont(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        super(fileHandle, fileHandle2, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, TextureRegion textureRegion, boolean bl) {
        super(fileHandle, textureRegion, bl);
    }

    public DistanceFieldFont(FileHandle fileHandle, TextureRegion textureRegion) {
        super(fileHandle, textureRegion);
    }

    public DistanceFieldFont(FileHandle fileHandle) {
        super(fileHandle);
    }

    @Override
    protected void load(BitmapFont$BitmapFontData object) {
        super.load((BitmapFont$BitmapFontData)object);
        object = this.getRegions();
        object = ((Array)object).iterator();
        while (object.hasNext()) {
            TextureRegion textureRegion = (TextureRegion)object.next();
            Texture$TextureFilter texture$TextureFilter = Texture$TextureFilter.Linear;
            textureRegion.getTexture().setFilter(texture$TextureFilter, texture$TextureFilter);
        }
    }

    @Override
    public BitmapFontCache newFontCache() {
        DistanceFieldFont distanceFieldFont = this;
        return new DistanceFieldFont$DistanceFieldFontCache(distanceFieldFont, distanceFieldFont.integer);
    }

    public float getDistanceFieldSmoothing() {
        return this.distanceFieldSmoothing;
    }

    public void setDistanceFieldSmoothing(float f2) {
        this.distanceFieldSmoothing = f2;
    }

    public static ShaderProgram createDistanceFieldShader() {
        Object object = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tv_color = a_color;\n\tv_color.a = v_color.a * (255.0/254.0);\n\tv_texCoords = a_texCoord0;\n\tgl_Position =  u_projTrans * a_position;\n}\n";
        String string = "#ifdef GL_ES\n\tprecision mediump float;\n\tprecision mediump int;\n#endif\n\nuniform sampler2D u_texture;\nuniform float u_smoothing;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main() {\n\tif (u_smoothing > 0.0) {\n\t\tfloat smoothing = 0.25 / u_smoothing;\n\t\tfloat distance = texture2D(u_texture, v_texCoords).a;\n\t\tfloat alpha = smoothstep(0.5 - smoothing, 0.5 + smoothing, distance);\n\t\tgl_FragColor = vec4(v_color.rgb, alpha * v_color.a);\n\t} else {\n\t\tgl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n\t}\n}\n";
        if (!((ShaderProgram)(object = new ShaderProgram((String)object, string))).isCompiled()) {
            throw new IllegalArgumentException("Error compiling distance field shader: " + ((ShaderProgram)object).getLog());
        }
        return object;
    }
}

