/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Colors;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.BitmapFont$BitmapFontData;
import com.badlogic.gdx.graphics.g2d.BitmapFont$Glyph;
import com.badlogic.gdx.graphics.g2d.GlyphLayout$GlyphRun;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.Pool;
import com.badlogic.gdx.utils.Pool$Poolable;
import com.badlogic.gdx.utils.Pools;

public class GlyphLayout
implements Pool$Poolable {
    private static final Pool<GlyphLayout$GlyphRun> glyphRunPool = Pools.get(GlyphLayout$GlyphRun.class);
    private static final IntArray colorStack = new IntArray(4);
    private static final float epsilon = 1.0E-4f;
    public final Array<GlyphLayout$GlyphRun> runs = new Array(1);
    public final IntArray colors = new IntArray(2);
    public int glyphCount;
    public float width;
    public float height;

    public GlyphLayout() {
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence) {
        this.setText(bitmapFont, charSequence);
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence, Color color, float f2, int n2, boolean bl) {
        this.setText(bitmapFont, charSequence, color, f2, n2, bl);
    }

    public GlyphLayout(BitmapFont bitmapFont, CharSequence charSequence, int n2, int n3, Color color, float f2, int n4, boolean bl, String string) {
        this.setText(bitmapFont, charSequence, n2, n3, color, f2, n4, bl, string);
    }

    public void setText(BitmapFont bitmapFont, CharSequence charSequence) {
        this.setText(bitmapFont, charSequence, 0, charSequence.length(), bitmapFont.getColor(), 0.0f, 8, false, null);
    }

    public void setText(BitmapFont bitmapFont, CharSequence charSequence, Color color, float f2, int n2, boolean bl) {
        this.setText(bitmapFont, charSequence, 0, charSequence.length(), color, f2, n2, bl, null);
    }

    public void setText(BitmapFont object, CharSequence charSequence, int n2, int n3, Color color, float f2, int n4, boolean bl, @Null String string) {
        int n5;
        this.reset();
        object = ((BitmapFont)object).data;
        if (n2 == n3) {
            this.height = ((BitmapFont$BitmapFontData)object).capHeight;
            return;
        }
        if (bl) {
            f2 = Math.max(f2, ((BitmapFont$BitmapFontData)object).spaceXadvance * 3.0f);
        }
        bl = bl || string != null;
        int n6 = n5 = color.toIntBits();
        this.colors.add(0, n5);
        boolean bl2 = ((BitmapFont$BitmapFontData)object).markupEnabled;
        if (bl2) {
            colorStack.add(n5);
        }
        boolean bl3 = false;
        float f3 = 0.0f;
        float f4 = ((BitmapFont$BitmapFontData)object).down;
        GlyphLayout$GlyphRun glyphLayout$GlyphRun = null;
        BitmapFont$Glyph bitmapFont$Glyph = null;
        int n7 = n2;
        block4: while (true) {
            int n8;
            boolean bl4;
            block30: {
                block29: {
                    GlyphLayout$GlyphRun glyphLayout$GlyphRun2;
                    block28: {
                        bl4 = false;
                        if (n2 == n3) {
                            if (n7 == n3) break;
                            n8 = n3;
                            bl3 = true;
                        } else {
                            switch (charSequence.charAt(n2++)) {
                                case '\n': {
                                    n8 = n2 - 1;
                                    bl4 = true;
                                    break;
                                }
                                case '[': {
                                    if (bl2) {
                                        int n9 = this.parseColorMarkup(charSequence, n2, n3);
                                        if (n9 >= 0) {
                                            n8 = n2 - 1;
                                            if ((n2 += n9 + 1) == n3) {
                                                bl3 = true;
                                                break;
                                            }
                                            n6 = colorStack.peek();
                                            break;
                                        }
                                        if (n9 == -2) {
                                            ++n2;
                                        }
                                    }
                                }
                                default: {
                                    continue block4;
                                }
                            }
                        }
                        glyphLayout$GlyphRun2 = glyphRunPool.obtain();
                        glyphRunPool.obtain().x = 0.0f;
                        glyphLayout$GlyphRun2.y = f3;
                        ((BitmapFont$BitmapFontData)object).getGlyphs(glyphLayout$GlyphRun2, charSequence, n7, n8, bitmapFont$Glyph);
                        this.glyphCount += glyphLayout$GlyphRun2.glyphs.size;
                        if (n6 != n5) {
                            if (this.colors.get(this.colors.size - 2) == this.glyphCount) {
                                this.colors.set(this.colors.size - 1, n6);
                            } else {
                                this.colors.add(this.glyphCount);
                                this.colors.add(n6);
                            }
                            n5 = n6;
                        }
                        if (glyphLayout$GlyphRun2.glyphs.size != 0) break block28;
                        glyphRunPool.free(glyphLayout$GlyphRun2);
                        if (glyphLayout$GlyphRun != null) break block29;
                        break block30;
                    }
                    if (glyphLayout$GlyphRun == null) {
                        glyphLayout$GlyphRun = glyphLayout$GlyphRun2;
                        this.runs.add(glyphLayout$GlyphRun);
                    } else {
                        glyphLayout$GlyphRun.appendRun(glyphLayout$GlyphRun2);
                        glyphRunPool.free(glyphLayout$GlyphRun2);
                    }
                }
                if (bl4 || bl3) {
                    this.setLastGlyphXAdvance((BitmapFont$BitmapFontData)object, glyphLayout$GlyphRun);
                    bitmapFont$Glyph = null;
                } else {
                    bitmapFont$Glyph = glyphLayout$GlyphRun.glyphs.peek();
                }
                if (bl && glyphLayout$GlyphRun.glyphs.size != 0 && (bl4 || bl3)) {
                    float f5 = glyphLayout$GlyphRun.xAdvances.first() + glyphLayout$GlyphRun.xAdvances.get(1);
                    for (int i2 = 2; i2 < glyphLayout$GlyphRun.xAdvances.size; ++i2) {
                        BitmapFont$Glyph bitmapFont$Glyph2 = glyphLayout$GlyphRun.glyphs.get(i2 - 1);
                        float f6 = this.getGlyphWidth(bitmapFont$Glyph2, (BitmapFont$BitmapFontData)object);
                        if (f5 + f6 - 1.0E-4f <= f2) {
                            f5 += glyphLayout$GlyphRun.xAdvances.items[i2];
                            continue;
                        }
                        if (string != null) {
                            this.truncate((BitmapFont$BitmapFontData)object, glyphLayout$GlyphRun, f2, string);
                            break block4;
                        }
                        int n10 = ((BitmapFont$BitmapFontData)object).getWrapIndex(glyphLayout$GlyphRun.glyphs, i2);
                        if (n10 == 0 && glyphLayout$GlyphRun.x == 0.0f || n10 >= glyphLayout$GlyphRun.glyphs.size) {
                            n10 = i2 - 1;
                        }
                        if ((glyphLayout$GlyphRun = this.wrap((BitmapFont$BitmapFontData)object, glyphLayout$GlyphRun, n10)) == null) break;
                        this.runs.add(glyphLayout$GlyphRun);
                        glyphLayout$GlyphRun.x = 0.0f;
                        glyphLayout$GlyphRun.y = f3 += f4;
                        f5 = glyphLayout$GlyphRun.xAdvances.first() + glyphLayout$GlyphRun.xAdvances.get(1);
                        i2 = 1;
                    }
                }
            }
            if (bl4) {
                glyphLayout$GlyphRun = null;
                bitmapFont$Glyph = null;
                f3 = n8 == n7 ? (f3 += f4 * ((BitmapFont$BitmapFontData)object).blankLineScale) : (f3 += f4);
            }
            n7 = n2;
        }
        this.height = ((BitmapFont$BitmapFontData)object).capHeight + Math.abs(f3);
        this.calculateWidths((BitmapFont$BitmapFontData)object);
        this.alignRuns(f2, n4);
        if (bl2) {
            colorStack.clear();
        }
    }

    private void calculateWidths(BitmapFont$BitmapFontData bitmapFont$BitmapFontData) {
        float f2 = 0.0f;
        T[] TArray = this.runs.items;
        int n2 = this.runs.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            GlyphLayout$GlyphRun glyphLayout$GlyphRun = (GlyphLayout$GlyphRun)TArray[i2];
            float[] fArray = glyphLayout$GlyphRun.xAdvances.items;
            float f3 = glyphLayout$GlyphRun.x + fArray[0];
            float f4 = 0.0f;
            T[] TArray2 = glyphLayout$GlyphRun.glyphs.items;
            int n3 = 0;
            int n4 = glyphLayout$GlyphRun.glyphs.size;
            while (n3 < n4) {
                BitmapFont$Glyph bitmapFont$Glyph = (BitmapFont$Glyph)TArray2[n3];
                float f5 = this.getGlyphWidth(bitmapFont$Glyph, bitmapFont$BitmapFontData);
                f4 = Math.max(f4, f3 + f5);
                f3 += fArray[++n3];
            }
            glyphLayout$GlyphRun.width = Math.max(f3, f4) - glyphLayout$GlyphRun.x;
            f2 = Math.max(f2, glyphLayout$GlyphRun.x + glyphLayout$GlyphRun.width);
        }
        this.width = f2;
    }

    private void alignRuns(float f2, int n2) {
        if ((n2 & 8) == 0) {
            n2 = (n2 & 1) != 0 ? 1 : 0;
            T[] TArray = this.runs.items;
            int n3 = this.runs.size;
            for (int i2 = 0; i2 < n3; ++i2) {
                GlyphLayout$GlyphRun glyphLayout$GlyphRun = (GlyphLayout$GlyphRun)TArray[i2];
                glyphLayout$GlyphRun.x = glyphLayout$GlyphRun.x + (n2 != 0 ? 0.5f * (f2 - glyphLayout$GlyphRun.width) : f2 - glyphLayout$GlyphRun.width);
            }
        }
    }

    private void truncate(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, GlyphLayout$GlyphRun glyphLayout$GlyphRun, float f2, String string) {
        int n2;
        int n3;
        int n4 = glyphLayout$GlyphRun.glyphs.size;
        GlyphLayout$GlyphRun glyphLayout$GlyphRun2 = glyphRunPool.obtain();
        bitmapFont$BitmapFontData.getGlyphs(glyphLayout$GlyphRun2, string, 0, string.length(), null);
        float f3 = 0.0f;
        if (glyphLayout$GlyphRun2.xAdvances.size > 0) {
            this.setLastGlyphXAdvance(bitmapFont$BitmapFontData, glyphLayout$GlyphRun2);
            float[] fArray = glyphLayout$GlyphRun2.xAdvances.items;
            int n5 = glyphLayout$GlyphRun2.xAdvances.size;
            for (int i2 = 1; i2 < n5; ++i2) {
                f3 += fArray[i2];
            }
        }
        f2 -= f3;
        float f4 = glyphLayout$GlyphRun.x;
        float[] fArray = glyphLayout$GlyphRun.xAdvances.items;
        for (n3 = 0; n3 < glyphLayout$GlyphRun.xAdvances.size && !((f4 += (f3 = fArray[n3])) > f2); ++n3) {
        }
        if (n3 > 1) {
            glyphLayout$GlyphRun.glyphs.truncate(n3 - 1);
            glyphLayout$GlyphRun.xAdvances.truncate(n3);
            this.setLastGlyphXAdvance(bitmapFont$BitmapFontData, glyphLayout$GlyphRun);
            if (glyphLayout$GlyphRun2.xAdvances.size > 0) {
                glyphLayout$GlyphRun.xAdvances.addAll(glyphLayout$GlyphRun2.xAdvances, 1, glyphLayout$GlyphRun2.xAdvances.size - 1);
            }
        } else {
            glyphLayout$GlyphRun.glyphs.clear();
            glyphLayout$GlyphRun.xAdvances.clear();
            glyphLayout$GlyphRun.xAdvances.addAll(glyphLayout$GlyphRun2.xAdvances);
        }
        if ((n2 = n4 - glyphLayout$GlyphRun.glyphs.size) > 0) {
            this.glyphCount -= n2;
            if (bitmapFont$BitmapFontData.markupEnabled) {
                while (this.colors.size > 2 && this.colors.get(this.colors.size - 2) >= this.glyphCount) {
                    this.colors.size -= 2;
                }
            }
        }
        glyphLayout$GlyphRun.glyphs.addAll(glyphLayout$GlyphRun2.glyphs);
        this.glyphCount += string.length();
        glyphRunPool.free(glyphLayout$GlyphRun2);
    }

    private GlyphLayout$GlyphRun wrap(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, GlyphLayout$GlyphRun glyphLayout$GlyphRun, int n2) {
        int n3;
        Array<BitmapFont$Glyph> array = glyphLayout$GlyphRun.glyphs;
        int n4 = glyphLayout$GlyphRun.glyphs.size;
        FloatArray floatArray = glyphLayout$GlyphRun.xAdvances;
        for (n3 = n2; n3 > 0 && bitmapFont$BitmapFontData.isWhitespace((char)array.get((int)(n3 - 1)).id); --n3) {
        }
        while (n2 < n4 && bitmapFont$BitmapFontData.isWhitespace((char)array.get((int)n2).id)) {
            ++n2;
        }
        GlyphLayout$GlyphRun glyphLayout$GlyphRun2 = null;
        if (n2 < n4) {
            glyphLayout$GlyphRun2 = glyphRunPool.obtain();
            Object object = glyphLayout$GlyphRun2.glyphs;
            ((Array)object).addAll(array, 0, n3);
            array.removeRange(0, n2 - 1);
            glyphLayout$GlyphRun.glyphs = object;
            glyphLayout$GlyphRun2.glyphs = array;
            object = glyphLayout$GlyphRun2.xAdvances;
            ((FloatArray)object).addAll(floatArray, 0, n3 + 1);
            floatArray.removeRange(1, n2);
            floatArray.items[0] = this.getLineOffset(array, bitmapFont$BitmapFontData);
            glyphLayout$GlyphRun.xAdvances = object;
            glyphLayout$GlyphRun2.xAdvances = floatArray;
            n2 = glyphLayout$GlyphRun.glyphs.size;
            int n5 = glyphLayout$GlyphRun2.glyphs.size;
            n2 = n4 - n2 - n5;
            this.glyphCount -= n2;
            if (bitmapFont$BitmapFontData.markupEnabled && n2 > 0) {
                int n6;
                n5 = this.glyphCount - n5;
                for (n4 = this.colors.size - 2; n4 >= 2 && (n6 = this.colors.get(n4)) > n5; n4 -= 2) {
                    this.colors.set(n4, n6 - n2);
                }
            }
        } else {
            array.truncate(n3);
            floatArray.truncate(n3 + 1);
            int n7 = n2 - n3;
            if (n7 > 0) {
                this.glyphCount -= n7;
                if (bitmapFont$BitmapFontData.markupEnabled && this.colors.get(this.colors.size - 2) > this.glyphCount) {
                    n7 = this.colors.peek();
                    while (this.colors.get(this.colors.size - 2) > this.glyphCount) {
                        this.colors.size -= 2;
                    }
                    this.colors.set(this.colors.size - 2, this.glyphCount);
                    this.colors.set(this.colors.size - 1, n7);
                }
            }
        }
        if (n3 == 0) {
            glyphRunPool.free(glyphLayout$GlyphRun);
            this.runs.pop();
        } else {
            this.setLastGlyphXAdvance(bitmapFont$BitmapFontData, glyphLayout$GlyphRun);
        }
        return glyphLayout$GlyphRun2;
    }

    private void setLastGlyphXAdvance(BitmapFont$BitmapFontData bitmapFont$BitmapFontData, GlyphLayout$GlyphRun glyphLayout$GlyphRun) {
        BitmapFont$Glyph bitmapFont$Glyph = glyphLayout$GlyphRun.glyphs.peek();
        if (!bitmapFont$Glyph.fixedWidth) {
            glyphLayout$GlyphRun.xAdvances.items[glyphLayout$GlyphRun.xAdvances.size - 1] = this.getGlyphWidth(bitmapFont$Glyph, bitmapFont$BitmapFontData);
        }
    }

    private float getGlyphWidth(BitmapFont$Glyph bitmapFont$Glyph, BitmapFont$BitmapFontData bitmapFont$BitmapFontData) {
        return (float)(bitmapFont$Glyph.fixedWidth ? bitmapFont$Glyph.xadvance : bitmapFont$Glyph.width + bitmapFont$Glyph.xoffset) * bitmapFont$BitmapFontData.scaleX - bitmapFont$BitmapFontData.padRight;
    }

    private float getLineOffset(Array<BitmapFont$Glyph> object, BitmapFont$BitmapFontData bitmapFont$BitmapFontData) {
        object = ((Array)object).first();
        return (((BitmapFont$Glyph)object).fixedWidth ? 0.0f : (float)(-((BitmapFont$Glyph)object).xoffset) * bitmapFont$BitmapFontData.scaleX) - bitmapFont$BitmapFontData.padLeft;
    }

    private int parseColorMarkup(CharSequence charSequence, int n2, int n3) {
        if (n2 == n3) {
            return -1;
        }
        switch (charSequence.charAt(n2)) {
            case '#': {
                int n4 = 0;
                for (int i2 = n2 + 1; i2 < n3; ++i2) {
                    char c2 = charSequence.charAt(i2);
                    if (c2 == ']') {
                        if (i2 < n2 + 2 || i2 > n2 + 9) break;
                        if (i2 - n2 < 8) {
                            n4 = n4 << (9 - (i2 - n2) << 2) | 0xFF;
                        }
                        colorStack.add(Integer.reverseBytes(n4));
                        return i2 - n2;
                    }
                    n4 = (n4 << 4) + c2;
                    if (c2 >= '0' && c2 <= '9') {
                        n4 -= 48;
                        continue;
                    }
                    if (c2 >= 'A' && c2 <= 'F') {
                        n4 -= 55;
                        continue;
                    }
                    if (c2 < 'a' || c2 > 'f') break;
                    n4 -= 87;
                }
                return -1;
            }
            case '[': {
                return -2;
            }
            case ']': {
                if (GlyphLayout.colorStack.size > 1) {
                    colorStack.pop();
                }
                return 0;
            }
        }
        for (int i3 = n2 + 1; i3 < n3; ++i3) {
            char c3 = charSequence.charAt(i3);
            if (c3 != ']') continue;
            Color color = Colors.get(charSequence.subSequence(n2, i3).toString());
            if (color == null) {
                return -1;
            }
            colorStack.add(color.toIntBits());
            return i3 - n2;
        }
        return -1;
    }

    @Override
    public void reset() {
        glyphRunPool.freeAll(this.runs);
        this.runs.clear();
        this.colors.clear();
        this.glyphCount = 0;
        this.width = 0.0f;
        this.height = 0.0f;
    }

    public String toString() {
        if (this.runs.size == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.width);
        stringBuilder.append('x');
        stringBuilder.append(this.height);
        stringBuilder.append('\n');
        int n2 = this.runs.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(this.runs.get(i2).toString());
            stringBuilder.append('\n');
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 1);
        return stringBuilder.toString();
    }
}

