/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$GradientColorValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$IndependentScaledNumericValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$Particle;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$ParticleValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$RangedNumericValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$ScaledNumericValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$SpawnShapeValue;
import com.badlogic.gdx.graphics.g2d.ParticleEmitter$SpriteMode;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;

public class ParticleEmitter {
    private static final int UPDATE_SCALE = 1;
    private static final int UPDATE_ANGLE = 2;
    private static final int UPDATE_ROTATION = 4;
    private static final int UPDATE_VELOCITY = 8;
    private static final int UPDATE_WIND = 16;
    private static final int UPDATE_GRAVITY = 32;
    private static final int UPDATE_TINT = 64;
    private static final int UPDATE_SPRITE = 128;
    private ParticleEmitter$RangedNumericValue delayValue = new ParticleEmitter$RangedNumericValue();
    private ParticleEmitter$IndependentScaledNumericValue lifeOffsetValue = new ParticleEmitter$IndependentScaledNumericValue();
    private ParticleEmitter$RangedNumericValue durationValue = new ParticleEmitter$RangedNumericValue();
    private ParticleEmitter$IndependentScaledNumericValue lifeValue = new ParticleEmitter$IndependentScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue emissionValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue xScaleValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue yScaleValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue rotationValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue velocityValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue angleValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue windValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue gravityValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue transparencyValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$GradientColorValue tintValue = new ParticleEmitter$GradientColorValue();
    private ParticleEmitter$RangedNumericValue xOffsetValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$RangedNumericValue yOffsetValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue spawnWidthValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$ScaledNumericValue spawnHeightValue = new ParticleEmitter$ScaledNumericValue();
    private ParticleEmitter$SpawnShapeValue spawnShapeValue = new ParticleEmitter$SpawnShapeValue();
    private ParticleEmitter$RangedNumericValue[] xSizeValues;
    private ParticleEmitter$RangedNumericValue[] ySizeValues;
    private ParticleEmitter$RangedNumericValue[] motionValues;
    private float accumulator;
    private Array<Sprite> sprites;
    private ParticleEmitter$SpriteMode spriteMode = ParticleEmitter$SpriteMode.single;
    private ParticleEmitter$Particle[] particles;
    private int minParticleCount;
    private int maxParticleCount = 4;
    private float x;
    private float y;
    private String name;
    private Array<String> imagePaths;
    private int activeCount;
    private boolean[] active;
    private boolean firstUpdate;
    private boolean flipX;
    private boolean flipY;
    private int updateFlags;
    private boolean allowCompletion;
    private BoundingBox bounds;
    private int emission;
    private int emissionDiff;
    private int emissionDelta;
    private int lifeOffset;
    private int lifeOffsetDiff;
    private int life;
    private int lifeDiff;
    private float spawnWidth;
    private float spawnWidthDiff;
    private float spawnHeight;
    private float spawnHeightDiff;
    public float duration = 1.0f;
    public float durationTimer;
    private float delay;
    private float delayTimer;
    private boolean attached;
    private boolean continuous;
    private boolean aligned;
    private boolean behind;
    private boolean additive = true;
    private boolean premultipliedAlpha = false;
    boolean cleansUpBlendFunction = true;

    public ParticleEmitter() {
        this.initialize();
    }

    public ParticleEmitter(BufferedReader bufferedReader) {
        this.initialize();
        this.load(bufferedReader);
    }

    public ParticleEmitter(ParticleEmitter particleEmitter) {
        this.sprites = new Array<Sprite>(particleEmitter.sprites);
        this.name = particleEmitter.name;
        this.imagePaths = new Array<String>(particleEmitter.imagePaths);
        this.setMaxParticleCount(particleEmitter.maxParticleCount);
        this.minParticleCount = particleEmitter.minParticleCount;
        this.delayValue.load(particleEmitter.delayValue);
        this.durationValue.load(particleEmitter.durationValue);
        this.emissionValue.load(particleEmitter.emissionValue);
        this.lifeValue.load(particleEmitter.lifeValue);
        this.lifeOffsetValue.load(particleEmitter.lifeOffsetValue);
        this.xScaleValue.load(particleEmitter.xScaleValue);
        this.yScaleValue.load(particleEmitter.yScaleValue);
        this.rotationValue.load(particleEmitter.rotationValue);
        this.velocityValue.load(particleEmitter.velocityValue);
        this.angleValue.load(particleEmitter.angleValue);
        this.windValue.load(particleEmitter.windValue);
        this.gravityValue.load(particleEmitter.gravityValue);
        this.transparencyValue.load(particleEmitter.transparencyValue);
        this.tintValue.load(particleEmitter.tintValue);
        this.xOffsetValue.load(particleEmitter.xOffsetValue);
        this.yOffsetValue.load(particleEmitter.yOffsetValue);
        this.spawnWidthValue.load(particleEmitter.spawnWidthValue);
        this.spawnHeightValue.load(particleEmitter.spawnHeightValue);
        this.spawnShapeValue.load(particleEmitter.spawnShapeValue);
        this.attached = particleEmitter.attached;
        this.continuous = particleEmitter.continuous;
        this.aligned = particleEmitter.aligned;
        this.behind = particleEmitter.behind;
        this.additive = particleEmitter.additive;
        this.premultipliedAlpha = particleEmitter.premultipliedAlpha;
        this.cleansUpBlendFunction = particleEmitter.cleansUpBlendFunction;
        this.spriteMode = particleEmitter.spriteMode;
        this.setPosition(particleEmitter.getX(), particleEmitter.getY());
    }

    private void initialize() {
        this.sprites = new Array();
        this.imagePaths = new Array();
        this.durationValue.setAlwaysActive(true);
        this.emissionValue.setAlwaysActive(true);
        this.lifeValue.setAlwaysActive(true);
        this.xScaleValue.setAlwaysActive(true);
        this.transparencyValue.setAlwaysActive(true);
        this.spawnShapeValue.setAlwaysActive(true);
        this.spawnWidthValue.setAlwaysActive(true);
        this.spawnHeightValue.setAlwaysActive(true);
    }

    public void setMaxParticleCount(int n2) {
        this.maxParticleCount = n2;
        this.active = new boolean[n2];
        this.activeCount = 0;
        this.particles = new ParticleEmitter$Particle[n2];
    }

    public void addParticle() {
        int n2 = this.activeCount;
        if (n2 == this.maxParticleCount) {
            return;
        }
        boolean[] blArray = this.active;
        int n3 = blArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (blArray[i2]) continue;
            this.activateParticle(i2);
            blArray[i2] = true;
            this.activeCount = n2 + 1;
            return;
        }
    }

    public void addParticles(int n2) {
        if ((n2 = Math.min(n2, this.maxParticleCount - this.activeCount)) == 0) {
            return;
        }
        boolean[] blArray = this.active;
        int n3 = 0;
        int n4 = blArray.length;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            while (n3 < n4) {
                if (blArray[n3]) {
                    ++n3;
                    continue;
                }
                this.activateParticle(n3);
                blArray[n3++] = true;
                continue block0;
            }
            break block0;
        }
        this.activeCount += n2;
    }

    public void update(float f2) {
        this.accumulator += f2 * 1000.0f;
        if (this.accumulator < 1.0f) {
            return;
        }
        int n2 = (int)this.accumulator;
        this.accumulator -= (float)n2;
        if (this.delayTimer < this.delay) {
            this.delayTimer += (float)n2;
        } else {
            boolean bl = false;
            if (this.firstUpdate) {
                this.firstUpdate = false;
                this.addParticle();
            }
            if (this.durationTimer < this.duration) {
                this.durationTimer += (float)n2;
            } else if (!this.continuous || this.allowCompletion) {
                bl = true;
            } else {
                this.restart();
            }
            if (!bl) {
                float f3;
                this.emissionDelta += n2;
                float f4 = (float)this.emission + (float)this.emissionDiff * this.emissionValue.getScale(this.durationTimer / this.duration);
                if (f3 > 0.0f && (float)this.emissionDelta >= (f4 = 1000.0f / f4)) {
                    int n3 = (int)((float)this.emissionDelta / f4);
                    n3 = Math.min(n3, this.maxParticleCount - this.activeCount);
                    this.emissionDelta = (int)((float)this.emissionDelta - (float)n3 * f4);
                    this.emissionDelta = (int)((float)this.emissionDelta % f4);
                    this.addParticles(n3);
                }
                if (this.activeCount < this.minParticleCount) {
                    ParticleEmitter particleEmitter = this;
                    particleEmitter.addParticles(particleEmitter.minParticleCount - this.activeCount);
                }
            }
        }
        boolean[] blArray = this.active;
        int n4 = this.activeCount;
        ParticleEmitter$Particle[] particleEmitter$ParticleArray = this.particles;
        int n5 = blArray.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            if (!blArray[i2] || this.updateParticle(particleEmitter$ParticleArray[i2], f2, n2)) continue;
            blArray[i2] = false;
            --n4;
        }
        this.activeCount = n4;
    }

    public void draw(Batch batch) {
        if (this.premultipliedAlpha) {
            batch.setBlendFunction(1, 771);
        } else if (this.additive) {
            batch.setBlendFunction(770, 1);
        } else {
            batch.setBlendFunction(770, 771);
        }
        ParticleEmitter$Particle[] particleEmitter$ParticleArray = this.particles;
        boolean[] blArray = this.active;
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blArray[i2]) continue;
            particleEmitter$ParticleArray[i2].draw(batch);
        }
        if (this.cleansUpBlendFunction && (this.additive || this.premultipliedAlpha)) {
            batch.setBlendFunction(770, 771);
        }
    }

    public void draw(Batch batch, float f2) {
        float f3;
        this.accumulator += f2 * 1000.0f;
        if (this.accumulator < 1.0f) {
            this.draw(batch);
            return;
        }
        int n2 = (int)this.accumulator;
        this.accumulator -= (float)n2;
        if (this.premultipliedAlpha) {
            batch.setBlendFunction(1, 771);
        } else if (this.additive) {
            batch.setBlendFunction(770, 1);
        } else {
            batch.setBlendFunction(770, 771);
        }
        ParticleEmitter$Particle[] particleEmitter$ParticleArray = this.particles;
        boolean[] blArray = this.active;
        int n3 = this.activeCount;
        int n4 = blArray.length;
        for (int i2 = 0; i2 < n4; ++i2) {
            if (!blArray[i2]) continue;
            ParticleEmitter$Particle particleEmitter$Particle = particleEmitter$ParticleArray[i2];
            if (this.updateParticle(particleEmitter$Particle, f2, n2)) {
                particleEmitter$Particle.draw(batch);
                continue;
            }
            blArray[i2] = false;
            --n3;
        }
        this.activeCount = n3;
        if (this.cleansUpBlendFunction && (this.additive || this.premultipliedAlpha)) {
            batch.setBlendFunction(770, 771);
        }
        if (this.delayTimer < this.delay) {
            this.delayTimer += (float)n2;
            return;
        }
        if (this.firstUpdate) {
            this.firstUpdate = false;
            this.addParticle();
        }
        if (this.durationTimer < this.duration) {
            this.durationTimer += (float)n2;
        } else {
            if (!this.continuous || this.allowCompletion) {
                return;
            }
            this.restart();
        }
        this.emissionDelta += n2;
        float f4 = (float)this.emission + (float)this.emissionDiff * this.emissionValue.getScale(this.durationTimer / this.duration);
        if (f3 > 0.0f && (float)this.emissionDelta >= (f4 = 1000.0f / f4)) {
            n4 = (int)((float)this.emissionDelta / f4);
            n4 = Math.min(n4, this.maxParticleCount - n3);
            this.emissionDelta = (int)((float)this.emissionDelta - (float)n4 * f4);
            this.emissionDelta = (int)((float)this.emissionDelta % f4);
            this.addParticles(n4);
        }
        if (n3 < this.minParticleCount) {
            ParticleEmitter particleEmitter = this;
            particleEmitter.addParticles(particleEmitter.minParticleCount - n3);
        }
    }

    public void start() {
        this.firstUpdate = true;
        this.allowCompletion = false;
        this.restart();
    }

    public void reset() {
        this.reset(true);
    }

    public void reset(boolean bl) {
        this.emissionDelta = 0;
        this.durationTimer = this.duration;
        boolean[] blArray = this.active;
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            blArray[i2] = false;
        }
        this.activeCount = 0;
        if (bl) {
            this.start();
        }
    }

    private void restart() {
        this.delay = this.delayValue.active ? this.delayValue.newLowValue() : 0.0f;
        this.delayTimer = 0.0f;
        this.durationTimer -= this.duration;
        this.duration = this.durationValue.newLowValue();
        this.emission = (int)this.emissionValue.newLowValue();
        this.emissionDiff = (int)this.emissionValue.newHighValue();
        if (!this.emissionValue.relative) {
            this.emissionDiff -= this.emission;
        }
        if (!this.lifeValue.independent) {
            this.generateLifeValues();
        }
        if (!this.lifeOffsetValue.independent) {
            this.generateLifeOffsetValues();
        }
        this.spawnWidth = this.spawnWidthValue.newLowValue();
        this.spawnWidthDiff = this.spawnWidthValue.newHighValue();
        if (!this.spawnWidthValue.relative) {
            this.spawnWidthDiff -= this.spawnWidth;
        }
        this.spawnHeight = this.spawnHeightValue.newLowValue();
        this.spawnHeightDiff = this.spawnHeightValue.newHighValue();
        if (!this.spawnHeightValue.relative) {
            this.spawnHeightDiff -= this.spawnHeight;
        }
        this.updateFlags = 0;
        if (this.angleValue.active && this.angleValue.timeline.length > 1) {
            this.updateFlags |= 2;
        }
        if (this.velocityValue.active) {
            this.updateFlags |= 8;
        }
        if (this.xScaleValue.timeline.length > 1) {
            this.updateFlags |= 1;
        }
        if (this.yScaleValue.active && this.yScaleValue.timeline.length > 1) {
            this.updateFlags |= 1;
        }
        if (this.rotationValue.active && this.rotationValue.timeline.length > 1) {
            this.updateFlags |= 4;
        }
        if (this.windValue.active) {
            this.updateFlags |= 0x10;
        }
        if (this.gravityValue.active) {
            this.updateFlags |= 0x20;
        }
        if (this.tintValue.timeline.length > 1) {
            this.updateFlags |= 0x40;
        }
        if (this.spriteMode == ParticleEmitter$SpriteMode.animated) {
            this.updateFlags |= 0x80;
        }
    }

    protected ParticleEmitter$Particle newParticle(Sprite sprite) {
        return new ParticleEmitter$Particle(sprite);
    }

    protected ParticleEmitter$Particle[] getParticles() {
        return this.particles;
    }

    private void activateParticle(int n2) {
        Sprite sprite = null;
        switch (this.spriteMode) {
            case single: 
            case animated: {
                sprite = this.sprites.first();
                break;
            }
            case random: {
                sprite = this.sprites.random();
            }
        }
        ParticleEmitter$Particle particleEmitter$Particle = this.particles[n2];
        if (particleEmitter$Particle == null) {
            this.particles[n2] = particleEmitter$Particle = this.newParticle(sprite);
            ((TextureRegion)particleEmitter$Particle).flip(this.flipX, this.flipY);
        } else {
            particleEmitter$Particle.set(sprite);
        }
        float f2 = this.durationTimer / this.duration;
        int n3 = this.updateFlags;
        if (this.lifeValue.independent) {
            this.generateLifeValues();
        }
        if (this.lifeOffsetValue.independent) {
            this.generateLifeOffsetValues();
        }
        ParticleEmitter$Particle particleEmitter$Particle2 = particleEmitter$Particle;
        particleEmitter$Particle2.currentLife = particleEmitter$Particle2.life = this.life + (int)((float)this.lifeDiff * this.lifeValue.getScale(f2));
        if (this.velocityValue.active) {
            particleEmitter$Particle.velocity = this.velocityValue.newLowValue();
            particleEmitter$Particle.velocityDiff = this.velocityValue.newHighValue();
            if (!this.velocityValue.relative) {
                particleEmitter$Particle.velocityDiff -= particleEmitter$Particle.velocity;
            }
        }
        particleEmitter$Particle.angle = this.angleValue.newLowValue();
        particleEmitter$Particle.angleDiff = this.angleValue.newHighValue();
        if (!this.angleValue.relative) {
            particleEmitter$Particle.angleDiff -= particleEmitter$Particle.angle;
        }
        float f3 = 0.0f;
        if ((n3 & 2) == 0) {
            particleEmitter$Particle.angle = f3 = particleEmitter$Particle.angle + particleEmitter$Particle.angleDiff * this.angleValue.getScale(0.0f);
            particleEmitter$Particle.angleCos = MathUtils.cosDeg(f3);
            particleEmitter$Particle.angleSin = MathUtils.sinDeg(f3);
        }
        float f4 = sprite.getWidth();
        float f5 = sprite.getHeight();
        particleEmitter$Particle.xScale = this.xScaleValue.newLowValue() / f4;
        particleEmitter$Particle.xScaleDiff = this.xScaleValue.newHighValue() / f4;
        if (!this.xScaleValue.relative) {
            particleEmitter$Particle.xScaleDiff -= particleEmitter$Particle.xScale;
        }
        if (this.yScaleValue.active) {
            particleEmitter$Particle.yScale = this.yScaleValue.newLowValue() / f5;
            particleEmitter$Particle.yScaleDiff = this.yScaleValue.newHighValue() / f5;
            if (!this.yScaleValue.relative) {
                particleEmitter$Particle.yScaleDiff -= particleEmitter$Particle.yScale;
            }
            ParticleEmitter$Particle particleEmitter$Particle3 = particleEmitter$Particle;
            particleEmitter$Particle3.setScale(particleEmitter$Particle3.xScale + particleEmitter$Particle.xScaleDiff * this.xScaleValue.getScale(0.0f), particleEmitter$Particle.yScale + particleEmitter$Particle.yScaleDiff * this.yScaleValue.getScale(0.0f));
        } else {
            ParticleEmitter$Particle particleEmitter$Particle4 = particleEmitter$Particle;
            particleEmitter$Particle4.setScale(particleEmitter$Particle4.xScale + particleEmitter$Particle.xScaleDiff * this.xScaleValue.getScale(0.0f));
        }
        if (this.rotationValue.active) {
            particleEmitter$Particle.rotation = this.rotationValue.newLowValue();
            particleEmitter$Particle.rotationDiff = this.rotationValue.newHighValue();
            if (!this.rotationValue.relative) {
                particleEmitter$Particle.rotationDiff -= particleEmitter$Particle.rotation;
            }
            float f6 = particleEmitter$Particle.rotation + particleEmitter$Particle.rotationDiff * this.rotationValue.getScale(0.0f);
            if (this.aligned) {
                f6 += f3;
            }
            particleEmitter$Particle.setRotation(f6);
        }
        if (this.windValue.active) {
            particleEmitter$Particle.wind = this.windValue.newLowValue();
            particleEmitter$Particle.windDiff = this.windValue.newHighValue();
            if (!this.windValue.relative) {
                particleEmitter$Particle.windDiff -= particleEmitter$Particle.wind;
            }
        }
        if (this.gravityValue.active) {
            particleEmitter$Particle.gravity = this.gravityValue.newLowValue();
            particleEmitter$Particle.gravityDiff = this.gravityValue.newHighValue();
            if (!this.gravityValue.relative) {
                particleEmitter$Particle.gravityDiff -= particleEmitter$Particle.gravity;
            }
        }
        float[] fArray = particleEmitter$Particle.tint;
        if (particleEmitter$Particle.tint == null) {
            particleEmitter$Particle.tint = fArray = new float[3];
        }
        float[] fArray2 = this.tintValue.getColor(0.0f);
        fArray[0] = fArray2[0];
        fArray[1] = fArray2[1];
        fArray[2] = fArray2[2];
        particleEmitter$Particle.transparency = this.transparencyValue.newLowValue();
        particleEmitter$Particle.transparencyDiff = this.transparencyValue.newHighValue() - particleEmitter$Particle.transparency;
        float f7 = this.x;
        if (this.xOffsetValue.active) {
            f7 += this.xOffsetValue.newLowValue();
        }
        float f8 = this.y;
        if (this.yOffsetValue.active) {
            f8 += this.yOffsetValue.newLowValue();
        }
        switch (this.spawnShapeValue.shape) {
            case square: {
                float f9 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f2);
                float f10 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f2);
                f7 += MathUtils.random(f9) - f9 * 0.5f;
                f8 += MathUtils.random(f10) - f10 * 0.5f;
                break;
            }
            case ellipse: {
                float f11;
                float f12;
                float f13;
                float f14;
                float f9 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f2);
                float f15 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f2);
                float f16 = f9 * 0.5f;
                if (f16 == 0.0f || (f15 *= 0.5f) == 0.0f) break;
                f15 = f16 / f15;
                if (this.spawnShapeValue.edges) {
                    float f17;
                    switch (this.spawnShapeValue.side) {
                        case top: {
                            f17 = -MathUtils.random(179.0f);
                            break;
                        }
                        case bottom: {
                            f17 = MathUtils.random(179.0f);
                            break;
                        }
                        default: {
                            f17 = MathUtils.random(360.0f);
                        }
                    }
                    float f18 = MathUtils.cosDeg(f17);
                    float f19 = MathUtils.sinDeg(f17);
                    f7 += f18 * f16;
                    f8 += f19 * f16 / f15;
                    if ((n3 & 2) != 0) break;
                    particleEmitter$Particle.angle = f17;
                    particleEmitter$Particle.angleCos = f18;
                    particleEmitter$Particle.angleSin = f19;
                    break;
                }
                float f20 = f16;
                float f21 = f20 * f20;
                do {
                    f12 = MathUtils.random(f9) - f16;
                    f11 = MathUtils.random(f9) - f16;
                    f14 = f12;
                    f13 = f11;
                } while (!(f14 * f14 + f13 * f13 <= f21));
                f7 += f12;
                f8 += f11 / f15;
                break;
            }
            case line: {
                float f9 = this.spawnWidth + this.spawnWidthDiff * this.spawnWidthValue.getScale(f2);
                float f22 = this.spawnHeight + this.spawnHeightDiff * this.spawnHeightValue.getScale(f2);
                if (f9 != 0.0f) {
                    float f23 = f9 * MathUtils.random();
                    f7 += f23;
                    f8 += f23 * (f22 / f9);
                    break;
                }
                f8 += f22 * MathUtils.random();
            }
        }
        particleEmitter$Particle.setBounds(f7 - f4 * 0.5f, f8 - f5 * 0.5f, f4, f5);
        int n4 = (int)((float)this.lifeOffset + (float)this.lifeOffsetDiff * this.lifeOffsetValue.getScale(f2));
        if (n4 > 0) {
            if (n4 >= particleEmitter$Particle.currentLife) {
                n4 = particleEmitter$Particle.currentLife - 1;
            }
            this.updateParticle(particleEmitter$Particle, (float)n4 / 1000.0f, n4);
        }
    }

    private boolean updateParticle(ParticleEmitter$Particle particleEmitter$Particle, float f2, int n2) {
        int n3;
        float f3;
        float f4;
        float f5;
        if ((n2 = particleEmitter$Particle.currentLife - n2) <= 0) {
            return false;
        }
        particleEmitter$Particle.currentLife = n2;
        float f6 = 1.0f - (float)particleEmitter$Particle.currentLife / (float)particleEmitter$Particle.life;
        int n4 = this.updateFlags;
        if ((n4 & 1) != 0) {
            if (this.yScaleValue.active) {
                ParticleEmitter$Particle particleEmitter$Particle2 = particleEmitter$Particle;
                particleEmitter$Particle2.setScale(particleEmitter$Particle2.xScale + particleEmitter$Particle.xScaleDiff * this.xScaleValue.getScale(f6), particleEmitter$Particle.yScale + particleEmitter$Particle.yScaleDiff * this.yScaleValue.getScale(f6));
            } else {
                ParticleEmitter$Particle particleEmitter$Particle3 = particleEmitter$Particle;
                particleEmitter$Particle3.setScale(particleEmitter$Particle3.xScale + particleEmitter$Particle.xScaleDiff * this.xScaleValue.getScale(f6));
            }
        }
        if ((n4 & 8) != 0) {
            float f7 = (particleEmitter$Particle.velocity + particleEmitter$Particle.velocityDiff * this.velocityValue.getScale(f6)) * f2;
            if ((n4 & 2) != 0) {
                f5 = particleEmitter$Particle.angle + particleEmitter$Particle.angleDiff * this.angleValue.getScale(f6);
                f4 = f7 * MathUtils.cosDeg(f5);
                f3 = f7 * MathUtils.sinDeg(f5);
                if ((n4 & 4) != 0) {
                    f7 = particleEmitter$Particle.rotation + particleEmitter$Particle.rotationDiff * this.rotationValue.getScale(f6);
                    if (this.aligned) {
                        f7 += f5;
                    }
                    particleEmitter$Particle.setRotation(f7);
                }
            } else {
                f4 = f7 * particleEmitter$Particle.angleCos;
                f3 = f7 * particleEmitter$Particle.angleSin;
                if (this.aligned || (n4 & 4) != 0) {
                    f5 = particleEmitter$Particle.rotation + particleEmitter$Particle.rotationDiff * this.rotationValue.getScale(f6);
                    if (this.aligned) {
                        f5 += particleEmitter$Particle.angle;
                    }
                    particleEmitter$Particle.setRotation(f5);
                }
            }
            if ((n4 & 0x10) != 0) {
                f4 += (particleEmitter$Particle.wind + particleEmitter$Particle.windDiff * this.windValue.getScale(f6)) * f2;
            }
            if ((n4 & 0x20) != 0) {
                f3 += (particleEmitter$Particle.gravity + particleEmitter$Particle.gravityDiff * this.gravityValue.getScale(f6)) * f2;
            }
            particleEmitter$Particle.translate(f4, f3);
        } else if ((n4 & 4) != 0) {
            ParticleEmitter$Particle particleEmitter$Particle4 = particleEmitter$Particle;
            particleEmitter$Particle4.setRotation(particleEmitter$Particle4.rotation + particleEmitter$Particle.rotationDiff * this.rotationValue.getScale(f6));
        }
        float[] fArray = (n4 & 0x40) != 0 ? this.tintValue.getColor(f6) : particleEmitter$Particle.tint;
        if (this.premultipliedAlpha) {
            f4 = this.additive ? 0.0f : 1.0f;
            f3 = particleEmitter$Particle.transparency + particleEmitter$Particle.transparencyDiff * this.transparencyValue.getScale(f6);
            particleEmitter$Particle.setColor(fArray[0] * f3, fArray[1] * f3, fArray[2] * f3, f3 * f4);
        } else {
            particleEmitter$Particle.setColor(fArray[0], fArray[1], fArray[2], particleEmitter$Particle.transparency + particleEmitter$Particle.transparencyDiff * this.transparencyValue.getScale(f6));
        }
        if ((n4 & 0x80) != 0 && particleEmitter$Particle.frame != (n3 = Math.min((int)(f6 * (float)this.sprites.size), this.sprites.size - 1))) {
            Sprite sprite = this.sprites.get(n3);
            f5 = particleEmitter$Particle.getWidth();
            float f8 = particleEmitter$Particle.getHeight();
            particleEmitter$Particle.setRegion(sprite);
            particleEmitter$Particle.setSize(sprite.getWidth(), sprite.getHeight());
            particleEmitter$Particle.setOrigin(sprite.getOriginX(), sprite.getOriginY());
            particleEmitter$Particle.translate((f5 - sprite.getWidth()) * 0.5f, (f8 - sprite.getHeight()) * 0.5f);
            particleEmitter$Particle.frame = n3;
        }
        return true;
    }

    private void generateLifeValues() {
        this.life = (int)this.lifeValue.newLowValue();
        this.lifeDiff = (int)this.lifeValue.newHighValue();
        if (!this.lifeValue.relative) {
            this.lifeDiff -= this.life;
        }
    }

    private void generateLifeOffsetValues() {
        this.lifeOffset = this.lifeOffsetValue.active ? (int)this.lifeOffsetValue.newLowValue() : 0;
        this.lifeOffsetDiff = (int)this.lifeOffsetValue.newHighValue();
        if (!this.lifeOffsetValue.relative) {
            this.lifeOffsetDiff -= this.lifeOffset;
        }
    }

    public void setPosition(float f2, float f3) {
        if (this.attached) {
            float f4 = f2 - this.x;
            float f5 = f3 - this.y;
            boolean[] blArray = this.active;
            int n2 = blArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!blArray[i2]) continue;
                this.particles[i2].translate(f4, f5);
            }
        }
        this.x = f2;
        this.y = f3;
    }

    public void setSprites(Array<Sprite> array) {
        this.sprites = array;
        if (array.size == 0) {
            return;
        }
        for (ParticleEmitter$Particle particleEmitter$Particle : this.particles) {
            if (particleEmitter$Particle == null) break;
            Sprite sprite = null;
            switch (this.spriteMode) {
                case single: {
                    sprite = array.first();
                    break;
                }
                case random: {
                    sprite = array.random();
                    break;
                }
                case animated: {
                    float f2 = 1.0f - (float)particleEmitter$Particle.currentLife / (float)particleEmitter$Particle.life;
                    particleEmitter$Particle.frame = Math.min((int)(f2 * (float)array.size), array.size - 1);
                    sprite = array.get(particleEmitter$Particle.frame);
                }
            }
            particleEmitter$Particle.setRegion(sprite);
            particleEmitter$Particle.setOrigin(sprite.getOriginX(), sprite.getOriginY());
        }
    }

    public void setSpriteMode(ParticleEmitter$SpriteMode particleEmitter$SpriteMode) {
        this.spriteMode = particleEmitter$SpriteMode;
    }

    public void preAllocateParticles() {
        if (this.sprites.isEmpty()) {
            throw new IllegalStateException("ParticleEmitter.setSprites() must have been called before preAllocateParticles()");
        }
        for (int i2 = 0; i2 < this.particles.length; ++i2) {
            ParticleEmitter$Particle particleEmitter$Particle = this.particles[i2];
            if (particleEmitter$Particle != null) continue;
            ParticleEmitter particleEmitter = this;
            this.particles[i2] = particleEmitter$Particle = particleEmitter.newParticle(particleEmitter.sprites.first());
            ((TextureRegion)particleEmitter$Particle).flip(this.flipX, this.flipY);
        }
    }

    public void allowCompletion() {
        this.allowCompletion = true;
        this.durationTimer = this.duration;
    }

    public boolean getAllowCompletion() {
        return this.allowCompletion;
    }

    public Array<Sprite> getSprites() {
        return this.sprites;
    }

    public ParticleEmitter$SpriteMode getSpriteMode() {
        return this.spriteMode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ParticleEmitter$ScaledNumericValue getLife() {
        return this.lifeValue;
    }

    public ParticleEmitter$ScaledNumericValue getXScale() {
        return this.xScaleValue;
    }

    public ParticleEmitter$ScaledNumericValue getYScale() {
        return this.yScaleValue;
    }

    public ParticleEmitter$ScaledNumericValue getRotation() {
        return this.rotationValue;
    }

    public ParticleEmitter$GradientColorValue getTint() {
        return this.tintValue;
    }

    public ParticleEmitter$ScaledNumericValue getVelocity() {
        return this.velocityValue;
    }

    public ParticleEmitter$ScaledNumericValue getWind() {
        return this.windValue;
    }

    public ParticleEmitter$ScaledNumericValue getGravity() {
        return this.gravityValue;
    }

    public ParticleEmitter$ScaledNumericValue getAngle() {
        return this.angleValue;
    }

    public ParticleEmitter$ScaledNumericValue getEmission() {
        return this.emissionValue;
    }

    public ParticleEmitter$ScaledNumericValue getTransparency() {
        return this.transparencyValue;
    }

    public ParticleEmitter$RangedNumericValue getDuration() {
        return this.durationValue;
    }

    public ParticleEmitter$RangedNumericValue getDelay() {
        return this.delayValue;
    }

    public ParticleEmitter$ScaledNumericValue getLifeOffset() {
        return this.lifeOffsetValue;
    }

    public ParticleEmitter$RangedNumericValue getXOffsetValue() {
        return this.xOffsetValue;
    }

    public ParticleEmitter$RangedNumericValue getYOffsetValue() {
        return this.yOffsetValue;
    }

    public ParticleEmitter$ScaledNumericValue getSpawnWidth() {
        return this.spawnWidthValue;
    }

    public ParticleEmitter$ScaledNumericValue getSpawnHeight() {
        return this.spawnHeightValue;
    }

    public ParticleEmitter$SpawnShapeValue getSpawnShape() {
        return this.spawnShapeValue;
    }

    public boolean isAttached() {
        return this.attached;
    }

    public void setAttached(boolean bl) {
        this.attached = bl;
    }

    public boolean isContinuous() {
        return this.continuous;
    }

    public void setContinuous(boolean bl) {
        this.continuous = bl;
    }

    public boolean isAligned() {
        return this.aligned;
    }

    public void setAligned(boolean bl) {
        this.aligned = bl;
    }

    public boolean isAdditive() {
        return this.additive;
    }

    public void setAdditive(boolean bl) {
        this.additive = bl;
    }

    public boolean cleansUpBlendFunction() {
        return this.cleansUpBlendFunction;
    }

    public void setCleansUpBlendFunction(boolean bl) {
        this.cleansUpBlendFunction = bl;
    }

    public boolean isBehind() {
        return this.behind;
    }

    public void setBehind(boolean bl) {
        this.behind = bl;
    }

    public boolean isPremultipliedAlpha() {
        return this.premultipliedAlpha;
    }

    public void setPremultipliedAlpha(boolean bl) {
        this.premultipliedAlpha = bl;
    }

    public int getMinParticleCount() {
        return this.minParticleCount;
    }

    public void setMinParticleCount(int n2) {
        this.minParticleCount = n2;
    }

    public int getMaxParticleCount() {
        return this.maxParticleCount;
    }

    public boolean isComplete() {
        if (this.continuous && !this.allowCompletion) {
            return false;
        }
        if (this.delayTimer < this.delay) {
            return false;
        }
        return this.durationTimer >= this.duration && this.activeCount == 0;
    }

    public float getPercentComplete() {
        if (this.delayTimer < this.delay) {
            return 0.0f;
        }
        return Math.min(1.0f, this.durationTimer / this.duration);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public Array<String> getImagePaths() {
        return this.imagePaths;
    }

    public void setImagePaths(Array<String> array) {
        this.imagePaths = array;
    }

    public void setFlip(boolean bl, boolean bl2) {
        this.flipX = bl;
        this.flipY = bl2;
        if (this.particles == null) {
            return;
        }
        for (ParticleEmitter$Particle particleEmitter$Particle : this.particles) {
            if (particleEmitter$Particle == null) continue;
            ((TextureRegion)particleEmitter$Particle).flip(bl, bl2);
        }
    }

    public void flipY() {
        this.angleValue.setHigh(-this.angleValue.getHighMin(), -this.angleValue.getHighMax());
        this.angleValue.setLow(-this.angleValue.getLowMin(), -this.angleValue.getLowMax());
        this.gravityValue.setHigh(-this.gravityValue.getHighMin(), -this.gravityValue.getHighMax());
        this.gravityValue.setLow(-this.gravityValue.getLowMin(), -this.gravityValue.getLowMax());
        this.windValue.setHigh(-this.windValue.getHighMin(), -this.windValue.getHighMax());
        this.windValue.setLow(-this.windValue.getLowMin(), -this.windValue.getLowMax());
        this.rotationValue.setHigh(-this.rotationValue.getHighMin(), -this.rotationValue.getHighMax());
        this.rotationValue.setLow(-this.rotationValue.getLowMin(), -this.rotationValue.getLowMax());
        this.yOffsetValue.setLow(-this.yOffsetValue.getLowMin(), -this.yOffsetValue.getLowMax());
    }

    public BoundingBox getBoundingBox() {
        if (this.bounds == null) {
            this.bounds = new BoundingBox();
        }
        ParticleEmitter$Particle[] particleEmitter$ParticleArray = this.particles;
        boolean[] blArray = this.active;
        BoundingBox boundingBox = this.bounds;
        boundingBox.inf();
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!blArray[i2]) continue;
            Rectangle rectangle = particleEmitter$ParticleArray[i2].getBoundingRectangle();
            boundingBox.ext(rectangle.x, rectangle.y, 0.0f);
            boundingBox.ext(rectangle.x + rectangle.width, rectangle.y + rectangle.height, 0.0f);
        }
        return boundingBox;
    }

    protected ParticleEmitter$RangedNumericValue[] getXSizeValues() {
        if (this.xSizeValues == null) {
            this.xSizeValues = new ParticleEmitter$RangedNumericValue[3];
            this.xSizeValues[0] = this.xScaleValue;
            this.xSizeValues[1] = this.spawnWidthValue;
            this.xSizeValues[2] = this.xOffsetValue;
        }
        return this.xSizeValues;
    }

    protected ParticleEmitter$RangedNumericValue[] getYSizeValues() {
        if (this.ySizeValues == null) {
            this.ySizeValues = new ParticleEmitter$RangedNumericValue[3];
            this.ySizeValues[0] = this.yScaleValue;
            this.ySizeValues[1] = this.spawnHeightValue;
            this.ySizeValues[2] = this.yOffsetValue;
        }
        return this.ySizeValues;
    }

    protected ParticleEmitter$RangedNumericValue[] getMotionValues() {
        if (this.motionValues == null) {
            this.motionValues = new ParticleEmitter$RangedNumericValue[3];
            this.motionValues[0] = this.velocityValue;
            this.motionValues[1] = this.windValue;
            this.motionValues[2] = this.gravityValue;
        }
        return this.motionValues;
    }

    public void scaleSize(float f2) {
        if (f2 == 1.0f) {
            return;
        }
        float f3 = f2;
        this.scaleSize(f3, f3);
    }

    public void scaleSize(float f2, float f3) {
        if (f2 == 1.0f && f3 == 1.0f) {
            return;
        }
        for (ParticleEmitter$RangedNumericValue particleEmitter$RangedNumericValue : this.getXSizeValues()) {
            particleEmitter$RangedNumericValue.scale(f2);
        }
        for (ParticleEmitter$RangedNumericValue particleEmitter$RangedNumericValue : this.getYSizeValues()) {
            particleEmitter$RangedNumericValue.scale(f3);
        }
    }

    public void scaleMotion(float f2) {
        if (f2 == 1.0f) {
            return;
        }
        for (ParticleEmitter$RangedNumericValue particleEmitter$RangedNumericValue : this.getMotionValues()) {
            particleEmitter$RangedNumericValue.scale(f2);
        }
    }

    public void matchSize(ParticleEmitter particleEmitter) {
        this.matchXSize(particleEmitter);
        this.matchYSize(particleEmitter);
    }

    public void matchXSize(ParticleEmitter particleEmitter$RangedNumericValueArray) {
        ParticleEmitter$RangedNumericValue[] particleEmitter$RangedNumericValueArray2 = this.getXSizeValues();
        particleEmitter$RangedNumericValueArray = particleEmitter$RangedNumericValueArray.getXSizeValues();
        for (int i2 = 0; i2 < particleEmitter$RangedNumericValueArray2.length; ++i2) {
            particleEmitter$RangedNumericValueArray2[i2].set(particleEmitter$RangedNumericValueArray[i2]);
        }
    }

    public void matchYSize(ParticleEmitter particleEmitter$RangedNumericValueArray) {
        ParticleEmitter$RangedNumericValue[] particleEmitter$RangedNumericValueArray2 = this.getYSizeValues();
        particleEmitter$RangedNumericValueArray = particleEmitter$RangedNumericValueArray.getYSizeValues();
        for (int i2 = 0; i2 < particleEmitter$RangedNumericValueArray2.length; ++i2) {
            particleEmitter$RangedNumericValueArray2[i2].set(particleEmitter$RangedNumericValueArray[i2]);
        }
    }

    public void matchMotion(ParticleEmitter particleEmitter$RangedNumericValueArray) {
        ParticleEmitter$RangedNumericValue[] particleEmitter$RangedNumericValueArray2 = this.getMotionValues();
        particleEmitter$RangedNumericValueArray = particleEmitter$RangedNumericValueArray.getMotionValues();
        for (int i2 = 0; i2 < particleEmitter$RangedNumericValueArray2.length; ++i2) {
            particleEmitter$RangedNumericValueArray2[i2].set(particleEmitter$RangedNumericValueArray[i2]);
        }
    }

    public void save(Writer writer) {
        writer.write(this.name + "\n");
        writer.write("- Delay -\n");
        ((ParticleEmitter$ParticleValue)this.delayValue).save(writer);
        writer.write("- Duration - \n");
        ((ParticleEmitter$ParticleValue)this.durationValue).save(writer);
        writer.write("- Count - \n");
        writer.write("min: " + this.minParticleCount + "\n");
        writer.write("max: " + this.maxParticleCount + "\n");
        writer.write("- Emission - \n");
        ((ParticleEmitter$ParticleValue)this.emissionValue).save(writer);
        writer.write("- Life - \n");
        ((ParticleEmitter$ParticleValue)this.lifeValue).save(writer);
        writer.write("- Life Offset - \n");
        ((ParticleEmitter$ParticleValue)this.lifeOffsetValue).save(writer);
        writer.write("- X Offset - \n");
        ((ParticleEmitter$ParticleValue)this.xOffsetValue).save(writer);
        writer.write("- Y Offset - \n");
        ((ParticleEmitter$ParticleValue)this.yOffsetValue).save(writer);
        writer.write("- Spawn Shape - \n");
        ((ParticleEmitter$ParticleValue)this.spawnShapeValue).save(writer);
        writer.write("- Spawn Width - \n");
        ((ParticleEmitter$ParticleValue)this.spawnWidthValue).save(writer);
        writer.write("- Spawn Height - \n");
        ((ParticleEmitter$ParticleValue)this.spawnHeightValue).save(writer);
        writer.write("- X Scale - \n");
        ((ParticleEmitter$ParticleValue)this.xScaleValue).save(writer);
        writer.write("- Y Scale - \n");
        ((ParticleEmitter$ParticleValue)this.yScaleValue).save(writer);
        writer.write("- Velocity - \n");
        ((ParticleEmitter$ParticleValue)this.velocityValue).save(writer);
        writer.write("- Angle - \n");
        ((ParticleEmitter$ParticleValue)this.angleValue).save(writer);
        writer.write("- Rotation - \n");
        ((ParticleEmitter$ParticleValue)this.rotationValue).save(writer);
        writer.write("- Wind - \n");
        ((ParticleEmitter$ParticleValue)this.windValue).save(writer);
        writer.write("- Gravity - \n");
        ((ParticleEmitter$ParticleValue)this.gravityValue).save(writer);
        writer.write("- Tint - \n");
        ((ParticleEmitter$ParticleValue)this.tintValue).save(writer);
        writer.write("- Transparency - \n");
        ((ParticleEmitter$ParticleValue)this.transparencyValue).save(writer);
        writer.write("- Options - \n");
        writer.write("attached: " + this.attached + "\n");
        writer.write("continuous: " + this.continuous + "\n");
        writer.write("aligned: " + this.aligned + "\n");
        writer.write("additive: " + this.additive + "\n");
        writer.write("behind: " + this.behind + "\n");
        writer.write("premultipliedAlpha: " + this.premultipliedAlpha + "\n");
        writer.write("spriteMode: " + this.spriteMode.toString() + "\n");
        writer.write("- Image Paths -\n");
        for (String string : this.imagePaths) {
            writer.write(string + "\n");
        }
        writer.write("\n");
    }

    public void load(BufferedReader bufferedReader) {
        try {
            this.name = ParticleEmitter.readString(bufferedReader, "name");
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.delayValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.durationValue).load(bufferedReader);
            bufferedReader.readLine();
            this.setMinParticleCount(ParticleEmitter.readInt(bufferedReader, "minParticleCount"));
            this.setMaxParticleCount(ParticleEmitter.readInt(bufferedReader, "maxParticleCount"));
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.emissionValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.lifeValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.lifeOffsetValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.xOffsetValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.yOffsetValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.spawnShapeValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.spawnWidthValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.spawnHeightValue).load(bufferedReader);
            String string = bufferedReader.readLine();
            if (string.trim().equals("- Scale -")) {
                ((ParticleEmitter$ParticleValue)this.xScaleValue).load(bufferedReader);
                this.yScaleValue.setActive(false);
            } else {
                ((ParticleEmitter$ParticleValue)this.xScaleValue).load(bufferedReader);
                bufferedReader.readLine();
                ((ParticleEmitter$ParticleValue)this.yScaleValue).load(bufferedReader);
            }
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.velocityValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.angleValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.rotationValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.windValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.gravityValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.tintValue).load(bufferedReader);
            bufferedReader.readLine();
            ((ParticleEmitter$ParticleValue)this.transparencyValue).load(bufferedReader);
            bufferedReader.readLine();
            this.attached = ParticleEmitter.readBoolean(bufferedReader, "attached");
            this.continuous = ParticleEmitter.readBoolean(bufferedReader, "continuous");
            this.aligned = ParticleEmitter.readBoolean(bufferedReader, "aligned");
            this.additive = ParticleEmitter.readBoolean(bufferedReader, "additive");
            this.behind = ParticleEmitter.readBoolean(bufferedReader, "behind");
            string = bufferedReader.readLine();
            if (string.startsWith("premultipliedAlpha")) {
                this.premultipliedAlpha = ParticleEmitter.readBoolean(string);
                string = bufferedReader.readLine();
            }
            if (string.startsWith("spriteMode")) {
                this.spriteMode = ParticleEmitter$SpriteMode.valueOf(ParticleEmitter.readString(string));
                bufferedReader.readLine();
            }
            Array<String> array = new Array<String>();
            while ((string = bufferedReader.readLine()) != null && !string.isEmpty()) {
                array.add(string);
            }
            this.setImagePaths(array);
            return;
        }
        catch (RuntimeException runtimeException) {
            if (this.name == null) {
                throw runtimeException;
            }
            throw new RuntimeException("Error parsing emitter: " + this.name, runtimeException);
        }
    }

    static String readString(String string) {
        String string2 = string;
        return string2.substring(string2.indexOf(":") + 1).trim();
    }

    static String readString(BufferedReader object, String string) {
        if ((object = ((BufferedReader)object).readLine()) == null) {
            throw new IOException("Missing value: " + string);
        }
        return ParticleEmitter.readString((String)object);
    }

    static boolean readBoolean(String string) {
        return Boolean.parseBoolean(ParticleEmitter.readString(string));
    }

    static boolean readBoolean(BufferedReader bufferedReader, String string) {
        return Boolean.parseBoolean(ParticleEmitter.readString(bufferedReader, string));
    }

    static int readInt(BufferedReader bufferedReader, String string) {
        return Integer.parseInt(ParticleEmitter.readString(bufferedReader, string));
    }

    static float readFloat(BufferedReader bufferedReader, String string) {
        return Float.parseFloat(ParticleEmitter.readString(bufferedReader, string));
    }
}

