/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.SynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonRegionLoader$PolygonRegionParameters;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.EarClippingTriangulator;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedReader;
import java.io.IOException;

public class PolygonRegionLoader
extends SynchronousAssetLoader<PolygonRegion, PolygonRegionLoader$PolygonRegionParameters> {
    private PolygonRegionLoader$PolygonRegionParameters defaultParameters = new PolygonRegionLoader$PolygonRegionParameters();
    private EarClippingTriangulator triangulator = new EarClippingTriangulator();

    public PolygonRegionLoader() {
        this(new InternalFileHandleResolver());
    }

    public PolygonRegionLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public PolygonRegion load(AssetManager disposable, String string, FileHandle fileHandle, PolygonRegionLoader$PolygonRegionParameters polygonRegionLoader$PolygonRegionParameters) {
        AssetManager assetManager = disposable;
        disposable = (Texture)assetManager.get(assetManager.getDependencies(string).first());
        return this.load(new TextureRegion((Texture)disposable), fileHandle);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String string, FileHandle fileHandle, PolygonRegionLoader$PolygonRegionParameters object) {
        Object object2;
        if (object == null) {
            object = this.defaultParameters;
        }
        String string2 = null;
        try {
            object2 = fileHandle.reader(((PolygonRegionLoader$PolygonRegionParameters)object).readerBuffer);
            String string3 = object2.readLine();
            while (string3 != null) {
                if (string3.startsWith(((PolygonRegionLoader$PolygonRegionParameters)object).texturePrefix)) {
                    string2 = string3.substring(((PolygonRegionLoader$PolygonRegionParameters)object).texturePrefix.length());
                    break;
                }
                string3 = object2.readLine();
            }
            object2.close();
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading " + string, iOException);
        }
        if (string2 == null && ((PolygonRegionLoader$PolygonRegionParameters)object).textureExtensions != null) {
            object2 = ((PolygonRegionLoader$PolygonRegionParameters)object).textureExtensions;
            int n2 = ((PolygonRegionLoader$PolygonRegionParameters)object).textureExtensions.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                object = object2[i2];
                FileHandle fileHandle2 = fileHandle;
                object = fileHandle2.sibling(fileHandle2.nameWithoutExtension().concat("." + (String)object));
                if (!((FileHandle)object).exists()) continue;
                string2 = ((FileHandle)object).name();
            }
        }
        if (string2 != null) {
            object2 = new Array<AssetDescriptor<Texture>>(1);
            object2.add(new AssetDescriptor<Texture>(fileHandle.sibling(string2), Texture.class));
            return object2;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PolygonRegion load(TextureRegion textureRegion, FileHandle fileHandle) {
        BufferedReader bufferedReader = fileHandle.reader(256);
        try {
            String[] stringArray;
            do {
                stringArray = bufferedReader.readLine();
                if (stringArray == null) throw new GdxRuntimeException("Polygon shape not found: " + fileHandle);
            } while (!stringArray.startsWith("s"));
            stringArray = stringArray.substring(1).trim().split(",");
            float[] fArray = new float[stringArray.length];
            int n2 = fArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                fArray[i2] = Float.parseFloat(stringArray[i2]);
            }
            PolygonRegion polygonRegion = new PolygonRegion(textureRegion, fArray, this.triangulator.computeTriangles(fArray).toArray());
            return polygonRegion;
        }
        catch (IOException iOException) {
            throw new GdxRuntimeException("Error reading polygon shape file: " + fileHandle, iOException);
        }
        finally {
            StreamUtils.closeQuietly(bufferedReader);
        }
    }
}

