/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Mesh$VertexDataType;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class SpriteBatch
implements Batch {
    @Deprecated
    public static Mesh$VertexDataType defaultVertexDataType = Mesh$VertexDataType.VertexArray;
    private Mesh mesh;
    final float[] vertices;
    int idx = 0;
    Texture lastTexture = null;
    float invTexWidth = 0.0f;
    float invTexHeight = 0.0f;
    boolean drawing = false;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private boolean blendingDisabled = false;
    private int blendSrcFunc = 770;
    private int blendDstFunc = 771;
    private int blendSrcFuncAlpha = 770;
    private int blendDstFuncAlpha = 771;
    private final ShaderProgram shader;
    private ShaderProgram customShader = null;
    private boolean ownsShader;
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    float colorPacked = Color.WHITE_FLOAT_BITS;
    public int renderCalls = 0;
    public int totalRenderCalls = 0;
    public int maxSpritesInBatch = 0;

    public SpriteBatch() {
        this(1000, null);
    }

    public SpriteBatch(int n2) {
        this(n2, null);
    }

    public SpriteBatch(int n2, ShaderProgram shaderProgram) {
        if (n2 > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + n2);
        }
        Mesh$VertexDataType mesh$VertexDataType = Gdx.gl30 != null ? Mesh$VertexDataType.VertexBufferObjectWithVAO : defaultVertexDataType;
        this.mesh = new Mesh(mesh$VertexDataType, false, n2 << 2, n2 * 6, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.vertices = new float[n2 * 20];
        short[] sArray = new short[n2 *= 6];
        short s2 = 0;
        int n3 = 0;
        while (n3 < n2) {
            sArray[n3] = s2;
            sArray[n3 + 1] = (short)(s2 + 1);
            sArray[n3 + 2] = (short)(s2 + 2);
            sArray[n3 + 3] = (short)(s2 + 2);
            sArray[n3 + 4] = (short)(s2 + 3);
            sArray[n3 + 5] = s2;
            n3 += 6;
            s2 = (short)(s2 + 4);
        }
        this.mesh.setIndices(sArray);
        if (shaderProgram == null) {
            this.shader = SpriteBatch.createDefaultShader();
            this.ownsShader = true;
        } else {
            this.shader = shaderProgram;
        }
        if (mesh$VertexDataType != Mesh$VertexDataType.VertexArray) {
            this.mesh.bind(this.shader);
            this.mesh.unbind(this.shader);
        }
    }

    public static ShaderProgram createDefaultShader() {
        Object object = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projTrans;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projTrans * a_position;\n}\n";
        String string = "#ifdef GL_ES\n#define LOWP lowp\nprecision mediump float;\n#else\n#define LOWP \n#endif\nvarying LOWP vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}";
        if (!((ShaderProgram)(object = new ShaderProgram((String)object, string))).isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + ((ShaderProgram)object).getLog());
        }
        return object;
    }

    @Override
    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("SpriteBatch.end must be called before begin.");
        }
        this.renderCalls = 0;
        Gdx.gl.glDepthMask(false);
        if (this.customShader != null) {
            this.customShader.bind();
        } else {
            this.shader.bind();
        }
        this.setupMatrices();
        this.drawing = true;
    }

    @Override
    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before end.");
        }
        if (this.idx > 0) {
            this.flush();
        }
        this.lastTexture = null;
        this.drawing = false;
        GL20 gL20 = Gdx.gl;
        gL20.glDepthMask(true);
        if (this.isBlendingEnabled()) {
            gL20.glDisable(3042);
        }
    }

    @Override
    public void setColor(Color color) {
        this.color.set(color);
        this.colorPacked = color.toFloatBits();
    }

    @Override
    public void setColor(float f2, float f3, float f4, float f5) {
        this.color.set(f2, f3, f4, f5);
        this.colorPacked = this.color.toFloatBits();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setPackedColor(float f2) {
        Color.abgr8888ToColor(this.color, f2);
        this.colorPacked = f2;
    }

    @Override
    public float getPackedColor() {
        return this.colorPacked;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        float f11;
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f12 = f2 + f4;
        f2 = f3 + f5;
        f3 = -f4;
        float f13 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f3 *= f8;
            f13 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f3;
        f7 = f13;
        f8 = f5;
        f9 = f4;
        if (f10 != 0.0f) {
            f13 = MathUtils.cosDeg(f10);
            f11 = MathUtils.sinDeg(f10);
            f10 = f13 * f6 - f11 * f7;
            f6 = f11 * f6 + f13 * f7;
            f7 = f13 * f3 - f11 * f8;
            f3 = f11 * f3 + f13 * f8;
            f8 = f13 * f9 - f11 * f5;
            f5 = f11 * f9 + f13 * f5;
            f4 = f10 + (f8 - f7);
            f9 = f5 - (f3 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f3;
            f3 = f8;
            f8 = f9;
            f9 = f13;
        }
        f10 += f12;
        f6 += f2;
        f7 += f12;
        f3 += f2;
        f8 += f12;
        f5 += f2;
        f4 += f12;
        f9 += f2;
        f13 = (float)n2 * this.invTexWidth;
        f11 = (float)(n3 + n5) * this.invTexHeight;
        f12 = (float)(n2 + n4) * this.invTexWidth;
        f2 = (float)n3 * this.invTexHeight;
        if (bl) {
            float f14 = f13;
            f13 = f12;
            f12 = f14;
        }
        if (bl2) {
            float f15 = f11;
            f11 = f2;
            f2 = f15;
        }
        float f16 = this.colorPacked;
        n3 = this.idx;
        fArray[n3] = f10;
        fArray[n3 + 1] = f6;
        fArray[n3 + 2] = f16;
        fArray[n3 + 3] = f13;
        fArray[n3 + 4] = f11;
        fArray[n3 + 5] = f7;
        fArray[n3 + 6] = f3;
        fArray[n3 + 7] = f16;
        fArray[n3 + 8] = f13;
        fArray[n3 + 9] = f2;
        fArray[n3 + 10] = f8;
        fArray[n3 + 11] = f5;
        fArray[n3 + 12] = f16;
        fArray[n3 + 13] = f12;
        fArray[n3 + 14] = f2;
        fArray[n3 + 15] = f4;
        fArray[n3 + 16] = f9;
        fArray[n3 + 17] = f16;
        fArray[n3 + 18] = f12;
        fArray[n3 + 19] = f11;
        this.idx = n3 + 20;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        void var11_19;
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f6 = (float)n2 * this.invTexWidth;
        float f7 = (float)(n3 + n5) * this.invTexHeight;
        float f8 = (float)(n2 + n4) * this.invTexWidth;
        float f9 = (float)n3 * this.invTexHeight;
        f4 = f2 + f4;
        f5 = f3 + f5;
        if (bl) {
            float f10 = f6;
            f6 = f8;
            f8 = f10;
        }
        if (var11_19 != false) {
            float f11 = f7;
            f7 = f9;
            f9 = f11;
        }
        float f12 = this.colorPacked;
        int n6 = this.idx;
        fArray[n6] = f2;
        fArray[n6 + 1] = f3;
        fArray[n6 + 2] = f12;
        fArray[n6 + 3] = f6;
        fArray[n6 + 4] = f7;
        fArray[n6 + 5] = f2;
        fArray[n6 + 6] = f5;
        fArray[n6 + 7] = f12;
        fArray[n6 + 8] = f6;
        fArray[n6 + 9] = f9;
        fArray[n6 + 10] = f4;
        fArray[n6 + 11] = f5;
        fArray[n6 + 12] = f12;
        fArray[n6 + 13] = f8;
        fArray[n6 + 14] = f9;
        fArray[n6 + 15] = f4;
        fArray[n6 + 16] = f3;
        fArray[n6 + 17] = f12;
        fArray[n6 + 18] = f8;
        fArray[n6 + 19] = f7;
        this.idx = n6 + 20;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, int n2, int n3, int n4, int n5) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f4 = (float)n2 * this.invTexWidth;
        float f5 = (float)(n3 + n5) * this.invTexHeight;
        float f6 = (float)(n2 + n4) * this.invTexWidth;
        float f7 = (float)n3 * this.invTexHeight;
        float f8 = f2 + (float)n4;
        float f9 = f3 + (float)n5;
        float f10 = this.colorPacked;
        int n6 = this.idx;
        fArray[n6] = f2;
        fArray[n6 + 1] = f3;
        fArray[n6 + 2] = f10;
        fArray[n6 + 3] = f4;
        fArray[n6 + 4] = f5;
        fArray[n6 + 5] = f2;
        fArray[n6 + 6] = f9;
        fArray[n6 + 7] = f10;
        fArray[n6 + 8] = f4;
        fArray[n6 + 9] = f7;
        fArray[n6 + 10] = f8;
        fArray[n6 + 11] = f9;
        fArray[n6 + 12] = f10;
        fArray[n6 + 13] = f6;
        fArray[n6 + 14] = f7;
        fArray[n6 + 15] = f8;
        fArray[n6 + 16] = f3;
        fArray[n6 + 17] = f10;
        fArray[n6 + 18] = f6;
        fArray[n6 + 19] = f5;
        this.idx = n6 + 20;
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f10 = f2 + f4;
        f4 = f3 + f5;
        f5 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f2;
        fArray[n2 + 1] = f3;
        fArray[n2 + 2] = f5;
        fArray[n2 + 3] = f6;
        fArray[n2 + 4] = f7;
        fArray[n2 + 5] = f2;
        fArray[n2 + 6] = f4;
        fArray[n2 + 7] = f5;
        fArray[n2 + 8] = f6;
        fArray[n2 + 9] = f9;
        fArray[n2 + 10] = f10;
        fArray[n2 + 11] = f4;
        fArray[n2 + 12] = f5;
        fArray[n2 + 13] = f8;
        fArray[n2 + 14] = f9;
        fArray[n2 + 15] = f10;
        fArray[n2 + 16] = f3;
        fArray[n2 + 17] = f5;
        fArray[n2 + 18] = f8;
        fArray[n2 + 19] = f7;
        this.idx = n2 + 20;
    }

    @Override
    public void draw(Texture texture, float f2, float f3) {
        this.draw(texture, f2, f3, (float)((GLTexture)texture).getWidth(), (float)((GLTexture)texture).getHeight());
    }

    @Override
    public void draw(Texture texture, float f2, float f3, float f4, float f5) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f6 = f2 + f4;
        f4 = f3 + f5;
        f5 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f2;
        fArray[n2 + 1] = f3;
        fArray[n2 + 2] = f5;
        fArray[n2 + 3] = 0.0f;
        fArray[n2 + 4] = 1.0f;
        fArray[n2 + 5] = f2;
        fArray[n2 + 6] = f4;
        fArray[n2 + 7] = f5;
        fArray[n2 + 8] = 0.0f;
        fArray[n2 + 9] = 0.0f;
        fArray[n2 + 10] = f6;
        fArray[n2 + 11] = f4;
        fArray[n2 + 12] = f5;
        fArray[n2 + 13] = 1.0f;
        fArray[n2 + 14] = 0.0f;
        fArray[n2 + 15] = f6;
        fArray[n2 + 16] = f3;
        fArray[n2 + 17] = f5;
        fArray[n2 + 18] = 1.0f;
        fArray[n2 + 19] = 1.0f;
        this.idx = n2 + 20;
    }

    @Override
    public void draw(Texture texture, float[] fArray, int n2, int n3) {
        int n4;
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        int n5 = n4 = this.vertices.length;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else {
            n5 = n4 - this.idx;
            if (n5 == 0) {
                this.flush();
                n5 = n4;
            }
        }
        int n6 = Math.min(n5, n3);
        System.arraycopy(fArray, n2, this.vertices, this.idx, n6);
        this.idx += n6;
        n3 -= n6;
        while (n3 > 0) {
            this.flush();
            n6 = Math.min(n4, n3);
            System.arraycopy(fArray, n2 += n6, this.vertices, 0, n6);
            this.idx += n6;
            n3 -= n6;
        }
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3) {
        this.draw(textureRegion, f2, f3, (float)textureRegion.getRegionWidth(), (float)textureRegion.getRegionHeight());
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        f4 = f2 + f4;
        f5 = f3 + f5;
        float f6 = textureRegion.u;
        float f7 = textureRegion.v2;
        float f8 = textureRegion.u2;
        float f9 = textureRegion.v;
        float f10 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f2;
        fArray[n2 + 1] = f3;
        fArray[n2 + 2] = f10;
        fArray[n2 + 3] = f6;
        fArray[n2 + 4] = f7;
        fArray[n2 + 5] = f2;
        fArray[n2 + 6] = f5;
        fArray[n2 + 7] = f10;
        fArray[n2 + 8] = f6;
        fArray[n2 + 9] = f9;
        fArray[n2 + 10] = f4;
        fArray[n2 + 11] = f5;
        fArray[n2 + 12] = f10;
        fArray[n2 + 13] = f8;
        fArray[n2 + 14] = f9;
        fArray[n2 + 15] = f4;
        fArray[n2 + 16] = f3;
        fArray[n2 + 17] = f10;
        fArray[n2 + 18] = f8;
        fArray[n2 + 19] = f7;
        this.idx = n2 + 20;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        f2 += f4;
        f3 += f5;
        float f12 = -f4;
        float f13 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f12 *= f8;
            f13 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f12;
        f7 = f13;
        f8 = f12;
        f9 = f5;
        f12 = f4;
        if (f10 != 0.0f) {
            f13 = MathUtils.cosDeg(f10);
            f11 = MathUtils.sinDeg(f10);
            f10 = f13 * f6 - f11 * f7;
            f6 = f11 * f6 + f13 * f7;
            f7 = f13 * f8 - f11 * f9;
            f8 = f11 * f8 + f13 * f9;
            f9 = f13 * f12 - f11 * f5;
            f5 = f11 * f12 + f13 * f5;
            f4 = f10 + (f9 - f7);
            f12 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f12;
            f12 = f13;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f12 += f3;
        f13 = textureRegion.u;
        f11 = textureRegion.v2;
        f2 = textureRegion.u2;
        float f14 = textureRegion.v;
        f3 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f10;
        fArray[n2 + 1] = f6;
        fArray[n2 + 2] = f3;
        fArray[n2 + 3] = f13;
        fArray[n2 + 4] = f11;
        fArray[n2 + 5] = f7;
        fArray[n2 + 6] = f8;
        fArray[n2 + 7] = f3;
        fArray[n2 + 8] = f13;
        fArray[n2 + 9] = f14;
        fArray[n2 + 10] = f9;
        fArray[n2 + 11] = f5;
        fArray[n2 + 12] = f3;
        fArray[n2 + 13] = f2;
        fArray[n2 + 14] = f14;
        fArray[n2 + 15] = f4;
        fArray[n2 + 16] = f12;
        fArray[n2 + 17] = f3;
        fArray[n2 + 18] = f2;
        fArray[n2 + 19] = f11;
        this.idx = n2 + 20;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, boolean bl) {
        float f11;
        float f12;
        float f13;
        float f14;
        float f15;
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        f2 += f4;
        f3 += f5;
        float f16 = -f4;
        float f17 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f16 *= f8;
            f17 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f16;
        f7 = f17;
        f8 = f16;
        f9 = f5;
        f16 = f4;
        if (f10 != 0.0f) {
            f17 = MathUtils.cosDeg(f10);
            f15 = MathUtils.sinDeg(f10);
            f10 = f17 * f6 - f15 * f7;
            f6 = f15 * f6 + f17 * f7;
            f7 = f17 * f8 - f15 * f9;
            f8 = f15 * f8 + f17 * f9;
            f9 = f17 * f16 - f15 * f5;
            f5 = f15 * f16 + f17 * f5;
            f4 = f10 + (f9 - f7);
            f16 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f16;
            f16 = f17;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f16 += f3;
        if (bl) {
            f17 = textureRegion.u2;
            f15 = textureRegion.v2;
            f2 = textureRegion.u;
            f3 = textureRegion.v2;
            f14 = textureRegion.u;
            f13 = textureRegion.v;
            f12 = textureRegion.u2;
            f11 = textureRegion.v;
        } else {
            f17 = textureRegion.u;
            f15 = textureRegion.v;
            f2 = textureRegion.u2;
            f3 = textureRegion.v;
            f14 = textureRegion.u2;
            f13 = textureRegion.v2;
            f12 = textureRegion.u;
            f11 = textureRegion.v2;
        }
        float f18 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f10;
        fArray[n2 + 1] = f6;
        fArray[n2 + 2] = f18;
        fArray[n2 + 3] = f17;
        fArray[n2 + 4] = f15;
        fArray[n2 + 5] = f7;
        fArray[n2 + 6] = f8;
        fArray[n2 + 7] = f18;
        fArray[n2 + 8] = f2;
        fArray[n2 + 9] = f3;
        fArray[n2 + 10] = f9;
        fArray[n2 + 11] = f5;
        fArray[n2 + 12] = f18;
        fArray[n2 + 13] = f14;
        fArray[n2 + 14] = f13;
        fArray[n2 + 15] = f4;
        fArray[n2 + 16] = f16;
        fArray[n2 + 17] = f18;
        fArray[n2 + 18] = f12;
        fArray[n2 + 19] = f11;
        this.idx = n2 + 20;
    }

    @Override
    public void draw(TextureRegion textureRegion, float f2, float f3, Affine2 affine2) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteBatch.begin must be called before draw.");
        }
        float[] fArray = this.vertices;
        Texture texture = textureRegion.texture;
        if (texture != this.lastTexture) {
            this.switchTexture(texture);
        } else if (this.idx == fArray.length) {
            this.flush();
        }
        float f4 = affine2.m02;
        float f5 = affine2.m12;
        float f6 = affine2.m01 * f3 + affine2.m02;
        float f7 = affine2.m11 * f3 + affine2.m12;
        float f8 = affine2.m00 * f2 + affine2.m01 * f3 + affine2.m02;
        f3 = affine2.m10 * f2 + affine2.m11 * f3 + affine2.m12;
        float f9 = affine2.m00 * f2 + affine2.m02;
        f2 = affine2.m10 * f2 + affine2.m12;
        float f10 = textureRegion.u;
        float f11 = textureRegion.v2;
        float f12 = textureRegion.u2;
        float f13 = textureRegion.v;
        float f14 = this.colorPacked;
        int n2 = this.idx;
        fArray[n2] = f4;
        fArray[n2 + 1] = f5;
        fArray[n2 + 2] = f14;
        fArray[n2 + 3] = f10;
        fArray[n2 + 4] = f11;
        fArray[n2 + 5] = f6;
        fArray[n2 + 6] = f7;
        fArray[n2 + 7] = f14;
        fArray[n2 + 8] = f10;
        fArray[n2 + 9] = f13;
        fArray[n2 + 10] = f8;
        fArray[n2 + 11] = f3;
        fArray[n2 + 12] = f14;
        fArray[n2 + 13] = f12;
        fArray[n2 + 14] = f13;
        fArray[n2 + 15] = f9;
        fArray[n2 + 16] = f2;
        fArray[n2 + 17] = f14;
        fArray[n2 + 18] = f12;
        fArray[n2 + 19] = f11;
        this.idx = n2 + 20;
    }

    @Override
    public void flush() {
        if (this.idx == 0) {
            return;
        }
        ++this.renderCalls;
        ++this.totalRenderCalls;
        int n2 = this.idx / 20;
        if (n2 > this.maxSpritesInBatch) {
            this.maxSpritesInBatch = n2;
        }
        n2 *= 6;
        this.lastTexture.bind();
        Mesh mesh = this.mesh;
        mesh.setVertices(this.vertices, 0, this.idx);
        ShortBuffer shortBuffer = mesh.getIndicesBuffer(false);
        ((Buffer)shortBuffer).position(0);
        ((Buffer)shortBuffer).limit(n2);
        if (this.blendingDisabled) {
            Gdx.gl.glDisable(3042);
        } else {
            Gdx.gl.glEnable(3042);
            if (this.blendSrcFunc != -1) {
                Gdx.gl.glBlendFuncSeparate(this.blendSrcFunc, this.blendDstFunc, this.blendSrcFuncAlpha, this.blendDstFuncAlpha);
            }
        }
        mesh.render(this.customShader != null ? this.customShader : this.shader, 4, 0, n2);
        this.idx = 0;
    }

    @Override
    public void disableBlending() {
        if (this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = true;
    }

    @Override
    public void enableBlending() {
        if (!this.blendingDisabled) {
            return;
        }
        this.flush();
        this.blendingDisabled = false;
    }

    @Override
    public void setBlendFunction(int n2, int n3) {
        this.setBlendFunctionSeparate(n2, n3, n2, n3);
    }

    @Override
    public void setBlendFunctionSeparate(int n2, int n3, int n4, int n5) {
        if (this.blendSrcFunc == n2 && this.blendDstFunc == n3 && this.blendSrcFuncAlpha == n4 && this.blendDstFuncAlpha == n5) {
            return;
        }
        this.flush();
        this.blendSrcFunc = n2;
        this.blendDstFunc = n3;
        this.blendSrcFuncAlpha = n4;
        this.blendDstFuncAlpha = n5;
    }

    @Override
    public int getBlendSrcFunc() {
        return this.blendSrcFunc;
    }

    @Override
    public int getBlendDstFunc() {
        return this.blendDstFunc;
    }

    @Override
    public int getBlendSrcFuncAlpha() {
        return this.blendSrcFuncAlpha;
    }

    @Override
    public int getBlendDstFuncAlpha() {
        return this.blendDstFuncAlpha;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        if (this.ownsShader && this.shader != null) {
            this.shader.dispose();
        }
    }

    @Override
    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    @Override
    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.projectionMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    @Override
    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            this.flush();
        }
        this.transformMatrix.set(matrix4);
        if (this.drawing) {
            this.setupMatrices();
        }
    }

    protected void setupMatrices() {
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        if (this.customShader != null) {
            this.customShader.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.customShader.setUniformi("u_texture", 0);
            return;
        }
        this.shader.setUniformMatrix("u_projTrans", this.combinedMatrix);
        this.shader.setUniformi("u_texture", 0);
    }

    protected void switchTexture(Texture texture) {
        this.flush();
        this.lastTexture = texture;
        this.invTexWidth = 1.0f / (float)((GLTexture)texture).getWidth();
        this.invTexHeight = 1.0f / (float)((GLTexture)texture).getHeight();
    }

    @Override
    public void setShader(ShaderProgram shaderProgram) {
        if (shaderProgram == this.customShader) {
            return;
        }
        if (this.drawing) {
            this.flush();
        }
        this.customShader = shaderProgram;
        if (this.drawing) {
            if (this.customShader != null) {
                this.customShader.bind();
            } else {
                this.shader.bind();
            }
            this.setupMatrices();
        }
    }

    @Override
    public ShaderProgram getShader() {
        if (this.customShader == null) {
            return this.shader;
        }
        return this.customShader;
    }

    @Override
    public boolean isBlendingEnabled() {
        return !this.blendingDisabled;
    }

    @Override
    public boolean isDrawing() {
        return this.drawing;
    }
}

