/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteCache$Cache;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class SpriteCache
implements Disposable {
    private static final float[] tempVertices = new float[30];
    private final Mesh mesh;
    private boolean drawing;
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 projectionMatrix = new Matrix4();
    private Array<SpriteCache$Cache> caches = new Array();
    private final Matrix4 combinedMatrix = new Matrix4();
    private final ShaderProgram shader;
    private SpriteCache$Cache currentCache;
    private final Array<Texture> textures = new Array(8);
    private final IntArray counts = new IntArray(8);
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private float colorPacked = Color.WHITE_FLOAT_BITS;
    private ShaderProgram customShader = null;
    public int renderCalls = 0;
    public int totalRenderCalls = 0;

    public SpriteCache() {
        this(1000, false);
    }

    public SpriteCache(int n2, boolean bl) {
        this(n2, SpriteCache.createDefaultShader(), bl);
    }

    public SpriteCache(int n2, ShaderProgram object, boolean bl) {
        this.shader = object;
        if (bl && n2 > 8191) {
            throw new IllegalArgumentException("Can't have more than 8191 sprites per batch: " + n2);
        }
        this.mesh = new Mesh(true, n2 * (bl ? 4 : 6), bl ? n2 * 6 : 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.mesh.setAutoBind(false);
        if (bl) {
            object = new short[n2 *= 6];
            boolean bl2 = false;
            int n3 = 0;
            while (n3 < n2) {
                short s2;
                object[n3] = s2;
                object[n3 + 1] = (short)(s2 + true);
                object[n3 + 2] = (short)(s2 + 2);
                object[n3 + 3] = (short)(s2 + 2);
                object[n3 + 4] = (short)(s2 + 3);
                object[n3 + 5] = s2;
                n3 += 6;
                s2 = (short)(s2 + 4);
            }
            this.mesh.setIndices((short[])object);
        }
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
    }

    public void setColor(Color color) {
        this.color.set(color);
        this.colorPacked = color.toFloatBits();
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        this.color.set(f2, f3, f4, f5);
        this.colorPacked = this.color.toFloatBits();
    }

    public Color getColor() {
        return this.color;
    }

    public void setPackedColor(float f2) {
        Color.abgr8888ToColor(this.color, f2);
        this.colorPacked = f2;
    }

    public float getPackedColor() {
        return this.colorPacked;
    }

    public void beginCache() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before beginCache");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin.");
        }
        this.mesh.getNumIndices();
        FloatBuffer floatBuffer = this.mesh.getVerticesBuffer(true);
        this.currentCache = new SpriteCache$Cache(this.caches.size, floatBuffer.limit());
        this.caches.add(this.currentCache);
        floatBuffer.compact();
    }

    public void beginCache(int n2) {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before beginCache");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin.");
        }
        FloatBuffer floatBuffer = this.mesh.getVerticesBuffer(true);
        if (n2 == this.caches.size - 1) {
            SpriteCache$Cache spriteCache$Cache = this.caches.removeIndex(n2);
            ((Buffer)floatBuffer).limit(spriteCache$Cache.offset);
            this.beginCache();
            return;
        }
        this.currentCache = this.caches.get(n2);
        ((Buffer)floatBuffer).position(this.currentCache.offset);
    }

    public int endCache() {
        if (this.currentCache == null) {
            throw new IllegalStateException("beginCache must be called before endCache.");
        }
        SpriteCache$Cache spriteCache$Cache = this.currentCache;
        int n2 = this.mesh.getVerticesBuffer(false).position() - spriteCache$Cache.offset;
        if (spriteCache$Cache.textures == null) {
            spriteCache$Cache.maxCount = n2;
            spriteCache$Cache.textureCount = this.textures.size;
            spriteCache$Cache.textures = this.textures.toArray(Texture.class);
            spriteCache$Cache.counts = new int[spriteCache$Cache.textureCount];
            int n3 = this.counts.size;
            for (n2 = 0; n2 < n3; ++n2) {
                spriteCache$Cache.counts[n2] = this.counts.get(n2);
            }
            ((Buffer)this.mesh.getVerticesBuffer(true)).flip();
        } else {
            if (n2 > spriteCache$Cache.maxCount) {
                throw new GdxRuntimeException("If a cache is not the last created, it cannot be redefined with more entries than when it was first created: " + n2 + " (" + spriteCache$Cache.maxCount + " max)");
            }
            spriteCache$Cache.textureCount = this.textures.size;
            if (spriteCache$Cache.textures.length < spriteCache$Cache.textureCount) {
                spriteCache$Cache.textures = new Texture[spriteCache$Cache.textureCount];
            }
            int n4 = spriteCache$Cache.textureCount;
            for (n2 = 0; n2 < n4; ++n2) {
                spriteCache$Cache.textures[n2] = this.textures.get(n2);
            }
            if (spriteCache$Cache.counts.length < spriteCache$Cache.textureCount) {
                spriteCache$Cache.counts = new int[spriteCache$Cache.textureCount];
            }
            n4 = spriteCache$Cache.textureCount;
            for (n2 = 0; n2 < n4; ++n2) {
                spriteCache$Cache.counts[n2] = this.counts.get(n2);
            }
            FloatBuffer floatBuffer = this.mesh.getVerticesBuffer(true);
            ((Buffer)floatBuffer).position(0);
            SpriteCache$Cache spriteCache$Cache2 = this.caches.get(this.caches.size - 1);
            ((Buffer)floatBuffer).limit(spriteCache$Cache2.offset + spriteCache$Cache2.maxCount);
        }
        this.currentCache = null;
        this.textures.clear();
        this.counts.clear();
        return spriteCache$Cache.id;
    }

    public void clear() {
        this.caches.clear();
        ((Buffer)this.mesh.getVerticesBuffer(true)).clear().flip();
    }

    public void add(Texture texture, float[] fArray, int n2, int n3) {
        if (this.currentCache == null) {
            throw new IllegalStateException("beginCache must be called before add.");
        }
        int n4 = this.mesh.getNumIndices() > 0 ? 4 : 6;
        n4 = n3 / (n4 * 5) * 6;
        int n5 = this.textures.size - 1;
        if (n5 < 0 || this.textures.get(n5) != texture) {
            this.textures.add(texture);
            this.counts.add(n4);
        } else {
            this.counts.incr(n5, n4);
        }
        this.mesh.getVerticesBuffer(true).put(fArray, n2, n3);
    }

    public void add(Texture texture, float f2, float f3) {
        float f4 = f2 + (float)((GLTexture)texture).getWidth();
        float f5 = f3 + (float)((GLTexture)texture).getHeight();
        SpriteCache.tempVertices[0] = f2;
        SpriteCache.tempVertices[1] = f3;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = 0.0f;
        SpriteCache.tempVertices[4] = 1.0f;
        SpriteCache.tempVertices[5] = f2;
        SpriteCache.tempVertices[6] = f5;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = 0.0f;
        SpriteCache.tempVertices[9] = 0.0f;
        SpriteCache.tempVertices[10] = f4;
        SpriteCache.tempVertices[11] = f5;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = 1.0f;
        SpriteCache.tempVertices[14] = 0.0f;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f4;
            SpriteCache.tempVertices[16] = f3;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = 1.0f;
            SpriteCache.tempVertices[19] = 1.0f;
            this.add(texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f4;
        SpriteCache.tempVertices[16] = f5;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = 1.0f;
        SpriteCache.tempVertices[19] = 0.0f;
        SpriteCache.tempVertices[20] = f4;
        SpriteCache.tempVertices[21] = f3;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = 1.0f;
        SpriteCache.tempVertices[24] = 1.0f;
        SpriteCache.tempVertices[25] = f2;
        SpriteCache.tempVertices[26] = f3;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = 0.0f;
        SpriteCache.tempVertices[29] = 1.0f;
        this.add(texture, tempVertices, 0, 30);
    }

    public void add(Texture texture, float f2, float f3, int n2, int n3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = f2 + (float)n2;
        float f10 = f3 + (float)n3;
        SpriteCache.tempVertices[0] = f2;
        SpriteCache.tempVertices[1] = f3;
        SpriteCache.tempVertices[2] = f8;
        SpriteCache.tempVertices[3] = f4;
        SpriteCache.tempVertices[4] = f5;
        SpriteCache.tempVertices[5] = f2;
        SpriteCache.tempVertices[6] = f10;
        SpriteCache.tempVertices[7] = f8;
        SpriteCache.tempVertices[8] = f4;
        SpriteCache.tempVertices[9] = f7;
        SpriteCache.tempVertices[10] = f9;
        SpriteCache.tempVertices[11] = f10;
        SpriteCache.tempVertices[12] = f8;
        SpriteCache.tempVertices[13] = f6;
        SpriteCache.tempVertices[14] = f7;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f9;
            SpriteCache.tempVertices[16] = f3;
            SpriteCache.tempVertices[17] = f8;
            SpriteCache.tempVertices[18] = f6;
            SpriteCache.tempVertices[19] = f5;
            this.add(texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f9;
        SpriteCache.tempVertices[16] = f10;
        SpriteCache.tempVertices[17] = f8;
        SpriteCache.tempVertices[18] = f6;
        SpriteCache.tempVertices[19] = f7;
        SpriteCache.tempVertices[20] = f9;
        SpriteCache.tempVertices[21] = f3;
        SpriteCache.tempVertices[22] = f8;
        SpriteCache.tempVertices[23] = f6;
        SpriteCache.tempVertices[24] = f5;
        SpriteCache.tempVertices[25] = f2;
        SpriteCache.tempVertices[26] = f3;
        SpriteCache.tempVertices[27] = f8;
        SpriteCache.tempVertices[28] = f4;
        SpriteCache.tempVertices[29] = f5;
        this.add(texture, tempVertices, 0, 30);
    }

    public void add(Texture texture, float f2, float f3, int n2, int n3, int n4, int n5) {
        float f4 = 1.0f / (float)((GLTexture)texture).getWidth();
        float f5 = 1.0f / (float)((GLTexture)texture).getHeight();
        float f6 = (float)n2 * f4;
        float f7 = (float)(n3 + n5) * f5;
        float f8 = (float)(n2 + n4) * f4;
        float f9 = (float)n3 * f5;
        float f10 = f2 + (float)n4;
        float f11 = f3 + (float)n5;
        SpriteCache.tempVertices[0] = f2;
        SpriteCache.tempVertices[1] = f3;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = f6;
        SpriteCache.tempVertices[4] = f7;
        SpriteCache.tempVertices[5] = f2;
        SpriteCache.tempVertices[6] = f11;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = f6;
        SpriteCache.tempVertices[9] = f9;
        SpriteCache.tempVertices[10] = f10;
        SpriteCache.tempVertices[11] = f11;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = f8;
        SpriteCache.tempVertices[14] = f9;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f10;
            SpriteCache.tempVertices[16] = f3;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = f8;
            SpriteCache.tempVertices[19] = f7;
            this.add(texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f10;
        SpriteCache.tempVertices[16] = f11;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = f8;
        SpriteCache.tempVertices[19] = f9;
        SpriteCache.tempVertices[20] = f10;
        SpriteCache.tempVertices[21] = f3;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = f8;
        SpriteCache.tempVertices[24] = f7;
        SpriteCache.tempVertices[25] = f2;
        SpriteCache.tempVertices[26] = f3;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = f6;
        SpriteCache.tempVertices[29] = f7;
        this.add(texture, tempVertices, 0, 30);
    }

    public void add(Texture texture, float f2, float f3, float f4, float f5, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        float f6 = 1.0f / (float)((GLTexture)texture).getWidth();
        float f7 = 1.0f / (float)((GLTexture)texture).getHeight();
        float f8 = (float)n2 * f6;
        float f9 = (float)(n3 + n5) * f7;
        float f10 = (float)(n2 + n4) * f6;
        float f11 = (float)n3 * f7;
        f4 = f2 + f4;
        f5 = f3 + f5;
        if (bl) {
            float f12 = f8;
            f8 = f10;
            f10 = f12;
        }
        if (bl2) {
            float f13 = f9;
            f9 = f11;
            f11 = f13;
        }
        SpriteCache.tempVertices[0] = f2;
        SpriteCache.tempVertices[1] = f3;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = f8;
        SpriteCache.tempVertices[4] = f9;
        SpriteCache.tempVertices[5] = f2;
        SpriteCache.tempVertices[6] = f5;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = f8;
        SpriteCache.tempVertices[9] = f11;
        SpriteCache.tempVertices[10] = f4;
        SpriteCache.tempVertices[11] = f5;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = f10;
        SpriteCache.tempVertices[14] = f11;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f4;
            SpriteCache.tempVertices[16] = f3;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = f10;
            SpriteCache.tempVertices[19] = f9;
            this.add(texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f4;
        SpriteCache.tempVertices[16] = f5;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = f10;
        SpriteCache.tempVertices[19] = f11;
        SpriteCache.tempVertices[20] = f4;
        SpriteCache.tempVertices[21] = f3;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = f10;
        SpriteCache.tempVertices[24] = f9;
        SpriteCache.tempVertices[25] = f2;
        SpriteCache.tempVertices[26] = f3;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = f8;
        SpriteCache.tempVertices[29] = f9;
        this.add(texture, tempVertices, 0, 30);
    }

    public void add(Texture texture, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        float f11;
        f2 += f4;
        f3 += f5;
        float f12 = -f4;
        float f13 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f12 *= f8;
            f13 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f12;
        f7 = f13;
        f8 = f12;
        f9 = f5;
        f12 = f4;
        if (f10 != 0.0f) {
            f13 = MathUtils.cosDeg(f10);
            f11 = MathUtils.sinDeg(f10);
            f10 = f13 * f6 - f11 * f7;
            f6 = f11 * f6 + f13 * f7;
            f7 = f13 * f8 - f11 * f9;
            f8 = f11 * f8 + f13 * f9;
            f9 = f13 * f12 - f11 * f5;
            f5 = f11 * f12 + f13 * f5;
            f4 = f10 + (f9 - f7);
            f12 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f12;
            f12 = f13;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f12 += f3;
        f13 = 1.0f / (float)((GLTexture)texture).getWidth();
        f11 = 1.0f / (float)((GLTexture)texture).getHeight();
        f2 = (float)n2 * f13;
        f3 = (float)(n3 + n5) * f11;
        float f14 = (float)(n2 + n4) * f13;
        float f15 = (float)n3 * f11;
        if (bl) {
            float f16 = f2;
            f2 = f14;
            f14 = f16;
        }
        if (bl2) {
            float f17 = f3;
            f3 = f15;
            f15 = f17;
        }
        SpriteCache.tempVertices[0] = f10;
        SpriteCache.tempVertices[1] = f6;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = f2;
        SpriteCache.tempVertices[4] = f3;
        SpriteCache.tempVertices[5] = f7;
        SpriteCache.tempVertices[6] = f8;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = f2;
        SpriteCache.tempVertices[9] = f15;
        SpriteCache.tempVertices[10] = f9;
        SpriteCache.tempVertices[11] = f5;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = f14;
        SpriteCache.tempVertices[14] = f15;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f4;
            SpriteCache.tempVertices[16] = f12;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = f14;
            SpriteCache.tempVertices[19] = f3;
            this.add(texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f9;
        SpriteCache.tempVertices[16] = f5;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = f14;
        SpriteCache.tempVertices[19] = f15;
        SpriteCache.tempVertices[20] = f4;
        SpriteCache.tempVertices[21] = f12;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = f14;
        SpriteCache.tempVertices[24] = f3;
        SpriteCache.tempVertices[25] = f10;
        SpriteCache.tempVertices[26] = f6;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = f2;
        SpriteCache.tempVertices[29] = f3;
        this.add(texture, tempVertices, 0, 30);
    }

    public void add(TextureRegion textureRegion, float f2, float f3) {
        this.add(textureRegion, f2, f3, textureRegion.getRegionWidth(), textureRegion.getRegionHeight());
    }

    public void add(TextureRegion textureRegion, float f2, float f3, float f4, float f5) {
        f4 = f2 + f4;
        f5 = f3 + f5;
        float f6 = textureRegion.u;
        float f7 = textureRegion.v2;
        float f8 = textureRegion.u2;
        float f9 = textureRegion.v;
        SpriteCache.tempVertices[0] = f2;
        SpriteCache.tempVertices[1] = f3;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = f6;
        SpriteCache.tempVertices[4] = f7;
        SpriteCache.tempVertices[5] = f2;
        SpriteCache.tempVertices[6] = f5;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = f6;
        SpriteCache.tempVertices[9] = f9;
        SpriteCache.tempVertices[10] = f4;
        SpriteCache.tempVertices[11] = f5;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = f8;
        SpriteCache.tempVertices[14] = f9;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f4;
            SpriteCache.tempVertices[16] = f3;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = f8;
            SpriteCache.tempVertices[19] = f7;
            this.add(textureRegion.texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f4;
        SpriteCache.tempVertices[16] = f5;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = f8;
        SpriteCache.tempVertices[19] = f9;
        SpriteCache.tempVertices[20] = f4;
        SpriteCache.tempVertices[21] = f3;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = f8;
        SpriteCache.tempVertices[24] = f7;
        SpriteCache.tempVertices[25] = f2;
        SpriteCache.tempVertices[26] = f3;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = f6;
        SpriteCache.tempVertices[29] = f7;
        this.add(textureRegion.texture, tempVertices, 0, 30);
    }

    public void add(TextureRegion textureRegion, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        float f11;
        f2 += f4;
        f3 += f5;
        float f12 = -f4;
        float f13 = -f5;
        f4 = f6 - f4;
        f5 = f7 - f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f12 *= f8;
            f13 *= f9;
            f4 *= f8;
            f5 *= f9;
        }
        f6 = f12;
        f7 = f13;
        f8 = f12;
        f9 = f5;
        f12 = f4;
        if (f10 != 0.0f) {
            f13 = MathUtils.cosDeg(f10);
            f11 = MathUtils.sinDeg(f10);
            f10 = f13 * f6 - f11 * f7;
            f6 = f11 * f6 + f13 * f7;
            f7 = f13 * f8 - f11 * f9;
            f8 = f11 * f8 + f13 * f9;
            f9 = f13 * f12 - f11 * f5;
            f5 = f11 * f12 + f13 * f5;
            f4 = f10 + (f9 - f7);
            f12 = f5 - (f8 - f6);
        } else {
            f10 = f6;
            f6 = f7;
            f7 = f8;
            f8 = f9;
            f9 = f12;
            f12 = f13;
        }
        f10 += f2;
        f6 += f3;
        f7 += f2;
        f8 += f3;
        f9 += f2;
        f5 += f3;
        f4 += f2;
        f12 += f3;
        f13 = textureRegion.u;
        f11 = textureRegion.v2;
        f2 = textureRegion.u2;
        f3 = textureRegion.v;
        SpriteCache.tempVertices[0] = f10;
        SpriteCache.tempVertices[1] = f6;
        SpriteCache.tempVertices[2] = this.colorPacked;
        SpriteCache.tempVertices[3] = f13;
        SpriteCache.tempVertices[4] = f11;
        SpriteCache.tempVertices[5] = f7;
        SpriteCache.tempVertices[6] = f8;
        SpriteCache.tempVertices[7] = this.colorPacked;
        SpriteCache.tempVertices[8] = f13;
        SpriteCache.tempVertices[9] = f3;
        SpriteCache.tempVertices[10] = f9;
        SpriteCache.tempVertices[11] = f5;
        SpriteCache.tempVertices[12] = this.colorPacked;
        SpriteCache.tempVertices[13] = f2;
        SpriteCache.tempVertices[14] = f3;
        if (this.mesh.getNumIndices() > 0) {
            SpriteCache.tempVertices[15] = f4;
            SpriteCache.tempVertices[16] = f12;
            SpriteCache.tempVertices[17] = this.colorPacked;
            SpriteCache.tempVertices[18] = f2;
            SpriteCache.tempVertices[19] = f11;
            this.add(textureRegion.texture, tempVertices, 0, 20);
            return;
        }
        SpriteCache.tempVertices[15] = f9;
        SpriteCache.tempVertices[16] = f5;
        SpriteCache.tempVertices[17] = this.colorPacked;
        SpriteCache.tempVertices[18] = f2;
        SpriteCache.tempVertices[19] = f3;
        SpriteCache.tempVertices[20] = f4;
        SpriteCache.tempVertices[21] = f12;
        SpriteCache.tempVertices[22] = this.colorPacked;
        SpriteCache.tempVertices[23] = f2;
        SpriteCache.tempVertices[24] = f11;
        SpriteCache.tempVertices[25] = f10;
        SpriteCache.tempVertices[26] = f6;
        SpriteCache.tempVertices[27] = this.colorPacked;
        SpriteCache.tempVertices[28] = f13;
        SpriteCache.tempVertices[29] = f11;
        this.add(textureRegion.texture, tempVertices, 0, 30);
    }

    public void add(Sprite sprite) {
        if (this.mesh.getNumIndices() > 0) {
            this.add(sprite.getTexture(), sprite.getVertices(), 0, 20);
            return;
        }
        float[] fArray = sprite.getVertices();
        System.arraycopy(fArray, 0, tempVertices, 0, 15);
        System.arraycopy(fArray, 10, tempVertices, 15, 5);
        System.arraycopy(fArray, 15, tempVertices, 20, 5);
        System.arraycopy(fArray, 0, tempVertices, 25, 5);
        this.add(sprite.getTexture(), tempVertices, 0, 30);
    }

    public void begin() {
        if (this.drawing) {
            throw new IllegalStateException("end must be called before begin.");
        }
        if (this.currentCache != null) {
            throw new IllegalStateException("endCache must be called before begin");
        }
        this.renderCalls = 0;
        this.combinedMatrix.set(this.projectionMatrix).mul(this.transformMatrix);
        Gdx.gl20.glDepthMask(false);
        if (this.customShader != null) {
            this.customShader.bind();
            this.customShader.setUniformMatrix("u_proj", this.projectionMatrix);
            this.customShader.setUniformMatrix("u_trans", this.transformMatrix);
            this.customShader.setUniformMatrix("u_projTrans", this.combinedMatrix);
            this.customShader.setUniformi("u_texture", 0);
            this.mesh.bind(this.customShader);
        } else {
            this.shader.bind();
            this.shader.setUniformMatrix("u_projectionViewMatrix", this.combinedMatrix);
            this.shader.setUniformi("u_texture", 0);
            this.mesh.bind(this.shader);
        }
        this.drawing = true;
    }

    public void end() {
        if (!this.drawing) {
            throw new IllegalStateException("begin must be called before end.");
        }
        this.drawing = false;
        GL20 gL20 = Gdx.gl20;
        gL20.glDepthMask(true);
        if (this.customShader != null) {
            this.mesh.unbind(this.customShader);
            return;
        }
        this.mesh.unbind(this.shader);
    }

    public void draw(int n2) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteCache.begin must be called before draw.");
        }
        SpriteCache$Cache spriteCache$Cache = this.caches.get(n2);
        int n3 = this.mesh.getNumIndices() > 0 ? 4 : 6;
        n3 = spriteCache$Cache.offset / (n3 * 5) * 6;
        Texture[] textureArray = spriteCache$Cache.textures;
        int[] nArray = spriteCache$Cache.counts;
        int n4 = spriteCache$Cache.textureCount;
        for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = nArray[i2];
            textureArray[i2].bind();
            if (this.customShader != null) {
                this.mesh.render(this.customShader, 4, n3, n5);
            } else {
                this.mesh.render(this.shader, 4, n3, n5);
            }
            n3 += n5;
        }
        this.renderCalls += n4;
        this.totalRenderCalls += n4;
    }

    public void draw(int n2, int n3, int n4) {
        if (!this.drawing) {
            throw new IllegalStateException("SpriteCache.begin must be called before draw.");
        }
        SpriteCache$Cache spriteCache$Cache = this.caches.get(n2);
        int n5 = this.mesh.getNumIndices() > 0 ? 4 : 6;
        n3 = spriteCache$Cache.offset / (n5 * 5) * 6 + n3 * 6;
        n4 *= 6;
        Texture[] textureArray = spriteCache$Cache.textures;
        int[] nArray = spriteCache$Cache.counts;
        int n6 = spriteCache$Cache.textureCount;
        for (int i2 = 0; i2 < n6; ++i2) {
            textureArray[i2].bind();
            int n7 = nArray[i2];
            if (n7 > n4) {
                i2 = n6;
                n7 = n4;
            } else {
                n4 -= n7;
            }
            if (this.customShader != null) {
                this.mesh.render(this.customShader, 4, n3, n7);
            } else {
                this.mesh.render(this.shader, 4, n3, n7);
            }
            n3 += n7;
        }
        this.renderCalls += spriteCache$Cache.textureCount;
        this.totalRenderCalls += n6;
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        if (this.shader != null) {
            this.shader.dispose();
        }
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setProjectionMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            throw new IllegalStateException("Can't set the matrix within begin/end.");
        }
        this.projectionMatrix.set(matrix4);
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void setTransformMatrix(Matrix4 matrix4) {
        if (this.drawing) {
            throw new IllegalStateException("Can't set the matrix within begin/end.");
        }
        this.transformMatrix.set(matrix4);
    }

    static ShaderProgram createDefaultShader() {
        Object object = "attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main()\n{\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n";
        String string = "#ifdef GL_ES\nprecision mediump float;\n#endif\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\nvoid main()\n{\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}";
        if (!((ShaderProgram)(object = new ShaderProgram((String)object, string))).isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + ((ShaderProgram)object).getLog());
        }
        return object;
    }

    public void setShader(ShaderProgram shaderProgram) {
        this.customShader = shaderProgram;
    }

    public ShaderProgram getCustomShader() {
        return this.customShader;
    }

    public boolean isDrawing() {
        return this.drawing;
    }
}

