/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g2d;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.NinePatch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasSprite;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData$Page;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$TextureAtlasData$Region;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.ObjectSet;

public class TextureAtlas
implements Disposable {
    private final ObjectSet<Texture> textures;
    private final Array<TextureAtlas$AtlasRegion> regions;

    public TextureAtlas() {
        this.textures = new ObjectSet(4);
        this.regions = new Array();
    }

    public TextureAtlas(String string) {
        this(Gdx.files.internal(string));
    }

    public TextureAtlas(FileHandle fileHandle) {
        FileHandle fileHandle2 = fileHandle;
        this(fileHandle2, fileHandle2.parent());
    }

    public TextureAtlas(FileHandle fileHandle, boolean bl) {
        FileHandle fileHandle2 = fileHandle;
        this(fileHandle2, fileHandle2.parent(), bl);
    }

    public TextureAtlas(FileHandle fileHandle, FileHandle fileHandle2) {
        this(fileHandle, fileHandle2, false);
    }

    public TextureAtlas(FileHandle fileHandle, FileHandle fileHandle2, boolean bl) {
        this(new TextureAtlas$TextureAtlasData(fileHandle, fileHandle2, bl));
    }

    public TextureAtlas(TextureAtlas$TextureAtlasData textureAtlas$TextureAtlasData) {
        this.textures = new ObjectSet(4);
        this.regions = new Array();
        this.load(textureAtlas$TextureAtlasData);
    }

    public void load(TextureAtlas$TextureAtlasData object) {
        this.textures.ensureCapacity(((TextureAtlas$TextureAtlasData)object).pages.size);
        for (TextureAtlas$TextureAtlasData$Page object2 : ((TextureAtlas$TextureAtlasData)object).pages) {
            if (object2.texture == null) {
                object2.texture = new Texture(object2.textureFile, object2.format, object2.useMipMaps);
            }
            object2.texture.setFilter(object2.minFilter, object2.magFilter);
            object2.texture.setWrap(object2.uWrap, object2.vWrap);
            this.textures.add(object2.texture);
        }
        this.regions.ensureCapacity(((TextureAtlas$TextureAtlasData)object).regions.size);
        for (TextureAtlas$TextureAtlasData$Region textureAtlas$TextureAtlasData$Region : ((TextureAtlas$TextureAtlasData)object).regions) {
            object = new TextureAtlas$AtlasRegion(textureAtlas$TextureAtlasData$Region.page.texture, textureAtlas$TextureAtlasData$Region.left, textureAtlas$TextureAtlasData$Region.top, textureAtlas$TextureAtlasData$Region.rotate ? textureAtlas$TextureAtlasData$Region.height : textureAtlas$TextureAtlasData$Region.width, textureAtlas$TextureAtlasData$Region.rotate ? textureAtlas$TextureAtlasData$Region.width : textureAtlas$TextureAtlasData$Region.height);
            new TextureAtlas$AtlasRegion(textureAtlas$TextureAtlasData$Region.page.texture, textureAtlas$TextureAtlasData$Region.left, textureAtlas$TextureAtlasData$Region.top, textureAtlas$TextureAtlasData$Region.rotate ? textureAtlas$TextureAtlasData$Region.height : textureAtlas$TextureAtlasData$Region.width, textureAtlas$TextureAtlasData$Region.rotate ? textureAtlas$TextureAtlasData$Region.width : textureAtlas$TextureAtlasData$Region.height).index = textureAtlas$TextureAtlasData$Region.index;
            ((TextureAtlas$AtlasRegion)object).name = textureAtlas$TextureAtlasData$Region.name;
            ((TextureAtlas$AtlasRegion)object).offsetX = textureAtlas$TextureAtlasData$Region.offsetX;
            ((TextureAtlas$AtlasRegion)object).offsetY = textureAtlas$TextureAtlasData$Region.offsetY;
            ((TextureAtlas$AtlasRegion)object).originalHeight = textureAtlas$TextureAtlasData$Region.originalHeight;
            ((TextureAtlas$AtlasRegion)object).originalWidth = textureAtlas$TextureAtlasData$Region.originalWidth;
            ((TextureAtlas$AtlasRegion)object).rotate = textureAtlas$TextureAtlasData$Region.rotate;
            ((TextureAtlas$AtlasRegion)object).degrees = textureAtlas$TextureAtlasData$Region.degrees;
            ((TextureAtlas$AtlasRegion)object).names = textureAtlas$TextureAtlasData$Region.names;
            ((TextureAtlas$AtlasRegion)object).values = textureAtlas$TextureAtlasData$Region.values;
            if (textureAtlas$TextureAtlasData$Region.flip) {
                ((TextureRegion)object).flip(false, true);
            }
            this.regions.add((TextureAtlas$AtlasRegion)object);
        }
    }

    public TextureAtlas$AtlasRegion addRegion(String string, Texture object, int n2, int n3, int n4, int n5) {
        this.textures.add((Texture)object);
        object = new TextureAtlas$AtlasRegion((Texture)object, n2, n3, n4, n5);
        v0.name = string;
        this.regions.add((TextureAtlas$AtlasRegion)object);
        return object;
    }

    public TextureAtlas$AtlasRegion addRegion(String string, TextureRegion textureRegion) {
        this.textures.add(textureRegion.texture);
        textureRegion = new TextureAtlas$AtlasRegion(textureRegion);
        v0.name = string;
        this.regions.add((TextureAtlas$AtlasRegion)textureRegion);
        return textureRegion;
    }

    public Array<TextureAtlas$AtlasRegion> getRegions() {
        return this.regions;
    }

    @Null
    public TextureAtlas$AtlasRegion findRegion(String string) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.regions.get((int)i2).name.equals(string)) continue;
            return this.regions.get(i2);
        }
        return null;
    }

    @Null
    public TextureAtlas$AtlasRegion findRegion(String string, int n2) {
        int n3 = this.regions.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string) || textureAtlas$AtlasRegion.index != n2) continue;
            return textureAtlas$AtlasRegion;
        }
        return null;
    }

    public Array<TextureAtlas$AtlasRegion> findRegions(String string) {
        Array<TextureAtlas$AtlasRegion> array = new Array<TextureAtlas$AtlasRegion>(TextureAtlas$AtlasRegion.class);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string)) continue;
            array.add(new TextureAtlas$AtlasRegion(textureAtlas$AtlasRegion));
        }
        return array;
    }

    public Array<Sprite> createSprites() {
        Array<Sprite> array = new Array<Sprite>(true, this.regions.size, Sprite.class);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas textureAtlas = this;
            array.add(textureAtlas.newSprite(textureAtlas.regions.get(i2)));
        }
        return array;
    }

    @Null
    public Sprite createSprite(String string) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.regions.get((int)i2).name.equals(string)) continue;
            TextureAtlas textureAtlas = this;
            return textureAtlas.newSprite(textureAtlas.regions.get(i2));
        }
        return null;
    }

    @Null
    public Sprite createSprite(String string, int n2) {
        int n3 = this.regions.size;
        for (int i2 = 0; i2 < n3; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = this.regions.get(i2);
            if (textureAtlas$AtlasRegion.index != n2 || !textureAtlas$AtlasRegion.name.equals(string)) continue;
            TextureAtlas textureAtlas = this;
            return textureAtlas.newSprite(textureAtlas.regions.get(i2));
        }
        return null;
    }

    public Array<Sprite> createSprites(String string) {
        Array<Sprite> array = new Array<Sprite>(Sprite.class);
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(string)) continue;
            array.add(this.newSprite(textureAtlas$AtlasRegion));
        }
        return array;
    }

    private Sprite newSprite(TextureAtlas$AtlasRegion textureAtlas$AtlasRegion) {
        if (textureAtlas$AtlasRegion.packedWidth == textureAtlas$AtlasRegion.originalWidth && textureAtlas$AtlasRegion.packedHeight == textureAtlas$AtlasRegion.originalHeight) {
            if (textureAtlas$AtlasRegion.rotate) {
                Sprite sprite = new Sprite(textureAtlas$AtlasRegion);
                sprite.setBounds(0.0f, 0.0f, textureAtlas$AtlasRegion.getRegionHeight(), textureAtlas$AtlasRegion.getRegionWidth());
                sprite.rotate90(true);
                return sprite;
            }
            return new Sprite(textureAtlas$AtlasRegion);
        }
        return new TextureAtlas$AtlasSprite(textureAtlas$AtlasRegion);
    }

    @Null
    public NinePatch createPatch(String object) {
        int n2 = this.regions.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextureAtlas$AtlasRegion textureAtlas$AtlasRegion = this.regions.get(i2);
            if (!textureAtlas$AtlasRegion.name.equals(object)) continue;
            int[] nArray = textureAtlas$AtlasRegion.findValue("split");
            if (nArray == null) {
                throw new IllegalArgumentException("Region does not have ninepatch splits: " + (String)object);
            }
            object = new NinePatch((TextureRegion)textureAtlas$AtlasRegion, nArray[0], nArray[1], nArray[2], nArray[3]);
            nArray = textureAtlas$AtlasRegion.findValue("pad");
            if (nArray != null) {
                ((NinePatch)object).setPadding(nArray[0], nArray[1], nArray[2], nArray[3]);
            }
            return object;
        }
        return null;
    }

    public ObjectSet<Texture> getTextures() {
        return this.textures;
    }

    @Override
    public void dispose() {
        for (Texture texture : this.textures) {
            ((GLTexture)texture).dispose();
        }
        this.textures.clear(0);
    }
}

