/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.MeshPart;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNode;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider;
import com.badlogic.gdx.graphics.g3d.utils.TextureProvider$FileTextureProvider;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import java.nio.Buffer;
import java.nio.ShortBuffer;

public class Model
implements Disposable {
    public final Array<Material> materials = new Array();
    public final Array<Node> nodes = new Array();
    public final Array<Animation> animations = new Array();
    public final Array<Mesh> meshes = new Array();
    public final Array<MeshPart> meshParts = new Array();
    protected final Array<Disposable> disposables = new Array();
    private ObjectMap<NodePart, ArrayMap<String, Matrix4>> nodePartBones = new ObjectMap();

    public Model() {
    }

    public Model(ModelData modelData) {
        this(modelData, new TextureProvider$FileTextureProvider());
    }

    public Model(ModelData modelData, TextureProvider textureProvider) {
        this.load(modelData, textureProvider);
    }

    protected void load(ModelData modelData, TextureProvider textureProvider) {
        this.loadMeshes(modelData.meshes);
        this.loadMaterials(modelData.materials, textureProvider);
        this.loadNodes(modelData.nodes);
        this.loadAnimations(modelData.animations);
        this.calculateTransforms();
    }

    protected void loadAnimations(Iterable<ModelAnimation> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ModelAnimation modelAnimation = (ModelAnimation)object.next();
            Animation animation = new Animation();
            new Animation().id = modelAnimation.id;
            for (ModelNodeAnimation modelNodeAnimation : modelAnimation.nodeAnimations) {
                Node node = this.getNode(modelNodeAnimation.nodeId);
                if (node == null) continue;
                NodeAnimation nodeAnimation = new NodeAnimation();
                new NodeAnimation().node = node;
                if (modelNodeAnimation.translation != null) {
                    nodeAnimation.translation = new Array();
                    nodeAnimation.translation.ensureCapacity(modelNodeAnimation.translation.size);
                    for (ModelNodeKeyframe modelNodeKeyframe : modelNodeAnimation.translation) {
                        ModelNodeKeyframe modelNodeKeyframe2;
                        if (modelNodeKeyframe2.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        nodeAnimation.translation.add(new NodeKeyframe<Vector3>(modelNodeKeyframe.keytime, new Vector3(modelNodeKeyframe.value == null ? node.translation : (Vector3)modelNodeKeyframe.value)));
                    }
                }
                if (modelNodeAnimation.rotation != null) {
                    nodeAnimation.rotation = new Array();
                    nodeAnimation.rotation.ensureCapacity(modelNodeAnimation.rotation.size);
                    for (ModelNodeKeyframe modelNodeKeyframe : modelNodeAnimation.rotation) {
                        ModelNodeKeyframe modelNodeKeyframe3;
                        if (modelNodeKeyframe3.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        nodeAnimation.rotation.add(new NodeKeyframe<Quaternion>(modelNodeKeyframe.keytime, new Quaternion(modelNodeKeyframe.value == null ? node.rotation : (Quaternion)modelNodeKeyframe.value)));
                    }
                }
                if (modelNodeAnimation.scaling != null) {
                    nodeAnimation.scaling = new Array();
                    nodeAnimation.scaling.ensureCapacity(modelNodeAnimation.scaling.size);
                    for (ModelNodeKeyframe modelNodeKeyframe : modelNodeAnimation.scaling) {
                        ModelNodeKeyframe modelNodeKeyframe4;
                        if (modelNodeKeyframe4.keytime > animation.duration) {
                            animation.duration = modelNodeKeyframe.keytime;
                        }
                        nodeAnimation.scaling.add(new NodeKeyframe<Vector3>(modelNodeKeyframe.keytime, new Vector3(modelNodeKeyframe.value == null ? node.scale : (Vector3)modelNodeKeyframe.value)));
                    }
                }
                if (!(nodeAnimation.translation != null && nodeAnimation.translation.size > 0 || nodeAnimation.rotation != null && nodeAnimation.rotation.size > 0) && (nodeAnimation.scaling == null || nodeAnimation.scaling.size <= 0)) continue;
                animation.nodeAnimations.add(nodeAnimation);
            }
            if (animation.nodeAnimations.size <= 0) continue;
            this.animations.add(animation);
        }
    }

    protected void loadNodes(Iterable<ModelNode> object) {
        this.nodePartBones.clear();
        object = object.iterator();
        while (object.hasNext()) {
            ModelNode object2 = (ModelNode)object.next();
            this.nodes.add(this.loadNode(object2));
        }
        for (ObjectMap$Entry objectMap$Entry : this.nodePartBones.entries()) {
            if (((NodePart)objectMap$Entry.key).invBoneBindTransforms == null) {
                ((NodePart)objectMap$Entry.key).invBoneBindTransforms = new ArrayMap(Node.class, Matrix4.class);
            }
            ((NodePart)objectMap$Entry.key).invBoneBindTransforms.clear();
            for (ObjectMap$Entry objectMap$Entry2 : ((ArrayMap)objectMap$Entry.value).entries()) {
                ((NodePart)objectMap$Entry.key).invBoneBindTransforms.put(this.getNode((String)objectMap$Entry2.key), new Matrix4((Matrix4)objectMap$Entry2.value).inv());
            }
        }
    }

    protected Node loadNode(ModelNode modelNode) {
        Object object;
        int n2;
        int n3;
        Object[] objectArray;
        Node node = new Node();
        new Node().id = modelNode.id;
        if (modelNode.translation != null) {
            node.translation.set(modelNode.translation);
        }
        if (modelNode.rotation != null) {
            node.rotation.set(modelNode.rotation);
        }
        if (modelNode.scale != null) {
            node.scale.set(modelNode.scale);
        }
        if (modelNode.parts != null) {
            objectArray = modelNode.parts;
            n3 = modelNode.parts.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                MeshPart object2 = null;
                Material object3 = null;
                if (((ModelNodePart)object).meshPartId != null) {
                    for (MeshPart meshPart : this.meshParts) {
                        if (!((ModelNodePart)object).meshPartId.equals(meshPart.id)) continue;
                        object2 = meshPart;
                        break;
                    }
                }
                if (((ModelNodePart)object).materialId != null) {
                    for (Material material : this.materials) {
                        if (!((ModelNodePart)object).materialId.equals(material.id)) continue;
                        object3 = material;
                        break;
                    }
                }
                if (object2 == null || object3 == null) {
                    throw new GdxRuntimeException("Invalid node: " + node.id);
                }
                NodePart nodePart = new NodePart();
                new NodePart().meshPart = object2;
                nodePart.material = object3;
                node.parts.add(nodePart);
                if (((ModelNodePart)object).bones == null) continue;
                this.nodePartBones.put(nodePart, ((ModelNodePart)object).bones);
            }
        }
        if (modelNode.children != null) {
            objectArray = modelNode.children;
            n3 = modelNode.children.length;
            for (n2 = 0; n2 < n3; ++n2) {
                object = objectArray[n2];
                node.addChild(this.loadNode((ModelNode)object));
            }
        }
        return node;
    }

    protected void loadMeshes(Iterable<ModelMesh> object) {
        object = object.iterator();
        while (object.hasNext()) {
            ModelMesh modelMesh = (ModelMesh)object.next();
            this.convertMesh(modelMesh);
        }
    }

    protected void convertMesh(ModelMesh object) {
        Object object2;
        int n2;
        int n3 = 0;
        ModelMeshPart[] modelMeshPartArray = ((ModelMesh)object).parts;
        int n4 = ((ModelMesh)object).parts.length;
        for (n2 = 0; n2 < n4; ++n2) {
            object2 = modelMeshPartArray[n2];
            n3 += ((ModelMeshPart)object2).indices.length;
        }
        boolean bl = n3 > 0;
        Comparable<VertexAttributes> comparable = new VertexAttributes(((ModelMesh)object).attributes);
        n2 = ((ModelMesh)object).vertices.length / (((VertexAttributes)comparable).vertexSize / 4);
        object2 = new Mesh(true, n2, n3, (VertexAttributes)comparable);
        this.meshes.add((Mesh)object2);
        this.disposables.add((Disposable)object2);
        BufferUtils.copy(((ModelMesh)object).vertices, ((Mesh)object2).getVerticesBuffer(true), ((ModelMesh)object).vertices.length, 0);
        n3 = 0;
        comparable = ((Mesh)object2).getIndicesBuffer(true);
        ((Buffer)((Object)comparable)).clear();
        object = ((ModelMesh)object).parts;
        int n5 = ((ModelMesh)object).parts.length;
        for (int i2 = 0; i2 < n5; ++i2) {
            ModelMeshPart modelMeshPart = object[i2];
            MeshPart meshPart = new MeshPart();
            new MeshPart().id = modelMeshPart.id;
            meshPart.primitiveType = modelMeshPart.primitiveType;
            meshPart.offset = n3;
            meshPart.size = bl ? modelMeshPart.indices.length : n2;
            meshPart.mesh = object2;
            if (bl) {
                ((ShortBuffer)comparable).put(modelMeshPart.indices);
            }
            n3 += meshPart.size;
            this.meshParts.add(meshPart);
        }
        ((Buffer)((Object)comparable)).position(0);
        for (MeshPart meshPart : this.meshParts) {
            meshPart.update();
        }
    }

    protected void loadMaterials(Iterable<ModelMaterial> object, TextureProvider textureProvider) {
        object = object.iterator();
        while (object.hasNext()) {
            ModelMaterial modelMaterial = (ModelMaterial)object.next();
            this.materials.add(this.convertMaterial(modelMaterial, textureProvider));
        }
    }

    protected Material convertMaterial(ModelMaterial object, TextureProvider textureProvider) {
        Material material = new Material();
        new Material().id = ((ModelMaterial)object).id;
        if (((ModelMaterial)object).ambient != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Ambient, ((ModelMaterial)object).ambient));
        }
        if (((ModelMaterial)object).diffuse != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Diffuse, ((ModelMaterial)object).diffuse));
        }
        if (((ModelMaterial)object).specular != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Specular, ((ModelMaterial)object).specular));
        }
        if (((ModelMaterial)object).emissive != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Emissive, ((ModelMaterial)object).emissive));
        }
        if (((ModelMaterial)object).reflection != null) {
            material.set((Attribute)new ColorAttribute(ColorAttribute.Reflection, ((ModelMaterial)object).reflection));
        }
        if (((ModelMaterial)object).shininess > 0.0f) {
            material.set((Attribute)new FloatAttribute(FloatAttribute.Shininess, ((ModelMaterial)object).shininess));
        }
        if (((ModelMaterial)object).opacity != 1.0f) {
            material.set((Attribute)new BlendingAttribute(770, 771, ((ModelMaterial)object).opacity));
        }
        ObjectMap<String, Texture> objectMap = new ObjectMap<String, Texture>();
        if (((ModelMaterial)object).textures != null) {
            for (ModelTexture modelTexture : ((ModelMaterial)object).textures) {
                Texture texture;
                if (objectMap.containsKey(modelTexture.fileName)) {
                    texture = (Texture)objectMap.get(modelTexture.fileName);
                } else {
                    texture = textureProvider.load(modelTexture.fileName);
                    objectMap.put(modelTexture.fileName, texture);
                    this.disposables.add(texture);
                }
                TextureDescriptor<Texture> textureDescriptor = new TextureDescriptor<Texture>(texture);
                new TextureDescriptor<Texture>(texture).minFilter = texture.getMinFilter();
                textureDescriptor.magFilter = texture.getMagFilter();
                textureDescriptor.uWrap = texture.getUWrap();
                textureDescriptor.vWrap = texture.getVWrap();
                float f2 = modelTexture.uvTranslation == null ? 0.0f : modelTexture.uvTranslation.x;
                float f3 = modelTexture.uvTranslation == null ? 0.0f : modelTexture.uvTranslation.y;
                float f4 = modelTexture.uvScaling == null ? 1.0f : modelTexture.uvScaling.x;
                float f5 = modelTexture.uvScaling == null ? 1.0f : modelTexture.uvScaling.y;
                switch (modelTexture.usage) {
                    case 2: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Diffuse, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 5: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Specular, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 8: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Bump, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 7: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Normal, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 4: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Ambient, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 3: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Emissive, textureDescriptor, f2, f3, f4, f5));
                        break;
                    }
                    case 10: {
                        material.set((Attribute)new TextureAttribute(TextureAttribute.Reflection, textureDescriptor, f2, f3, f4, f5));
                    }
                }
            }
        }
        return material;
    }

    public void manageDisposable(Disposable disposable) {
        if (!this.disposables.contains(disposable, true)) {
            this.disposables.add(disposable);
        }
    }

    public Iterable<Disposable> getManagedDisposables() {
        return this.disposables;
    }

    @Override
    public void dispose() {
        for (Disposable disposable : this.disposables) {
            disposable.dispose();
        }
    }

    public void calculateTransforms() {
        int n2;
        int n3 = this.nodes.size;
        for (n2 = 0; n2 < n3; ++n2) {
            this.nodes.get(n2).calculateTransforms(true);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.nodes.get(n2).calculateBoneTransforms(true);
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        int n2 = this.nodes.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.nodes.get(i2).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public Animation getAnimation(String string) {
        return this.getAnimation(string, true);
    }

    public Animation getAnimation(String string, boolean bl) {
        int n2 = this.animations.size;
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Animation animation = this.animations.get(i2);
                if (!animation.id.equalsIgnoreCase(string)) continue;
                return animation;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Animation animation = this.animations.get(i3);
                if (!animation.id.equals(string)) continue;
                return animation;
            }
        }
        return null;
    }

    public Material getMaterial(String string) {
        return this.getMaterial(string, true);
    }

    public Material getMaterial(String string, boolean bl) {
        int n2 = this.materials.size;
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Material material = this.materials.get(i2);
                if (!material.id.equalsIgnoreCase(string)) continue;
                return material;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Material material = this.materials.get(i3);
                if (!material.id.equals(string)) continue;
                return material;
            }
        }
        return null;
    }

    public Node getNode(String string) {
        return this.getNode(string, true);
    }

    public Node getNode(String string, boolean bl) {
        return this.getNode(string, bl, false);
    }

    public Node getNode(String string, boolean bl, boolean bl2) {
        return Node.getNode(this.nodes, string, bl, bl2);
    }
}

