/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.ModelCache$MeshPool;
import com.badlogic.gdx.utils.Array;

public class ModelCache$TightMeshPool
implements ModelCache$MeshPool {
    private Array<Mesh> freeMeshes = new Array();
    private Array<Mesh> usedMeshes = new Array();

    @Override
    public void flush() {
        this.freeMeshes.addAll(this.usedMeshes);
        this.usedMeshes.clear();
    }

    @Override
    public Mesh obtain(VertexAttributes vertexAttributes, int n2, int n3) {
        int n4 = this.freeMeshes.size;
        for (int i2 = 0; i2 < n4; ++i2) {
            Mesh mesh = this.freeMeshes.get(i2);
            if (!mesh.getVertexAttributes().equals(vertexAttributes) || mesh.getMaxVertices() != n2 || mesh.getMaxIndices() != n3) continue;
            this.freeMeshes.removeIndex(i2);
            this.usedMeshes.add(mesh);
            return mesh;
        }
        Mesh mesh = new Mesh(true, n2, n3, vertexAttributes);
        this.usedMeshes.add(mesh);
        return mesh;
    }

    @Override
    public void dispose() {
        for (Mesh mesh : this.usedMeshes) {
            mesh.dispose();
        }
        this.usedMeshes.clear();
        for (Mesh mesh : this.freeMeshes) {
            mesh.dispose();
        }
        this.freeMeshes.clear();
    }
}

