/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d;

import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.NodePart;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.BoundingBox;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.Pool;

public class ModelInstance
implements RenderableProvider {
    public static boolean defaultShareKeyframes = true;
    public final Array<Material> materials;
    public final Array<Node> nodes;
    public final Array<Animation> animations;
    public final Model model;
    public Matrix4 transform;
    public Object userData;

    public ModelInstance(Model model) {
        this(model, (String[])null);
    }

    public ModelInstance(Model model, String string, boolean bl) {
        this(model, null, string, false, false, bl);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string, boolean bl) {
        this(model, matrix4, string, false, false, bl);
    }

    public ModelInstance(Model model, String string, boolean bl, boolean bl2) {
        this(model, null, string, true, bl, bl2);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string, boolean bl, boolean bl2) {
        this(model, matrix4, string, true, bl, bl2);
    }

    public ModelInstance(Model model, String string, boolean bl, boolean bl2, boolean bl3) {
        this(model, null, string, bl, bl2, bl3);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String string, boolean bl, boolean bl2, boolean bl3) {
        this(model, matrix4, string, bl, bl2, bl3, defaultShareKeyframes);
    }

    public ModelInstance(Model model, Matrix4 object, String object2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.materials = new Array();
        this.nodes = new Array();
        this.animations = new Array();
        this.model = model;
        this.transform = object == null ? new Matrix4() : object;
        object2 = model.getNode((String)object2, bl);
        object = ((Node)object2).copy();
        this.nodes.add((Node)object);
        if (bl3) {
            this.transform.mul(bl2 ? ((Node)object2).globalTransform : ((Node)object2).localTransform);
            ((Node)object).translation.set(0.0f, 0.0f, 0.0f);
            ((Node)object).rotation.idt();
            ((Node)object).scale.set(1.0f, 1.0f, 1.0f);
        } else if (bl2 && ((Node)object).hasParent()) {
            this.transform.mul(((Node)object2).getParent().globalTransform);
        }
        this.invalidate();
        this.copyAnimations(model.animations, bl4);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, String ... stringArray) {
        this(model, (Matrix4)null, stringArray);
    }

    public ModelInstance(Model model, Matrix4 matrix4, String ... stringArray) {
        this.materials = new Array();
        this.nodes = new Array();
        this.animations = new Array();
        this.model = model;
        Matrix4 matrix42 = this.transform = matrix4 == null ? new Matrix4() : matrix4;
        if (stringArray == null) {
            this.copyNodes(model.nodes);
        } else {
            this.copyNodes(model.nodes, stringArray);
        }
        this.copyAnimations(model.animations, defaultShareKeyframes);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, Array<String> array) {
        this(model, null, array);
    }

    public ModelInstance(Model model, Matrix4 matrix4, Array<String> array) {
        this(model, matrix4, array, defaultShareKeyframes);
    }

    public ModelInstance(Model model, Matrix4 matrix4, Array<String> array, boolean bl) {
        this.materials = new Array();
        this.nodes = new Array();
        this.animations = new Array();
        this.model = model;
        this.transform = matrix4 == null ? new Matrix4() : matrix4;
        this.copyNodes(model.nodes, array);
        this.copyAnimations(model.animations, bl);
        this.calculateTransforms();
    }

    public ModelInstance(Model model, Vector3 vector3) {
        this(model);
        this.transform.setToTranslation(vector3);
    }

    public ModelInstance(Model model, float f2, float f3, float f4) {
        this(model);
        this.transform.setToTranslation(f2, f3, f4);
    }

    public ModelInstance(Model model, Matrix4 matrix4) {
        this(model, matrix4, (String[])null);
    }

    public ModelInstance(ModelInstance modelInstance) {
        ModelInstance modelInstance2 = modelInstance;
        this(modelInstance2, modelInstance2.transform.cpy());
    }

    public ModelInstance(ModelInstance modelInstance, Matrix4 matrix4) {
        this(modelInstance, matrix4, defaultShareKeyframes);
    }

    public ModelInstance(ModelInstance modelInstance, Matrix4 matrix4, boolean bl) {
        this.materials = new Array();
        this.nodes = new Array();
        this.animations = new Array();
        this.model = modelInstance.model;
        this.transform = matrix4 == null ? new Matrix4() : matrix4;
        this.copyNodes(modelInstance.nodes);
        this.copyAnimations(modelInstance.animations, bl);
        this.calculateTransforms();
    }

    public ModelInstance copy() {
        return new ModelInstance(this);
    }

    private void copyNodes(Array<Node> array) {
        int n2 = array.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = array.get(i2);
            this.nodes.add(node.copy());
        }
        this.invalidate();
    }

    private void copyNodes(Array<Node> array, String ... stringArray) {
        int n2 = array.size;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Node node = array.get(i2);
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                String string = stringArray2[i3];
                if (!string.equals(node.id)) continue;
                this.nodes.add(node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void copyNodes(Array<Node> array, Array<String> array2) {
        int n2 = array.size;
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            Node node = array.get(i2);
            for (String string : array2) {
                if (!string.equals(node.id)) continue;
                this.nodes.add(node.copy());
                continue block0;
            }
        }
        this.invalidate();
    }

    private void invalidate(Node node) {
        int n2;
        int n3 = node.parts.size;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            NodePart nodePart = node.parts.get(n2);
            ArrayMap<Node, Matrix4> arrayMap = nodePart.invBoneBindTransforms;
            if (arrayMap != null) {
                for (n4 = 0; n4 < arrayMap.size; ++n4) {
                    ((Node[])arrayMap.keys)[n4] = this.getNode(((Node[])arrayMap.keys)[n4].id);
                }
            }
            if (this.materials.contains(nodePart.material, true)) continue;
            n4 = this.materials.indexOf(nodePart.material, false);
            if (n4 < 0) {
                nodePart.material = nodePart.material.copy();
                this.materials.add(nodePart.material);
                continue;
            }
            nodePart.material = this.materials.get(n4);
        }
        n3 = node.getChildCount();
        for (n2 = 0; n2 < n3; ++n2) {
            this.invalidate(node.getChild(n2));
        }
    }

    private void invalidate() {
        int n2 = this.nodes.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            ModelInstance modelInstance = this;
            modelInstance.invalidate(modelInstance.nodes.get(i2));
        }
    }

    public void copyAnimations(Iterable<Animation> object) {
        object = object.iterator();
        while (object.hasNext()) {
            Animation animation = (Animation)object.next();
            this.copyAnimation(animation, defaultShareKeyframes);
        }
    }

    public void copyAnimations(Iterable<Animation> object, boolean bl) {
        object = object.iterator();
        while (object.hasNext()) {
            Animation animation = (Animation)object.next();
            this.copyAnimation(animation, bl);
        }
    }

    public void copyAnimation(Animation animation) {
        this.copyAnimation(animation, defaultShareKeyframes);
    }

    public void copyAnimation(Animation object, boolean bl) {
        Animation animation = new Animation();
        new Animation().id = ((Animation)object).id;
        animation.duration = ((Animation)object).duration;
        for (NodeAnimation nodeAnimation : ((Animation)object).nodeAnimations) {
            Node node = this.getNode(nodeAnimation.node.id);
            if (node == null) continue;
            NodeAnimation nodeAnimation2 = new NodeAnimation();
            new NodeAnimation().node = node;
            if (bl) {
                nodeAnimation2.translation = nodeAnimation.translation;
                nodeAnimation2.rotation = nodeAnimation.rotation;
                nodeAnimation2.scaling = nodeAnimation.scaling;
            } else {
                if (nodeAnimation.translation != null) {
                    nodeAnimation2.translation = new Array();
                    for (NodeKeyframe nodeKeyframe : nodeAnimation.translation) {
                        nodeAnimation2.translation.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
                if (nodeAnimation.rotation != null) {
                    nodeAnimation2.rotation = new Array();
                    for (NodeKeyframe nodeKeyframe : nodeAnimation.rotation) {
                        nodeAnimation2.rotation.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
                if (nodeAnimation.scaling != null) {
                    nodeAnimation2.scaling = new Array();
                    for (NodeKeyframe nodeKeyframe : nodeAnimation.scaling) {
                        nodeAnimation2.scaling.add(new NodeKeyframe(nodeKeyframe.keytime, nodeKeyframe.value));
                    }
                }
            }
            if (nodeAnimation2.translation == null && nodeAnimation2.rotation == null && nodeAnimation2.scaling == null) continue;
            animation.nodeAnimations.add(nodeAnimation2);
        }
        if (animation.nodeAnimations.size > 0) {
            this.animations.add(animation);
        }
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        for (Node node : this.nodes) {
            this.getRenderables(node, array, pool);
        }
    }

    public Renderable getRenderable(Renderable renderable) {
        return this.getRenderable(renderable, this.nodes.get(0));
    }

    public Renderable getRenderable(Renderable renderable, Node node) {
        Node node2 = node;
        return this.getRenderable(renderable, node2, node2.parts.get(0));
    }

    public Renderable getRenderable(Renderable renderable, Node node, NodePart nodePart) {
        nodePart.setRenderable(renderable);
        if (nodePart.bones == null && this.transform != null) {
            renderable.worldTransform.set(this.transform).mul(node.globalTransform);
        } else if (this.transform != null) {
            renderable.worldTransform.set(this.transform);
        } else {
            renderable.worldTransform.idt();
        }
        renderable.userData = this.userData;
        return renderable;
    }

    protected void getRenderables(Node node, Array<Renderable> array, Pool<Renderable> pool) {
        if (node.parts.size > 0) {
            for (NodePart object : node.parts) {
                if (!object.enabled) continue;
                array.add(this.getRenderable(pool.obtain(), node, object));
            }
        }
        for (Node node2 : node.getChildren()) {
            this.getRenderables(node2, array, pool);
        }
    }

    public void calculateTransforms() {
        int n2;
        int n3 = this.nodes.size;
        for (n2 = 0; n2 < n3; ++n2) {
            this.nodes.get(n2).calculateTransforms(true);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.nodes.get(n2).calculateBoneTransforms(true);
        }
    }

    public BoundingBox calculateBoundingBox(BoundingBox boundingBox) {
        boundingBox.inf();
        return this.extendBoundingBox(boundingBox);
    }

    public BoundingBox extendBoundingBox(BoundingBox boundingBox) {
        int n2 = this.nodes.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.nodes.get(i2).extendBoundingBox(boundingBox);
        }
        return boundingBox;
    }

    public Animation getAnimation(String string) {
        return this.getAnimation(string, false);
    }

    public Animation getAnimation(String string, boolean bl) {
        int n2 = this.animations.size;
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Animation animation = this.animations.get(i2);
                if (!animation.id.equalsIgnoreCase(string)) continue;
                return animation;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Animation animation = this.animations.get(i3);
                if (!animation.id.equals(string)) continue;
                return animation;
            }
        }
        return null;
    }

    public Material getMaterial(String string) {
        return this.getMaterial(string, true);
    }

    public Material getMaterial(String string, boolean bl) {
        int n2 = this.materials.size;
        if (bl) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Material material = this.materials.get(i2);
                if (!material.id.equalsIgnoreCase(string)) continue;
                return material;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Material material = this.materials.get(i3);
                if (!material.id.equals(string)) continue;
                return material;
            }
        }
        return null;
    }

    public Node getNode(String string) {
        return this.getNode(string, true);
    }

    public Node getNode(String string, boolean bl) {
        return this.getNode(string, bl, false);
    }

    public Node getNode(String string, boolean bl, boolean bl2) {
        return Node.getNode(this.nodes, string, bl, bl2);
    }
}

