/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.attributes;

import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.NumberUtils;

public class DepthTestAttribute
extends Attribute {
    public static final String Alias = "depthStencil";
    public static final long Type;
    protected static long Mask;
    public int depthFunc;
    public float depthRangeNear;
    public float depthRangeFar;
    public boolean depthMask;

    public static final boolean is(long l2) {
        return (l2 & Mask) != 0L;
    }

    public DepthTestAttribute() {
        this(515);
    }

    public DepthTestAttribute(boolean bl) {
        this(515, bl);
    }

    public DepthTestAttribute(int n2) {
        this(n2, true);
    }

    public DepthTestAttribute(int n2, boolean bl) {
        this(n2, 0.0f, 1.0f, bl);
    }

    public DepthTestAttribute(int n2, float f2, float f3) {
        this(n2, f2, f3, true);
    }

    public DepthTestAttribute(int n2, float f2, float f3, boolean bl) {
        this(Type, n2, f2, f3, bl);
    }

    public DepthTestAttribute(long l2, int n2, float f2, float f3, boolean bl) {
        super(l2);
        if (!DepthTestAttribute.is(l2)) {
            throw new GdxRuntimeException("Invalid type specified");
        }
        this.depthFunc = n2;
        this.depthRangeNear = f2;
        this.depthRangeFar = f3;
        this.depthMask = bl;
    }

    public DepthTestAttribute(DepthTestAttribute depthTestAttribute) {
        this(depthTestAttribute.type, depthTestAttribute.depthFunc, depthTestAttribute.depthRangeNear, depthTestAttribute.depthRangeFar, depthTestAttribute.depthMask);
    }

    @Override
    public Attribute copy() {
        return new DepthTestAttribute(this);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = n2 * 971 + this.depthFunc;
        n2 = n2 * 971 + NumberUtils.floatToRawIntBits(this.depthRangeNear);
        n2 = n2 * 971 + NumberUtils.floatToRawIntBits(this.depthRangeFar);
        n2 = n2 * 971 + (this.depthMask ? 1 : 0);
        return n2;
    }

    @Override
    public int compareTo(Attribute attribute) {
        if (this.type != attribute.type) {
            return (int)(this.type - attribute.type);
        }
        attribute = (DepthTestAttribute)attribute;
        if (this.depthFunc != ((DepthTestAttribute)attribute).depthFunc) {
            return this.depthFunc - ((DepthTestAttribute)attribute).depthFunc;
        }
        if (this.depthMask != ((DepthTestAttribute)attribute).depthMask) {
            if (this.depthMask) {
                return -1;
            }
            return 1;
        }
        if (!MathUtils.isEqual(this.depthRangeNear, ((DepthTestAttribute)attribute).depthRangeNear)) {
            if (this.depthRangeNear < ((DepthTestAttribute)attribute).depthRangeNear) {
                return -1;
            }
            return 1;
        }
        if (!MathUtils.isEqual(this.depthRangeFar, ((DepthTestAttribute)attribute).depthRangeFar)) {
            if (this.depthRangeFar < ((DepthTestAttribute)attribute).depthRangeFar) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    static {
        Mask = Type = DepthTestAttribute.register(Alias);
    }
}

