/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loader;

import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.ModelLoader;
import com.badlogic.gdx.assets.loaders.ModelLoader$ModelParameters;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.model.data.ModelAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelData;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMesh;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMeshPart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNode;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodeKeyframe;
import com.badlogic.gdx.graphics.g3d.model.data.ModelNodePart;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ArrayMap;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.JsonValue;

public class G3dModelLoader
extends ModelLoader<ModelLoader$ModelParameters> {
    public static final short VERSION_HI = 0;
    public static final short VERSION_LO = 1;
    protected final BaseJsonReader reader;
    protected final Quaternion tempQ = new Quaternion();

    public G3dModelLoader(BaseJsonReader baseJsonReader) {
        this(baseJsonReader, null);
    }

    public G3dModelLoader(BaseJsonReader baseJsonReader, FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
        this.reader = baseJsonReader;
    }

    @Override
    public ModelData loadModelData(FileHandle fileHandle, ModelLoader$ModelParameters modelLoader$ModelParameters) {
        return this.parseModel(fileHandle);
    }

    public ModelData parseModel(FileHandle fileHandle) {
        JsonValue jsonValue = this.reader.parse(fileHandle);
        ModelData modelData = new ModelData();
        JsonValue jsonValue2 = jsonValue.require("version");
        modelData.version[0] = jsonValue2.getShort(0);
        modelData.version[1] = jsonValue2.getShort(1);
        if (modelData.version[0] != 0 || modelData.version[1] != 1) {
            throw new GdxRuntimeException("Model version not supported");
        }
        modelData.id = jsonValue.getString("id", "");
        this.parseMeshes(modelData, jsonValue);
        this.parseMaterials(modelData, jsonValue, fileHandle.parent().path());
        this.parseNodes(modelData, jsonValue);
        this.parseAnimations(modelData, jsonValue);
        return modelData;
    }

    protected void parseMeshes(ModelData modelData, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("meshes")) != null) {
            modelData.meshes.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                ModelMesh modelMesh = new ModelMesh();
                Object object = jsonValue.getString("id", "");
                modelMesh.id = object;
                object = jsonValue.require("attributes");
                modelMesh.attributes = this.parseAttributes((JsonValue)object);
                modelMesh.vertices = jsonValue.require("vertices").asFloatArray();
                object = jsonValue.require("parts");
                Array<ModelMeshPart> array = new Array<ModelMeshPart>();
                object = ((JsonValue)object).child;
                while (object != null) {
                    ModelMeshPart modelMeshPart = new ModelMeshPart();
                    String string = ((JsonValue)object).getString("id", null);
                    if (string == null) {
                        throw new GdxRuntimeException("Not id given for mesh part");
                    }
                    for (ModelMeshPart modelMeshPart2 : array) {
                        if (!modelMeshPart2.id.equals(string)) continue;
                        throw new GdxRuntimeException("Mesh part with id '" + string + "' already in defined");
                    }
                    modelMeshPart.id = string;
                    String string2 = ((JsonValue)object).getString("type", null);
                    if (string2 == null) {
                        throw new GdxRuntimeException("No primitive type given for mesh part '" + string + "'");
                    }
                    modelMeshPart.primitiveType = this.parseType(string2);
                    modelMeshPart.indices = ((JsonValue)object).require("indices").asShortArray();
                    array.add(modelMeshPart);
                    object = ((JsonValue)object).next;
                }
                modelMesh.parts = array.toArray(ModelMeshPart.class);
                modelData.meshes.add(modelMesh);
                jsonValue = jsonValue.next;
            }
        }
    }

    protected int parseType(String string) {
        if (string.equals("TRIANGLES")) {
            return 4;
        }
        if (string.equals("LINES")) {
            return 1;
        }
        if (string.equals("POINTS")) {
            return 0;
        }
        if (string.equals("TRIANGLE_STRIP")) {
            return 5;
        }
        if (string.equals("LINE_STRIP")) {
            return 3;
        }
        throw new GdxRuntimeException("Unknown primitive type '" + string + "', should be one of triangle, trianglestrip, line, linestrip or point");
    }

    protected VertexAttribute[] parseAttributes(JsonValue jsonValue) {
        Array<VertexAttribute> array = new Array<VertexAttribute>();
        int n2 = 0;
        int n3 = 0;
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            String string;
            String string2 = jsonValue.asString();
            string2 = string2;
            if (string.equals("POSITION")) {
                array.add(VertexAttribute.Position());
            } else if (string2.equals("NORMAL")) {
                array.add(VertexAttribute.Normal());
            } else if (string2.equals("COLOR")) {
                array.add(VertexAttribute.ColorUnpacked());
            } else if (string2.equals("COLORPACKED")) {
                array.add(VertexAttribute.ColorPacked());
            } else if (string2.equals("TANGENT")) {
                array.add(VertexAttribute.Tangent());
            } else if (string2.equals("BINORMAL")) {
                array.add(VertexAttribute.Binormal());
            } else if (string2.startsWith("TEXCOORD")) {
                array.add(VertexAttribute.TexCoords(n2++));
            } else if (string2.startsWith("BLENDWEIGHT")) {
                array.add(VertexAttribute.BoneWeight(n3++));
            } else {
                throw new GdxRuntimeException("Unknown vertex attribute '" + string2 + "', should be one of position, normal, uv, tangent or binormal");
            }
            jsonValue = jsonValue.next;
        }
        return array.toArray(VertexAttribute.class);
    }

    protected void parseMaterials(ModelData modelData, JsonValue jsonValue, String string) {
        if ((jsonValue = jsonValue.get("materials")) != null) {
            modelData.materials.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                ModelMaterial modelMaterial = new ModelMaterial();
                Object object = jsonValue.getString("id", null);
                if (object == null) {
                    throw new GdxRuntimeException("Material needs an id.");
                }
                modelMaterial.id = object;
                object = jsonValue.get("diffuse");
                if (object != null) {
                    modelMaterial.diffuse = this.parseColor((JsonValue)object);
                }
                if ((object = jsonValue.get("ambient")) != null) {
                    modelMaterial.ambient = this.parseColor((JsonValue)object);
                }
                if ((object = jsonValue.get("emissive")) != null) {
                    modelMaterial.emissive = this.parseColor((JsonValue)object);
                }
                if ((object = jsonValue.get("specular")) != null) {
                    modelMaterial.specular = this.parseColor((JsonValue)object);
                }
                if ((object = jsonValue.get("reflection")) != null) {
                    modelMaterial.reflection = this.parseColor((JsonValue)object);
                }
                modelMaterial.shininess = jsonValue.getFloat("shininess", 0.0f);
                modelMaterial.opacity = jsonValue.getFloat("opacity", 1.0f);
                object = jsonValue.get("textures");
                if (object != null) {
                    object = ((JsonValue)object).child;
                    while (object != null) {
                        ModelTexture modelTexture = new ModelTexture();
                        String string2 = ((JsonValue)object).getString("id", null);
                        if (string2 == null) {
                            throw new GdxRuntimeException("Texture has no id.");
                        }
                        modelTexture.id = string2;
                        string2 = ((JsonValue)object).getString("filename", null);
                        if (string2 == null) {
                            throw new GdxRuntimeException("Texture needs filename.");
                        }
                        modelTexture.fileName = string + (string.length() == 0 || string.endsWith("/") ? "" : "/") + string2;
                        modelTexture.uvTranslation = this.readVector2(((JsonValue)object).get("uvTranslation"), 0.0f, 0.0f);
                        modelTexture.uvScaling = this.readVector2(((JsonValue)object).get("uvScaling"), 1.0f, 1.0f);
                        string2 = ((JsonValue)object).getString("type", null);
                        if (string2 == null) {
                            throw new GdxRuntimeException("Texture needs type.");
                        }
                        modelTexture.usage = this.parseTextureUsage(string2);
                        if (modelMaterial.textures == null) {
                            modelMaterial.textures = new Array();
                        }
                        modelMaterial.textures.add(modelTexture);
                        object = ((JsonValue)object).next;
                    }
                }
                modelData.materials.add(modelMaterial);
                jsonValue = jsonValue.next;
            }
        }
    }

    protected int parseTextureUsage(String string) {
        if (string.equalsIgnoreCase("AMBIENT")) {
            return 4;
        }
        if (string.equalsIgnoreCase("BUMP")) {
            return 8;
        }
        if (string.equalsIgnoreCase("DIFFUSE")) {
            return 2;
        }
        if (string.equalsIgnoreCase("EMISSIVE")) {
            return 3;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return 1;
        }
        if (string.equalsIgnoreCase("NORMAL")) {
            return 7;
        }
        if (string.equalsIgnoreCase("REFLECTION")) {
            return 10;
        }
        if (string.equalsIgnoreCase("SHININESS")) {
            return 6;
        }
        if (string.equalsIgnoreCase("SPECULAR")) {
            return 5;
        }
        if (string.equalsIgnoreCase("TRANSPARENCY")) {
            return 9;
        }
        return 0;
    }

    protected Color parseColor(JsonValue jsonValue) {
        if (jsonValue.size >= 3) {
            return new Color(jsonValue.getFloat(0), jsonValue.getFloat(1), jsonValue.getFloat(2), 1.0f);
        }
        throw new GdxRuntimeException("Expected Color values <> than three.");
    }

    protected Vector2 readVector2(JsonValue jsonValue, float f2, float f3) {
        if (jsonValue == null) {
            return new Vector2(f2, f3);
        }
        if (jsonValue.size == 2) {
            return new Vector2(jsonValue.getFloat(0), jsonValue.getFloat(1));
        }
        throw new GdxRuntimeException("Expected Vector2 values <> than two.");
    }

    protected Array<ModelNode> parseNodes(ModelData modelData, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("nodes")) != null) {
            modelData.nodes.ensureCapacity(jsonValue.size);
            jsonValue = jsonValue.child;
            while (jsonValue != null) {
                modelData.nodes.add(this.parseNodesRecursively(jsonValue));
                jsonValue = jsonValue.next;
            }
        }
        return modelData.nodes;
    }

    protected ModelNode parseNodesRecursively(JsonValue jsonValue) {
        JsonValue jsonValue2;
        Object object;
        ModelNode modelNode = new ModelNode();
        String string = jsonValue.getString("id", null);
        if (string == null) {
            throw new GdxRuntimeException("Node id missing.");
        }
        modelNode.id = string;
        Object object2 = jsonValue.get("translation");
        if (object2 != null && ((JsonValue)object2).size != 3) {
            throw new GdxRuntimeException("Node translation incomplete");
        }
        modelNode.translation = object2 == null ? null : new Vector3(((JsonValue)object2).getFloat(0), ((JsonValue)object2).getFloat(1), ((JsonValue)object2).getFloat(2));
        object2 = jsonValue.get("rotation");
        if (object2 != null && ((JsonValue)object2).size != 4) {
            throw new GdxRuntimeException("Node rotation incomplete");
        }
        modelNode.rotation = object2 == null ? null : new Quaternion(((JsonValue)object2).getFloat(0), ((JsonValue)object2).getFloat(1), ((JsonValue)object2).getFloat(2), ((JsonValue)object2).getFloat(3));
        object2 = jsonValue.get("scale");
        if (object2 != null && ((JsonValue)object2).size != 3) {
            throw new GdxRuntimeException("Node scale incomplete");
        }
        modelNode.scale = object2 == null ? null : new Vector3(((JsonValue)object2).getFloat(0), ((JsonValue)object2).getFloat(1), ((JsonValue)object2).getFloat(2));
        object2 = jsonValue.getString("mesh", null);
        if (object2 != null) {
            modelNode.meshId = object2;
        }
        if ((object2 = jsonValue.get("parts")) != null) {
            modelNode.parts = new ModelNodePart[((JsonValue)object2).size];
            int n2 = 0;
            object2 = ((JsonValue)object2).child;
            while (object2 != null) {
                object = new ModelNodePart();
                Object object3 = ((JsonValue)object2).getString("meshpartid", null);
                String string2 = ((JsonValue)object2).getString("materialid", null);
                if (object3 == null || string2 == null) {
                    throw new GdxRuntimeException("Node " + string + " part is missing meshPartId or materialId");
                }
                ((ModelNodePart)object).materialId = string2;
                ((ModelNodePart)object).meshPartId = object3;
                object3 = ((JsonValue)object2).get("bones");
                if (object3 != null) {
                    ((ModelNodePart)object).bones = new ArrayMap(true, ((JsonValue)object3).size, String.class, Matrix4.class);
                    object3 = ((JsonValue)object3).child;
                    while (object3 != null) {
                        string2 = ((JsonValue)object3).getString("node", null);
                        if (string2 == null) {
                            throw new GdxRuntimeException("Bone node ID missing");
                        }
                        Matrix4 matrix4 = new Matrix4();
                        JsonValue jsonValue3 = ((JsonValue)object3).get("translation");
                        if (jsonValue3 != null && jsonValue3.size >= 3) {
                            matrix4.translate(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                        }
                        if ((jsonValue3 = ((JsonValue)object3).get("rotation")) != null && jsonValue3.size >= 4) {
                            matrix4.rotate(this.tempQ.set(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2), jsonValue3.getFloat(3)));
                        }
                        if ((jsonValue3 = ((JsonValue)object3).get("scale")) != null && jsonValue3.size >= 3) {
                            matrix4.scale(jsonValue3.getFloat(0), jsonValue3.getFloat(1), jsonValue3.getFloat(2));
                        }
                        ((ModelNodePart)object).bones.put(string2, matrix4);
                        object3 = ((JsonValue)object3).next;
                    }
                }
                modelNode.parts[n2] = object;
                object2 = ((JsonValue)object2).next;
                ++n2;
            }
        }
        if ((jsonValue2 = jsonValue.get("children")) != null) {
            modelNode.children = new ModelNode[jsonValue2.size];
            int n3 = 0;
            object = jsonValue2.child;
            while (object != null) {
                modelNode.children[n3] = this.parseNodesRecursively((JsonValue)object);
                object = ((JsonValue)object).next;
                ++n3;
            }
        }
        return modelNode;
    }

    protected void parseAnimations(ModelData modelData, JsonValue jsonValue) {
        if ((jsonValue = jsonValue.get("animations")) == null) {
            return;
        }
        modelData.animations.ensureCapacity(jsonValue.size);
        jsonValue = jsonValue.child;
        while (jsonValue != null) {
            JsonValue jsonValue2 = jsonValue.get("bones");
            if (jsonValue2 != null) {
                ModelAnimation modelAnimation = new ModelAnimation();
                modelData.animations.add(modelAnimation);
                modelAnimation.nodeAnimations.ensureCapacity(jsonValue2.size);
                modelAnimation.id = jsonValue.getString("id");
                jsonValue2 = jsonValue2.child;
                while (jsonValue2 != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    ModelNodeAnimation modelNodeAnimation = new ModelNodeAnimation();
                    modelAnimation.nodeAnimations.add(modelNodeAnimation);
                    modelNodeAnimation.nodeId = jsonValue2.getString("boneId");
                    JsonValue jsonValue3 = jsonValue2.get("keyframes");
                    if (jsonValue3 != null && jsonValue3.isArray()) {
                        jsonValue3 = jsonValue3.child;
                        while (jsonValue3 != null) {
                            float f2 = jsonValue3.getFloat("keytime", 0.0f) / 1000.0f;
                            object3 = jsonValue3.get("translation");
                            if (object3 != null && ((JsonValue)object3).size == 3) {
                                if (modelNodeAnimation.translation == null) {
                                    modelNodeAnimation.translation = new Array();
                                }
                                object2 = new ModelNodeKeyframe();
                                new ModelNodeKeyframe().keytime = f2;
                                ((ModelNodeKeyframe)object2).value = new Vector3(((JsonValue)object3).getFloat(0), ((JsonValue)object3).getFloat(1), ((JsonValue)object3).getFloat(2));
                                modelNodeAnimation.translation.add((ModelNodeKeyframe<Vector3>)object2);
                            }
                            if ((object2 = jsonValue3.get("rotation")) != null && ((JsonValue)object2).size == 4) {
                                if (modelNodeAnimation.rotation == null) {
                                    modelNodeAnimation.rotation = new Array();
                                }
                                object = new ModelNodeKeyframe();
                                new ModelNodeKeyframe().keytime = f2;
                                ((ModelNodeKeyframe)object).value = new Quaternion(((JsonValue)object2).getFloat(0), ((JsonValue)object2).getFloat(1), ((JsonValue)object2).getFloat(2), ((JsonValue)object2).getFloat(3));
                                modelNodeAnimation.rotation.add((ModelNodeKeyframe<Quaternion>)object);
                            }
                            if ((object = jsonValue3.get("scale")) != null && ((JsonValue)object).size == 3) {
                                if (modelNodeAnimation.scaling == null) {
                                    modelNodeAnimation.scaling = new Array();
                                }
                                object3 = new ModelNodeKeyframe();
                                new ModelNodeKeyframe().keytime = f2;
                                ((ModelNodeKeyframe)object3).value = new Vector3(((JsonValue)object).getFloat(0), ((JsonValue)object).getFloat(1), ((JsonValue)object).getFloat(2));
                                modelNodeAnimation.scaling.add((ModelNodeKeyframe<Vector3>)object3);
                            }
                            jsonValue3 = jsonValue3.next;
                        }
                    } else {
                        JsonValue jsonValue4;
                        jsonValue3 = jsonValue2.get("translation");
                        if (jsonValue3 != null && jsonValue3.isArray()) {
                            modelNodeAnimation.translation = new Array();
                            modelNodeAnimation.translation.ensureCapacity(jsonValue3.size);
                            jsonValue4 = jsonValue3.child;
                            while (jsonValue4 != null) {
                                object3 = new ModelNodeKeyframe();
                                modelNodeAnimation.translation.add((ModelNodeKeyframe<Vector3>)object3);
                                ((ModelNodeKeyframe)object3).keytime = jsonValue4.getFloat("keytime", 0.0f) / 1000.0f;
                                object2 = jsonValue4.get("value");
                                if (object2 != null && ((JsonValue)object2).size >= 3) {
                                    ((ModelNodeKeyframe)object3).value = new Vector3(((JsonValue)object2).getFloat(0), ((JsonValue)object2).getFloat(1), ((JsonValue)object2).getFloat(2));
                                }
                                jsonValue4 = jsonValue4.next;
                            }
                        }
                        if ((jsonValue4 = jsonValue2.get("rotation")) != null && jsonValue4.isArray()) {
                            modelNodeAnimation.rotation = new Array();
                            modelNodeAnimation.rotation.ensureCapacity(jsonValue4.size);
                            object3 = jsonValue4.child;
                            while (object3 != null) {
                                object2 = new ModelNodeKeyframe();
                                modelNodeAnimation.rotation.add((ModelNodeKeyframe<Quaternion>)object2);
                                ((ModelNodeKeyframe)object2).keytime = ((JsonValue)object3).getFloat("keytime", 0.0f) / 1000.0f;
                                object = ((JsonValue)object3).get("value");
                                if (object != null && ((JsonValue)object).size >= 4) {
                                    ((ModelNodeKeyframe)object2).value = new Quaternion(((JsonValue)object).getFloat(0), ((JsonValue)object).getFloat(1), ((JsonValue)object).getFloat(2), ((JsonValue)object).getFloat(3));
                                }
                                object3 = ((JsonValue)object3).next;
                            }
                        }
                        if ((object3 = jsonValue2.get("scaling")) != null && ((JsonValue)object3).isArray()) {
                            modelNodeAnimation.scaling = new Array();
                            modelNodeAnimation.scaling.ensureCapacity(((JsonValue)object3).size);
                            object2 = ((JsonValue)object3).child;
                            while (object2 != null) {
                                object = new ModelNodeKeyframe();
                                modelNodeAnimation.scaling.add((ModelNodeKeyframe<Vector3>)object);
                                ((ModelNodeKeyframe)object).keytime = ((JsonValue)object2).getFloat("keytime", 0.0f) / 1000.0f;
                                object3 = ((JsonValue)object2).get("value");
                                if (object3 != null && ((JsonValue)object3).size >= 3) {
                                    ((ModelNodeKeyframe)object).value = new Vector3(((JsonValue)object3).getFloat(0), ((JsonValue)object3).getFloat(1), ((JsonValue)object3).getFloat(2));
                                }
                                object2 = ((JsonValue)object2).next;
                            }
                        }
                    }
                    jsonValue2 = jsonValue2.next;
                }
            }
            jsonValue = jsonValue.next;
        }
    }
}

