/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loader;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelTexture;
import com.badlogic.gdx.utils.Array;

class MtlLoader$ObjMaterial {
    String materialName = "default";
    Color ambientColor;
    Color diffuseColor;
    Color specularColor;
    float opacity;
    float shininess;
    String alphaTexFilename;
    String ambientTexFilename;
    String diffuseTexFilename;
    String shininessTexFilename;
    String specularTexFilename;

    public MtlLoader$ObjMaterial() {
        this.reset();
    }

    public ModelMaterial build() {
        ModelMaterial modelMaterial = new ModelMaterial();
        new ModelMaterial().id = this.materialName;
        modelMaterial.ambient = this.ambientColor == null ? null : new Color(this.ambientColor);
        modelMaterial.diffuse = new Color(this.diffuseColor);
        modelMaterial.specular = new Color(this.specularColor);
        modelMaterial.opacity = this.opacity;
        modelMaterial.shininess = this.shininess;
        this.addTexture(modelMaterial, this.alphaTexFilename, 9);
        this.addTexture(modelMaterial, this.ambientTexFilename, 4);
        this.addTexture(modelMaterial, this.diffuseTexFilename, 2);
        this.addTexture(modelMaterial, this.specularTexFilename, 5);
        this.addTexture(modelMaterial, this.shininessTexFilename, 6);
        return modelMaterial;
    }

    private void addTexture(ModelMaterial modelMaterial, String string, int n2) {
        if (string != null) {
            ModelTexture modelTexture = new ModelTexture();
            new ModelTexture().usage = n2;
            modelTexture.fileName = string;
            if (modelMaterial.textures == null) {
                modelMaterial.textures = new Array(1);
            }
            modelMaterial.textures.add(modelTexture);
        }
    }

    public void reset() {
        this.ambientColor = null;
        this.diffuseColor = Color.WHITE;
        this.specularColor = Color.WHITE;
        this.opacity = 1.0f;
        this.shininess = 0.0f;
        this.alphaTexFilename = null;
        this.ambientTexFilename = null;
        this.diffuseTexFilename = null;
        this.shininessTexFilename = null;
        this.specularTexFilename = null;
    }
}

