/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loader;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.loader.MtlLoader$ObjMaterial;
import com.badlogic.gdx.graphics.g3d.model.data.ModelMaterial;
import com.badlogic.gdx.utils.Array;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class MtlLoader {
    public Array<ModelMaterial> materials = new Array();

    MtlLoader() {
    }

    public void load(FileHandle fileHandle) {
        Object object;
        MtlLoader$ObjMaterial mtlLoader$ObjMaterial = new MtlLoader$ObjMaterial();
        if (fileHandle == null || !fileHandle.exists()) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileHandle.read()), 4096);
        try {
            String[] stringArray;
            while ((stringArray = bufferedReader.readLine()) != null) {
                if (stringArray.length() > 0 && stringArray.charAt(0) == '\t') {
                    stringArray = stringArray.substring(1).trim();
                }
                if ((stringArray = stringArray.split("\\s+"))[0].length() == 0 || stringArray[0].charAt(0) == '#') continue;
                object = stringArray[0].toLowerCase();
                if (((String)object).equals("newmtl")) {
                    object = mtlLoader$ObjMaterial.build();
                    this.materials.add((ModelMaterial)object);
                    if (stringArray.length > 1) {
                        mtlLoader$ObjMaterial.materialName = stringArray[1];
                        mtlLoader$ObjMaterial.materialName = mtlLoader$ObjMaterial.materialName.replace('.', '_');
                    } else {
                        mtlLoader$ObjMaterial.materialName = "default";
                    }
                    mtlLoader$ObjMaterial.reset();
                    continue;
                }
                if (((String)object).equals("ka")) {
                    mtlLoader$ObjMaterial.ambientColor = this.parseColor(stringArray);
                    continue;
                }
                if (((String)object).equals("kd")) {
                    mtlLoader$ObjMaterial.diffuseColor = this.parseColor(stringArray);
                    continue;
                }
                if (((String)object).equals("ks")) {
                    mtlLoader$ObjMaterial.specularColor = this.parseColor(stringArray);
                    continue;
                }
                if (((String)object).equals("tr") || ((String)object).equals("d")) {
                    mtlLoader$ObjMaterial.opacity = Float.parseFloat(stringArray[1]);
                    continue;
                }
                if (((String)object).equals("ns")) {
                    mtlLoader$ObjMaterial.shininess = Float.parseFloat(stringArray[1]);
                    continue;
                }
                if (((String)object).equals("map_d")) {
                    mtlLoader$ObjMaterial.alphaTexFilename = fileHandle.parent().child(stringArray[1]).path();
                    continue;
                }
                if (((String)object).equals("map_ka")) {
                    mtlLoader$ObjMaterial.ambientTexFilename = fileHandle.parent().child(stringArray[1]).path();
                    continue;
                }
                if (((String)object).equals("map_kd")) {
                    mtlLoader$ObjMaterial.diffuseTexFilename = fileHandle.parent().child(stringArray[1]).path();
                    continue;
                }
                if (((String)object).equals("map_ks")) {
                    mtlLoader$ObjMaterial.specularTexFilename = fileHandle.parent().child(stringArray[1]).path();
                    continue;
                }
                if (!((String)object).equals("map_ns")) continue;
                mtlLoader$ObjMaterial.shininessTexFilename = fileHandle.parent().child(stringArray[1]).path();
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            return;
        }
        object = mtlLoader$ObjMaterial.build();
        this.materials.add((ModelMaterial)object);
    }

    private Color parseColor(String[] stringArray) {
        float f2 = Float.parseFloat(stringArray[1]);
        float f3 = Float.parseFloat(stringArray[2]);
        float f4 = Float.parseFloat(stringArray[3]);
        float f5 = 1.0f;
        if (stringArray.length > 4) {
            f5 = Float.parseFloat(stringArray[4]);
        }
        return new Color(f2, f3, f4, f5);
    }

    public ModelMaterial getMaterial(String string) {
        for (ModelMaterial modelMaterial : this.materials) {
            if (!modelMaterial.id.equals(string)) continue;
            return modelMaterial;
        }
        ModelMaterial modelMaterial = new ModelMaterial();
        new ModelMaterial().id = string;
        modelMaterial.diffuse = new Color(Color.WHITE);
        this.materials.add(modelMaterial);
        return modelMaterial;
    }
}

