/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$Channel;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$ChannelDescriptor;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$ChannelInitializer;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$IntChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$ObjectChannel;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class ParallelArray {
    Array<ParallelArray$Channel> arrays = new Array(false, 2, ParallelArray$Channel.class);
    public int capacity;
    public int size;

    public ParallelArray(int n2) {
        this.capacity = n2;
        this.size = 0;
    }

    public <T extends ParallelArray$Channel> T addChannel(ParallelArray$ChannelDescriptor parallelArray$ChannelDescriptor) {
        return this.addChannel(parallelArray$ChannelDescriptor, null);
    }

    public <T extends ParallelArray$Channel> T addChannel(ParallelArray$ChannelDescriptor parallelArray$ChannelDescriptor, ParallelArray$ChannelInitializer<T> parallelArray$ChannelInitializer) {
        T t2 = this.getChannel(parallelArray$ChannelDescriptor);
        if (t2 == null) {
            t2 = this.allocateChannel(parallelArray$ChannelDescriptor);
            if (parallelArray$ChannelInitializer != null) {
                parallelArray$ChannelInitializer.init(t2);
            }
            this.arrays.add((ParallelArray$Channel)t2);
        }
        return t2;
    }

    private <T extends ParallelArray$Channel> T allocateChannel(ParallelArray$ChannelDescriptor parallelArray$ChannelDescriptor) {
        if (parallelArray$ChannelDescriptor.type == Float.TYPE) {
            return (T)new ParallelArray$FloatChannel(this, parallelArray$ChannelDescriptor.id, parallelArray$ChannelDescriptor.count, this.capacity);
        }
        if (parallelArray$ChannelDescriptor.type == Integer.TYPE) {
            return (T)new ParallelArray$IntChannel(this, parallelArray$ChannelDescriptor.id, parallelArray$ChannelDescriptor.count, this.capacity);
        }
        return (T)new ParallelArray$ObjectChannel(this, parallelArray$ChannelDescriptor.id, parallelArray$ChannelDescriptor.count, this.capacity, parallelArray$ChannelDescriptor.type);
    }

    public <T> void removeArray(int n2) {
        this.arrays.removeIndex(this.findIndex(n2));
    }

    private int findIndex(int n2) {
        for (int i2 = 0; i2 < this.arrays.size; ++i2) {
            ParallelArray$Channel parallelArray$Channel = ((ParallelArray$Channel[])this.arrays.items)[i2];
            if (parallelArray$Channel.id != n2) continue;
            return i2;
        }
        return -1;
    }

    public void addElement(Object ... objectArray) {
        if (this.size == this.capacity) {
            throw new GdxRuntimeException("Capacity reached, cannot add other elements");
        }
        int n2 = 0;
        for (ParallelArray$Channel parallelArray$Channel : this.arrays) {
            parallelArray$Channel.add(n2, objectArray);
            n2 += parallelArray$Channel.strideSize;
        }
        ++this.size;
    }

    public void removeElement(int n2) {
        int n3 = this.size - 1;
        for (ParallelArray$Channel parallelArray$Channel : this.arrays) {
            parallelArray$Channel.swap(n2, n3);
        }
        this.size = n3;
    }

    public <T extends ParallelArray$Channel> T getChannel(ParallelArray$ChannelDescriptor parallelArray$ChannelDescriptor) {
        for (ParallelArray$Channel parallelArray$Channel : this.arrays) {
            if (parallelArray$Channel.id != parallelArray$ChannelDescriptor.id) continue;
            return (T)parallelArray$Channel;
        }
        return null;
    }

    public void clear() {
        this.arrays.clear();
        this.size = 0;
    }

    public void setCapacity(int n2) {
        if (this.capacity != n2) {
            for (ParallelArray$Channel parallelArray$Channel : this.arrays) {
                parallelArray$Channel.setCapacity(n2);
            }
            this.capacity = n2;
        }
    }
}

