/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.RenderableProvider;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.g3d.particles.batches.ParticleBatch;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public final class ParticleSystem
implements RenderableProvider {
    private static ParticleSystem instance;
    private Array<ParticleBatch<?>> batches = new Array();
    private Array<ParticleEffect> effects = new Array();

    @Deprecated
    public static ParticleSystem get() {
        if (instance == null) {
            instance = new ParticleSystem();
        }
        return instance;
    }

    public final void add(ParticleBatch<?> particleBatch) {
        this.batches.add(particleBatch);
    }

    public final void add(ParticleEffect particleEffect) {
        this.effects.add(particleEffect);
    }

    public final void remove(ParticleEffect particleEffect) {
        this.effects.removeValue(particleEffect, true);
    }

    public final void removeAll() {
        this.effects.clear();
    }

    public final void update() {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update();
        }
    }

    public final void updateAndDraw() {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update();
            particleEffect.draw();
        }
    }

    public final void update(float f2) {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update(f2);
        }
    }

    public final void updateAndDraw(float f2) {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.update(f2);
            particleEffect.draw();
        }
    }

    public final void begin() {
        for (ParticleBatch particleBatch : this.batches) {
            particleBatch.begin();
        }
    }

    public final void draw() {
        for (ParticleEffect particleEffect : this.effects) {
            particleEffect.draw();
        }
    }

    public final void end() {
        for (ParticleBatch particleBatch : this.batches) {
            particleBatch.end();
        }
    }

    @Override
    public final void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        for (ParticleBatch particleBatch : this.batches) {
            particleBatch.getRenderables(array, pool);
        }
    }

    public final Array<ParticleBatch<?>> getBatches() {
        return this.batches;
    }
}

