/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$AssetData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.Json$Serializable;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;

public class ResourceData<T>
implements Json$Serializable {
    private ObjectMap<String, ResourceData$SaveData> uniqueData = new ObjectMap();
    private Array<ResourceData$SaveData> data = new Array(true, 3, ResourceData$SaveData.class);
    Array<ResourceData$AssetData> sharedAssets = new Array();
    private int currentLoadIndex = 0;
    public T resource;

    public ResourceData() {
    }

    public ResourceData(T t2) {
        this();
        this.resource = t2;
    }

    <K> int getAssetData(String string, Class<K> clazz) {
        int n2 = 0;
        for (ResourceData$AssetData resourceData$AssetData : this.sharedAssets) {
            if (resourceData$AssetData.filename.equals(string) && resourceData$AssetData.type.equals(clazz)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Array<AssetDescriptor> getAssetDescriptors() {
        Array<AssetDescriptor> array = new Array<AssetDescriptor>();
        for (ResourceData$AssetData resourceData$AssetData : this.sharedAssets) {
            array.add(new AssetDescriptor(resourceData$AssetData.filename, resourceData$AssetData.type));
        }
        return array;
    }

    public Array<ResourceData$AssetData> getAssets() {
        return this.sharedAssets;
    }

    public ResourceData$SaveData createSaveData() {
        ResourceData$SaveData resourceData$SaveData = new ResourceData$SaveData(this);
        this.data.add(resourceData$SaveData);
        return resourceData$SaveData;
    }

    public ResourceData$SaveData createSaveData(String string) {
        ResourceData$SaveData resourceData$SaveData = new ResourceData$SaveData(this);
        if (this.uniqueData.containsKey(string)) {
            throw new RuntimeException("Key already used, data must be unique, use a different key");
        }
        this.uniqueData.put(string, resourceData$SaveData);
        return resourceData$SaveData;
    }

    public ResourceData$SaveData getSaveData() {
        return this.data.get(this.currentLoadIndex++);
    }

    public ResourceData$SaveData getSaveData(String string) {
        return this.uniqueData.get(string);
    }

    @Override
    public void write(Json json) {
        json.writeValue("unique", this.uniqueData, ObjectMap.class);
        json.writeValue("data", this.data, Array.class, ResourceData$SaveData.class);
        json.writeValue("assets", this.sharedAssets.toArray(ResourceData$AssetData.class), ResourceData$AssetData[].class);
        json.writeValue("resource", this.resource, null);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.uniqueData = json.readValue("unique", ObjectMap.class, jsonValue);
        for (ObjectMap$Entry object : this.uniqueData.entries()) {
            ((ResourceData$SaveData)((ObjectMap$Entry)var3_3.next()).value).resources = this;
        }
        this.data = json.readValue("data", Array.class, ResourceData$SaveData.class, jsonValue);
        for (ResourceData$SaveData resourceData$SaveData : this.data) {
            ((ResourceData$SaveData)var3_3.next()).resources = this;
        }
        this.sharedAssets.addAll(json.readValue("assets", Array.class, ResourceData$AssetData.class, jsonValue));
        this.resource = json.readValue("resource", null, jsonValue);
    }
}

