/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.batches;

import com.badlogic.gdx.Application$ApplicationType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Material;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$Config;
import com.badlogic.gdx.graphics.g3d.particles.ParticleShader$ParticleType;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.batches.BufferedParticleBatch;
import com.badlogic.gdx.graphics.g3d.particles.renderers.PointSpriteControllerRenderData;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;

public class PointSpriteParticleBatch
extends BufferedParticleBatch<PointSpriteControllerRenderData> {
    private static boolean pointSpritesEnabled = false;
    protected static final Vector3 TMP_V1 = new Vector3();
    protected static final int sizeAndRotationUsage = 512;
    protected static final VertexAttributes CPU_ATTRIBUTES = new VertexAttributes(new VertexAttribute(1, 3, "a_position"), new VertexAttribute(2, 4, "a_color"), new VertexAttribute(16, 4, "a_region"), new VertexAttribute(512, 3, "a_sizeAndRotation"));
    protected static final int CPU_VERTEX_SIZE = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.vertexSize / 4);
    protected static final int CPU_POSITION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)1).offset / 4);
    protected static final int CPU_COLOR_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)2).offset / 4);
    protected static final int CPU_REGION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)16).offset / 4);
    protected static final int CPU_SIZE_AND_ROTATION_OFFSET = (short)(PointSpriteParticleBatch.CPU_ATTRIBUTES.findByUsage((int)512).offset / 4);
    private float[] vertices;
    Renderable renderable;
    protected BlendingAttribute blendingAttribute;
    protected DepthTestAttribute depthTestAttribute;

    private static void enablePointSprites() {
        Gdx.gl.glEnable(34370);
        if (Gdx.app.getType() == Application$ApplicationType.Desktop) {
            Gdx.gl.glEnable(34913);
        }
        pointSpritesEnabled = true;
    }

    public PointSpriteParticleBatch() {
        this(1000);
    }

    public PointSpriteParticleBatch(int n2) {
        this(n2, new ParticleShader$Config(ParticleShader$ParticleType.Point));
    }

    public PointSpriteParticleBatch(int n2, ParticleShader$Config particleShader$Config) {
        this(n2, particleShader$Config, null, null);
    }

    public PointSpriteParticleBatch(int n2, ParticleShader$Config particleShader$Config, BlendingAttribute blendingAttribute, DepthTestAttribute depthTestAttribute) {
        super(PointSpriteControllerRenderData.class);
        if (!pointSpritesEnabled) {
            PointSpriteParticleBatch.enablePointSprites();
        }
        this.blendingAttribute = blendingAttribute;
        this.depthTestAttribute = depthTestAttribute;
        if (this.blendingAttribute == null) {
            this.blendingAttribute = new BlendingAttribute(1, 771, 1.0f);
        }
        if (this.depthTestAttribute == null) {
            this.depthTestAttribute = new DepthTestAttribute(515, false);
        }
        this.allocRenderable();
        this.ensureCapacity(n2);
        this.renderable.shader = new ParticleShader(this.renderable, particleShader$Config);
        this.renderable.shader.init();
    }

    @Override
    protected void allocParticlesData(int n2) {
        this.vertices = new float[n2 * CPU_VERTEX_SIZE];
        if (this.renderable.meshPart.mesh != null) {
            this.renderable.meshPart.mesh.dispose();
        }
        this.renderable.meshPart.mesh = new Mesh(false, n2, 0, CPU_ATTRIBUTES);
    }

    protected void allocRenderable() {
        this.renderable = new Renderable();
        this.renderable.meshPart.primitiveType = 0;
        this.renderable.meshPart.offset = 0;
        this.renderable.material = new Material(this.blendingAttribute, this.depthTestAttribute, TextureAttribute.createDiffuse(null));
    }

    public void setTexture(Texture texture) {
        TextureAttribute textureAttribute = (TextureAttribute)this.renderable.material.get(TextureAttribute.Diffuse);
        ((TextureAttribute)this.renderable.material.get(TextureAttribute.Diffuse)).textureDescription.texture = texture;
    }

    public Texture getTexture() {
        TextureAttribute textureAttribute = (TextureAttribute)this.renderable.material.get(TextureAttribute.Diffuse);
        return (Texture)textureAttribute.textureDescription.texture;
    }

    public BlendingAttribute getBlendingAttribute() {
        return this.blendingAttribute;
    }

    @Override
    protected void flush(int[] nArray) {
        int n2 = 0;
        for (PointSpriteControllerRenderData pointSpriteControllerRenderData : this.renderData) {
            ParallelArray$FloatChannel parallelArray$FloatChannel = pointSpriteControllerRenderData.scaleChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel2 = pointSpriteControllerRenderData.regionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel3 = pointSpriteControllerRenderData.positionChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel4 = pointSpriteControllerRenderData.colorChannel;
            ParallelArray$FloatChannel parallelArray$FloatChannel5 = pointSpriteControllerRenderData.rotationChannel;
            int n3 = 0;
            while (n3 < pointSpriteControllerRenderData.controller.particles.size) {
                int n4 = nArray[n2] * CPU_VERTEX_SIZE;
                int n5 = n3 * parallelArray$FloatChannel2.strideSize;
                int n6 = n3 * parallelArray$FloatChannel3.strideSize;
                int n7 = n3 * parallelArray$FloatChannel4.strideSize;
                int n8 = n3 * parallelArray$FloatChannel5.strideSize;
                this.vertices[n4 + PointSpriteParticleBatch.CPU_POSITION_OFFSET] = parallelArray$FloatChannel3.data[n6];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_POSITION_OFFSET + 1] = parallelArray$FloatChannel3.data[n6 + 1];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_POSITION_OFFSET + 2] = parallelArray$FloatChannel3.data[n6 + 2];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_COLOR_OFFSET] = parallelArray$FloatChannel4.data[n7];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_COLOR_OFFSET + 1] = parallelArray$FloatChannel4.data[n7 + 1];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_COLOR_OFFSET + 2] = parallelArray$FloatChannel4.data[n7 + 2];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_COLOR_OFFSET + 3] = parallelArray$FloatChannel4.data[n7 + 3];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET] = parallelArray$FloatChannel.data[n3 * parallelArray$FloatChannel.strideSize];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET + 1] = parallelArray$FloatChannel5.data[n8];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_SIZE_AND_ROTATION_OFFSET + 2] = parallelArray$FloatChannel5.data[n8 + 1];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_REGION_OFFSET] = parallelArray$FloatChannel2.data[n5];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_REGION_OFFSET + 1] = parallelArray$FloatChannel2.data[n5 + 1];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_REGION_OFFSET + 2] = parallelArray$FloatChannel2.data[n5 + 2];
                this.vertices[n4 + PointSpriteParticleBatch.CPU_REGION_OFFSET + 3] = parallelArray$FloatChannel2.data[n5 + 3];
                ++n3;
                ++n2;
            }
        }
        this.renderable.meshPart.size = this.bufferedParticlesCount;
        this.renderable.meshPart.mesh.setVertices(this.vertices, 0, this.bufferedParticlesCount * CPU_VERTEX_SIZE);
        this.renderable.meshPart.update();
    }

    @Override
    public void getRenderables(Array<Renderable> array, Pool<Renderable> pool) {
        if (this.bufferedParticlesCount > 0) {
            array.add(pool.obtain().set(this.renderable));
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData json$Serializable) {
        json$Serializable = json$Serializable.createSaveData("pointSpriteBatch");
        ((ResourceData$SaveData)json$Serializable).saveAsset(assetManager.getAssetFileName(this.getTexture()), Texture.class);
    }

    @Override
    public void load(AssetManager assetManager, ResourceData json$Serializable) {
        if ((json$Serializable = ((ResourceData)json$Serializable).getSaveData("pointSpriteBatch")) != null) {
            this.setTexture((Texture)assetManager.get(((ResourceData$SaveData)json$Serializable).loadAsset()));
        }
    }
}

