/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.ColorInfluencer;
import com.badlogic.gdx.graphics.g3d.particles.values.GradientColorValue;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class ColorInfluencer$Single
extends ColorInfluencer {
    ParallelArray$FloatChannel alphaInterpolationChannel;
    ParallelArray$FloatChannel lifeChannel;
    public ScaledNumericValue alphaValue;
    public GradientColorValue colorValue = new GradientColorValue();

    public ColorInfluencer$Single() {
        this.alphaValue = new ScaledNumericValue();
        this.alphaValue.setHigh(1.0f);
    }

    public ColorInfluencer$Single(ColorInfluencer$Single colorInfluencer$Single) {
        this();
        this.set(colorInfluencer$Single);
    }

    public void set(ColorInfluencer$Single colorInfluencer$Single) {
        this.colorValue.load(colorInfluencer$Single.colorValue);
        this.alphaValue.load(colorInfluencer$Single.alphaValue);
    }

    @Override
    public void allocateChannels() {
        super.allocateChannels();
        ParticleChannels.Interpolation.id = this.controller.particleChannels.newId();
        this.alphaInterpolationChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation);
        this.lifeChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.Life);
    }

    @Override
    public void activateParticles(int n2, int n3) {
        int n4 = n2 * this.colorChannel.strideSize;
        int n5 = n2 * this.alphaInterpolationChannel.strideSize;
        n2 = n2 * this.lifeChannel.strideSize + 2;
        n3 = n4 + n3 * this.colorChannel.strideSize;
        while (n4 < n3) {
            float f2 = this.alphaValue.newLowValue();
            float f3 = this.alphaValue.newHighValue() - f2;
            this.colorValue.getColor(0.0f, this.colorChannel.data, n4);
            this.colorChannel.data[n4 + 3] = f2 + f3 * this.alphaValue.getScale(this.lifeChannel.data[n2]);
            this.alphaInterpolationChannel.data[n5] = f2;
            this.alphaInterpolationChannel.data[n5 + 1] = f3;
            n4 += this.colorChannel.strideSize;
            n5 += this.alphaInterpolationChannel.strideSize;
            n2 += this.lifeChannel.strideSize;
        }
    }

    @Override
    public void update() {
        int n2 = 0;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0 + this.controller.particles.size * this.colorChannel.strideSize;
        while (n2 < n5) {
            float f2 = this.lifeChannel.data[n4];
            this.colorValue.getColor(f2, this.colorChannel.data, n2);
            this.colorChannel.data[n2 + 3] = this.alphaInterpolationChannel.data[n3] + this.alphaInterpolationChannel.data[n3 + 1] * this.alphaValue.getScale(f2);
            n2 += this.colorChannel.strideSize;
            n3 += this.alphaInterpolationChannel.strideSize;
            n4 += this.lifeChannel.strideSize;
        }
    }

    @Override
    public ColorInfluencer$Single copy() {
        return new ColorInfluencer$Single(this);
    }

    @Override
    public void write(Json json) {
        json.writeValue("alpha", this.alphaValue);
        json.writeValue("color", this.colorValue);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        this.alphaValue = json.readValue("alpha", ScaledNumericValue.class, jsonValue);
        this.colorValue = json.readValue("color", GradientColorValue.class, jsonValue);
    }
}

