/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$FloatChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.influencers.DynamicsModifier$Strength;
import com.badlogic.gdx.graphics.g3d.particles.values.ScaledNumericValue;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public abstract class DynamicsModifier$Angular
extends DynamicsModifier$Strength {
    protected ParallelArray$FloatChannel angularChannel;
    public ScaledNumericValue thetaValue = new ScaledNumericValue();
    public ScaledNumericValue phiValue = new ScaledNumericValue();

    public DynamicsModifier$Angular() {
    }

    public DynamicsModifier$Angular(DynamicsModifier$Angular dynamicsModifier$Angular) {
        super(dynamicsModifier$Angular);
        this.thetaValue.load(dynamicsModifier$Angular.thetaValue);
        this.phiValue.load(dynamicsModifier$Angular.phiValue);
    }

    @Override
    public void allocateChannels() {
        super.allocateChannels();
        ParticleChannels.Interpolation4.id = this.controller.particleChannels.newId();
        this.angularChannel = (ParallelArray$FloatChannel)this.controller.particles.addChannel(ParticleChannels.Interpolation4);
    }

    @Override
    public void activateParticles(int n2, int n3) {
        int n4;
        super.activateParticles(n2, n3);
        int n5 = n4 + n3 * this.angularChannel.strideSize;
        for (n4 = n2 * this.angularChannel.strideSize; n4 < n5; n4 += this.angularChannel.strideSize) {
            float f2 = this.thetaValue.newLowValue();
            float f3 = this.thetaValue.newHighValue();
            if (!this.thetaValue.isRelative()) {
                f3 -= f2;
            }
            this.angularChannel.data[n4] = f2;
            this.angularChannel.data[n4 + 1] = f3;
            f2 = this.phiValue.newLowValue();
            f3 = this.phiValue.newHighValue();
            if (!this.phiValue.isRelative()) {
                f3 -= f2;
            }
            this.angularChannel.data[n4 + 2] = f2;
            this.angularChannel.data[n4 + 3] = f3;
        }
    }

    @Override
    public void write(Json json) {
        super.write(json);
        json.writeValue("thetaValue", this.thetaValue);
        json.writeValue("phiValue", this.phiValue);
    }

    @Override
    public void read(Json json, JsonValue jsonValue) {
        super.read(json, jsonValue);
        this.thetaValue = json.readValue("thetaValue", ScaledNumericValue.class, jsonValue);
        this.phiValue = json.readValue("phiValue", ScaledNumericValue.class, jsonValue);
    }
}

