/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$ObjectChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.Array;

public abstract class ModelInfluencer
extends Influencer {
    public Array<Model> models;
    ParallelArray$ObjectChannel<ModelInstance> modelChannel;

    public ModelInfluencer() {
        this.models = new Array(true, 1, Model.class);
    }

    public ModelInfluencer(Model ... modelArray) {
        this.models = new Array<Model>(modelArray);
    }

    public ModelInfluencer(ModelInfluencer modelInfluencer) {
        this(modelInfluencer.models.toArray(Model.class));
    }

    @Override
    public void allocateChannels() {
        this.modelChannel = (ParallelArray$ObjectChannel)this.controller.particles.addChannel(ParticleChannels.ModelInstance);
    }

    @Override
    public void save(AssetManager assetManager, ResourceData json$Serializable) {
        json$Serializable = ((ResourceData)json$Serializable).createSaveData();
        for (Model model : this.models) {
            ((ResourceData$SaveData)json$Serializable).saveAsset(assetManager.getAssetFileName(model), Model.class);
        }
    }

    @Override
    public void load(AssetManager assetManager, ResourceData json$Serializable) {
        Object object;
        json$Serializable = ((ResourceData)json$Serializable).getSaveData();
        while ((object = ((ResourceData$SaveData)json$Serializable).loadAsset()) != null) {
            if ((object = (Model)assetManager.get(object)) == null) {
                throw new RuntimeException("Model is null");
            }
            this.models.add((Model)object);
        }
    }
}

