/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.g3d.particles.ParallelArray$ObjectChannel;
import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleController;
import com.badlogic.gdx.graphics.g3d.particles.ParticleEffect;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.influencers.Influencer;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntArray;
import java.util.Iterator;

public abstract class ParticleControllerInfluencer
extends Influencer {
    public Array<ParticleController> templates;
    ParallelArray$ObjectChannel<ParticleController> particleControllerChannel;

    public ParticleControllerInfluencer() {
        this.templates = new Array(true, 1, ParticleController.class);
    }

    public ParticleControllerInfluencer(ParticleController ... particleControllerArray) {
        this.templates = new Array<ParticleController>(particleControllerArray);
    }

    public ParticleControllerInfluencer(ParticleControllerInfluencer particleControllerInfluencer) {
        this((ParticleController[])particleControllerInfluencer.templates.items);
    }

    @Override
    public void allocateChannels() {
        this.particleControllerChannel = (ParallelArray$ObjectChannel)this.controller.particles.addChannel(ParticleChannels.ParticleController);
    }

    @Override
    public void end() {
        for (int i2 = 0; i2 < this.controller.particles.size; ++i2) {
            ((ParticleController[])this.particleControllerChannel.data)[i2].end();
        }
    }

    @Override
    public void dispose() {
        if (this.controller != null) {
            for (int i2 = 0; i2 < this.controller.particles.size; ++i2) {
                ParticleController particleController = ((ParticleController[])this.particleControllerChannel.data)[i2];
                if (particleController == null) continue;
                particleController.dispose();
                ((ParticleController[])this.particleControllerChannel.data)[i2] = null;
            }
        }
    }

    @Override
    public void save(AssetManager assetManager, ResourceData json$Serializable) {
        json$Serializable = ((ResourceData)json$Serializable).createSaveData();
        Array<ParticleEffect> array = assetManager.getAll(ParticleEffect.class, new Array());
        Array<ParticleController> array2 = new Array<ParticleController>(this.templates);
        Array<IntArray> array3 = new Array<IntArray>();
        for (int i2 = 0; i2 < array.size && array2.size > 0; ++i2) {
            ParticleEffect particleEffect = array.get(i2);
            Array<ParticleController> array4 = particleEffect.getControllers();
            Iterator iterator = array2.iterator();
            IntArray intArray = null;
            while (iterator.hasNext()) {
                ParticleController particleController = (ParticleController)iterator.next();
                int n2 = array4.indexOf(particleController, true);
                if (n2 < 0) continue;
                if (intArray == null) {
                    intArray = new IntArray();
                }
                iterator.remove();
                intArray.add(n2);
            }
            if (intArray == null) continue;
            ((ResourceData$SaveData)json$Serializable).saveAsset(assetManager.getAssetFileName(particleEffect), ParticleEffect.class);
            array3.add(intArray);
        }
        ((ResourceData$SaveData)json$Serializable).save("indices", array3);
    }

    @Override
    public void load(AssetManager assetManager, ResourceData json$Serializable) {
        json$Serializable = ((ResourceData)json$Serializable).getSaveData();
        Array<ParticleController> array = (Array)((ResourceData$SaveData)json$Serializable).load("indices");
        Iterator iterator = array.iterator();
        while ((array = ((ResourceData$SaveData)json$Serializable).loadAsset()) != null) {
            if ((array = (ParticleEffect)assetManager.get(array)) == null) {
                throw new RuntimeException("Template is null");
            }
            array = ((ParticleEffect)((Object)array)).getControllers();
            IntArray intArray = (IntArray)iterator.next();
            int n2 = intArray.size;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.templates.add(array.get(intArray.get(i2)));
            }
        }
    }
}

