/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.influencers;

import com.badlogic.gdx.graphics.g3d.particles.ParticleChannels;
import com.badlogic.gdx.graphics.g3d.particles.ParticleControllerComponent;
import com.badlogic.gdx.graphics.g3d.particles.influencers.SimpleInfluencer;

public class ScaleInfluencer
extends SimpleInfluencer {
    public ScaleInfluencer() {
        this.valueChannelDescriptor = ParticleChannels.Scale;
    }

    @Override
    public void activateParticles(int n2, int n3) {
        if (this.value.isRelative()) {
            int n4 = n2 * this.valueChannel.strideSize;
            n2 *= this.interpolationChannel.strideSize;
            n3 = n4 + n3 * this.valueChannel.strideSize;
            while (n4 < n3) {
                float f2 = this.value.newLowValue() * this.controller.scale.x;
                float f3 = this.value.newHighValue() * this.controller.scale.x;
                this.interpolationChannel.data[n2] = f2;
                this.interpolationChannel.data[n2 + 1] = f3;
                this.valueChannel.data[n4] = f2 + f3 * this.value.getScale(0.0f);
                n4 += this.valueChannel.strideSize;
                n2 += this.interpolationChannel.strideSize;
            }
            return;
        }
        int n5 = n2 * this.valueChannel.strideSize;
        n2 *= this.interpolationChannel.strideSize;
        n3 = n5 + n3 * this.valueChannel.strideSize;
        while (n5 < n3) {
            float f4 = this.value.newLowValue() * this.controller.scale.x;
            float f5 = this.value.newHighValue() * this.controller.scale.x - f4;
            this.interpolationChannel.data[n2] = f4;
            this.interpolationChannel.data[n2 + 1] = f5;
            this.valueChannel.data[n5] = f4 + f5 * this.value.getScale(0.0f);
            n5 += this.valueChannel.strideSize;
            n2 += this.interpolationChannel.strideSize;
        }
    }

    public ScaleInfluencer(ScaleInfluencer scaleInfluencer) {
        super(scaleInfluencer);
    }

    @Override
    public ParticleControllerComponent copy() {
        return new ScaleInfluencer(this);
    }
}

