/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.particles.values;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.g3d.Model;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData;
import com.badlogic.gdx.graphics.g3d.particles.ResourceData$SaveData;
import com.badlogic.gdx.graphics.g3d.particles.values.ParticleValue;
import com.badlogic.gdx.graphics.g3d.particles.values.SpawnShapeValue;
import com.badlogic.gdx.utils.GdxRuntimeException;

public abstract class MeshSpawnShapeValue
extends SpawnShapeValue {
    protected Mesh mesh;
    protected Model model;

    public MeshSpawnShapeValue(MeshSpawnShapeValue meshSpawnShapeValue) {
        super(meshSpawnShapeValue);
    }

    public MeshSpawnShapeValue() {
    }

    @Override
    public void load(ParticleValue particleValue) {
        super.load(particleValue);
        particleValue = (MeshSpawnShapeValue)particleValue;
        this.setMesh(((MeshSpawnShapeValue)particleValue).mesh, ((MeshSpawnShapeValue)particleValue).model);
    }

    public void setMesh(Mesh mesh, Model model) {
        if (mesh.getVertexAttribute(1) == null) {
            throw new GdxRuntimeException("Mesh vertices must have Usage.Position");
        }
        this.model = model;
        this.mesh = mesh;
    }

    public void setMesh(Mesh mesh) {
        this.setMesh(mesh, null);
    }

    @Override
    public void save(AssetManager assetManager, ResourceData json$Serializable) {
        if (this.model != null) {
            json$Serializable = ((ResourceData)json$Serializable).createSaveData();
            ((ResourceData$SaveData)json$Serializable).saveAsset(assetManager.getAssetFileName(this.model), Model.class);
            ((ResourceData$SaveData)json$Serializable).save("index", this.model.meshes.indexOf(this.mesh, true));
        }
    }

    @Override
    public void load(AssetManager disposable, ResourceData json$Serializable) {
        AssetDescriptor assetDescriptor = ((ResourceData$SaveData)(json$Serializable = ((ResourceData)json$Serializable).getSaveData())).loadAsset();
        if (assetDescriptor != null) {
            disposable = (Model)disposable.get(assetDescriptor);
            this.setMesh(((Model)disposable).meshes.get((Integer)((ResourceData$SaveData)json$Serializable).load("index")), (Model)disposable);
        }
    }
}

