/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.VertexAttributes;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader$Setter;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader$Uniform;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader$Validator;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.g3d.utils.TextureDescriptor;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntIntMap;

public abstract class BaseShader
implements Shader {
    private final Array<String> uniforms = new Array();
    private final Array<BaseShader$Validator> validators = new Array();
    private final Array<BaseShader$Setter> setters = new Array();
    private int[] locations;
    private final IntArray globalUniforms = new IntArray();
    private final IntArray localUniforms = new IntArray();
    private final IntIntMap attributes = new IntIntMap();
    private final IntIntMap instancedAttributes = new IntIntMap();
    public ShaderProgram program;
    public RenderContext context;
    public Camera camera;
    private Mesh currentMesh;
    private final IntArray tempArray = new IntArray();
    private final IntArray tempArray2 = new IntArray();
    private Attributes combinedAttributes = new Attributes();

    public int register(String string, BaseShader$Validator baseShader$Validator, BaseShader$Setter baseShader$Setter) {
        if (this.locations != null) {
            throw new GdxRuntimeException("Cannot register an uniform after initialization");
        }
        int n2 = this.getUniformID(string);
        if (n2 >= 0) {
            this.validators.set(n2, baseShader$Validator);
            this.setters.set(n2, baseShader$Setter);
            return n2;
        }
        this.uniforms.add(string);
        this.validators.add(baseShader$Validator);
        this.setters.add(baseShader$Setter);
        return this.uniforms.size - 1;
    }

    public int register(String string, BaseShader$Validator baseShader$Validator) {
        return this.register(string, baseShader$Validator, null);
    }

    public int register(String string, BaseShader$Setter baseShader$Setter) {
        return this.register(string, null, baseShader$Setter);
    }

    public int register(String string) {
        return this.register(string, null, null);
    }

    public int register(BaseShader$Uniform baseShader$Uniform, BaseShader$Setter baseShader$Setter) {
        return this.register(baseShader$Uniform.alias, baseShader$Uniform, baseShader$Setter);
    }

    public int register(BaseShader$Uniform baseShader$Uniform) {
        return this.register(baseShader$Uniform, null);
    }

    public int getUniformID(String string) {
        int n2 = this.uniforms.size;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!this.uniforms.get(i2).equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public String getUniformAlias(int n2) {
        return this.uniforms.get(n2);
    }

    public void init(ShaderProgram shaderProgram, Renderable object) {
        Object object2;
        if (this.locations != null) {
            throw new GdxRuntimeException("Already initialized");
        }
        if (!shaderProgram.isCompiled()) {
            throw new GdxRuntimeException(shaderProgram.getLog());
        }
        this.program = shaderProgram;
        int n2 = this.uniforms.size;
        this.locations = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.uniforms.get(i2);
            BaseShader$Validator baseShader$Validator = this.validators.get(i2);
            object2 = this.setters.get(i2);
            if (baseShader$Validator != null && !baseShader$Validator.validate(this, i2, (Renderable)object)) {
                this.locations[i2] = -1;
            } else {
                this.locations[i2] = shaderProgram.fetchUniformLocation(string, false);
                if (this.locations[i2] >= 0 && object2 != null) {
                    if (object2.isGlobal(this, i2)) {
                        this.globalUniforms.add(i2);
                    } else {
                        this.localUniforms.add(i2);
                    }
                }
            }
            if (this.locations[i2] >= 0) continue;
            this.validators.set(i2, null);
            this.setters.set(i2, null);
        }
        if (object != null) {
            VertexAttributes vertexAttributes = ((Renderable)object).meshPart.mesh.getVertexAttributes();
            int n3 = vertexAttributes.size();
            for (int i3 = 0; i3 < n3; ++i3) {
                object2 = vertexAttributes.get(i3);
                n2 = shaderProgram.getAttributeLocation(((VertexAttribute)object2).alias);
                if (n2 < 0) continue;
                this.attributes.put(((VertexAttribute)object2).getKey(), n2);
            }
            VertexAttributes vertexAttributes2 = ((Renderable)object).meshPart.mesh.getInstancedAttributes();
            if (vertexAttributes2 != null) {
                int n4 = vertexAttributes2.size();
                for (n2 = 0; n2 < n4; ++n2) {
                    object = vertexAttributes2.get(n2);
                    int n5 = shaderProgram.getAttributeLocation(((VertexAttribute)object).alias);
                    if (n5 < 0) continue;
                    this.instancedAttributes.put(((VertexAttribute)object).getKey(), n5);
                }
            }
        }
    }

    @Override
    public void begin(Camera camera, RenderContext renderContext) {
        this.camera = camera;
        this.context = renderContext;
        this.program.bind();
        this.currentMesh = null;
        for (int i2 = 0; i2 < this.globalUniforms.size; ++i2) {
            int n2 = this.globalUniforms.get(i2);
            if (this.setters.get(n2) == null) continue;
            this.setters.get(n2).set(this, n2, null, null);
        }
    }

    private final int[] getAttributeLocations(VertexAttributes vertexAttributes) {
        this.tempArray.clear();
        int n2 = vertexAttributes.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tempArray.add(this.attributes.get(vertexAttributes.get(i2).getKey(), -1));
        }
        this.tempArray.shrink();
        return this.tempArray.items;
    }

    private final int[] getInstancedAttributeLocations(VertexAttributes vertexAttributes) {
        if (vertexAttributes == null) {
            return null;
        }
        this.tempArray2.clear();
        int n2 = vertexAttributes.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.tempArray2.add(this.instancedAttributes.get(vertexAttributes.get(i2).getKey(), -1));
        }
        this.tempArray2.shrink();
        return this.tempArray2.items;
    }

    @Override
    public void render(Renderable renderable) {
        if (renderable.worldTransform.det3x3() == 0.0f) {
            return;
        }
        this.combinedAttributes.clear();
        if (renderable.environment != null) {
            this.combinedAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            this.combinedAttributes.set(renderable.material);
        }
        this.render(renderable, this.combinedAttributes);
    }

    public void render(Renderable renderable, Attributes attributes) {
        for (int i2 = 0; i2 < this.localUniforms.size; ++i2) {
            int n2 = this.localUniforms.get(i2);
            if (this.setters.get(n2) == null) continue;
            this.setters.get(n2).set(this, n2, renderable, attributes);
        }
        if (this.currentMesh != renderable.meshPart.mesh) {
            if (this.currentMesh != null) {
                this.currentMesh.unbind(this.program, this.tempArray.items, this.tempArray2.items);
            }
            this.currentMesh = renderable.meshPart.mesh;
            this.currentMesh.bind(this.program, this.getAttributeLocations(renderable.meshPart.mesh.getVertexAttributes()), this.getInstancedAttributeLocations(renderable.meshPart.mesh.getInstancedAttributes()));
        }
        renderable.meshPart.render(this.program, false);
    }

    @Override
    public void end() {
        if (this.currentMesh != null) {
            this.currentMesh.unbind(this.program, this.tempArray.items, this.tempArray2.items);
            this.currentMesh = null;
        }
    }

    @Override
    public void dispose() {
        this.program = null;
        this.uniforms.clear();
        this.validators.clear();
        this.setters.clear();
        this.localUniforms.clear();
        this.globalUniforms.clear();
        this.locations = null;
    }

    public final boolean has(int n2) {
        return n2 >= 0 && n2 < this.locations.length && this.locations[n2] >= 0;
    }

    public final int loc(int n2) {
        if (n2 >= 0 && n2 < this.locations.length) {
            return this.locations[n2];
        }
        return -1;
    }

    public final boolean set(int n2, Matrix4 matrix4) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformMatrix(this.locations[n2], matrix4);
        return true;
    }

    public final boolean set(int n2, Matrix3 matrix3) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformMatrix(this.locations[n2], matrix3);
        return true;
    }

    public final boolean set(int n2, Vector3 vector3) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], vector3);
        return true;
    }

    public final boolean set(int n2, Vector2 vector2) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], vector2);
        return true;
    }

    public final boolean set(int n2, Color color) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], color);
        return true;
    }

    public final boolean set(int n2, float f2) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], f2);
        return true;
    }

    public final boolean set(int n2, float f2, float f3) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], f2, f3);
        return true;
    }

    public final boolean set(int n2, float f2, float f3, float f4) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], f2, f3, f4);
        return true;
    }

    public final boolean set(int n2, float f2, float f3, float f4, float f5) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformf(this.locations[n2], f2, f3, f4, f5);
        return true;
    }

    public final boolean set(int n2, int n3) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], n3);
        return true;
    }

    public final boolean set(int n2, int n3, int n4) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], n3, n4);
        return true;
    }

    public final boolean set(int n2, int n3, int n4, int n5) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], n3, n4, n5);
        return true;
    }

    public final boolean set(int n2, int n3, int n4, int n5, int n6) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], n3, n4, n5, n6);
        return true;
    }

    public final boolean set(int n2, TextureDescriptor textureDescriptor) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], this.context.textureBinder.bind(textureDescriptor));
        return true;
    }

    public final boolean set(int n2, GLTexture gLTexture) {
        if (this.locations[n2] < 0) {
            return false;
        }
        this.program.setUniformi(this.locations[n2], this.context.textureBinder.bind(gLTexture));
        return true;
    }
}

