/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.shaders;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.Attribute;
import com.badlogic.gdx.graphics.g3d.Attributes;
import com.badlogic.gdx.graphics.g3d.Environment;
import com.badlogic.gdx.graphics.g3d.Renderable;
import com.badlogic.gdx.graphics.g3d.Shader;
import com.badlogic.gdx.graphics.g3d.attributes.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.ColorAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.CubemapAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DepthTestAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.DirectionalLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.FloatAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.IntAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.PointLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.SpotLightsAttribute;
import com.badlogic.gdx.graphics.g3d.attributes.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.environment.AmbientCubemap;
import com.badlogic.gdx.graphics.g3d.environment.BaseLight;
import com.badlogic.gdx.graphics.g3d.environment.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.environment.PointLight;
import com.badlogic.gdx.graphics.g3d.environment.SpotLight;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader$Setter;
import com.badlogic.gdx.graphics.g3d.shaders.BaseShader$Uniform;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Config;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Inputs;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Setters;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Setters$ACubemap;
import com.badlogic.gdx.graphics.g3d.shaders.DefaultShader$Setters$Bones;
import com.badlogic.gdx.graphics.g3d.utils.RenderContext;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Matrix3;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class DefaultShader
extends BaseShader {
    private static String defaultVertexShader = null;
    private static String defaultFragmentShader = null;
    protected static long implementedFlags = BlendingAttribute.Type | TextureAttribute.Diffuse | ColorAttribute.Diffuse | ColorAttribute.Specular | FloatAttribute.Shininess;
    @Deprecated
    public static int defaultCullFace = 1029;
    @Deprecated
    public static int defaultDepthFunc = 515;
    public final int u_projTrans;
    public final int u_viewTrans;
    public final int u_projViewTrans;
    public final int u_cameraPosition;
    public final int u_cameraDirection;
    public final int u_cameraUp;
    public final int u_cameraNearFar;
    public final int u_time;
    public final int u_worldTrans;
    public final int u_viewWorldTrans;
    public final int u_projViewWorldTrans;
    public final int u_normalMatrix;
    public final int u_bones;
    public final int u_shininess;
    public final int u_opacity;
    public final int u_diffuseColor;
    public final int u_diffuseTexture;
    public final int u_diffuseUVTransform;
    public final int u_specularColor;
    public final int u_specularTexture;
    public final int u_specularUVTransform;
    public final int u_emissiveColor;
    public final int u_emissiveTexture;
    public final int u_emissiveUVTransform;
    public final int u_reflectionColor;
    public final int u_reflectionTexture;
    public final int u_reflectionUVTransform;
    public final int u_normalTexture;
    public final int u_normalUVTransform;
    public final int u_ambientTexture;
    public final int u_ambientUVTransform;
    public final int u_alphaTest;
    protected final int u_ambientCubemap;
    protected final int u_environmentCubemap;
    protected final int u_dirLights0color = this.register(new BaseShader$Uniform("u_dirLights[0].color"));
    protected final int u_dirLights0direction = this.register(new BaseShader$Uniform("u_dirLights[0].direction"));
    protected final int u_dirLights1color = this.register(new BaseShader$Uniform("u_dirLights[1].color"));
    protected final int u_pointLights0color = this.register(new BaseShader$Uniform("u_pointLights[0].color"));
    protected final int u_pointLights0position = this.register(new BaseShader$Uniform("u_pointLights[0].position"));
    protected final int u_pointLights0intensity = this.register(new BaseShader$Uniform("u_pointLights[0].intensity"));
    protected final int u_pointLights1color = this.register(new BaseShader$Uniform("u_pointLights[1].color"));
    protected final int u_spotLights0color = this.register(new BaseShader$Uniform("u_spotLights[0].color"));
    protected final int u_spotLights0position = this.register(new BaseShader$Uniform("u_spotLights[0].position"));
    protected final int u_spotLights0intensity = this.register(new BaseShader$Uniform("u_spotLights[0].intensity"));
    protected final int u_spotLights0direction = this.register(new BaseShader$Uniform("u_spotLights[0].direction"));
    protected final int u_spotLights0cutoffAngle = this.register(new BaseShader$Uniform("u_spotLights[0].cutoffAngle"));
    protected final int u_spotLights0exponent = this.register(new BaseShader$Uniform("u_spotLights[0].exponent"));
    protected final int u_spotLights1color = this.register(new BaseShader$Uniform("u_spotLights[1].color"));
    protected final int u_fogColor = this.register(new BaseShader$Uniform("u_fogColor"));
    protected final int u_shadowMapProjViewTrans = this.register(new BaseShader$Uniform("u_shadowMapProjViewTrans"));
    protected final int u_shadowTexture = this.register(new BaseShader$Uniform("u_shadowTexture"));
    protected final int u_shadowPCFOffset = this.register(new BaseShader$Uniform("u_shadowPCFOffset"));
    protected int dirLightsLoc;
    protected int dirLightsColorOffset;
    protected int dirLightsDirectionOffset;
    protected int dirLightsSize;
    protected int pointLightsLoc;
    protected int pointLightsColorOffset;
    protected int pointLightsPositionOffset;
    protected int pointLightsIntensityOffset;
    protected int pointLightsSize;
    protected int spotLightsLoc;
    protected int spotLightsColorOffset;
    protected int spotLightsPositionOffset;
    protected int spotLightsDirectionOffset;
    protected int spotLightsIntensityOffset;
    protected int spotLightsCutoffAngleOffset;
    protected int spotLightsExponentOffset;
    protected int spotLightsSize;
    protected final boolean lighting;
    protected final boolean environmentCubemap;
    protected final boolean shadowMap;
    protected final AmbientCubemap ambientCubemap = new AmbientCubemap();
    protected final DirectionalLight[] directionalLights;
    protected final PointLight[] pointLights;
    protected final SpotLight[] spotLights;
    private Renderable renderable;
    protected final long attributesMask;
    private final long vertexMask;
    private final int textureCoordinates;
    private int[] boneWeightsLocations;
    protected final DefaultShader$Config config;
    private static final long optionalAttributes = IntAttribute.CullFace | DepthTestAttribute.Type;
    private static final Attributes tmpAttributes = new Attributes();
    private final Matrix3 normalMatrix = new Matrix3();
    private float time;
    private boolean lightsSet;
    private final Vector3 tmpV1 = new Vector3();

    public static String getDefaultVertexShader() {
        if (defaultVertexShader == null) {
            defaultVertexShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/default.vertex.glsl").readString();
        }
        return defaultVertexShader;
    }

    public static String getDefaultFragmentShader() {
        if (defaultFragmentShader == null) {
            defaultFragmentShader = Gdx.files.classpath("com/badlogic/gdx/graphics/g3d/shaders/default.fragment.glsl").readString();
        }
        return defaultFragmentShader;
    }

    public DefaultShader(Renderable renderable) {
        this(renderable, new DefaultShader$Config());
    }

    public DefaultShader(Renderable renderable, DefaultShader$Config defaultShader$Config) {
        this(renderable, defaultShader$Config, DefaultShader.createPrefix(renderable, defaultShader$Config));
    }

    public DefaultShader(Renderable renderable, DefaultShader$Config defaultShader$Config, String string) {
        this(renderable, defaultShader$Config, string, defaultShader$Config.vertexShader != null ? defaultShader$Config.vertexShader : DefaultShader.getDefaultVertexShader(), defaultShader$Config.fragmentShader != null ? defaultShader$Config.fragmentShader : DefaultShader.getDefaultFragmentShader());
    }

    public DefaultShader(Renderable renderable, DefaultShader$Config defaultShader$Config, String string, String string2, String string3) {
        this(renderable, defaultShader$Config, new ShaderProgram(string + string2, string + string3));
    }

    public DefaultShader(Renderable renderable, DefaultShader$Config defaultShader$Config, ShaderProgram shaderProgram) {
        int n2;
        Attributes attributes = DefaultShader.combineAttributes(renderable);
        this.config = defaultShader$Config;
        this.program = shaderProgram;
        this.lighting = renderable.environment != null;
        this.environmentCubemap = attributes.has(CubemapAttribute.EnvironmentMap) || this.lighting && attributes.has(CubemapAttribute.EnvironmentMap);
        this.shadowMap = this.lighting && renderable.environment.shadowMap != null;
        this.renderable = renderable;
        this.attributesMask = attributes.getMask() | optionalAttributes;
        this.vertexMask = renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked();
        this.textureCoordinates = renderable.meshPart.mesh.getVertexAttributes().getTextureCoordinates();
        this.directionalLights = new DirectionalLight[this.lighting && defaultShader$Config.numDirectionalLights > 0 ? defaultShader$Config.numDirectionalLights : 0];
        for (n2 = 0; n2 < this.directionalLights.length; ++n2) {
            this.directionalLights[n2] = new DirectionalLight();
        }
        this.pointLights = new PointLight[this.lighting && defaultShader$Config.numPointLights > 0 ? defaultShader$Config.numPointLights : 0];
        for (n2 = 0; n2 < this.pointLights.length; ++n2) {
            this.pointLights[n2] = new PointLight();
        }
        this.spotLights = new SpotLight[this.lighting && defaultShader$Config.numSpotLights > 0 ? defaultShader$Config.numSpotLights : 0];
        for (n2 = 0; n2 < this.spotLights.length; ++n2) {
            this.spotLights[n2] = new SpotLight();
        }
        if (!defaultShader$Config.ignoreUnimplemented && (implementedFlags & this.attributesMask) != this.attributesMask) {
            throw new GdxRuntimeException("Some attributes not implemented yet (" + this.attributesMask + ")");
        }
        if (renderable.bones != null && renderable.bones.length > defaultShader$Config.numBones) {
            throw new GdxRuntimeException("too many bones: " + renderable.bones.length + ", max configured: " + defaultShader$Config.numBones);
        }
        n2 = renderable.meshPart.mesh.getVertexAttributes().getBoneWeights();
        if (n2 > defaultShader$Config.numBoneWeights) {
            throw new GdxRuntimeException("too many bone weights: " + n2 + ", max configured: " + defaultShader$Config.numBoneWeights);
        }
        if (renderable.bones != null) {
            this.boneWeightsLocations = new int[defaultShader$Config.numBoneWeights];
        }
        this.u_projTrans = this.register(DefaultShader$Inputs.projTrans, DefaultShader$Setters.projTrans);
        this.u_viewTrans = this.register(DefaultShader$Inputs.viewTrans, DefaultShader$Setters.viewTrans);
        this.u_projViewTrans = this.register(DefaultShader$Inputs.projViewTrans, DefaultShader$Setters.projViewTrans);
        this.u_cameraPosition = this.register(DefaultShader$Inputs.cameraPosition, DefaultShader$Setters.cameraPosition);
        this.u_cameraDirection = this.register(DefaultShader$Inputs.cameraDirection, DefaultShader$Setters.cameraDirection);
        this.u_cameraUp = this.register(DefaultShader$Inputs.cameraUp, DefaultShader$Setters.cameraUp);
        this.u_cameraNearFar = this.register(DefaultShader$Inputs.cameraNearFar, DefaultShader$Setters.cameraNearFar);
        this.u_time = this.register(new BaseShader$Uniform("u_time"));
        this.u_worldTrans = this.register(DefaultShader$Inputs.worldTrans, DefaultShader$Setters.worldTrans);
        this.u_viewWorldTrans = this.register(DefaultShader$Inputs.viewWorldTrans, DefaultShader$Setters.viewWorldTrans);
        this.u_projViewWorldTrans = this.register(DefaultShader$Inputs.projViewWorldTrans, DefaultShader$Setters.projViewWorldTrans);
        this.u_normalMatrix = this.register(DefaultShader$Inputs.normalMatrix, DefaultShader$Setters.normalMatrix);
        this.u_bones = renderable.bones != null && defaultShader$Config.numBones > 0 ? this.register(DefaultShader$Inputs.bones, (BaseShader$Setter)new DefaultShader$Setters$Bones(defaultShader$Config.numBones)) : -1;
        this.u_shininess = this.register(DefaultShader$Inputs.shininess, DefaultShader$Setters.shininess);
        this.u_opacity = this.register(DefaultShader$Inputs.opacity);
        this.u_diffuseColor = this.register(DefaultShader$Inputs.diffuseColor, DefaultShader$Setters.diffuseColor);
        this.u_diffuseTexture = this.register(DefaultShader$Inputs.diffuseTexture, DefaultShader$Setters.diffuseTexture);
        this.u_diffuseUVTransform = this.register(DefaultShader$Inputs.diffuseUVTransform, DefaultShader$Setters.diffuseUVTransform);
        this.u_specularColor = this.register(DefaultShader$Inputs.specularColor, DefaultShader$Setters.specularColor);
        this.u_specularTexture = this.register(DefaultShader$Inputs.specularTexture, DefaultShader$Setters.specularTexture);
        this.u_specularUVTransform = this.register(DefaultShader$Inputs.specularUVTransform, DefaultShader$Setters.specularUVTransform);
        this.u_emissiveColor = this.register(DefaultShader$Inputs.emissiveColor, DefaultShader$Setters.emissiveColor);
        this.u_emissiveTexture = this.register(DefaultShader$Inputs.emissiveTexture, DefaultShader$Setters.emissiveTexture);
        this.u_emissiveUVTransform = this.register(DefaultShader$Inputs.emissiveUVTransform, DefaultShader$Setters.emissiveUVTransform);
        this.u_reflectionColor = this.register(DefaultShader$Inputs.reflectionColor, DefaultShader$Setters.reflectionColor);
        this.u_reflectionTexture = this.register(DefaultShader$Inputs.reflectionTexture, DefaultShader$Setters.reflectionTexture);
        this.u_reflectionUVTransform = this.register(DefaultShader$Inputs.reflectionUVTransform, DefaultShader$Setters.reflectionUVTransform);
        this.u_normalTexture = this.register(DefaultShader$Inputs.normalTexture, DefaultShader$Setters.normalTexture);
        this.u_normalUVTransform = this.register(DefaultShader$Inputs.normalUVTransform, DefaultShader$Setters.normalUVTransform);
        this.u_ambientTexture = this.register(DefaultShader$Inputs.ambientTexture, DefaultShader$Setters.ambientTexture);
        this.u_ambientUVTransform = this.register(DefaultShader$Inputs.ambientUVTransform, DefaultShader$Setters.ambientUVTransform);
        this.u_alphaTest = this.register(DefaultShader$Inputs.alphaTest);
        this.u_ambientCubemap = this.lighting ? this.register(DefaultShader$Inputs.ambientCube, (BaseShader$Setter)new DefaultShader$Setters$ACubemap(defaultShader$Config.numDirectionalLights, defaultShader$Config.numPointLights)) : -1;
        this.u_environmentCubemap = this.environmentCubemap ? this.register(DefaultShader$Inputs.environmentCubemap, DefaultShader$Setters.environmentCubemap) : -1;
    }

    @Override
    public void init() {
        int n2;
        int n3;
        ShaderProgram shaderProgram = this.program;
        this.program = null;
        this.init(shaderProgram, this.renderable);
        this.renderable = null;
        this.dirLightsLoc = this.loc(this.u_dirLights0color);
        this.dirLightsColorOffset = this.loc(this.u_dirLights0color) - this.dirLightsLoc;
        this.dirLightsDirectionOffset = this.loc(this.u_dirLights0direction) - this.dirLightsLoc;
        this.dirLightsSize = this.loc(this.u_dirLights1color) - this.dirLightsLoc;
        if (this.dirLightsSize < 0) {
            this.dirLightsSize = 0;
        }
        this.pointLightsLoc = this.loc(this.u_pointLights0color);
        this.pointLightsColorOffset = this.loc(this.u_pointLights0color) - this.pointLightsLoc;
        this.pointLightsPositionOffset = this.loc(this.u_pointLights0position) - this.pointLightsLoc;
        if (this.has(this.u_pointLights0intensity)) {
            DefaultShader defaultShader = this;
            n3 = defaultShader.loc(defaultShader.u_pointLights0intensity) - this.pointLightsLoc;
        } else {
            n3 = -1;
        }
        this.pointLightsIntensityOffset = n3;
        this.pointLightsSize = this.loc(this.u_pointLights1color) - this.pointLightsLoc;
        if (this.pointLightsSize < 0) {
            this.pointLightsSize = 0;
        }
        this.spotLightsLoc = this.loc(this.u_spotLights0color);
        this.spotLightsColorOffset = this.loc(this.u_spotLights0color) - this.spotLightsLoc;
        this.spotLightsPositionOffset = this.loc(this.u_spotLights0position) - this.spotLightsLoc;
        this.spotLightsDirectionOffset = this.loc(this.u_spotLights0direction) - this.spotLightsLoc;
        if (this.has(this.u_spotLights0intensity)) {
            DefaultShader defaultShader = this;
            n2 = defaultShader.loc(defaultShader.u_spotLights0intensity) - this.spotLightsLoc;
        } else {
            n2 = -1;
        }
        this.spotLightsIntensityOffset = n2;
        this.spotLightsCutoffAngleOffset = this.loc(this.u_spotLights0cutoffAngle) - this.spotLightsLoc;
        this.spotLightsExponentOffset = this.loc(this.u_spotLights0exponent) - this.spotLightsLoc;
        this.spotLightsSize = this.loc(this.u_spotLights1color) - this.spotLightsLoc;
        if (this.spotLightsSize < 0) {
            this.spotLightsSize = 0;
        }
        if (this.boneWeightsLocations != null) {
            for (int i2 = 0; i2 < this.boneWeightsLocations.length; ++i2) {
                this.boneWeightsLocations[i2] = shaderProgram.getAttributeLocation("a_boneWeight" + i2);
            }
        }
    }

    private static final boolean and(long l2, long l3) {
        return (l2 & l3) == l3;
    }

    private static final boolean or(long l2, long l3) {
        return (l2 & l3) != 0L;
    }

    private static final Attributes combineAttributes(Renderable renderable) {
        tmpAttributes.clear();
        if (renderable.environment != null) {
            tmpAttributes.set(renderable.environment);
        }
        if (renderable.material != null) {
            tmpAttributes.set(renderable.material);
        }
        return tmpAttributes;
    }

    private static final long combineAttributeMasks(Renderable renderable) {
        long l2 = 0L;
        if (renderable.environment != null) {
            l2 = 0L | renderable.environment.getMask();
        }
        if (renderable.material != null) {
            l2 |= renderable.material.getMask();
        }
        return l2;
    }

    public static String createPrefix(Renderable renderable, DefaultShader$Config defaultShader$Config) {
        int n2;
        Attributes attributes = DefaultShader.combineAttributes(renderable);
        String string = "";
        long l2 = attributes.getMask();
        long l3 = renderable.meshPart.mesh.getVertexAttributes().getMask();
        if (DefaultShader.and(l3, 1L)) {
            string = string + "#define positionFlag\n";
        }
        if (DefaultShader.or(l3, 6L)) {
            string = string + "#define colorFlag\n";
        }
        if (DefaultShader.and(l3, 256L)) {
            string = string + "#define binormalFlag\n";
        }
        if (DefaultShader.and(l3, 128L)) {
            string = string + "#define tangentFlag\n";
        }
        if (DefaultShader.and(l3, 8L)) {
            string = string + "#define normalFlag\n";
        }
        if ((DefaultShader.and(l3, 8L) || DefaultShader.and(l3, 384L)) && renderable.environment != null) {
            string = string + "#define lightingFlag\n";
            string = string + "#define ambientCubemapFlag\n";
            string = string + "#define numDirectionalLights " + defaultShader$Config.numDirectionalLights + "\n";
            string = string + "#define numPointLights " + defaultShader$Config.numPointLights + "\n";
            string = string + "#define numSpotLights " + defaultShader$Config.numSpotLights + "\n";
            if (attributes.has(ColorAttribute.Fog)) {
                string = string + "#define fogFlag\n";
            }
            if (renderable.environment.shadowMap != null) {
                string = string + "#define shadowMapFlag\n";
            }
            if (attributes.has(CubemapAttribute.EnvironmentMap)) {
                string = string + "#define environmentCubemapFlag\n";
            }
        }
        int n3 = renderable.meshPart.mesh.getVertexAttributes().size();
        for (n2 = 0; n2 < n3; ++n2) {
            VertexAttribute vertexAttribute = renderable.meshPart.mesh.getVertexAttributes().get(n2);
            if (vertexAttribute.usage != 16) continue;
            string = string + "#define texCoord" + vertexAttribute.unit + "Flag\n";
        }
        if (renderable.bones != null) {
            for (n2 = 0; n2 < defaultShader$Config.numBoneWeights; ++n2) {
                string = string + "#define boneWeight" + n2 + "Flag\n";
            }
        }
        if ((l2 & BlendingAttribute.Type) == BlendingAttribute.Type) {
            string = string + "#define blendedFlag\n";
        }
        if ((l2 & TextureAttribute.Diffuse) == TextureAttribute.Diffuse) {
            string = string + "#define diffuseTextureFlag\n";
            string = string + "#define diffuseTextureCoord texCoord0\n";
        }
        if ((l2 & TextureAttribute.Specular) == TextureAttribute.Specular) {
            string = string + "#define specularTextureFlag\n";
            string = string + "#define specularTextureCoord texCoord0\n";
        }
        if ((l2 & TextureAttribute.Normal) == TextureAttribute.Normal) {
            string = string + "#define normalTextureFlag\n";
            string = string + "#define normalTextureCoord texCoord0\n";
        }
        if ((l2 & TextureAttribute.Emissive) == TextureAttribute.Emissive) {
            string = string + "#define emissiveTextureFlag\n";
            string = string + "#define emissiveTextureCoord texCoord0\n";
        }
        if ((l2 & TextureAttribute.Reflection) == TextureAttribute.Reflection) {
            string = string + "#define reflectionTextureFlag\n";
            string = string + "#define reflectionTextureCoord texCoord0\n";
        }
        if ((l2 & TextureAttribute.Ambient) == TextureAttribute.Ambient) {
            string = string + "#define ambientTextureFlag\n";
            string = string + "#define ambientTextureCoord texCoord0\n";
        }
        if ((l2 & ColorAttribute.Diffuse) == ColorAttribute.Diffuse) {
            string = string + "#define diffuseColorFlag\n";
        }
        if ((l2 & ColorAttribute.Specular) == ColorAttribute.Specular) {
            string = string + "#define specularColorFlag\n";
        }
        if ((l2 & ColorAttribute.Emissive) == ColorAttribute.Emissive) {
            string = string + "#define emissiveColorFlag\n";
        }
        if ((l2 & ColorAttribute.Reflection) == ColorAttribute.Reflection) {
            string = string + "#define reflectionColorFlag\n";
        }
        if ((l2 & FloatAttribute.Shininess) == FloatAttribute.Shininess) {
            string = string + "#define shininessFlag\n";
        }
        if ((l2 & FloatAttribute.AlphaTest) == FloatAttribute.AlphaTest) {
            string = string + "#define alphaTestFlag\n";
        }
        if (renderable.bones != null && defaultShader$Config.numBones > 0) {
            string = string + "#define numBones " + defaultShader$Config.numBones + "\n";
        }
        return string;
    }

    @Override
    public boolean canRender(Renderable renderable) {
        if (renderable.bones != null) {
            if (renderable.bones.length > this.config.numBones) {
                return false;
            }
            if (renderable.meshPart.mesh.getVertexAttributes().getBoneWeights() > this.config.numBoneWeights) {
                return false;
            }
        }
        if (renderable.meshPart.mesh.getVertexAttributes().getTextureCoordinates() != this.textureCoordinates) {
            return false;
        }
        long l2 = DefaultShader.combineAttributeMasks(renderable);
        return this.attributesMask == (l2 | optionalAttributes) && this.vertexMask == renderable.meshPart.mesh.getVertexAttributes().getMaskWithSizePacked() && renderable.environment != null == this.lighting;
    }

    @Override
    public int compareTo(Shader shader) {
        if (shader == null) {
            return -1;
        }
        if (shader == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof DefaultShader && this.equals((DefaultShader)object);
    }

    public boolean equals(DefaultShader defaultShader) {
        return defaultShader == this;
    }

    @Override
    public void begin(Camera objectArray, RenderContext renderContext) {
        BaseLight baseLight;
        int n2;
        super.begin((Camera)objectArray, renderContext);
        objectArray = this.directionalLights;
        int n3 = this.directionalLights.length;
        for (n2 = 0; n2 < n3; ++n2) {
            baseLight = objectArray[n2];
            baseLight.set(0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        }
        objectArray = this.pointLights;
        n3 = this.pointLights.length;
        for (n2 = 0; n2 < n3; ++n2) {
            baseLight = objectArray[n2];
            ((PointLight)baseLight).set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        objectArray = this.spotLights;
        n3 = this.spotLights.length;
        for (n2 = 0; n2 < n3; ++n2) {
            baseLight = objectArray[n2];
            ((SpotLight)baseLight).set(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        }
        this.lightsSet = false;
        DefaultShader defaultShader = this;
        if (defaultShader.has(defaultShader.u_time)) {
            DefaultShader defaultShader2 = this;
            defaultShader2.set(defaultShader2.u_time, this.time += Gdx.graphics.getDeltaTime());
        }
        if (this.boneWeightsLocations != null) {
            objectArray = this.boneWeightsLocations;
            n3 = this.boneWeightsLocations.length;
            for (n2 = 0; n2 < n3; ++n2) {
                BaseLight baseLight2 = objectArray[n2];
                if (baseLight2 < 0) continue;
                Gdx.gl.glVertexAttrib2f((int)baseLight2, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public void render(Renderable renderable, Attributes attributes) {
        if (!attributes.has(BlendingAttribute.Type)) {
            this.context.setBlending(false, 770, 771);
        }
        this.bindMaterial(attributes);
        if (this.lighting) {
            this.bindLights(renderable, attributes);
        }
        super.render(renderable, attributes);
    }

    @Override
    public void end() {
        super.end();
    }

    protected void bindMaterial(Attributes object) {
        int n2 = this.config.defaultCullFace == -1 ? defaultCullFace : this.config.defaultCullFace;
        int n3 = this.config.defaultDepthFunc == -1 ? defaultDepthFunc : this.config.defaultDepthFunc;
        float f2 = 0.0f;
        float f3 = 1.0f;
        boolean bl = true;
        object = ((Attributes)object).iterator();
        while (object.hasNext()) {
            Attribute attribute = (Attribute)object.next();
            long l2 = attribute.type;
            if (BlendingAttribute.is(l2)) {
                this.context.setBlending(true, ((BlendingAttribute)attribute).sourceFunction, ((BlendingAttribute)attribute).destFunction);
                DefaultShader defaultShader = this;
                defaultShader.set(defaultShader.u_opacity, ((BlendingAttribute)attribute).opacity);
                continue;
            }
            if ((l2 & IntAttribute.CullFace) == IntAttribute.CullFace) {
                n2 = ((IntAttribute)attribute).value;
                continue;
            }
            if ((l2 & FloatAttribute.AlphaTest) == FloatAttribute.AlphaTest) {
                DefaultShader defaultShader = this;
                defaultShader.set(defaultShader.u_alphaTest, ((FloatAttribute)attribute).value);
                continue;
            }
            if ((l2 & DepthTestAttribute.Type) == DepthTestAttribute.Type) {
                DepthTestAttribute depthTestAttribute = (DepthTestAttribute)attribute;
                n3 = depthTestAttribute.depthFunc;
                f2 = depthTestAttribute.depthRangeNear;
                f3 = depthTestAttribute.depthRangeFar;
                bl = depthTestAttribute.depthMask;
                continue;
            }
            if (this.config.ignoreUnimplemented) continue;
            throw new GdxRuntimeException("Unknown material attribute: " + attribute.toString());
        }
        this.context.setCullFace(n2);
        this.context.setDepthTest(n3, f2, f3);
        this.context.setDepthMask(bl);
    }

    protected void bindLights(Renderable object, Attributes attributes) {
        int n2;
        int n3;
        object = ((Renderable)object).environment;
        Object object2 = attributes.get(DirectionalLightsAttribute.class, DirectionalLightsAttribute.Type);
        object2 = object2 == null ? null : ((DirectionalLightsAttribute)object2).lights;
        Object object3 = attributes.get(PointLightsAttribute.class, PointLightsAttribute.Type);
        object3 = object3 == null ? null : ((PointLightsAttribute)object3).lights;
        Object object4 = attributes.get(SpotLightsAttribute.class, SpotLightsAttribute.Type);
        Object object5 = object4 = object4 == null ? null : ((SpotLightsAttribute)object4).lights;
        if (this.dirLightsLoc >= 0) {
            for (n3 = 0; n3 < this.directionalLights.length; ++n3) {
                if (object2 == null || n3 >= ((Array)object2).size) {
                    if (this.lightsSet && this.directionalLights[n3].color.r == 0.0f && this.directionalLights[n3].color.g == 0.0f && this.directionalLights[n3].color.b == 0.0f) continue;
                    this.directionalLights[n3].color.set(0.0f, 0.0f, 0.0f, 1.0f);
                } else {
                    if (this.lightsSet && this.directionalLights[n3].equals((DirectionalLight)((Array)object2).get(n3))) continue;
                    this.directionalLights[n3].set((DirectionalLight)((Array)object2).get(n3));
                }
                n2 = this.dirLightsLoc + n3 * this.dirLightsSize;
                this.program.setUniformf(n2 + this.dirLightsColorOffset, this.directionalLights[n3].color.r, this.directionalLights[n3].color.g, this.directionalLights[n3].color.b);
                this.program.setUniformf(n2 + this.dirLightsDirectionOffset, this.directionalLights[n3].direction.x, this.directionalLights[n3].direction.y, this.directionalLights[n3].direction.z);
                if (this.dirLightsSize <= 0) break;
            }
        }
        if (this.pointLightsLoc >= 0) {
            for (n3 = 0; n3 < this.pointLights.length; ++n3) {
                if (object3 == null || n3 >= ((Array)object3).size) {
                    if (this.lightsSet && this.pointLights[n3].intensity == 0.0f) continue;
                    this.pointLights[n3].intensity = 0.0f;
                } else {
                    if (this.lightsSet && this.pointLights[n3].equals((PointLight)((Array)object3).get(n3))) continue;
                    this.pointLights[n3].set((PointLight)((Array)object3).get(n3));
                }
                n2 = this.pointLightsLoc + n3 * this.pointLightsSize;
                this.program.setUniformf(n2 + this.pointLightsColorOffset, this.pointLights[n3].color.r * this.pointLights[n3].intensity, this.pointLights[n3].color.g * this.pointLights[n3].intensity, this.pointLights[n3].color.b * this.pointLights[n3].intensity);
                this.program.setUniformf(n2 + this.pointLightsPositionOffset, this.pointLights[n3].position.x, this.pointLights[n3].position.y, this.pointLights[n3].position.z);
                if (this.pointLightsIntensityOffset >= 0) {
                    this.program.setUniformf(n2 + this.pointLightsIntensityOffset, this.pointLights[n3].intensity);
                }
                if (this.pointLightsSize <= 0) break;
            }
        }
        if (this.spotLightsLoc >= 0) {
            for (n3 = 0; n3 < this.spotLights.length; ++n3) {
                if (object4 == null || n3 >= ((Array)object4).size) {
                    if (this.lightsSet && this.spotLights[n3].intensity == 0.0f) continue;
                    this.spotLights[n3].intensity = 0.0f;
                } else {
                    if (this.lightsSet && this.spotLights[n3].equals((SpotLight)((Array)object4).get(n3))) continue;
                    this.spotLights[n3].set((SpotLight)((Array)object4).get(n3));
                }
                n2 = this.spotLightsLoc + n3 * this.spotLightsSize;
                this.program.setUniformf(n2 + this.spotLightsColorOffset, this.spotLights[n3].color.r * this.spotLights[n3].intensity, this.spotLights[n3].color.g * this.spotLights[n3].intensity, this.spotLights[n3].color.b * this.spotLights[n3].intensity);
                this.program.setUniformf(n2 + this.spotLightsPositionOffset, this.spotLights[n3].position);
                this.program.setUniformf(n2 + this.spotLightsDirectionOffset, this.spotLights[n3].direction);
                this.program.setUniformf(n2 + this.spotLightsCutoffAngleOffset, this.spotLights[n3].cutoffAngle);
                this.program.setUniformf(n2 + this.spotLightsExponentOffset, this.spotLights[n3].exponent);
                if (this.spotLightsIntensityOffset >= 0) {
                    this.program.setUniformf(n2 + this.spotLightsIntensityOffset, this.spotLights[n3].intensity);
                }
                if (this.spotLightsSize <= 0) break;
            }
        }
        if (attributes.has(ColorAttribute.Fog)) {
            DefaultShader defaultShader = this;
            defaultShader.set(defaultShader.u_fogColor, ((ColorAttribute)attributes.get((long)ColorAttribute.Fog)).color);
        }
        if (object != null && ((Environment)object).shadowMap != null) {
            DefaultShader defaultShader = this;
            defaultShader.set(defaultShader.u_shadowMapProjViewTrans, ((Environment)object).shadowMap.getProjViewTrans());
            DefaultShader defaultShader2 = this;
            defaultShader2.set(defaultShader2.u_shadowTexture, ((Environment)object).shadowMap.getDepthMap());
            DefaultShader defaultShader3 = this;
            defaultShader3.set(defaultShader3.u_shadowPCFOffset, 1.0f / (2.0f * (float)((GLTexture)((Environment)object).shadowMap.getDepthMap().texture).getWidth()));
        }
        this.lightsSet = true;
    }

    @Override
    public void dispose() {
        this.program.dispose();
        super.dispose();
    }

    public int getDefaultCullFace() {
        if (this.config.defaultCullFace == -1) {
            return defaultCullFace;
        }
        return this.config.defaultCullFace;
    }

    public void setDefaultCullFace(int n2) {
        this.config.defaultCullFace = n2;
    }

    public int getDefaultDepthFunc() {
        if (this.config.defaultDepthFunc == -1) {
            return defaultDepthFunc;
        }
        return this.config.defaultDepthFunc;
    }

    public void setDefaultDepthFunc(int n2) {
        this.config.defaultDepthFunc = n2;
    }
}

