/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.utils;

import com.badlogic.gdx.graphics.g3d.ModelInstance;
import com.badlogic.gdx.graphics.g3d.model.Animation;
import com.badlogic.gdx.graphics.g3d.model.Node;
import com.badlogic.gdx.graphics.g3d.model.NodeAnimation;
import com.badlogic.gdx.graphics.g3d.model.NodeKeyframe;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController$1;
import com.badlogic.gdx.graphics.g3d.utils.BaseAnimationController$Transform;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.ObjectMap$Entry;
import com.badlogic.gdx.utils.Pool;

public class BaseAnimationController {
    private final Pool<BaseAnimationController$Transform> transformPool = new BaseAnimationController$1(this);
    private static final ObjectMap<Node, BaseAnimationController$Transform> transforms = new ObjectMap();
    private boolean applying = false;
    public final ModelInstance target;
    private static final BaseAnimationController$Transform tmpT = new BaseAnimationController$Transform();

    public BaseAnimationController(ModelInstance modelInstance) {
        this.target = modelInstance;
    }

    protected void begin() {
        if (this.applying) {
            throw new GdxRuntimeException("You must call end() after each call to being()");
        }
        this.applying = true;
    }

    protected void apply(Animation animation, float f2, float f3) {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() before adding an animation");
        }
        BaseAnimationController.applyAnimation(transforms, this.transformPool, f3, animation, f2);
    }

    protected void end() {
        if (!this.applying) {
            throw new GdxRuntimeException("You must call begin() first");
        }
        for (ObjectMap$Entry objectMap$Entry : transforms.entries()) {
            ((BaseAnimationController$Transform)objectMap$Entry.value).toMatrix4(((Node)objectMap$Entry.key).localTransform);
            this.transformPool.free((BaseAnimationController$Transform)objectMap$Entry.value);
        }
        transforms.clear();
        this.target.calculateTransforms();
        this.applying = false;
    }

    protected void applyAnimation(Animation animation, float f2) {
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        BaseAnimationController.applyAnimation(null, null, 1.0f, animation, f2);
        this.target.calculateTransforms();
    }

    protected void applyAnimations(Animation animation, float f2, Animation animation2, float f3, float f4) {
        if (animation2 == null || f4 == 0.0f) {
            this.applyAnimation(animation, f2);
            return;
        }
        if (animation == null || f4 == 1.0f) {
            this.applyAnimation(animation2, f3);
            return;
        }
        if (this.applying) {
            throw new GdxRuntimeException("Call end() first");
        }
        this.begin();
        this.apply(animation, f2, 1.0f);
        this.apply(animation2, f3, f4);
        this.end();
    }

    static final <T> int getFirstKeyframeIndexAtTime(Array<NodeKeyframe<T>> array, float f2) {
        int n2 = array.size - 1;
        if (n2 <= 0 || f2 < array.get((int)0).keytime || f2 > array.get((int)n2).keytime) {
            return 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 + n2) / 2;
            if (f2 > array.get((int)(n4 + 1)).keytime) {
                n3 = n4 + 1;
                continue;
            }
            if (f2 < array.get((int)n4).keytime) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n3;
    }

    private static final Vector3 getTranslationAtTime(NodeAnimation object, float f2, Vector3 vector3) {
        if (((NodeAnimation)object).translation == null) {
            return vector3.set(((NodeAnimation)object).node.translation);
        }
        if (((NodeAnimation)object).translation.size == 1) {
            return vector3.set((Vector3)((NodeAnimation)object).translation.get((int)0).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).translation, f2);
        NodeKeyframe<Vector3> nodeKeyframe = ((NodeAnimation)object).translation.get(n2);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).translation.size) {
            object = ((NodeAnimation)object).translation.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f2);
        }
        return vector3;
    }

    private static final Quaternion getRotationAtTime(NodeAnimation object, float f2, Quaternion quaternion) {
        if (((NodeAnimation)object).rotation == null) {
            return quaternion.set(((NodeAnimation)object).node.rotation);
        }
        if (((NodeAnimation)object).rotation.size == 1) {
            return quaternion.set((Quaternion)((NodeAnimation)object).rotation.get((int)0).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).rotation, f2);
        NodeKeyframe<Quaternion> nodeKeyframe = ((NodeAnimation)object).rotation.get(n2);
        quaternion.set((Quaternion)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).rotation.size) {
            object = ((NodeAnimation)object).rotation.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            quaternion.slerp((Quaternion)((NodeKeyframe)object).value, f2);
        }
        return quaternion;
    }

    private static final Vector3 getScalingAtTime(NodeAnimation object, float f2, Vector3 vector3) {
        if (((NodeAnimation)object).scaling == null) {
            return vector3.set(((NodeAnimation)object).node.scale);
        }
        if (((NodeAnimation)object).scaling.size == 1) {
            return vector3.set((Vector3)((NodeAnimation)object).scaling.get((int)0).value);
        }
        int n2 = BaseAnimationController.getFirstKeyframeIndexAtTime(((NodeAnimation)object).scaling, f2);
        NodeKeyframe<Vector3> nodeKeyframe = ((NodeAnimation)object).scaling.get(n2);
        vector3.set((Vector3)nodeKeyframe.value);
        if (++n2 < ((NodeAnimation)object).scaling.size) {
            object = ((NodeAnimation)object).scaling.get(n2);
            f2 = (f2 - nodeKeyframe.keytime) / (((NodeKeyframe)object).keytime - nodeKeyframe.keytime);
            vector3.lerp((Vector3)((NodeKeyframe)object).value, f2);
        }
        return vector3;
    }

    private static final BaseAnimationController$Transform getNodeAnimationTransform(NodeAnimation nodeAnimation, float f2) {
        BaseAnimationController$Transform baseAnimationController$Transform = tmpT;
        BaseAnimationController.getTranslationAtTime(nodeAnimation, f2, baseAnimationController$Transform.translation);
        BaseAnimationController.getRotationAtTime(nodeAnimation, f2, baseAnimationController$Transform.rotation);
        BaseAnimationController.getScalingAtTime(nodeAnimation, f2, baseAnimationController$Transform.scale);
        return baseAnimationController$Transform;
    }

    private static final void applyNodeAnimationDirectly(NodeAnimation object, float f2) {
        Node node = ((NodeAnimation)object).node;
        ((NodeAnimation)object).node.isAnimated = true;
        object = BaseAnimationController.getNodeAnimationTransform((NodeAnimation)object, f2);
        ((BaseAnimationController$Transform)object).toMatrix4(node.localTransform);
    }

    private static final void applyNodeAnimationBlending(NodeAnimation object, ObjectMap<Node, BaseAnimationController$Transform> objectMap, Pool<BaseAnimationController$Transform> pool, float f2, float f3) {
        Node node = ((NodeAnimation)object).node;
        ((NodeAnimation)object).node.isAnimated = true;
        object = BaseAnimationController.getNodeAnimationTransform((NodeAnimation)object, f3);
        BaseAnimationController$Transform baseAnimationController$Transform = objectMap.get(node, null);
        if (baseAnimationController$Transform != null) {
            if (f2 > 0.999999f) {
                baseAnimationController$Transform.set((BaseAnimationController$Transform)object);
                return;
            }
            baseAnimationController$Transform.lerp((BaseAnimationController$Transform)object, f2);
            return;
        }
        if (f2 > 0.999999f) {
            objectMap.put(node, pool.obtain().set((BaseAnimationController$Transform)object));
            return;
        }
        objectMap.put(node, pool.obtain().set(node.translation, node.rotation, node.scale).lerp((BaseAnimationController$Transform)object, f2));
    }

    protected static void applyAnimation(ObjectMap<Node, BaseAnimationController$Transform> objectMap, Pool<BaseAnimationController$Transform> pool, float f2, Animation animation, float f3) {
        if (objectMap == null) {
            for (NodeAnimation nodeAnimation : animation.nodeAnimations) {
                BaseAnimationController.applyNodeAnimationDirectly(nodeAnimation, f3);
            }
            return;
        }
        for (Node object : objectMap.keys()) {
            ((Node)var5_6.next()).isAnimated = false;
        }
        for (NodeAnimation nodeAnimation : animation.nodeAnimations) {
            BaseAnimationController.applyNodeAnimationBlending(nodeAnimation, objectMap, pool, f2, f3);
        }
        for (ObjectMap$Entry objectMap$Entry : objectMap.entries()) {
            if (((Node)objectMap$Entry.key).isAnimated) continue;
            ((Node)objectMap$Entry.key).isAnimated = true;
            ((BaseAnimationController$Transform)objectMap$Entry.value).lerp(((Node)objectMap$Entry.key).translation, ((Node)objectMap$Entry.key).rotation, ((Node)objectMap$Entry.key).scale, f2);
        }
    }

    protected void removeAnimation(Animation object) {
        for (NodeAnimation nodeAnimation : ((Animation)object).nodeAnimations) {
            ((NodeAnimation)object.next()).node.isAnimated = false;
        }
    }
}

