/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.glutils.ETC1;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class ETC1$ETC1Data
implements Disposable {
    public final int width;
    public final int height;
    public final ByteBuffer compressedData;
    public final int dataOffset;

    public ETC1$ETC1Data(int n2, int n3, ByteBuffer byteBuffer, int n4) {
        this.width = n2;
        this.height = n3;
        this.compressedData = byteBuffer;
        this.dataOffset = n4;
        this.checkNPOT();
    }

    public ETC1$ETC1Data(FileHandle fileHandle) {
        byte[] byArray = new byte[10240];
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new GZIPInputStream(fileHandle.read())));
            int n2 = dataInputStream.readInt();
            this.compressedData = BufferUtils.newUnsafeByteBuffer(n2);
            while ((n2 = dataInputStream.read(byArray)) != -1) {
                this.compressedData.put(byArray, 0, n2);
            }
            ((Buffer)this.compressedData).position(0);
            ((Buffer)this.compressedData).limit(this.compressedData.capacity());
        }
        catch (Exception exception) {
            try {
                throw new GdxRuntimeException("Couldn't load pkm file '" + fileHandle + "'", exception);
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataInputStream);
                throw throwable;
            }
        }
        StreamUtils.closeQuietly(dataInputStream);
        this.width = ETC1.getWidthPKM(this.compressedData, 0);
        this.height = ETC1.getHeightPKM(this.compressedData, 0);
        this.dataOffset = ETC1.PKM_HEADER_SIZE;
        ((Buffer)this.compressedData).position(this.dataOffset);
        this.checkNPOT();
    }

    private void checkNPOT() {
        if (!MathUtils.isPowerOfTwo(this.width) || !MathUtils.isPowerOfTwo(this.height)) {
            System.out.println("ETC1Data warning: non-power-of-two ETC1 textures may crash the driver of PowerVR GPUs");
        }
    }

    public final boolean hasPKMHeader() {
        return this.dataOffset == 16;
    }

    public final void write(FileHandle fileHandle) {
        DataOutputStream dataOutputStream = null;
        byte[] byArray = new byte[10240];
        ((Buffer)this.compressedData).position(0);
        ((Buffer)this.compressedData).limit(this.compressedData.capacity());
        try {
            int n2;
            dataOutputStream = new DataOutputStream(new GZIPOutputStream(fileHandle.write(false)));
            dataOutputStream.writeInt(this.compressedData.capacity());
            for (int i2 = 0; i2 != this.compressedData.capacity(); i2 += n2) {
                n2 = Math.min(this.compressedData.remaining(), byArray.length);
                this.compressedData.get(byArray, 0, n2);
                dataOutputStream.write(byArray, 0, n2);
            }
        }
        catch (Exception exception) {
            try {
                throw new GdxRuntimeException("Couldn't write PKM file to '" + fileHandle + "'", exception);
            }
            catch (Throwable throwable) {
                StreamUtils.closeQuietly(dataOutputStream);
                throw throwable;
            }
        }
        StreamUtils.closeQuietly(dataOutputStream);
        ((Buffer)this.compressedData).position(this.dataOffset);
        ((Buffer)this.compressedData).limit(this.compressedData.capacity());
    }

    @Override
    public final void dispose() {
        BufferUtils.disposeUnsafeByteBuffer(this.compressedData);
    }

    public final String toString() {
        if (this.hasPKMHeader()) {
            return (ETC1.isValidPKM(this.compressedData, 0) ? "valid" : "invalid") + " pkm [" + ETC1.getWidthPKM(this.compressedData, 0) + "x" + ETC1.getHeightPKM(this.compressedData, 0) + "], compressed: " + (this.compressedData.capacity() - ETC1.PKM_HEADER_SIZE);
        }
        return "raw [" + this.width + "x" + this.height + "], compressed: " + (this.compressedData.capacity() - ETC1.PKM_HEADER_SIZE);
    }
}

