/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.glutils.ETC1$ETC1Data;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.ByteBuffer;

public class ETC1 {
    public static int PKM_HEADER_SIZE = 16;
    public static int ETC1_RGB8_OES = 36196;

    private static int getPixelSize(Pixmap$Format pixmap$Format) {
        if (pixmap$Format == Pixmap$Format.RGB565) {
            return 2;
        }
        if (pixmap$Format == Pixmap$Format.RGB888) {
            return 3;
        }
        throw new GdxRuntimeException("Can only handle RGB565 or RGB888 images");
    }

    public static ETC1$ETC1Data encodeImage(Pixmap pixmap) {
        int n2 = ETC1.getPixelSize(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImage(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n2);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1$ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 0);
    }

    public static ETC1$ETC1Data encodeImagePKM(Pixmap pixmap) {
        int n2 = ETC1.getPixelSize(pixmap.getFormat());
        ByteBuffer byteBuffer = ETC1.encodeImagePKM(pixmap.getPixels(), 0, pixmap.getWidth(), pixmap.getHeight(), n2);
        BufferUtils.newUnsafeByteBuffer(byteBuffer);
        return new ETC1$ETC1Data(pixmap.getWidth(), pixmap.getHeight(), byteBuffer, 16);
    }

    public static Pixmap decodeImage(ETC1$ETC1Data eTC1$ETC1Data, Pixmap$Format object) {
        int n2;
        int n3;
        int n4;
        if (eTC1$ETC1Data.hasPKMHeader()) {
            n4 = 16;
            n3 = ETC1.getWidthPKM(eTC1$ETC1Data.compressedData, 0);
            n2 = ETC1.getHeightPKM(eTC1$ETC1Data.compressedData, 0);
        } else {
            n4 = 0;
            n3 = eTC1$ETC1Data.width;
            n2 = eTC1$ETC1Data.height;
        }
        int n5 = ETC1.getPixelSize((Pixmap$Format)((Object)object));
        object = new Pixmap(n3, n2, (Pixmap$Format)((Object)object));
        ETC1.decodeImage(eTC1$ETC1Data.compressedData, n4, ((Pixmap)object).getPixels(), 0, n3, n2, n5);
        return object;
    }

    public static native int getCompressedDataSize(int var0, int var1);

    public static native void formatHeader(ByteBuffer var0, int var1, int var2, int var3);

    static native int getWidthPKM(ByteBuffer var0, int var1);

    static native int getHeightPKM(ByteBuffer var0, int var1);

    static native boolean isValidPKM(ByteBuffer var0, int var1);

    private static native void decodeImage(ByteBuffer var0, int var1, ByteBuffer var2, int var3, int var4, int var5, int var6);

    private static native ByteBuffer encodeImage(ByteBuffer var0, int var1, int var2, int var3, int var4);

    private static native ByteBuffer encodeImagePKM(ByteBuffer var0, int var1, int var2, int var3, int var4);
}

