/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Cubemap;
import com.badlogic.gdx.graphics.Cubemap$CubemapSide;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.Texture$TextureWrap;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferCubemapBuilder;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferTextureAttachmentSpec;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$GLFrameBufferBuilder;
import com.badlogic.gdx.graphics.glutils.GLOnlyTextureData;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class FrameBufferCubemap
extends GLFrameBuffer<Cubemap> {
    private int currentSide;
    private static final Cubemap$CubemapSide[] cubemapSides = Cubemap$CubemapSide.values();

    FrameBufferCubemap() {
    }

    protected FrameBufferCubemap(GLFrameBuffer$GLFrameBufferBuilder<? extends GLFrameBuffer<Cubemap>> gLFrameBuffer$GLFrameBufferBuilder) {
        super(gLFrameBuffer$GLFrameBufferBuilder);
    }

    public FrameBufferCubemap(Pixmap$Format pixmap$Format, int n2, int n3, boolean bl) {
        this(pixmap$Format, n2, n3, bl, false);
    }

    public FrameBufferCubemap(Pixmap$Format pixmap$Format, int n2, int n3, boolean bl, boolean bl2) {
        GLFrameBuffer$FrameBufferCubemapBuilder gLFrameBuffer$FrameBufferCubemapBuilder = new GLFrameBuffer$FrameBufferCubemapBuilder(n2, n3);
        gLFrameBuffer$FrameBufferCubemapBuilder.addBasicColorTextureAttachment(pixmap$Format);
        if (bl) {
            gLFrameBuffer$FrameBufferCubemapBuilder.addBasicDepthRenderBuffer();
        }
        if (bl2) {
            gLFrameBuffer$FrameBufferCubemapBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = gLFrameBuffer$FrameBufferCubemapBuilder;
        this.build();
    }

    @Override
    protected Cubemap createTexture(GLFrameBuffer$FrameBufferTextureAttachmentSpec object) {
        Object object2 = object = new GLOnlyTextureData(this.bufferBuilder.width, this.bufferBuilder.height, 0, ((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).internalFormat, ((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).format, ((GLFrameBuffer$FrameBufferTextureAttachmentSpec)object).type);
        Object object3 = object;
        Object object4 = object;
        object = new Cubemap((TextureData)object2, (TextureData)object2, (TextureData)object3, (TextureData)object3, (TextureData)object4, (TextureData)object4);
        Texture$TextureFilter texture$TextureFilter = Texture$TextureFilter.Linear;
        ((GLTexture)object).setFilter(texture$TextureFilter, texture$TextureFilter);
        Texture$TextureWrap texture$TextureWrap = Texture$TextureWrap.ClampToEdge;
        ((GLTexture)object).setWrap(texture$TextureWrap, texture$TextureWrap);
        return object;
    }

    @Override
    protected void disposeColorTexture(Cubemap cubemap) {
        ((GLTexture)cubemap).dispose();
    }

    @Override
    protected void attachFrameBufferColorTexture(Cubemap cubemap) {
        GL20 gL20 = Gdx.gl20;
        int n2 = cubemap.getTextureObjectHandle();
        Cubemap$CubemapSide[] cubemap$CubemapSideArray = Cubemap$CubemapSide.values();
        Cubemap$CubemapSide[] cubemap$CubemapSideArray2 = cubemap$CubemapSideArray;
        cubemap$CubemapSideArray2 = cubemap$CubemapSideArray;
        int n3 = cubemap$CubemapSideArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Cubemap$CubemapSide cubemap$CubemapSide = cubemap$CubemapSideArray2[i2];
            gL20.glFramebufferTexture2D(36160, 36064, cubemap$CubemapSide.glEnum, n2, 0);
        }
    }

    @Override
    public void bind() {
        this.currentSide = -1;
        super.bind();
    }

    public boolean nextSide() {
        if (this.currentSide > 5) {
            throw new GdxRuntimeException("No remaining sides.");
        }
        if (this.currentSide == 5) {
            return false;
        }
        ++this.currentSide;
        FrameBufferCubemap frameBufferCubemap = this;
        frameBufferCubemap.bindSide(frameBufferCubemap.getSide());
        return true;
    }

    protected void bindSide(Cubemap$CubemapSide cubemap$CubemapSide) {
        Gdx.gl20.glFramebufferTexture2D(36160, 36064, cubemap$CubemapSide.glEnum, ((Cubemap)this.getColorBufferTexture()).getTextureObjectHandle(), 0);
    }

    public Cubemap$CubemapSide getSide() {
        if (this.currentSide < 0) {
            return null;
        }
        return cubemapSides[this.currentSide];
    }
}

