/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.graphics.GLTexture;
import com.badlogic.gdx.graphics.Pixmap$Format;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec;
import com.badlogic.gdx.graphics.glutils.GLFrameBuffer$FrameBufferTextureAttachmentSpec;
import com.badlogic.gdx.utils.Array;

public abstract class GLFrameBuffer$GLFrameBufferBuilder<U extends GLFrameBuffer<? extends GLTexture>> {
    protected int width;
    protected int height;
    protected int samples;
    protected Array<GLFrameBuffer$FrameBufferTextureAttachmentSpec> textureAttachmentSpecs = new Array();
    protected Array<GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec> colorRenderBufferSpecs = new Array();
    protected GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec stencilRenderBufferSpec;
    protected GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec depthRenderBufferSpec;
    protected GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec packedStencilDepthRenderBufferSpec;
    protected boolean hasStencilRenderBuffer;
    protected boolean hasDepthRenderBuffer;
    protected boolean hasPackedStencilDepthRenderBuffer;

    public GLFrameBuffer$GLFrameBufferBuilder(int n2, int n3) {
        this(n2, n3, 0);
    }

    public GLFrameBuffer$GLFrameBufferBuilder(int n2, int n3, int n4) {
        this.width = n2;
        this.height = n3;
        this.samples = n4;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addColorTextureAttachment(int n2, int n3, int n4) {
        this.textureAttachmentSpecs.add(new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, n3, n4));
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addBasicColorTextureAttachment(Pixmap$Format pixmap$Format) {
        int n2 = Pixmap$Format.toGlFormat(pixmap$Format);
        int n3 = Pixmap$Format.toGlType(pixmap$Format);
        int n4 = n2;
        return this.addColorTextureAttachment(n4, n4, n3);
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addFloatAttachment(int n2, int n3, int n4, boolean bl) {
        GLFrameBuffer$FrameBufferTextureAttachmentSpec gLFrameBuffer$FrameBufferTextureAttachmentSpec = new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, n3, n4);
        new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, n3, n4).isFloat = true;
        gLFrameBuffer$FrameBufferTextureAttachmentSpec.isGpuOnly = bl;
        this.textureAttachmentSpecs.add(gLFrameBuffer$FrameBufferTextureAttachmentSpec);
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addDepthTextureAttachment(int n2, int n3) {
        GLFrameBuffer$FrameBufferTextureAttachmentSpec gLFrameBuffer$FrameBufferTextureAttachmentSpec = new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, 6402, n3);
        new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, 6402, n3).isDepth = true;
        this.textureAttachmentSpecs.add(gLFrameBuffer$FrameBufferTextureAttachmentSpec);
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addStencilTextureAttachment(int n2, int n3) {
        GLFrameBuffer$FrameBufferTextureAttachmentSpec gLFrameBuffer$FrameBufferTextureAttachmentSpec = new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, 36128, n3);
        new GLFrameBuffer$FrameBufferTextureAttachmentSpec(n2, 36128, n3).isStencil = true;
        this.textureAttachmentSpecs.add(gLFrameBuffer$FrameBufferTextureAttachmentSpec);
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addDepthRenderBuffer(int n2) {
        this.depthRenderBufferSpec = new GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec(n2);
        this.hasDepthRenderBuffer = true;
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addColorRenderBuffer(int n2) {
        this.colorRenderBufferSpecs.add(new GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec(n2));
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addStencilRenderBuffer(int n2) {
        this.stencilRenderBufferSpec = new GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec(n2);
        this.hasStencilRenderBuffer = true;
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addStencilDepthPackedRenderBuffer(int n2) {
        this.packedStencilDepthRenderBufferSpec = new GLFrameBuffer$FrameBufferRenderBufferAttachmentSpec(n2);
        this.hasPackedStencilDepthRenderBuffer = true;
        return this;
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addBasicDepthRenderBuffer() {
        return this.addDepthRenderBuffer(33189);
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addBasicStencilRenderBuffer() {
        return this.addStencilRenderBuffer(36168);
    }

    public GLFrameBuffer$GLFrameBufferBuilder<U> addBasicStencilDepthPackedRenderBuffer() {
        return this.addStencilDepthPackedRenderBuffer(35056);
    }

    public abstract U build();
}

