/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application$ApplicationType;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.glutils.GLVersion$Type;
import java.util.regex.Pattern;

public class GLVersion {
    private int majorVersion;
    private int minorVersion;
    private int releaseVersion;
    private final String versionString;
    private final String vendorString;
    private final String rendererString;
    private final GLVersion$Type type;
    private final String TAG = "GLVersion";

    public GLVersion(Application$ApplicationType application$ApplicationType, String string, String string2, String string3) {
        this.type = application$ApplicationType == Application$ApplicationType.Android ? GLVersion$Type.GLES : (application$ApplicationType == Application$ApplicationType.iOS ? GLVersion$Type.GLES : (application$ApplicationType == Application$ApplicationType.Desktop ? GLVersion$Type.OpenGL : (application$ApplicationType == Application$ApplicationType.Applet ? GLVersion$Type.OpenGL : (application$ApplicationType == Application$ApplicationType.WebGL ? GLVersion$Type.WebGL : GLVersion$Type.NONE))));
        if (this.type == GLVersion$Type.GLES) {
            this.extractVersion("OpenGL ES (\\d(\\.\\d){0,2})", string);
        } else if (this.type == GLVersion$Type.WebGL) {
            this.extractVersion("WebGL (\\d(\\.\\d){0,2})", string);
        } else if (this.type == GLVersion$Type.OpenGL) {
            this.extractVersion("(\\d(\\.\\d){0,2})", string);
        } else {
            this.majorVersion = -1;
            this.minorVersion = -1;
            this.releaseVersion = -1;
            string2 = "";
            string3 = "";
        }
        this.versionString = string;
        this.vendorString = string2;
        this.rendererString = string3;
    }

    private void extractVersion(String stringArray, String string) {
        stringArray = Pattern.compile((String)stringArray);
        boolean bl = (stringArray = stringArray.matcher(string)).find();
        if (bl) {
            stringArray = stringArray.group(1);
            stringArray = stringArray.split("\\.");
            this.majorVersion = this.parseInt(stringArray[0], 2);
            this.minorVersion = stringArray.length < 2 ? 0 : this.parseInt(stringArray[1], 0);
            this.releaseVersion = stringArray.length < 3 ? 0 : this.parseInt(stringArray[2], 0);
            return;
        }
        Gdx.app.log("GLVersion", "Invalid version string: " + string);
        this.majorVersion = 2;
        this.minorVersion = 0;
        this.releaseVersion = 0;
    }

    private int parseInt(String string, int n2) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Gdx.app.error("libGDX GL", "Error parsing number: " + string + ", assuming: " + n2);
            return n2;
        }
    }

    public GLVersion$Type getType() {
        return this.type;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getReleaseVersion() {
        return this.releaseVersion;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public String getVendorString() {
        return this.vendorString;
    }

    public String getRendererString() {
        return this.rendererString;
    }

    public boolean isVersionEqualToOrHigher(int n2, int n3) {
        return this.majorVersion > n2 || this.majorVersion == n2 && this.minorVersion >= n3;
    }

    public String getDebugVersionString() {
        return "Type: " + (Object)((Object)this.type) + "\nVersion: " + this.majorVersion + ":" + this.minorVersion + ":" + this.releaseVersion + "\nVendor: " + this.vendorString + "\nRenderer: " + this.rendererString;
    }
}

