/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer20;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer$ShapeType;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Disposable;

public class ShapeRenderer
implements Disposable {
    private final ImmediateModeRenderer renderer;
    private boolean matrixDirty = false;
    private final Matrix4 projectionMatrix = new Matrix4();
    private final Matrix4 transformMatrix = new Matrix4();
    private final Matrix4 combinedMatrix = new Matrix4();
    private final Vector2 tmp = new Vector2();
    private final Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private ShapeRenderer$ShapeType shapeType;
    private boolean autoShapeType;
    private float defaultRectLineWidth = 0.75f;

    public ShapeRenderer() {
        this(5000);
    }

    public ShapeRenderer(int n2) {
        this(n2, null);
    }

    public ShapeRenderer(int n2, ShaderProgram shaderProgram) {
        this.renderer = shaderProgram == null ? new ImmediateModeRenderer20(n2, false, true, 0) : new ImmediateModeRenderer20(n2, false, true, 0, shaderProgram);
        this.projectionMatrix.setToOrtho2D(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.matrixDirty = true;
    }

    public void setColor(Color color) {
        this.color.set(color);
    }

    public void setColor(float f2, float f3, float f4, float f5) {
        this.color.set(f2, f3, f4, f5);
    }

    public Color getColor() {
        return this.color;
    }

    public void updateMatrices() {
        this.matrixDirty = true;
    }

    public void setProjectionMatrix(Matrix4 matrix4) {
        this.projectionMatrix.set(matrix4);
        this.matrixDirty = true;
    }

    public Matrix4 getProjectionMatrix() {
        return this.projectionMatrix;
    }

    public void setTransformMatrix(Matrix4 matrix4) {
        this.transformMatrix.set(matrix4);
        this.matrixDirty = true;
    }

    public Matrix4 getTransformMatrix() {
        return this.transformMatrix;
    }

    public void identity() {
        this.transformMatrix.idt();
        this.matrixDirty = true;
    }

    public void translate(float f2, float f3, float f4) {
        this.transformMatrix.translate(f2, f3, f4);
        this.matrixDirty = true;
    }

    public void rotate(float f2, float f3, float f4, float f5) {
        this.transformMatrix.rotate(f2, f3, f4, f5);
        this.matrixDirty = true;
    }

    public void scale(float f2, float f3, float f4) {
        this.transformMatrix.scale(f2, f3, f4);
        this.matrixDirty = true;
    }

    public void setAutoShapeType(boolean bl) {
        this.autoShapeType = bl;
    }

    public void begin() {
        if (!this.autoShapeType) {
            throw new IllegalStateException("autoShapeType must be true to use this method.");
        }
        this.begin(ShapeRenderer$ShapeType.Line);
    }

    public void begin(ShapeRenderer$ShapeType shapeRenderer$ShapeType) {
        if (this.shapeType != null) {
            throw new IllegalStateException("Call end() before beginning a new shape batch.");
        }
        this.shapeType = shapeRenderer$ShapeType;
        if (this.matrixDirty) {
            this.combinedMatrix.set(this.projectionMatrix);
            Matrix4.mul(this.combinedMatrix.val, this.transformMatrix.val);
            this.matrixDirty = false;
        }
        this.renderer.begin(this.combinedMatrix, this.shapeType.getGlType());
    }

    public void set(ShapeRenderer$ShapeType shapeRenderer$ShapeType) {
        if (this.shapeType == shapeRenderer$ShapeType) {
            return;
        }
        if (this.shapeType == null) {
            throw new IllegalStateException("begin must be called first.");
        }
        if (!this.autoShapeType) {
            throw new IllegalStateException("autoShapeType must be enabled.");
        }
        this.end();
        this.begin(shapeRenderer$ShapeType);
    }

    public void point(float f2, float f3, float f4) {
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            float f5 = this.defaultRectLineWidth * 0.5f;
            this.line(f2 - f5, f3 - f5, f4, f2 + f5, f3 + f5, f4);
            return;
        }
        if (this.shapeType == ShapeRenderer$ShapeType.Filled) {
            float f6 = this.defaultRectLineWidth * 0.5f;
            this.box(f2 - f6, f3 - f6, f4 - f6, this.defaultRectLineWidth, this.defaultRectLineWidth, this.defaultRectLineWidth);
            return;
        }
        this.check(ShapeRenderer$ShapeType.Point, null, 1);
        this.renderer.color(this.color);
        this.renderer.vertex(f2, f3, f4);
    }

    public final void line(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.line(f2, f3, f4, f5, f6, f7, this.color, this.color);
    }

    public final void line(Vector3 vector3, Vector3 vector32) {
        this.line(vector3.x, vector3.y, vector3.z, vector32.x, vector32.y, vector32.z, this.color, this.color);
    }

    public final void line(float f2, float f3, float f4, float f5) {
        this.line(f2, f3, 0.0f, f4, f5, 0.0f, this.color, this.color);
    }

    public final void line(Vector2 vector2, Vector2 vector22) {
        this.line(vector2.x, vector2.y, 0.0f, vector22.x, vector22.y, 0.0f, this.color, this.color);
    }

    public final void line(float f2, float f3, float f4, float f5, Color color, Color color2) {
        this.line(f2, f3, 0.0f, f4, f5, 0.0f, color, color2);
    }

    public void line(float f2, float f3, float f4, float f5, float f6, float f7, Color color, Color color2) {
        if (this.shapeType == ShapeRenderer$ShapeType.Filled) {
            this.rectLine(f2, f3, f5, f6, this.defaultRectLineWidth, color, color2);
            return;
        }
        this.check(ShapeRenderer$ShapeType.Line, null, 2);
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f2, f3, f4);
        this.renderer.color(color2.r, color2.g, color2.b, color2.a);
        this.renderer.vertex(f5, f6, f7);
    }

    public void curve(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n2) {
        this.check(ShapeRenderer$ShapeType.Line, null, (n2 << 1) + 2);
        float f10 = this.color.toFloatBits();
        float f11 = 1.0f / (float)n2;
        float f12 = f11 * f11;
        float f13 = f12 * f11;
        f11 = 3.0f * f11;
        float f14 = 3.0f * f12;
        f12 = 6.0f * f12;
        float f15 = 6.0f * f13;
        float f16 = f2 - f4 * 2.0f + f6;
        float f17 = f3 - f5 * 2.0f + f7;
        f6 = (f4 - f6) * 3.0f - f2 + f8;
        f7 = (f5 - f7) * 3.0f - f3 + f9;
        float f18 = f2;
        float f19 = f3;
        f2 = (f4 - f2) * f11 + f16 * f14 + f6 * f13;
        f3 = (f5 - f3) * f11 + f17 * f14 + f7 * f13;
        f4 = f16 * f12 + f6 * f15;
        f5 = f17 * f12 + f7 * f15;
        f6 *= f15;
        f7 *= f15;
        while (n2-- > 0) {
            this.renderer.color(f10);
            this.renderer.vertex(f18, f19, 0.0f);
            f18 += f2;
            f19 += f3;
            f2 += f4;
            f3 += f5;
            f4 += f6;
            f5 += f7;
            this.renderer.color(f10);
            this.renderer.vertex(f18, f19, 0.0f);
        }
        this.renderer.color(f10);
        this.renderer.vertex(f18, f19, 0.0f);
        this.renderer.color(f10);
        this.renderer.vertex(f8, f9, 0.0f);
    }

    public void triangle(float f2, float f3, float f4, float f5, float f6, float f7) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 6);
        float f8 = this.color.toFloatBits();
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4, f5, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4, f5, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, 0.0f);
            return;
        }
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(f8);
        this.renderer.vertex(f4, f5, 0.0f);
        this.renderer.color(f8);
        this.renderer.vertex(f6, f7, 0.0f);
    }

    public void triangle(float f2, float f3, float f4, float f5, float f6, float f7, Color color, Color color2, Color color3) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 6);
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f4, f5, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f4, f5, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f2, f3, 0.0f);
            return;
        }
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(color2.r, color2.g, color2.b, color2.a);
        this.renderer.vertex(f4, f5, 0.0f);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f6, f7, 0.0f);
    }

    public void rect(float f2, float f3, float f4, float f5) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 8);
        float f6 = this.color.toFloatBits();
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(f6);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4, f3, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4, f3, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2, f3 + f5, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2, f3 + f5, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2, f3, 0.0f);
            return;
        }
        this.renderer.color(f6);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(f6);
        this.renderer.vertex(f2 + f4, f3, 0.0f);
        this.renderer.color(f6);
        this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
        this.renderer.color(f6);
        this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
        this.renderer.color(f6);
        this.renderer.vertex(f2, f3 + f5, 0.0f);
        this.renderer.color(f6);
        this.renderer.vertex(f2, f3, 0.0f);
    }

    public void rect(float f2, float f3, float f4, float f5, Color color, Color color2, Color color3, Color color4) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 8);
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f2 + f4, f3, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f2 + f4, f3, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f2, f3 + f5, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f2, f3 + f5, 0.0f);
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f2, f3, 0.0f);
            return;
        }
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(color2.r, color2.g, color2.b, color2.a);
        this.renderer.vertex(f2 + f4, f3, 0.0f);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f2 + f4, f3 + f5, 0.0f);
        this.renderer.color(color4.r, color4.g, color4.b, color4.a);
        this.renderer.vertex(f2, f3 + f5, 0.0f);
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f2, f3, 0.0f);
    }

    public void rect(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.rect(f2, f3, f4, f5, f6, f7, f8, f9, f10, this.color, this.color, this.color, this.color);
    }

    public void rect(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, Color color, Color color2, Color color3, Color color4) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 8);
        float f11 = MathUtils.cosDeg(f10);
        f10 = MathUtils.sinDeg(f10);
        float f12 = -f4;
        float f13 = -f5;
        f6 -= f4;
        f7 -= f5;
        if (f8 != 1.0f || f9 != 1.0f) {
            f12 *= f8;
            f13 *= f9;
            f6 *= f8;
            f7 *= f9;
        }
        f2 += f4;
        f3 += f5;
        f4 = f11 * f12 - f10 * f13 + f2;
        f5 = f10 * f12 + f11 * f13 + f3;
        f8 = f11 * f6 - f10 * f13 + f2;
        f9 = f10 * f6 + f11 * f13 + f3;
        f2 = f11 * f6 - f10 * f7 + f2;
        f3 = f10 * f6 + f11 * f7 + f3;
        f6 = f4 + (f2 - f8);
        f7 = f3 - (f9 - f5);
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f4, f5, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f8, f9, 0.0f);
            this.renderer.color(color2.r, color2.g, color2.b, color2.a);
            this.renderer.vertex(f8, f9, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(color3.r, color3.g, color3.b, color3.a);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(color4.r, color4.g, color4.b, color4.a);
            this.renderer.vertex(f6, f7, 0.0f);
            this.renderer.color(color.r, color.g, color.b, color.a);
            this.renderer.vertex(f4, f5, 0.0f);
            return;
        }
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f4, f5, 0.0f);
        this.renderer.color(color2.r, color2.g, color2.b, color2.a);
        this.renderer.vertex(f8, f9, 0.0f);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(color3.r, color3.g, color3.b, color3.a);
        this.renderer.vertex(f2, f3, 0.0f);
        this.renderer.color(color4.r, color4.g, color4.b, color4.a);
        this.renderer.vertex(f6, f7, 0.0f);
        this.renderer.color(color.r, color.g, color.b, color.a);
        this.renderer.vertex(f4, f5, 0.0f);
    }

    public void rectLine(float f2, float f3, float f4, float f5, float f6) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 8);
        float f7 = this.color.toFloatBits();
        Vector2 vector2 = this.tmp.set(f5 - f3, f2 - f4).nor();
        float f8 = vector2.x * (f6 *= 0.5f);
        f6 = vector2.y * f6;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f8, f3 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 - f8, f3 - f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f4 + f8, f5 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f4 - f8, f5 - f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f4 + f8, f5 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f8, f3 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f4 - f8, f5 - f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 - f8, f3 - f6, 0.0f);
            return;
        }
        this.renderer.color(f7);
        this.renderer.vertex(f2 + f8, f3 + f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f2 - f8, f3 - f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f4 + f8, f5 + f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f4 - f8, f5 - f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f4 + f8, f5 + f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f2 - f8, f3 - f6, 0.0f);
    }

    public void rectLine(float f2, float f3, float f4, float f5, float f6, Color color, Color color2) {
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 8);
        float f7 = color.toFloatBits();
        float f8 = color2.toFloatBits();
        Vector2 vector2 = this.tmp.set(f5 - f3, f2 - f4).nor();
        float f9 = vector2.x * (f6 *= 0.5f);
        f6 = vector2.y * f6;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f9, f3 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 - f9, f3 - f6, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4 + f9, f5 + f6, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4 - f9, f5 - f6, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4 + f9, f5 + f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f9, f3 + f6, 0.0f);
            this.renderer.color(f8);
            this.renderer.vertex(f4 - f9, f5 - f6, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 - f9, f3 - f6, 0.0f);
            return;
        }
        this.renderer.color(f7);
        this.renderer.vertex(f2 + f9, f3 + f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f2 - f9, f3 - f6, 0.0f);
        this.renderer.color(f8);
        this.renderer.vertex(f4 + f9, f5 + f6, 0.0f);
        this.renderer.color(f8);
        this.renderer.vertex(f4 - f9, f5 - f6, 0.0f);
        this.renderer.color(f8);
        this.renderer.vertex(f4 + f9, f5 + f6, 0.0f);
        this.renderer.color(f7);
        this.renderer.vertex(f2 - f9, f3 - f6, 0.0f);
    }

    public void rectLine(Vector2 vector2, Vector2 vector22, float f2) {
        this.rectLine(vector2.x, vector2.y, vector22.x, vector22.y, f2);
    }

    public void box(float f2, float f3, float f4, float f5, float f6, float f7) {
        f7 = -f7;
        float f8 = this.color.toFloatBits();
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 24);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4 + f7);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3 + f6, f4 + f7);
            return;
        }
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, 36);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3 + f6, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4 + f7);
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3, f4);
        this.renderer.color(f8);
        this.renderer.vertex(f2, f3, f4);
    }

    public void x(float f2, float f3, float f4) {
        this.line(f2 - f4, f3 - f4, f2 + f4, f3 + f4);
        this.line(f2 - f4, f3 + f4, f2 + f4, f3 - f4);
    }

    public void x(Vector2 vector2, float f2) {
        this.x(vector2.x, vector2.y, f2);
    }

    public void arc(float f2, float f3, float f4, float f5, float f6) {
        this.arc(f2, f3, f4, f5, f6, Math.max(1, (int)(6.0f * (float)Math.cbrt(f4) * (f6 / 360.0f))));
    }

    public void arc(float f2, float f3, float f4, float f5, float f6, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        float f7 = this.color.toFloatBits();
        f6 = (float)Math.PI * 2 * (f6 / 360.0f) / (float)n2;
        float f8 = MathUtils.cos(f6);
        f6 = MathUtils.sin(f6);
        float f9 = f4 * MathUtils.cos(f5 * ((float)Math.PI / 180));
        f4 *= MathUtils.sin(f5 * ((float)Math.PI / 180));
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, (n2 << 1) + 2);
            this.renderer.color(f7);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
                float f10 = f9;
                f9 = f8 * f9 - f6 * f4;
                f4 = f6 * f10 + f8 * f4;
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
            }
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
        } else {
            this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, n2 * 3 + 3);
            for (int i3 = 0; i3 < n2; ++i3) {
                this.renderer.color(f7);
                this.renderer.vertex(f2, f3, 0.0f);
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
                float f11 = f9;
                f9 = f8 * f9 - f6 * f4;
                f4 = f6 * f11 + f8 * f4;
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
            }
            this.renderer.color(f7);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f9, f3 + f4, 0.0f);
        }
        this.renderer.color(f7);
        this.renderer.vertex(f2 + 0.0f, f3 + 0.0f, 0.0f);
    }

    public void circle(float f2, float f3, float f4) {
        this.circle(f2, f3, f4, Math.max(1, (int)(6.0f * (float)Math.cbrt(f4))));
    }

    public void circle(float f2, float f3, float f4, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        float f5 = this.color.toFloatBits();
        float f6 = (float)Math.PI * 2 / (float)n2;
        float f7 = MathUtils.cos(f6);
        f6 = MathUtils.sin(f6);
        float f8 = f4;
        float f9 = 0.0f;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, (n2 << 1) + 2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.renderer.color(f5);
                this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
                float f10 = f8;
                f8 = f7 * f8 - f6 * f9;
                f9 = f6 * f10 + f7 * f9;
                this.renderer.color(f5);
                this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
            }
            this.renderer.color(f5);
            this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
        } else {
            this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, n2 * 3 + 3);
            --n2;
            for (int i3 = 0; i3 < n2; ++i3) {
                this.renderer.color(f5);
                this.renderer.vertex(f2, f3, 0.0f);
                this.renderer.color(f5);
                this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
                float f11 = f8;
                f8 = f7 * f8 - f6 * f9;
                f9 = f6 * f11 + f7 * f9;
                this.renderer.color(f5);
                this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
            }
            this.renderer.color(f5);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f5);
            this.renderer.vertex(f2 + f8, f3 + f9, 0.0f);
        }
        this.renderer.color(f5);
        this.renderer.vertex(f2 + f4, f3 + 0.0f, 0.0f);
    }

    public void ellipse(float f2, float f3, float f4, float f5) {
        this.ellipse(f2, f3, f4, f5, Math.max(1, (int)(12.0f * (float)Math.cbrt(Math.max(f4 * 0.5f, f5 * 0.5f)))));
    }

    public void ellipse(float f2, float f3, float f4, float f5, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, n2 * 3);
        float f6 = this.color.toFloatBits();
        float f7 = (float)Math.PI * 2 / (float)n2;
        f2 += f4 / 2.0f;
        f3 += f5 / 2.0f;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.renderer.color(f6);
                this.renderer.vertex(f2 + f4 * 0.5f * MathUtils.cos((float)i2 * f7), f3 + f5 * 0.5f * MathUtils.sin((float)i2 * f7), 0.0f);
                this.renderer.color(f6);
                this.renderer.vertex(f2 + f4 * 0.5f * MathUtils.cos((float)(i2 + 1) * f7), f3 + f5 * 0.5f * MathUtils.sin((float)(i2 + 1) * f7), 0.0f);
            }
            return;
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4 * 0.5f * MathUtils.cos((float)i3 * f7), f3 + f5 * 0.5f * MathUtils.sin((float)i3 * f7), 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2, f3, 0.0f);
            this.renderer.color(f6);
            this.renderer.vertex(f2 + f4 * 0.5f * MathUtils.cos((float)(i3 + 1) * f7), f3 + f5 * 0.5f * MathUtils.sin((float)(i3 + 1) * f7), 0.0f);
        }
    }

    public void ellipse(float f2, float f3, float f4, float f5, float f6) {
        this.ellipse(f2, f3, f4, f5, f6, Math.max(1, (int)(12.0f * (float)Math.cbrt(Math.max(f4 * 0.5f, f5 * 0.5f)))));
    }

    public void ellipse(float f2, float f3, float f4, float f5, float f6, int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, n2 * 3);
        float f7 = this.color.toFloatBits();
        float f8 = (float)Math.PI * 2 / (float)n2;
        f6 = (float)Math.PI * f6 / 180.0f;
        float f9 = MathUtils.sin(f6);
        f6 = MathUtils.cos(f6);
        f2 += f4 / 2.0f;
        f3 += f5 / 2.0f;
        float f10 = f4 * 0.5f;
        float f11 = 0.0f;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f6 * f10 - f9 * f11, f3 + f9 * f10 + f6 * f11, 0.0f);
                f10 = f4 * 0.5f * MathUtils.cos((float)(i2 + 1) * f8);
                f11 = f5 * 0.5f * MathUtils.sin((float)(i2 + 1) * f8);
                this.renderer.color(f7);
                this.renderer.vertex(f2 + f6 * f10 - f9 * f11, f3 + f9 * f10 + f6 * f11, 0.0f);
            }
            return;
        }
        for (int i3 = 0; i3 < n2; ++i3) {
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f6 * f10 - f9 * f11, f3 + f9 * f10 + f6 * f11, 0.0f);
            this.renderer.color(f7);
            this.renderer.vertex(f2, f3, 0.0f);
            f10 = f4 * 0.5f * MathUtils.cos((float)(i3 + 1) * f8);
            f11 = f5 * 0.5f * MathUtils.sin((float)(i3 + 1) * f8);
            this.renderer.color(f7);
            this.renderer.vertex(f2 + f6 * f10 - f9 * f11, f3 + f9 * f10 + f6 * f11, 0.0f);
        }
    }

    public void cone(float f2, float f3, float f4, float f5, float f6) {
        this.cone(f2, f3, f4, f5, f6, Math.max(1, (int)(4.0f * (float)Math.sqrt(f5))));
    }

    public void cone(float f2, float f3, float f4, float f5, float f6, int n2) {
        float f7;
        int n3;
        if (n2 <= 0) {
            throw new IllegalArgumentException("segments must be > 0.");
        }
        this.check(ShapeRenderer$ShapeType.Line, ShapeRenderer$ShapeType.Filled, (n2 << 2) + 2);
        float f8 = this.color.toFloatBits();
        float f9 = (float)Math.PI * 2 / (float)n2;
        float f10 = MathUtils.cos(f9);
        f9 = MathUtils.sin(f9);
        float f11 = f5;
        float f12 = 0.0f;
        if (this.shapeType == ShapeRenderer$ShapeType.Line) {
            for (n3 = 0; n3 < n2; ++n3) {
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
                this.renderer.color(f8);
                this.renderer.vertex(f2, f3, f4 + f6);
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
                f7 = f11;
                f11 = f10 * f11 - f9 * f12;
                f12 = f9 * f7 + f10 * f12;
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
            }
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f11, f3 + f12, f4);
        } else {
            --n2;
            for (n3 = 0; n3 < n2; ++n3) {
                this.renderer.color(f8);
                this.renderer.vertex(f2, f3, f4);
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
                f7 = f11;
                float f13 = f12;
                f11 = f10 * f11 - f9 * f12;
                f12 = f9 * f7 + f10 * f12;
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f7, f3 + f13, f4);
                this.renderer.color(f8);
                this.renderer.vertex(f2 + f11, f3 + f12, f4);
                this.renderer.color(f8);
                this.renderer.vertex(f2, f3, f4 + f6);
            }
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f11, f3 + f12, f4);
        }
        float f14 = f11;
        f7 = f12;
        this.renderer.color(f8);
        this.renderer.vertex(f2 + f5, f3 + 0.0f, f4);
        if (this.shapeType != ShapeRenderer$ShapeType.Line) {
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f14, f3 + f7, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2 + f5, f3 + 0.0f, f4);
            this.renderer.color(f8);
            this.renderer.vertex(f2, f3, f4 + f6);
        }
    }

    public void polygon(float[] fArray, int n2, int n3) {
        if (n3 < 6) {
            throw new IllegalArgumentException("Polygons must contain at least 3 points.");
        }
        if (n3 % 2 != 0) {
            throw new IllegalArgumentException("Polygons must have an even number of vertices.");
        }
        this.check(ShapeRenderer$ShapeType.Line, null, n3);
        float f2 = this.color.toFloatBits();
        float f3 = fArray[0];
        float f4 = fArray[1];
        int n4 = n2;
        n2 += n3;
        while (n4 < n2) {
            float f5;
            float f6;
            float f7 = fArray[n4];
            float f8 = fArray[n4 + 1];
            if (n4 + 2 >= n3) {
                f6 = f3;
                f5 = f4;
            } else {
                f6 = fArray[n4 + 2];
                f5 = fArray[n4 + 3];
            }
            this.renderer.color(f2);
            this.renderer.vertex(f7, f8, 0.0f);
            this.renderer.color(f2);
            this.renderer.vertex(f6, f5, 0.0f);
            n4 += 2;
        }
    }

    public void polygon(float[] fArray) {
        this.polygon(fArray, 0, fArray.length);
    }

    public void polyline(float[] fArray, int n2, int n3) {
        if (n3 < 4) {
            throw new IllegalArgumentException("Polylines must contain at least 2 points.");
        }
        if (n3 % 2 != 0) {
            throw new IllegalArgumentException("Polylines must have an even number of vertices.");
        }
        this.check(ShapeRenderer$ShapeType.Line, null, n3);
        float f2 = this.color.toFloatBits();
        int n4 = n2;
        n2 = n2 + n3 - 2;
        while (n4 < n2) {
            float f3 = fArray[n4];
            float f4 = fArray[n4 + 1];
            float f5 = fArray[n4 + 2];
            float f6 = fArray[n4 + 3];
            this.renderer.color(f2);
            this.renderer.vertex(f3, f4, 0.0f);
            this.renderer.color(f2);
            this.renderer.vertex(f5, f6, 0.0f);
            n4 += 2;
        }
    }

    public void polyline(float[] fArray) {
        this.polyline(fArray, 0, fArray.length);
    }

    protected final void check(ShapeRenderer$ShapeType shapeRenderer$ShapeType, ShapeRenderer$ShapeType shapeRenderer$ShapeType2, int n2) {
        if (this.shapeType == null) {
            throw new IllegalStateException("begin must be called first.");
        }
        if (this.shapeType != shapeRenderer$ShapeType && this.shapeType != shapeRenderer$ShapeType2) {
            if (!this.autoShapeType) {
                if (shapeRenderer$ShapeType2 == null) {
                    throw new IllegalStateException("Must call begin(ShapeType." + (Object)((Object)shapeRenderer$ShapeType) + ").");
                }
                throw new IllegalStateException("Must call begin(ShapeType." + (Object)((Object)shapeRenderer$ShapeType) + ") or begin(ShapeType." + (Object)((Object)shapeRenderer$ShapeType2) + ").");
            }
            this.end();
            this.begin(shapeRenderer$ShapeType);
            return;
        }
        if (this.matrixDirty) {
            shapeRenderer$ShapeType = this.shapeType;
            this.end();
            this.begin(shapeRenderer$ShapeType);
            return;
        }
        if (this.renderer.getMaxVertices() - this.renderer.getNumVertices() < n2) {
            shapeRenderer$ShapeType = this.shapeType;
            this.end();
            this.begin(shapeRenderer$ShapeType);
        }
    }

    public void end() {
        this.renderer.end();
        this.shapeType = null;
    }

    public void flush() {
        ShapeRenderer$ShapeType shapeRenderer$ShapeType = this.shapeType;
        if (shapeRenderer$ShapeType == null) {
            return;
        }
        this.end();
        this.begin(shapeRenderer$ShapeType);
    }

    public ShapeRenderer$ShapeType getCurrentType() {
        return this.shapeType;
    }

    public ImmediateModeRenderer getRenderer() {
        return this.renderer;
    }

    public boolean isDrawing() {
        return this.shapeType != null;
    }

    @Override
    public void dispose() {
        this.renderer.dispose();
    }
}

