/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.profiling;

import com.badlogic.gdx.graphics.GL31;
import com.badlogic.gdx.graphics.profiling.GL30Interceptor;
import com.badlogic.gdx.graphics.profiling.GLProfiler;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class GL31Interceptor
extends GL30Interceptor
implements GL31 {
    final GL31 gl31;

    public GL31Interceptor(GLProfiler gLProfiler, GL31 gL31) {
        super(gLProfiler, gL31);
        this.gl31 = gL31;
    }

    protected void check() {
        int n2 = this.gl30.glGetError();
        while (n2 != 0) {
            this.glProfiler.getListener().onError(n2);
            n2 = this.gl30.glGetError();
        }
    }

    @Override
    public void glDispatchCompute(int n2, int n3, int n4) {
        ++this.calls;
        this.gl31.glDispatchCompute(n2, n3, n4);
        this.check();
    }

    @Override
    public void glDispatchComputeIndirect(long l2) {
        ++this.calls;
        this.gl31.glDispatchComputeIndirect(l2);
        this.check();
    }

    @Override
    public void glDrawArraysIndirect(int n2, long l2) {
        ++this.drawCalls;
        ++this.calls;
        this.gl31.glDrawArraysIndirect(n2, l2);
        this.check();
    }

    @Override
    public void glDrawElementsIndirect(int n2, int n3, long l2) {
        ++this.drawCalls;
        ++this.calls;
        this.gl31.glDrawElementsIndirect(n2, n3, l2);
        this.check();
    }

    @Override
    public void glFramebufferParameteri(int n2, int n3, int n4) {
        ++this.calls;
        this.gl31.glFramebufferParameteri(n2, n3, n4);
        this.check();
    }

    @Override
    public void glGetFramebufferParameteriv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGetFramebufferParameteriv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glGetProgramInterfaceiv(int n2, int n3, int n4, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGetProgramInterfaceiv(n2, n3, n4, intBuffer);
        this.check();
    }

    @Override
    public int glGetProgramResourceIndex(int n2, int n3, String string) {
        ++this.calls;
        n2 = this.gl31.glGetProgramResourceIndex(n2, n3, string);
        this.check();
        return n2;
    }

    @Override
    public String glGetProgramResourceName(int n2, int n3, int n4) {
        ++this.calls;
        String string = this.gl31.glGetProgramResourceName(n2, n3, n4);
        this.check();
        return string;
    }

    @Override
    public void glGetProgramResourceiv(int n2, int n3, int n4, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3) {
        ++this.calls;
        this.gl31.glGetProgramResourceiv(n2, n3, n4, intBuffer, intBuffer2, intBuffer3);
        this.check();
    }

    @Override
    public int glGetProgramResourceLocation(int n2, int n3, String string) {
        ++this.calls;
        n2 = this.gl31.glGetProgramResourceLocation(n2, n3, string);
        this.check();
        return n2;
    }

    @Override
    public void glUseProgramStages(int n2, int n3, int n4) {
        ++this.calls;
        this.gl31.glUseProgramStages(n2, n3, n4);
        this.check();
    }

    @Override
    public void glActiveShaderProgram(int n2, int n3) {
        ++this.calls;
        this.gl31.glActiveShaderProgram(n2, n3);
        this.check();
    }

    @Override
    public int glCreateShaderProgramv(int n2, String[] stringArray) {
        ++this.calls;
        n2 = this.gl31.glCreateShaderProgramv(n2, stringArray);
        this.check();
        return n2;
    }

    @Override
    public void glBindProgramPipeline(int n2) {
        ++this.calls;
        this.gl31.glBindProgramPipeline(n2);
        this.check();
    }

    @Override
    public void glDeleteProgramPipelines(int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glDeleteProgramPipelines(n2, intBuffer);
        this.check();
    }

    @Override
    public void glGenProgramPipelines(int n2, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGenProgramPipelines(n2, intBuffer);
        this.check();
    }

    @Override
    public boolean glIsProgramPipeline(int n2) {
        ++this.calls;
        n2 = this.gl31.glIsProgramPipeline(n2) ? 1 : 0;
        this.check();
        return n2 != 0;
    }

    @Override
    public void glGetProgramPipelineiv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGetProgramPipelineiv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform1i(int n2, int n3, int n4) {
        ++this.calls;
        this.gl31.glProgramUniform1i(n2, n3, n4);
        this.check();
    }

    @Override
    public void glProgramUniform2i(int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl31.glProgramUniform2i(n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glProgramUniform3i(int n2, int n3, int n4, int n5, int n6) {
        ++this.calls;
        this.gl31.glProgramUniform3i(n2, n3, n4, n5, n6);
        this.check();
    }

    @Override
    public void glProgramUniform4i(int n2, int n3, int n4, int n5, int n6, int n7) {
        ++this.calls;
        this.gl31.glProgramUniform4i(n2, n3, n4, n5, n6, n7);
        this.check();
    }

    @Override
    public void glProgramUniform1ui(int n2, int n3, int n4) {
        ++this.calls;
        this.gl31.glProgramUniform1ui(n2, n3, n4);
        this.check();
    }

    @Override
    public void glProgramUniform2ui(int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl31.glProgramUniform2ui(n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glProgramUniform3ui(int n2, int n3, int n4, int n5, int n6) {
        ++this.calls;
        this.gl31.glProgramUniform3ui(n2, n3, n4, n5, n6);
        this.check();
    }

    @Override
    public void glProgramUniform4ui(int n2, int n3, int n4, int n5, int n6, int n7) {
        ++this.calls;
        this.gl31.glProgramUniform4ui(n2, n3, n4, n5, n6, n7);
        this.check();
    }

    @Override
    public void glProgramUniform1f(int n2, int n3, float f2) {
        ++this.calls;
        this.gl31.glProgramUniform1f(n2, n3, f2);
        this.check();
    }

    @Override
    public void glProgramUniform2f(int n2, int n3, float f2, float f3) {
        ++this.calls;
        this.gl31.glProgramUniform2f(n2, n3, f2, f3);
        this.check();
    }

    @Override
    public void glProgramUniform3f(int n2, int n3, float f2, float f3, float f4) {
        ++this.calls;
        this.gl31.glProgramUniform3f(n2, n3, f2, f3, f4);
        this.check();
    }

    @Override
    public void glProgramUniform4f(int n2, int n3, float f2, float f3, float f4, float f5) {
        ++this.calls;
        this.gl31.glProgramUniform4f(n2, n3, f2, f3, f4, f5);
        this.check();
    }

    @Override
    public void glProgramUniform1iv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform1iv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform2iv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform2iv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform3iv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform3iv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform4iv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform4iv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform1uiv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform1uiv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform2uiv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform2uiv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform3uiv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform3uiv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform4uiv(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform4uiv(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform1fv(int n2, int n3, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform1fv(n2, n3, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform2fv(int n2, int n3, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform2fv(n2, n3, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform3fv(int n2, int n3, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform3fv(n2, n3, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniform4fv(int n2, int n3, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniform4fv(n2, n3, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix2fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix3fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix4fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix2x3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix2x3fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix3x2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix3x2fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix2x4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix2x4fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix4x2fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix4x2fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix3x4fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix3x4fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glProgramUniformMatrix4x3fv(int n2, int n3, boolean bl, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glProgramUniformMatrix4x3fv(n2, n3, bl, floatBuffer);
        this.check();
    }

    @Override
    public void glValidateProgramPipeline(int n2) {
        ++this.calls;
        this.gl31.glValidateProgramPipeline(n2);
        this.check();
    }

    @Override
    public String glGetProgramPipelineInfoLog(int n2) {
        ++this.calls;
        String string = this.gl31.glGetProgramPipelineInfoLog(n2);
        this.check();
        return string;
    }

    @Override
    public void glBindImageTexture(int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        ++this.calls;
        this.gl31.glBindImageTexture(n2, n3, n4, bl, n5, n6, n7);
        this.check();
    }

    @Override
    public void glGetBooleani_v(int n2, int n3, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGetBooleani_v(n2, n3, intBuffer);
        this.check();
    }

    @Override
    public void glMemoryBarrier(int n2) {
        ++this.calls;
        this.gl31.glMemoryBarrier(n2);
        this.check();
    }

    @Override
    public void glMemoryBarrierByRegion(int n2) {
        ++this.calls;
        this.gl31.glMemoryBarrierByRegion(n2);
        this.check();
    }

    @Override
    public void glTexStorage2DMultisample(int n2, int n3, int n4, int n5, int n6, boolean bl) {
        ++this.calls;
        this.gl31.glTexStorage2DMultisample(n2, n3, n4, n5, n6, bl);
        this.check();
    }

    @Override
    public void glGetMultisamplefv(int n2, int n3, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glGetMultisamplefv(n2, n3, floatBuffer);
        this.check();
    }

    @Override
    public void glSampleMaski(int n2, int n3) {
        ++this.calls;
        this.gl31.glSampleMaski(n2, n3);
        this.check();
    }

    @Override
    public void glGetTexLevelParameteriv(int n2, int n3, int n4, IntBuffer intBuffer) {
        ++this.calls;
        this.gl31.glGetTexLevelParameteriv(n2, n3, n4, intBuffer);
        this.check();
    }

    @Override
    public void glGetTexLevelParameterfv(int n2, int n3, int n4, FloatBuffer floatBuffer) {
        ++this.calls;
        this.gl31.glGetTexLevelParameterfv(n2, n3, n4, floatBuffer);
        this.check();
    }

    @Override
    public void glBindVertexBuffer(int n2, int n3, long l2, int n4) {
        ++this.calls;
        this.gl31.glBindVertexBuffer(n2, n3, l2, n4);
        this.check();
    }

    @Override
    public void glVertexAttribFormat(int n2, int n3, int n4, boolean bl, int n5) {
        ++this.calls;
        this.gl31.glVertexAttribFormat(n2, n3, n4, bl, n5);
        this.check();
    }

    @Override
    public void glVertexAttribIFormat(int n2, int n3, int n4, int n5) {
        ++this.calls;
        this.gl31.glVertexAttribIFormat(n2, n3, n4, n5);
        this.check();
    }

    @Override
    public void glVertexAttribBinding(int n2, int n3) {
        ++this.calls;
        this.gl31.glVertexAttribBinding(n2, n3);
        this.check();
    }

    @Override
    public void glVertexBindingDivisor(int n2, int n3) {
        ++this.calls;
        this.gl31.glVertexBindingDivisor(n2, n3);
        this.check();
    }
}

