/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

class GestureDetector$VelocityTracker {
    int sampleSize = 10;
    float lastX;
    float lastY;
    float deltaX;
    float deltaY;
    long lastTime;
    int numSamples;
    float[] meanX = new float[this.sampleSize];
    float[] meanY = new float[this.sampleSize];
    long[] meanTime = new long[this.sampleSize];

    GestureDetector$VelocityTracker() {
    }

    public void start(float f2, float f3, long l2) {
        this.lastX = f2;
        this.lastY = f3;
        this.deltaX = 0.0f;
        this.deltaY = 0.0f;
        this.numSamples = 0;
        for (int i2 = 0; i2 < this.sampleSize; ++i2) {
            this.meanX[i2] = 0.0f;
            this.meanY[i2] = 0.0f;
            this.meanTime[i2] = 0L;
        }
        this.lastTime = l2;
    }

    public void update(float f2, float f3, long l2) {
        this.deltaX = f2 - this.lastX;
        this.deltaY = f3 - this.lastY;
        this.lastX = f2;
        this.lastY = f3;
        long l3 = l2 - this.lastTime;
        this.lastTime = l2;
        int n2 = this.numSamples % this.sampleSize;
        this.meanX[n2] = this.deltaX;
        this.meanY[n2] = this.deltaY;
        this.meanTime[n2] = l3;
        ++this.numSamples;
    }

    public float getVelocityX() {
        GestureDetector$VelocityTracker gestureDetector$VelocityTracker = this;
        float f2 = gestureDetector$VelocityTracker.getAverage(gestureDetector$VelocityTracker.meanX, this.numSamples);
        GestureDetector$VelocityTracker gestureDetector$VelocityTracker2 = this;
        float f3 = (float)gestureDetector$VelocityTracker2.getAverage(gestureDetector$VelocityTracker2.meanTime, this.numSamples) / 1.0E9f;
        if (f3 == 0.0f) {
            return 0.0f;
        }
        return f2 / f3;
    }

    public float getVelocityY() {
        GestureDetector$VelocityTracker gestureDetector$VelocityTracker = this;
        float f2 = gestureDetector$VelocityTracker.getAverage(gestureDetector$VelocityTracker.meanY, this.numSamples);
        GestureDetector$VelocityTracker gestureDetector$VelocityTracker2 = this;
        float f3 = (float)gestureDetector$VelocityTracker2.getAverage(gestureDetector$VelocityTracker2.meanTime, this.numSamples) / 1.0E9f;
        if (f3 == 0.0f) {
            return 0.0f;
        }
        return f2 / f3;
    }

    private float getAverage(float[] fArray, int n2) {
        n2 = Math.min(this.sampleSize, n2);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += fArray[i2];
        }
        return f2 / (float)n2;
    }

    private long getAverage(long[] lArray, int n2) {
        n2 = Math.min(this.sampleSize, n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            l2 += lArray[i2];
        }
        if (n2 == 0) {
            return 0L;
        }
        return l2 / (long)n2;
    }

    private float getSum(float[] fArray, int n2) {
        n2 = Math.min(this.sampleSize, n2);
        float f2 = 0.0f;
        for (int i2 = 0; i2 < n2; ++i2) {
            f2 += fArray[i2];
        }
        if (n2 == 0) {
            return 0.0f;
        }
        return f2;
    }
}

