/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.input.GestureDetector$1;
import com.badlogic.gdx.input.GestureDetector$GestureListener;
import com.badlogic.gdx.input.GestureDetector$VelocityTracker;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.TimeUtils;
import com.badlogic.gdx.utils.Timer;
import com.badlogic.gdx.utils.Timer$Task;

public class GestureDetector
extends InputAdapter {
    final GestureDetector$GestureListener listener;
    private float tapRectangleWidth;
    private float tapRectangleHeight;
    private long tapCountInterval;
    private float longPressSeconds;
    private long maxFlingDelay;
    private boolean inTapRectangle;
    private int tapCount;
    private long lastTapTime;
    private float lastTapX;
    private float lastTapY;
    private int lastTapButton;
    private int lastTapPointer;
    boolean longPressFired;
    private boolean pinching;
    private boolean panning;
    private final GestureDetector$VelocityTracker tracker;
    private float tapRectangleCenterX;
    private float tapRectangleCenterY;
    private long touchDownTime;
    Vector2 pointer1;
    private final Vector2 pointer2;
    private final Vector2 initialPointer1;
    private final Vector2 initialPointer2;
    private final Timer$Task longPressTask;

    public GestureDetector(GestureDetector$GestureListener gestureDetector$GestureListener) {
        this(20.0f, 0.4f, 1.1f, 2.1474836E9f, gestureDetector$GestureListener);
    }

    public GestureDetector(float f2, float f3, float f4, float f5, GestureDetector$GestureListener gestureDetector$GestureListener) {
        float f6 = f2;
        this(f6, f6, f3, f4, f5, gestureDetector$GestureListener);
    }

    public GestureDetector(float f2, float f3, float f4, float f5, float f6, GestureDetector$GestureListener gestureDetector$GestureListener) {
        this.tracker = new GestureDetector$VelocityTracker();
        this.pointer1 = new Vector2();
        this.pointer2 = new Vector2();
        this.initialPointer1 = new Vector2();
        this.initialPointer2 = new Vector2();
        this.longPressTask = new GestureDetector$1(this);
        if (gestureDetector$GestureListener == null) {
            throw new IllegalArgumentException("listener cannot be null.");
        }
        this.tapRectangleWidth = f2;
        this.tapRectangleHeight = f3;
        this.tapCountInterval = (long)(f4 * 1.0E9f);
        this.longPressSeconds = f5;
        this.maxFlingDelay = (long)(f6 * 1.0E9f);
        this.listener = gestureDetector$GestureListener;
    }

    @Override
    public boolean touchDown(int n2, int n3, int n4, int n5) {
        return this.touchDown((float)n2, (float)n3, n4, n5);
    }

    public boolean touchDown(float f2, float f3, int n2, int n3) {
        if (n2 > 1) {
            return false;
        }
        if (n2 == 0) {
            this.pointer1.set(f2, f3);
            this.touchDownTime = Gdx.input.getCurrentEventTime();
            this.tracker.start(f2, f3, this.touchDownTime);
            if (Gdx.input.isTouched(1)) {
                this.inTapRectangle = false;
                this.pinching = true;
                this.initialPointer1.set(this.pointer1);
                this.initialPointer2.set(this.pointer2);
                this.longPressTask.cancel();
            } else {
                this.inTapRectangle = true;
                this.pinching = false;
                this.longPressFired = false;
                this.tapRectangleCenterX = f2;
                this.tapRectangleCenterY = f3;
                if (!this.longPressTask.isScheduled()) {
                    Timer.schedule(this.longPressTask, this.longPressSeconds);
                }
            }
        } else {
            this.pointer2.set(f2, f3);
            this.inTapRectangle = false;
            this.pinching = true;
            this.initialPointer1.set(this.pointer1);
            this.initialPointer2.set(this.pointer2);
            this.longPressTask.cancel();
        }
        return this.listener.touchDown(f2, f3, n2, n3);
    }

    @Override
    public boolean touchDragged(int n2, int n3, int n4) {
        return this.touchDragged((float)n2, (float)n3, n4);
    }

    public boolean touchDragged(float f2, float f3, int n2) {
        if (n2 > 1) {
            return false;
        }
        if (this.longPressFired) {
            return false;
        }
        if (n2 == 0) {
            this.pointer1.set(f2, f3);
        } else {
            this.pointer2.set(f2, f3);
        }
        if (this.pinching) {
            boolean bl = this.listener.pinch(this.initialPointer1, this.initialPointer2, this.pointer1, this.pointer2);
            return this.listener.zoom(this.initialPointer1.dst(this.initialPointer2), this.pointer1.dst(this.pointer2)) || bl;
        }
        this.tracker.update(f2, f3, Gdx.input.getCurrentEventTime());
        if (this.inTapRectangle && !this.isWithinTapRectangle(f2, f3, this.tapRectangleCenterX, this.tapRectangleCenterY)) {
            this.longPressTask.cancel();
            this.inTapRectangle = false;
        }
        if (!this.inTapRectangle) {
            this.panning = true;
            return this.listener.pan(f2, f3, this.tracker.deltaX, this.tracker.deltaY);
        }
        return false;
    }

    @Override
    public boolean touchUp(int n2, int n3, int n4, int n5) {
        return this.touchUp((float)n2, (float)n3, n4, n5);
    }

    public boolean touchUp(float f2, float f3, int n2, int n3) {
        long l2;
        if (n2 > 1) {
            return false;
        }
        if (this.inTapRectangle && !this.isWithinTapRectangle(f2, f3, this.tapRectangleCenterX, this.tapRectangleCenterY)) {
            this.inTapRectangle = false;
        }
        boolean bl = this.panning;
        this.panning = false;
        this.longPressTask.cancel();
        if (this.longPressFired) {
            return false;
        }
        if (this.inTapRectangle) {
            if (this.lastTapButton != n3 || this.lastTapPointer != n2 || TimeUtils.nanoTime() - this.lastTapTime > this.tapCountInterval || !this.isWithinTapRectangle(f2, f3, this.lastTapX, this.lastTapY)) {
                this.tapCount = 0;
            }
            ++this.tapCount;
            this.lastTapTime = TimeUtils.nanoTime();
            this.lastTapX = f2;
            this.lastTapY = f3;
            this.lastTapButton = n3;
            this.lastTapPointer = n2;
            this.touchDownTime = 0L;
            return this.listener.tap(f2, f3, this.tapCount, n3);
        }
        if (this.pinching) {
            this.pinching = false;
            this.listener.pinchStop();
            this.panning = true;
            if (n2 == 0) {
                this.tracker.start(this.pointer2.x, this.pointer2.y, Gdx.input.getCurrentEventTime());
            } else {
                this.tracker.start(this.pointer1.x, this.pointer1.y, Gdx.input.getCurrentEventTime());
            }
            return false;
        }
        boolean bl2 = false;
        if (bl && !this.panning) {
            bl2 = this.listener.panStop(f2, f3, n2, n3);
        }
        if ((l2 = Gdx.input.getCurrentEventTime()) - this.touchDownTime <= this.maxFlingDelay) {
            this.tracker.update(f2, f3, l2);
            bl2 = this.listener.fling(this.tracker.getVelocityX(), this.tracker.getVelocityY(), n3) || bl2;
        }
        this.touchDownTime = 0L;
        return bl2;
    }

    @Override
    public boolean touchCancelled(int n2, int n3, int n4, int n5) {
        this.cancel();
        return super.touchCancelled(n2, n3, n4, n5);
    }

    public void cancel() {
        this.longPressTask.cancel();
        this.longPressFired = true;
    }

    public boolean isLongPressed() {
        GestureDetector gestureDetector = this;
        return gestureDetector.isLongPressed(gestureDetector.longPressSeconds);
    }

    public boolean isLongPressed(float f2) {
        if (this.touchDownTime == 0L) {
            return false;
        }
        return TimeUtils.nanoTime() - this.touchDownTime > (long)(f2 * 1.0E9f);
    }

    public boolean isPanning() {
        return this.panning;
    }

    public void reset() {
        this.longPressTask.cancel();
        this.touchDownTime = 0L;
        this.panning = false;
        this.inTapRectangle = false;
        this.tracker.lastTime = 0L;
    }

    private boolean isWithinTapRectangle(float f2, float f3, float f4, float f5) {
        return Math.abs(f2 - f4) < this.tapRectangleWidth && Math.abs(f3 - f5) < this.tapRectangleHeight;
    }

    public void invalidateTapSquare() {
        this.inTapRectangle = false;
    }

    public void setTapSquareSize(float f2) {
        float f3 = f2;
        this.setTapRectangleSize(f3, f3);
    }

    public void setTapRectangleSize(float f2, float f3) {
        this.tapRectangleWidth = f2;
        this.tapRectangleHeight = f3;
    }

    public void setTapCountInterval(float f2) {
        this.tapCountInterval = (long)(f2 * 1.0E9f);
    }

    public void setLongPressSeconds(float f2) {
        this.longPressSeconds = f2;
    }

    public void setMaxFlingDelay(long l2) {
        this.maxFlingDelay = l2;
    }
}

