/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Input$InputStringValidator;
import com.badlogic.gdx.Input$OnscreenKeyboardType;
import com.badlogic.gdx.input.TextInputWrapper;

public class NativeInputConfiguration {
    private Input$OnscreenKeyboardType type = Input$OnscreenKeyboardType.Default;
    private boolean preventCorrection = false;
    private TextInputWrapper textInputWrapper;
    private boolean isMultiLine = false;
    private Integer maxLength;
    private Input$InputStringValidator validator;
    private String placeholder = "";
    private boolean showPasswordButton = false;
    private String[] autoComplete = null;

    public Input$OnscreenKeyboardType getType() {
        return this.type;
    }

    public NativeInputConfiguration setType(Input$OnscreenKeyboardType input$OnscreenKeyboardType) {
        this.type = input$OnscreenKeyboardType;
        return this;
    }

    public boolean isPreventCorrection() {
        return this.preventCorrection;
    }

    public NativeInputConfiguration setPreventCorrection(boolean bl) {
        this.preventCorrection = bl;
        return this;
    }

    public TextInputWrapper getTextInputWrapper() {
        return this.textInputWrapper;
    }

    public NativeInputConfiguration setTextInputWrapper(TextInputWrapper textInputWrapper) {
        this.textInputWrapper = textInputWrapper;
        return this;
    }

    public boolean isMultiLine() {
        return this.isMultiLine;
    }

    public NativeInputConfiguration setMultiLine(boolean bl) {
        this.isMultiLine = bl;
        return this;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public NativeInputConfiguration setMaxLength(Integer n2) {
        this.maxLength = n2;
        return this;
    }

    public Input$InputStringValidator getValidator() {
        return this.validator;
    }

    public NativeInputConfiguration setValidator(Input$InputStringValidator input$InputStringValidator) {
        this.validator = input$InputStringValidator;
        return this;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public NativeInputConfiguration setPlaceholder(String string) {
        this.placeholder = string;
        return this;
    }

    public boolean isShowPasswordButton() {
        return this.showPasswordButton;
    }

    public NativeInputConfiguration setShowPasswordButton(boolean bl) {
        this.showPasswordButton = bl;
        return this;
    }

    public String[] getAutoComplete() {
        return this.autoComplete;
    }

    public NativeInputConfiguration setAutoComplete(String[] stringArray) {
        this.autoComplete = stringArray;
        return this;
    }

    public void validate() {
        String string = null;
        if (this.type == null) {
            string = "OnscreenKeyboardType needs to be non null";
        }
        if (this.textInputWrapper == null) {
            string = "TextInputWrapper needs to be non null";
        }
        if (this.showPasswordButton && this.type != Input$OnscreenKeyboardType.Password) {
            string = "ShowPasswordButton only works with OnscreenKeyboardType.Password";
        }
        if (this.placeholder == null) {
            string = "Placeholder needs to be non null";
        }
        if (this.autoComplete != null && this.type != Input$OnscreenKeyboardType.Default) {
            string = "AutoComplete should only be used with OnscreenKeyboardType.Default";
        }
        if (this.autoComplete != null && this.isMultiLine) {
            string = "AutoComplete shouldn't be used with multiline";
        }
        if (string != null) {
            throw new IllegalArgumentException("NativeInputConfiguration validation failed: " + string);
        }
    }
}

