/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.Input$KeyboardHeightObserver;
import com.badlogic.gdx.Input$OnscreenKeyboardType;
import com.badlogic.gdx.Input$Orientation;
import com.badlogic.gdx.Input$Peripheral;
import com.badlogic.gdx.Input$TextInputListener;
import com.badlogic.gdx.Input$VibrationType;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.input.NativeInputConfiguration;
import com.badlogic.gdx.input.RemoteInput$EventTrigger;
import com.badlogic.gdx.input.RemoteInput$KeyEvent;
import com.badlogic.gdx.input.RemoteInput$RemoteInputListener;
import com.badlogic.gdx.input.RemoteInput$TouchEvent;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class RemoteInput
implements Input,
Runnable {
    private static final int MAX_TOUCHES = 20;
    public static int DEFAULT_PORT = 8190;
    private ServerSocket serverSocket;
    private float[] accel = new float[3];
    private float[] gyrate = new float[3];
    private float[] compass = new float[3];
    private boolean multiTouch = false;
    private float remoteWidth = 0.0f;
    private float remoteHeight = 0.0f;
    private boolean connected = false;
    private RemoteInput$RemoteInputListener listener;
    int keyCount = 0;
    boolean[] keys = new boolean[256];
    boolean keyJustPressed = false;
    boolean[] justPressedKeys = new boolean[256];
    int[] deltaX = new int[20];
    int[] deltaY = new int[20];
    int[] touchX = new int[20];
    int[] touchY = new int[20];
    boolean[] isTouched = new boolean[20];
    boolean justTouched = false;
    InputProcessor processor = null;
    private final int port;
    public final String[] ips;

    public RemoteInput() {
        this(DEFAULT_PORT);
    }

    public RemoteInput(RemoteInput$RemoteInputListener remoteInput$RemoteInputListener) {
        this(DEFAULT_PORT, remoteInput$RemoteInputListener);
    }

    public RemoteInput(int n2) {
        this(n2, null);
    }

    public RemoteInput(int n2, RemoteInput$RemoteInputListener inetAddressArray) {
        this.listener = inetAddressArray;
        try {
            this.port = n2;
            this.serverSocket = new ServerSocket(n2);
            inetAddressArray = new Thread(this);
            inetAddressArray.setDaemon(true);
            inetAddressArray.start();
            inetAddressArray = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            this.ips = new String[inetAddressArray.length];
            for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                this.ips[i2] = inetAddressArray[i2].getHostAddress();
            }
            return;
        }
        catch (Exception exception) {
            throw new GdxRuntimeException("Couldn't open listening socket at port '" + n2 + "'", exception);
        }
    }

    @Override
    public void run() {
        while (true) {
            Object object;
            try {
                this.connected = false;
                if (this.listener != null) {
                    this.listener.onDisconnected();
                }
                System.out.println("listening, port " + this.port);
                object = this.serverSocket.accept();
                ((Socket)object).setTcpNoDelay(true);
                ((Socket)object).setSoTimeout(3000);
                this.connected = true;
                if (this.listener != null) {
                    this.listener.onConnected();
                }
                object = new DataInputStream(((Socket)object).getInputStream());
                this.multiTouch = ((DataInputStream)object).readBoolean();
                while (true) {
                    int n2 = ((DataInputStream)object).readInt();
                    RemoteInput$KeyEvent remoteInput$KeyEvent = null;
                    RemoteInput$TouchEvent remoteInput$TouchEvent = null;
                    switch (n2) {
                        case 6: {
                            this.accel[0] = ((DataInputStream)object).readFloat();
                            this.accel[1] = ((DataInputStream)object).readFloat();
                            this.accel[2] = ((DataInputStream)object).readFloat();
                            break;
                        }
                        case 7: {
                            this.compass[0] = ((DataInputStream)object).readFloat();
                            this.compass[1] = ((DataInputStream)object).readFloat();
                            this.compass[2] = ((DataInputStream)object).readFloat();
                            break;
                        }
                        case 8: {
                            this.remoteWidth = ((DataInputStream)object).readFloat();
                            this.remoteHeight = ((DataInputStream)object).readFloat();
                            break;
                        }
                        case 9: {
                            this.gyrate[0] = ((DataInputStream)object).readFloat();
                            this.gyrate[1] = ((DataInputStream)object).readFloat();
                            this.gyrate[2] = ((DataInputStream)object).readFloat();
                            break;
                        }
                        case 0: {
                            remoteInput$KeyEvent = new RemoteInput$KeyEvent(this);
                            new RemoteInput$KeyEvent(this).keyCode = ((DataInputStream)object).readInt();
                            remoteInput$KeyEvent.type = 0;
                            break;
                        }
                        case 1: {
                            remoteInput$KeyEvent = new RemoteInput$KeyEvent(this);
                            new RemoteInput$KeyEvent(this).keyCode = ((DataInputStream)object).readInt();
                            remoteInput$KeyEvent.type = 1;
                            break;
                        }
                        case 2: {
                            remoteInput$KeyEvent = new RemoteInput$KeyEvent(this);
                            new RemoteInput$KeyEvent(this).keyChar = ((DataInputStream)object).readChar();
                            remoteInput$KeyEvent.type = 2;
                            break;
                        }
                        case 3: {
                            remoteInput$TouchEvent = new RemoteInput$TouchEvent(this);
                            new RemoteInput$TouchEvent(this).x = (int)((float)((DataInputStream)object).readInt() / this.remoteWidth * (float)Gdx.graphics.getWidth());
                            remoteInput$TouchEvent.y = (int)((float)((DataInputStream)object).readInt() / this.remoteHeight * (float)Gdx.graphics.getHeight());
                            remoteInput$TouchEvent.pointer = ((DataInputStream)object).readInt();
                            remoteInput$TouchEvent.type = 0;
                            break;
                        }
                        case 4: {
                            remoteInput$TouchEvent = new RemoteInput$TouchEvent(this);
                            new RemoteInput$TouchEvent(this).x = (int)((float)((DataInputStream)object).readInt() / this.remoteWidth * (float)Gdx.graphics.getWidth());
                            remoteInput$TouchEvent.y = (int)((float)((DataInputStream)object).readInt() / this.remoteHeight * (float)Gdx.graphics.getHeight());
                            remoteInput$TouchEvent.pointer = ((DataInputStream)object).readInt();
                            remoteInput$TouchEvent.type = 1;
                            break;
                        }
                        case 5: {
                            remoteInput$TouchEvent = new RemoteInput$TouchEvent(this);
                            new RemoteInput$TouchEvent(this).x = (int)((float)((DataInputStream)object).readInt() / this.remoteWidth * (float)Gdx.graphics.getWidth());
                            remoteInput$TouchEvent.y = (int)((float)((DataInputStream)object).readInt() / this.remoteHeight * (float)Gdx.graphics.getHeight());
                            remoteInput$TouchEvent.pointer = ((DataInputStream)object).readInt();
                            remoteInput$TouchEvent.type = 2;
                        }
                    }
                    Gdx.app.postRunnable(new RemoteInput$EventTrigger(this, remoteInput$TouchEvent, remoteInput$KeyEvent));
                }
            }
            catch (IOException iOException) {
                object = iOException;
                iOException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public float getAccelerometerX() {
        return this.accel[0];
    }

    @Override
    public float getAccelerometerY() {
        return this.accel[1];
    }

    @Override
    public float getAccelerometerZ() {
        return this.accel[2];
    }

    @Override
    public float getGyroscopeX() {
        return this.gyrate[0];
    }

    @Override
    public float getGyroscopeY() {
        return this.gyrate[1];
    }

    @Override
    public float getGyroscopeZ() {
        return this.gyrate[2];
    }

    @Override
    public int getMaxPointers() {
        return 20;
    }

    @Override
    public int getX() {
        return this.touchX[0];
    }

    @Override
    public int getX(int n2) {
        return this.touchX[n2];
    }

    @Override
    public int getY() {
        return this.touchY[0];
    }

    @Override
    public int getY(int n2) {
        return this.touchY[n2];
    }

    @Override
    public boolean isTouched() {
        return this.isTouched[0];
    }

    @Override
    public boolean justTouched() {
        return this.justTouched;
    }

    @Override
    public boolean isTouched(int n2) {
        return this.isTouched[n2];
    }

    @Override
    public float getPressure() {
        return this.getPressure(0);
    }

    @Override
    public float getPressure(int n2) {
        if (this.isTouched(n2)) {
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    public boolean isButtonPressed(int n2) {
        if (n2 != 0) {
            return false;
        }
        for (n2 = 0; n2 < this.isTouched.length; ++n2) {
            if (!this.isTouched[n2]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isButtonJustPressed(int n2) {
        return n2 == 0 && this.justTouched;
    }

    @Override
    public boolean isKeyPressed(int n2) {
        if (n2 == -1) {
            return this.keyCount > 0;
        }
        if (n2 < 0 || n2 > 255) {
            return false;
        }
        return this.keys[n2];
    }

    @Override
    public boolean isKeyJustPressed(int n2) {
        if (n2 == -1) {
            return this.keyJustPressed;
        }
        if (n2 < 0 || n2 > 255) {
            return false;
        }
        return this.justPressedKeys[n2];
    }

    @Override
    public void getTextInput(Input$TextInputListener input$TextInputListener, String string, String string2, String string3) {
        Gdx.app.getInput().getTextInput(input$TextInputListener, string, string2, string3);
    }

    @Override
    public void getTextInput(Input$TextInputListener input$TextInputListener, String string, String string2, String string3, Input$OnscreenKeyboardType input$OnscreenKeyboardType) {
        Gdx.app.getInput().getTextInput(input$TextInputListener, string, string2, string3, input$OnscreenKeyboardType);
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean bl) {
    }

    @Override
    public void setOnscreenKeyboardVisible(boolean bl, Input$OnscreenKeyboardType input$OnscreenKeyboardType) {
    }

    @Override
    public void openTextInputField(NativeInputConfiguration nativeInputConfiguration) {
    }

    @Override
    public void closeTextInputField(boolean bl) {
    }

    @Override
    public void setKeyboardHeightObserver(Input$KeyboardHeightObserver input$KeyboardHeightObserver) {
    }

    @Override
    public void vibrate(int n2) {
    }

    @Override
    public void vibrate(int n2, boolean bl) {
    }

    @Override
    public void vibrate(int n2, int n3, boolean bl) {
    }

    @Override
    public void vibrate(Input$VibrationType input$VibrationType) {
    }

    @Override
    public float getAzimuth() {
        return this.compass[0];
    }

    @Override
    public float getPitch() {
        return this.compass[1];
    }

    @Override
    public float getRoll() {
        return this.compass[2];
    }

    @Override
    public void setCatchKey(int n2, boolean bl) {
    }

    @Override
    public boolean isCatchKey(int n2) {
        return false;
    }

    @Override
    public void setInputProcessor(InputProcessor inputProcessor) {
        this.processor = inputProcessor;
    }

    @Override
    public InputProcessor getInputProcessor() {
        return this.processor;
    }

    public String[] getIPs() {
        return this.ips;
    }

    @Override
    public boolean isPeripheralAvailable(Input$Peripheral input$Peripheral) {
        if (input$Peripheral == Input$Peripheral.Accelerometer) {
            return true;
        }
        if (input$Peripheral == Input$Peripheral.Compass) {
            return true;
        }
        if (input$Peripheral == Input$Peripheral.MultitouchScreen) {
            return this.multiTouch;
        }
        return false;
    }

    @Override
    public int getRotation() {
        return 0;
    }

    @Override
    public Input$Orientation getNativeOrientation() {
        return Input$Orientation.Landscape;
    }

    @Override
    public void setCursorCatched(boolean bl) {
    }

    @Override
    public boolean isCursorCatched() {
        return false;
    }

    @Override
    public int getDeltaX() {
        return this.deltaX[0];
    }

    @Override
    public int getDeltaX(int n2) {
        return this.deltaX[n2];
    }

    @Override
    public int getDeltaY() {
        return this.deltaY[0];
    }

    @Override
    public int getDeltaY(int n2) {
        return this.deltaY[n2];
    }

    @Override
    public void setCursorPosition(int n2, int n3) {
    }

    @Override
    public long getCurrentEventTime() {
        return 0L;
    }

    @Override
    public void getRotationMatrix(float[] fArray) {
    }
}

