/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input$Peripheral;
import com.badlogic.gdx.InputProcessor;
import java.io.DataOutputStream;
import java.net.Socket;

public class RemoteSender
implements InputProcessor {
    private DataOutputStream out;
    private boolean connected = false;
    public static final int KEY_DOWN = 0;
    public static final int KEY_UP = 1;
    public static final int KEY_TYPED = 2;
    public static final int TOUCH_DOWN = 3;
    public static final int TOUCH_UP = 4;
    public static final int TOUCH_DRAGGED = 5;
    public static final int ACCEL = 6;
    public static final int COMPASS = 7;
    public static final int SIZE = 8;
    public static final int GYRO = 9;

    public RemoteSender(String string, int n2) {
        try {
            Socket socket = new Socket(string, n2);
            socket.setTcpNoDelay(true);
            socket.setSoTimeout(3000);
            this.out = new DataOutputStream(socket.getOutputStream());
            this.out.writeBoolean(Gdx.input.isPeripheralAvailable(Input$Peripheral.MultitouchScreen));
            this.connected = true;
            Gdx.input.setInputProcessor(this);
            return;
        }
        catch (Exception exception) {
            Gdx.app.log("RemoteSender", "couldn't connect to " + string + ":" + n2);
            return;
        }
    }

    public void sendUpdate() {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return;
            }
        }
        try {
            this.out.writeInt(6);
            this.out.writeFloat(Gdx.input.getAccelerometerX());
            this.out.writeFloat(Gdx.input.getAccelerometerY());
            this.out.writeFloat(Gdx.input.getAccelerometerZ());
            this.out.writeInt(7);
            this.out.writeFloat(Gdx.input.getAzimuth());
            this.out.writeFloat(Gdx.input.getPitch());
            this.out.writeFloat(Gdx.input.getRoll());
            this.out.writeInt(8);
            this.out.writeFloat(Gdx.graphics.getWidth());
            this.out.writeFloat(Gdx.graphics.getHeight());
            this.out.writeInt(9);
            this.out.writeFloat(Gdx.input.getGyroscopeX());
            this.out.writeFloat(Gdx.input.getGyroscopeY());
            this.out.writeFloat(Gdx.input.getGyroscopeZ());
            return;
        }
        catch (Throwable throwable) {
            this.out = null;
            this.connected = false;
            return;
        }
    }

    @Override
    public boolean keyDown(int n2) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(0);
            this.out.writeInt(n2);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyUp(int n2) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(1);
            this.out.writeInt(n2);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char c2) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(2);
            this.out.writeChar(c2);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean touchDown(int n2, int n3, int n4, int n5) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(3);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(n4);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean touchUp(int n2, int n3, int n4, int n5) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(4);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(n4);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean touchCancelled(int n2, int n3, int n4, int n5) {
        return this.touchUp(n2, n3, n4, n5);
    }

    @Override
    public boolean touchDragged(int n2, int n3, int n4) {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            if (!this.connected) {
                return false;
            }
        }
        try {
            this.out.writeInt(5);
            this.out.writeInt(n2);
            this.out.writeInt(n3);
            this.out.writeInt(n4);
        }
        catch (Throwable throwable) {
            RemoteSender remoteSender2 = this;
            synchronized (remoteSender2) {
                this.connected = false;
            }
        }
        return false;
    }

    @Override
    public boolean mouseMoved(int n2, int n3) {
        return false;
    }

    @Override
    public boolean scrolled(float f2, float f3) {
        return false;
    }

    public boolean isConnected() {
        RemoteSender remoteSender = this;
        synchronized (remoteSender) {
            return this.connected;
        }
    }
}

