/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureParameter;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.Texture$TextureFilter;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureAtlas$AtlasRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.tiled.AtlasTmxMapLoader$AtlasResolver;
import com.badlogic.gdx.maps.tiled.AtlasTmxMapLoader$AtlasResolver$AssetManagerAtlasResolver;
import com.badlogic.gdx.maps.tiled.AtlasTmxMapLoader$AtlasResolver$DirectAtlasResolver;
import com.badlogic.gdx.maps.tiled.AtlasTmxMapLoader$AtlasTiledMapLoaderParameters;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader$Element;
import java.util.Iterator;

public class AtlasTmxMapLoader
extends BaseTmxMapLoader<AtlasTmxMapLoader$AtlasTiledMapLoaderParameters> {
    protected Array<Texture> trackedTextures = new Array();
    protected AtlasTmxMapLoader$AtlasResolver atlasResolver;

    public AtlasTmxMapLoader() {
        super(new InternalFileHandleResolver());
    }

    public AtlasTmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    public TiledMap load(String string) {
        return this.load(string, new AtlasTmxMapLoader$AtlasTiledMapLoaderParameters());
    }

    public TiledMap load(String object, AtlasTmxMapLoader$AtlasTiledMapLoaderParameters atlasTmxMapLoader$AtlasTiledMapLoaderParameters) {
        object = this.resolve((String)object);
        this.root = this.xml.parse((FileHandle)object);
        Object object2 = this.getAtlasFileHandle((FileHandle)object);
        object2 = new TextureAtlas((FileHandle)object2);
        this.atlasResolver = new AtlasTmxMapLoader$AtlasResolver$DirectAtlasResolver((TextureAtlas)object2);
        object = this.loadTiledMap((FileHandle)object, atlasTmxMapLoader$AtlasTiledMapLoaderParameters, this.atlasResolver);
        ((TiledMap)object).setOwnedResources(new Array<TextureAtlas>(new TextureAtlas[]{object2}));
        this.setTextureFilters(atlasTmxMapLoader$AtlasTiledMapLoaderParameters.textureMinFilter, atlasTmxMapLoader$AtlasTiledMapLoaderParameters.textureMagFilter);
        return object;
    }

    @Override
    public void loadAsync(AssetManager assetManager, String object, FileHandle fileHandle, AtlasTmxMapLoader$AtlasTiledMapLoaderParameters atlasTmxMapLoader$AtlasTiledMapLoaderParameters) {
        object = this.getAtlasFileHandle(fileHandle);
        this.atlasResolver = new AtlasTmxMapLoader$AtlasResolver$AssetManagerAtlasResolver(assetManager, ((FileHandle)object).path());
        this.map = this.loadTiledMap(fileHandle, atlasTmxMapLoader$AtlasTiledMapLoaderParameters, this.atlasResolver);
    }

    @Override
    public TiledMap loadSync(AssetManager assetManager, String string, FileHandle fileHandle, AtlasTmxMapLoader$AtlasTiledMapLoaderParameters atlasTmxMapLoader$AtlasTiledMapLoaderParameters) {
        if (atlasTmxMapLoader$AtlasTiledMapLoaderParameters != null) {
            this.setTextureFilters(atlasTmxMapLoader$AtlasTiledMapLoaderParameters.textureMinFilter, atlasTmxMapLoader$AtlasTiledMapLoaderParameters.textureMagFilter);
        }
        return this.map;
    }

    @Override
    protected Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle fileHandle, TextureLoader$TextureParameter object) {
        object = new Array();
        if ((fileHandle = this.getAtlasFileHandle(fileHandle)) != null) {
            ((Array)object).add(new AssetDescriptor<TextureAtlas>(fileHandle, TextureAtlas.class));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addStaticTiles(FileHandle object, ImageResolver object2, TiledMapTileSet tiledMapTileSet, XmlReader$Element object32, Array<XmlReader$Element> object4, String object52, int n2, int n3, int n4, int n5, int n6, String string, int n7, int n8, String string2, int n9, int n10, FileHandle fileHandle) {
        TextureAtlas$AtlasRegion textureAtlas$AtlasRegion;
        void var14_24;
        void var13_23;
        void var7_16;
        void var10_20;
        void var11_21;
        void var9_19;
        void var8_17;
        void var17_27;
        void var16_26;
        void var15_25;
        void var6_11;
        object = this.atlasResolver.getAtlas();
        object2 = var6_11;
        for (Texture texture : ((TextureAtlas)object).getTextures()) {
            this.trackedTextures.add(texture);
        }
        MapProperties mapProperties = tiledMapTileSet.getProperties();
        mapProperties.put("imagesource", var15_25);
        mapProperties.put("imagewidth", (int)var16_26);
        mapProperties.put("imageheight", (int)var17_27);
        mapProperties.put("tilewidth", (int)var8_17);
        mapProperties.put("tileheight", (int)var9_19);
        mapProperties.put("margin", (int)var11_21);
        mapProperties.put("spacing", (int)var10_20);
        if (var15_25 != null && var15_25.length() > 0) {
            void var6_14 = var7_16 + var16_26 / var8_17 * (var17_27 / var9_19) - true;
            for (TextureAtlas$AtlasRegion textureAtlas$AtlasRegion2 : ((TextureAtlas)object).findRegions((String)object2)) {
                if (textureAtlas$AtlasRegion2 == null || (var8_17 = var7_16 + textureAtlas$AtlasRegion2.index) < var7_16 || var8_17 > var6_14) continue;
                this.addStaticTiledMapTile(tiledMapTileSet, textureAtlas$AtlasRegion2, (int)var8_17, (float)var13_23, (float)var14_24);
            }
        }
        Iterator iterator = ((Array)((Object)textureAtlas$AtlasRegion)).iterator();
        while (iterator.hasNext()) {
            object2 = (XmlReader$Element)iterator.next();
            void var4_9 = var7_16 + ((XmlReader$Element)object2).getIntAttribute("id", 0);
            TiledMapTile tiledMapTile = tiledMapTileSet.getTile((int)var4_9);
            if (tiledMapTile != null || (object2 = ((XmlReader$Element)object2).getChildByName("image")) == null) continue;
            object2 = ((XmlReader$Element)object2).getAttribute("source");
            textureAtlas$AtlasRegion = ((TextureAtlas)object).findRegion((String)(object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46))));
            if (textureAtlas$AtlasRegion == null) {
                throw new GdxRuntimeException("Tileset atlasRegion not found: " + (String)object2);
            }
            this.addStaticTiledMapTile(tiledMapTileSet, textureAtlas$AtlasRegion, (int)var4_9, (float)var13_23, (float)var14_24);
        }
    }

    protected FileHandle getAtlasFileHandle(FileHandle fileHandle) {
        Object object = this.root.getChildByName("properties");
        String string = null;
        if (object != null) {
            for (XmlReader$Element xmlReader$Element : ((XmlReader$Element)object).getChildrenByName("property")) {
                String string2 = xmlReader$Element.getAttribute("name");
                if (!string2.startsWith("atlas")) continue;
                string = xmlReader$Element.getAttribute("value");
                break;
            }
        }
        if (string == null) {
            throw new GdxRuntimeException("The map is missing the 'atlas' property");
        }
        object = AtlasTmxMapLoader.getRelativeFileHandle(fileHandle, string);
        if (!((FileHandle)object).exists()) {
            throw new GdxRuntimeException("The 'atlas' file could not be found: '" + string + "'");
        }
        return object;
    }

    protected void setTextureFilters(Texture$TextureFilter texture$TextureFilter, Texture$TextureFilter texture$TextureFilter2) {
        for (Texture texture : this.trackedTextures) {
            texture.setFilter(texture$TextureFilter, texture$TextureFilter2);
        }
        this.trackedTextures.clear();
    }
}

