/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.maps.tiled;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.TextureLoader$TextureParameter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.maps.ImageResolver;
import com.badlogic.gdx.maps.Map;
import com.badlogic.gdx.maps.MapGroupLayer;
import com.badlogic.gdx.maps.MapLayer;
import com.badlogic.gdx.maps.MapLayers;
import com.badlogic.gdx.maps.MapObject;
import com.badlogic.gdx.maps.MapObjects;
import com.badlogic.gdx.maps.MapProperties;
import com.badlogic.gdx.maps.objects.EllipseMapObject;
import com.badlogic.gdx.maps.objects.PolygonMapObject;
import com.badlogic.gdx.maps.objects.PolylineMapObject;
import com.badlogic.gdx.maps.objects.RectangleMapObject;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader$1;
import com.badlogic.gdx.maps.tiled.BaseTmxMapLoader$Parameters;
import com.badlogic.gdx.maps.tiled.TiledMap;
import com.badlogic.gdx.maps.tiled.TiledMapImageLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTile;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer;
import com.badlogic.gdx.maps.tiled.TiledMapTileLayer$Cell;
import com.badlogic.gdx.maps.tiled.TiledMapTileSet;
import com.badlogic.gdx.maps.tiled.TiledMapTileSets;
import com.badlogic.gdx.maps.tiled.objects.TiledMapTileMapObject;
import com.badlogic.gdx.maps.tiled.tiles.AnimatedTiledMapTile;
import com.badlogic.gdx.maps.tiled.tiles.StaticTiledMapTile;
import com.badlogic.gdx.math.Polygon;
import com.badlogic.gdx.math.Polyline;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Base64Coder;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.IntMap;
import com.badlogic.gdx.utils.Null;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.XmlReader;
import com.badlogic.gdx.utils.XmlReader$Element;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public abstract class BaseTmxMapLoader<P extends BaseTmxMapLoader$Parameters>
extends AsynchronousAssetLoader<TiledMap, P> {
    protected static final int FLAG_FLIP_HORIZONTALLY = Integer.MIN_VALUE;
    protected static final int FLAG_FLIP_VERTICALLY = 0x40000000;
    protected static final int FLAG_FLIP_DIAGONALLY = 0x20000000;
    protected static final int MASK_CLEAR = -536870912;
    protected XmlReader xml = new XmlReader();
    protected XmlReader$Element root;
    protected boolean convertObjectToTileSpace;
    protected boolean flipY = true;
    protected int mapTileWidth;
    protected int mapTileHeight;
    protected int mapWidthInPixels;
    protected int mapHeightInPixels;
    protected TiledMap map;
    protected IntMap<MapObject> idToObject;
    protected Array<Runnable> runOnEndOfLoadTiled;

    public BaseTmxMapLoader(FileHandleResolver fileHandleResolver) {
        super(fileHandleResolver);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String object, FileHandle fileHandle, P p2) {
        this.root = this.xml.parse(fileHandle);
        object = new TextureLoader$TextureParameter();
        if (p2 != null) {
            ((TextureLoader$TextureParameter)object).genMipMaps = ((BaseTmxMapLoader$Parameters)p2).generateMipMaps;
            ((TextureLoader$TextureParameter)object).minFilter = ((BaseTmxMapLoader$Parameters)p2).textureMinFilter;
            ((TextureLoader$TextureParameter)object).magFilter = ((BaseTmxMapLoader$Parameters)p2).textureMagFilter;
        }
        return this.getDependencyAssetDescriptors(fileHandle, (TextureLoader$TextureParameter)object);
    }

    @Null
    public IntMap<MapObject> getIdToObject() {
        return this.idToObject;
    }

    protected abstract Array<AssetDescriptor> getDependencyAssetDescriptors(FileHandle var1, TextureLoader$TextureParameter var2);

    protected TiledMap loadTiledMap(FileHandle object3, P object2, ImageResolver imageResolver) {
        this.map = new TiledMap();
        this.idToObject = new IntMap();
        this.runOnEndOfLoadTiled = new Array();
        if (object2 != null) {
            this.convertObjectToTileSpace = ((BaseTmxMapLoader$Parameters)object2).convertObjectToTileSpace;
            this.flipY = ((BaseTmxMapLoader$Parameters)object2).flipY;
        } else {
            this.convertObjectToTileSpace = false;
            this.flipY = true;
        }
        object2 = this.root.getAttribute("orientation", null);
        int n2 = this.root.getIntAttribute("width", 0);
        int n3 = this.root.getIntAttribute("height", 0);
        int n4 = this.root.getIntAttribute("tilewidth", 0);
        int n5 = this.root.getIntAttribute("tileheight", 0);
        int n6 = this.root.getIntAttribute("hexsidelength", 0);
        String string = this.root.getAttribute("staggeraxis", null);
        String string2 = this.root.getAttribute("staggerindex", null);
        String string3 = this.root.getAttribute("backgroundcolor", null);
        MapProperties mapProperties = this.map.getProperties();
        if (object2 != null) {
            mapProperties.put("orientation", object2);
        }
        mapProperties.put("width", n2);
        mapProperties.put("height", n3);
        mapProperties.put("tilewidth", n4);
        mapProperties.put("tileheight", n5);
        mapProperties.put("hexsidelength", n6);
        if (string != null) {
            mapProperties.put("staggeraxis", string);
        }
        if (string2 != null) {
            mapProperties.put("staggerindex", string2);
        }
        if (string3 != null) {
            mapProperties.put("backgroundcolor", string3);
        }
        this.mapTileWidth = n4;
        this.mapTileHeight = n5;
        this.mapWidthInPixels = n2 * n4;
        this.mapHeightInPixels = n3 * n5;
        if (object2 != null && "staggered".equals(object2) && n3 > 1) {
            this.mapWidthInPixels += n4 / 2;
            this.mapHeightInPixels = this.mapHeightInPixels / 2 + n5 / 2;
        }
        if ((object2 = this.root.getChildByName("properties")) != null) {
            BaseTmxMapLoader baseTmxMapLoader = this;
            baseTmxMapLoader.loadProperties(baseTmxMapLoader.map.getProperties(), (XmlReader$Element)object2);
        }
        object2 = this.root.getChildrenByName("tileset");
        object2 = ((Array)object2).iterator();
        while (object2.hasNext()) {
            XmlReader$Element xmlReader$Element = (XmlReader$Element)object2.next();
            this.loadTileSet(xmlReader$Element, (FileHandle)object3, imageResolver);
            this.root.removeChild(xmlReader$Element);
        }
        n2 = this.root.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            XmlReader$Element xmlReader$Element = this.root.getChild(i2);
            BaseTmxMapLoader baseTmxMapLoader = this;
            baseTmxMapLoader.loadLayer(baseTmxMapLoader.map, this.map.getLayers(), xmlReader$Element, (FileHandle)object3, imageResolver);
        }
        Array<MapGroupLayer> array = this.map.getLayers().getByType(MapGroupLayer.class);
        while (array.notEmpty()) {
            MapGroupLayer mapGroupLayer = array.first();
            array.removeIndex(0);
            for (Object object3 : mapGroupLayer.getLayers()) {
                ((MapLayer)object3).setParallaxX(((MapLayer)object3).getParallaxX() * mapGroupLayer.getParallaxX());
                Object object4 = object3;
                ((MapLayer)object4).setParallaxY(((MapLayer)object4).getParallaxY() * mapGroupLayer.getParallaxY());
                if (!(object3 instanceof MapGroupLayer)) continue;
                array.add((MapGroupLayer)object3);
            }
        }
        for (Runnable runnable : this.runOnEndOfLoadTiled) {
            runnable.run();
        }
        this.runOnEndOfLoadTiled = null;
        return this.map;
    }

    protected void loadLayer(TiledMap tiledMap, MapLayers mapLayers, XmlReader$Element xmlReader$Element, FileHandle fileHandle, ImageResolver imageResolver) {
        String string = xmlReader$Element.getName();
        if (string.equals("group")) {
            this.loadLayerGroup(tiledMap, mapLayers, xmlReader$Element, fileHandle, imageResolver);
            return;
        }
        if (string.equals("layer")) {
            this.loadTileLayer(tiledMap, mapLayers, xmlReader$Element);
            return;
        }
        if (string.equals("objectgroup")) {
            this.loadObjectGroup(tiledMap, mapLayers, xmlReader$Element);
            return;
        }
        if (string.equals("imagelayer")) {
            this.loadImageLayer(tiledMap, mapLayers, xmlReader$Element, fileHandle, imageResolver);
        }
    }

    protected void loadLayerGroup(TiledMap tiledMap, MapLayers mapLayers, XmlReader$Element xmlReader$Element, FileHandle fileHandle, ImageResolver imageResolver) {
        if (xmlReader$Element.getName().equals("group")) {
            MapGroupLayer mapGroupLayer = new MapGroupLayer();
            this.loadBasicLayerInfo(mapGroupLayer, xmlReader$Element);
            XmlReader$Element xmlReader$Element2 = xmlReader$Element.getChildByName("properties");
            if (xmlReader$Element2 != null) {
                this.loadProperties(mapGroupLayer.getProperties(), xmlReader$Element2);
            }
            int n2 = xmlReader$Element.getChildCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                XmlReader$Element xmlReader$Element3 = xmlReader$Element.getChild(i2);
                this.loadLayer(tiledMap, mapGroupLayer.getLayers(), xmlReader$Element3, fileHandle, imageResolver);
            }
            for (MapLayer mapLayer : mapGroupLayer.getLayers()) {
                mapLayer.setParent(mapGroupLayer);
            }
            mapLayers.add(mapGroupLayer);
        }
    }

    protected void loadTileLayer(TiledMap object, MapLayers mapLayers, XmlReader$Element xmlReader$Element) {
        if (xmlReader$Element.getName().equals("layer")) {
            int n2 = xmlReader$Element.getIntAttribute("width", 0);
            int n3 = xmlReader$Element.getIntAttribute("height", 0);
            int n4 = ((Map)object).getProperties().get("tilewidth", Integer.class);
            int n5 = ((Map)object).getProperties().get("tileheight", Integer.class);
            TiledMapTileLayer tiledMapTileLayer = new TiledMapTileLayer(n2, n3, n4, n5);
            this.loadBasicLayerInfo(tiledMapTileLayer, xmlReader$Element);
            int[] nArray = BaseTmxMapLoader.getTileIds(xmlReader$Element, n2, n3);
            object = ((TiledMap)object).getTileSets();
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n6 = nArray[i2 * n2 + i3];
                    boolean bl = (n6 & Integer.MIN_VALUE) != 0;
                    boolean bl2 = (n6 & 0x40000000) != 0;
                    boolean bl3 = (n6 & 0x20000000) != 0;
                    TiledMapTile tiledMapTile = ((TiledMapTileSets)object).getTile(n6 & 0x1FFFFFFF);
                    if (tiledMapTile == null) continue;
                    TiledMapTileLayer$Cell tiledMapTileLayer$Cell = this.createTileLayerCell(bl, bl2, bl3);
                    tiledMapTileLayer$Cell.setTile(tiledMapTile);
                    tiledMapTileLayer.setCell(i3, this.flipY ? n3 - 1 - i2 : i2, tiledMapTileLayer$Cell);
                }
            }
            XmlReader$Element xmlReader$Element2 = xmlReader$Element.getChildByName("properties");
            if (xmlReader$Element2 != null) {
                this.loadProperties(tiledMapTileLayer.getProperties(), xmlReader$Element2);
            }
            mapLayers.add(tiledMapTileLayer);
        }
    }

    protected void loadObjectGroup(TiledMap tiledMap, MapLayers mapLayers, XmlReader$Element object) {
        if (((XmlReader$Element)object).getName().equals("objectgroup")) {
            MapLayer mapLayer = new MapLayer();
            this.loadBasicLayerInfo(mapLayer, (XmlReader$Element)object);
            XmlReader$Element xmlReader$Element2 = ((XmlReader$Element)object).getChildByName("properties");
            if (xmlReader$Element2 != null) {
                this.loadProperties(mapLayer.getProperties(), xmlReader$Element2);
            }
            for (XmlReader$Element xmlReader$Element2 : ((XmlReader$Element)object).getChildrenByName("object")) {
                this.loadObject(tiledMap, mapLayer, xmlReader$Element2);
            }
            mapLayers.add(mapLayer);
        }
    }

    protected void loadImageLayer(TiledMap tiledMap, MapLayers mapLayers, XmlReader$Element xmlReader$Element, FileHandle object, ImageResolver imageResolver) {
        if (xmlReader$Element.getName().equals("imagelayer")) {
            float f2 = xmlReader$Element.hasAttribute("offsetx") ? Float.parseFloat(xmlReader$Element.getAttribute("offsetx", "0")) : Float.parseFloat(xmlReader$Element.getAttribute("x", "0"));
            float f3 = xmlReader$Element.hasAttribute("offsety") ? Float.parseFloat(xmlReader$Element.getAttribute("offsety", "0")) : Float.parseFloat(xmlReader$Element.getAttribute("y", "0"));
            if (this.flipY) {
                f3 = (float)this.mapHeightInPixels - f3;
            }
            Object object2 = null;
            XmlReader$Element xmlReader$Element2 = xmlReader$Element.getChildByName("image");
            if (xmlReader$Element2 != null) {
                object2 = xmlReader$Element2.getAttribute("source");
                object = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)object, (String)object2);
                object2 = imageResolver.getImage(((FileHandle)object).path());
                f3 -= (float)((TextureRegion)object2).getRegionHeight();
            }
            object2 = new TiledMapImageLayer((TextureRegion)object2, f2, f3);
            this.loadBasicLayerInfo((MapLayer)object2, xmlReader$Element);
            object = xmlReader$Element.getChildByName("properties");
            if (object != null) {
                this.loadProperties(((MapLayer)object2).getProperties(), (XmlReader$Element)object);
            }
            mapLayers.add((MapLayer)object2);
        }
    }

    protected void loadBasicLayerInfo(MapLayer mapLayer, XmlReader$Element xmlReader$Element) {
        String string = xmlReader$Element.getAttribute("name", null);
        float f2 = Float.parseFloat(xmlReader$Element.getAttribute("opacity", "1.0"));
        boolean bl = xmlReader$Element.getIntAttribute("visible", 1) == 1;
        float f3 = xmlReader$Element.getFloatAttribute("offsetx", 0.0f);
        float f4 = xmlReader$Element.getFloatAttribute("offsety", 0.0f);
        float f5 = xmlReader$Element.getFloatAttribute("parallaxx", 1.0f);
        float f6 = xmlReader$Element.getFloatAttribute("parallaxy", 1.0f);
        mapLayer.setName(string);
        mapLayer.setOpacity(f2);
        mapLayer.setVisible(bl);
        mapLayer.setOffsetX(f3);
        mapLayer.setOffsetY(f4);
        mapLayer.setParallaxX(f5);
        mapLayer.setParallaxY(f6);
    }

    protected void loadObject(TiledMap tiledMap, MapLayer mapLayer, XmlReader$Element xmlReader$Element) {
        this.loadObject(tiledMap, mapLayer.getObjects(), xmlReader$Element, this.mapHeightInPixels);
    }

    protected void loadObject(TiledMap tiledMap, TiledMapTile tiledMapTile, XmlReader$Element xmlReader$Element) {
        this.loadObject(tiledMap, tiledMapTile.getObjects(), xmlReader$Element, tiledMapTile.getTextureRegion().getRegionHeight());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void loadObject(TiledMap var1_1, MapObjects var2_2, XmlReader$Element var3_3, float var4_4) {
        block17: {
            block18: {
                if (!var3_3.getName().equals("object")) break block17;
                var5_5 = null;
                var6_6 = this.convertObjectToTileSpace != false ? 1.0f / (float)this.mapTileWidth : 1.0f;
                var7_7 = this.convertObjectToTileSpace != false ? 1.0f / (float)this.mapTileHeight : 1.0f;
                var8_8 = var3_3.getFloatAttribute("x", 0.0f) * var6_6;
                var4_4 = (this.flipY != false ? var4_4 - var3_3.getFloatAttribute("y", 0.0f) : var3_3.getFloatAttribute("y", 0.0f)) * var7_7;
                var9_9 = var3_3.getFloatAttribute("width", 0.0f) * var6_6;
                var10_10 = var3_3.getFloatAttribute("height", 0.0f) * var7_7;
                if (var3_3.getChildCount() > 0) {
                    var11_11 /* !! */  = var3_3.getChildByName("polygon");
                    if (var11_11 /* !! */  != null) {
                        var11_11 /* !! */  = var11_11 /* !! */ .getAttribute("points").split(" ");
                        var12_15 = new float[var11_11 /* !! */ .length << 1];
                        for (var13_19 = 0; var13_19 < var11_11 /* !! */ .length; ++var13_19) {
                            var5_5 = var11_11 /* !! */ [var13_19].split(",");
                            var12_15[var13_19 << 1] = Float.parseFloat(var5_5[0]) * var6_6;
                            var12_15[(var13_19 << 1) + 1] = Float.parseFloat((String)var5_5[1]) * var7_7 * (float)(this.flipY != false ? -1 : 1);
                        }
                        var13_20 /* !! */  = new Polygon(var12_15);
                        var13_20 /* !! */ .setPosition(var8_8, var4_4);
                        var5_5 = new PolygonMapObject(var13_20 /* !! */ );
                    } else {
                        var11_11 /* !! */  = var3_3.getChildByName("polyline");
                        if (var11_11 /* !! */  != null) {
                            var11_11 /* !! */  = var11_11 /* !! */ .getAttribute("points").split(" ");
                            var12_15 = new float[var11_11 /* !! */ .length << 1];
                            for (var13_21 = 0; var13_21 < var11_11 /* !! */ .length; ++var13_21) {
                                var5_5 = var11_11 /* !! */ [var13_21].split(",");
                                var12_15[var13_21 << 1] = Float.parseFloat((String)var5_5[0]) * var6_6;
                                var12_15[(var13_21 << 1) + 1] = Float.parseFloat((String)var5_5[1]) * var7_7 * (float)(this.flipY != false ? -1 : 1);
                            }
                            var13_20 /* !! */  = new Polyline(var12_15);
                            var13_20 /* !! */ .setPosition(var8_8, var4_4);
                            var5_5 = new PolylineMapObject((Polyline)var13_20 /* !! */ );
                        } else if (var3_3.getChildByName("ellipse") != null) {
                            var5_5 = new EllipseMapObject(var8_8, this.flipY != false ? var4_4 - var10_10 : var4_4, var9_9, var10_10);
                        }
                    }
                }
                if (var5_5 == null) {
                    var11_11 /* !! */  = var3_3.getAttribute("gid", null);
                    if (var11_11 /* !! */  != null) {
                        var11_12 = (int)Long.parseLong((String)var11_11 /* !! */ );
                        var12_16 = (var11_12 & -2147483648) != 0;
                        var13_22 = (var11_12 & 0x40000000) != 0;
                        var5_5 = var1_1.getTileSets().getTile(var11_12 & 0x1FFFFFFF);
                        var1_1 = new TiledMapTileMapObject((TiledMapTile)var5_5, var12_16, var13_22);
                        var5_5 = var1_1.getTextureRegion();
                        var1_1.getProperties().put("gid", var11_12);
                        var1_1.setX(var8_8);
                        var1_1.setY(this.flipY != false ? var4_4 : var4_4 - var10_10);
                        var11_13 = var3_3.getFloatAttribute("width", var5_5.getRegionWidth());
                        var12_17 = var3_3.getFloatAttribute("height", var5_5.getRegionHeight());
                        var1_1.setScaleX(var6_6 * (var11_13 / (float)var5_5.getRegionWidth()));
                        var1_1.setScaleY(var7_7 * (var12_17 / (float)var5_5.getRegionHeight()));
                        var1_1.setRotation(var3_3.getFloatAttribute("rotation", 0.0f));
                        var5_5 = var1_1;
                    } else {
                        var5_5 = new RectangleMapObject(var8_8, this.flipY != false ? var4_4 - var10_10 : var4_4, var9_9, var10_10);
                    }
                }
                var5_5.setName(var3_3.getAttribute("name", null));
                var11_14 = var3_3.getAttribute("rotation", null);
                if (var11_14 != null) {
                    var5_5.getProperties().put("rotation", Float.valueOf(Float.parseFloat(var11_14)));
                }
                if ((var11_14 = var3_3.getAttribute("type", null)) != null) {
                    var5_5.getProperties().put("type", var11_14);
                }
                if ((var12_18 = var3_3.getIntAttribute("id", 0)) != 0) {
                    var5_5.getProperties().put("id", var12_18);
                }
                var5_5.getProperties().put("x", Float.valueOf(var8_8));
                if (!(var5_5 instanceof TiledMapTileMapObject)) break block18;
                v0 = var5_5.getProperties();
                v1 = "y";
                ** GOTO lbl-1000
            }
            v0 = var5_5.getProperties();
            v1 = "y";
            if (this.flipY) {
                v2 = var4_4 - var10_10;
            } else lbl-1000:
            // 2 sources

            {
                v2 = var4_4;
            }
            v0.put(v1, Float.valueOf(v2));
            var5_5.getProperties().put("width", Float.valueOf(var9_9));
            var5_5.getProperties().put("height", Float.valueOf(var10_10));
            var5_5.setVisible(var3_3.getIntAttribute("visible", 1) == 1);
            var13_23 = var3_3.getChildByName("properties");
            if (var13_23 != null) {
                this.loadProperties(var5_5.getProperties(), var13_23);
            }
            this.idToObject.put(var12_18, (MapObject)var5_5);
            var2_2.add((MapObject)var5_5);
        }
    }

    protected void loadProperties(MapProperties mapProperties, XmlReader$Element object) {
        if (object == null) {
            return;
        }
        if (((XmlReader$Element)object).getName().equals("properties")) {
            for (XmlReader$Element n2 : ((XmlReader$Element)object).getChildrenByName("property")) {
                String string = n2.getAttribute("name", null);
                String string2 = n2.getAttribute("value", null);
                String string3 = n2.getAttribute("type", null);
                if (string2 == null) {
                    string2 = n2.getText();
                }
                if (string3 != null && string3.equals("object")) {
                    try {
                        int exception = Integer.parseInt(string2);
                        BaseTmxMapLoader$1 baseTmxMapLoader$1 = new BaseTmxMapLoader$1(this, exception, mapProperties, string);
                        this.runOnEndOfLoadTiled.add(baseTmxMapLoader$1);
                        continue;
                    }
                    catch (Exception exception) {
                        throw new GdxRuntimeException("Error parsing property [\" + name + \"] of type \"object\" with value: [" + string2 + "]", exception);
                    }
                }
                Object object2 = this.castProperty(string, string2, string3);
                mapProperties.put(string, object2);
            }
        }
    }

    protected Object castProperty(String string, String string2, String string3) {
        if (string3 == null) {
            return string2;
        }
        if (string3.equals("int")) {
            return Integer.valueOf(string2);
        }
        if (string3.equals("float")) {
            return Float.valueOf(string2);
        }
        if (string3.equals("bool")) {
            return Boolean.valueOf(string2);
        }
        if (string3.equals("color")) {
            string = string2.substring(3);
            string2 = string2.substring(1, 3);
            return Color.valueOf(string + string2);
        }
        throw new GdxRuntimeException("Wrong type given for property " + string + ", given : " + string3 + ", supported : string, bool, int, float, color");
    }

    protected TiledMapTileLayer$Cell createTileLayerCell(boolean bl, boolean bl2, boolean bl3) {
        TiledMapTileLayer$Cell tiledMapTileLayer$Cell = new TiledMapTileLayer$Cell();
        if (bl3) {
            if (bl && bl2) {
                tiledMapTileLayer$Cell.setFlipHorizontally(true);
                tiledMapTileLayer$Cell.setRotation(3);
            } else if (bl) {
                tiledMapTileLayer$Cell.setRotation(3);
            } else if (bl2) {
                tiledMapTileLayer$Cell.setRotation(1);
            } else {
                tiledMapTileLayer$Cell.setFlipVertically(true);
                tiledMapTileLayer$Cell.setRotation(3);
            }
        } else {
            tiledMapTileLayer$Cell.setFlipHorizontally(bl);
            tiledMapTileLayer$Cell.setFlipVertically(bl2);
        }
        return tiledMapTileLayer$Cell;
    }

    public static int[] getTileIds(XmlReader$Element object, int n2, int n3) {
        Object object2 = ((XmlReader$Element)(object = ((XmlReader$Element)object).getChildByName("data"))).getAttribute("encoding", null);
        if (object2 == null) {
            throw new GdxRuntimeException("Unsupported encoding (XML) for TMX Layer Data");
        }
        int[] nArray = new int[n2 * n3];
        if (((String)object2).equals("csv")) {
            object2 = ((XmlReader$Element)object).getText().split(",");
            for (int i2 = 0; i2 < ((String[])object2).length; ++i2) {
                nArray[i2] = (int)Long.parseLong(object2[i2].trim());
            }
        } else if (((String)object2).equals("base64")) {
            object2 = null;
            try {
                String string = ((XmlReader$Element)object).getAttribute("compression", null);
                object = Base64Coder.decode(((XmlReader$Element)object).getText());
                if (string == null) {
                    object2 = new ByteArrayInputStream((byte[])object);
                } else if (string.equals("gzip")) {
                    object2 = new BufferedInputStream(new GZIPInputStream((InputStream)new ByteArrayInputStream((byte[])object), ((Object)object).length));
                } else if (string.equals("zlib")) {
                    object2 = new BufferedInputStream(new InflaterInputStream(new ByteArrayInputStream((byte[])object)));
                } else {
                    throw new GdxRuntimeException("Unrecognised compression (" + string + ") for TMX Layer Data");
                }
                object = new byte[4];
                for (int i3 = 0; i3 < n3; ++i3) {
                    for (int i4 = 0; i4 < n2; ++i4) {
                        int n4;
                        int n5;
                        for (n4 = ((InputStream)object2).read((byte[])object); n4 < ((Object)object).length && (n5 = ((InputStream)object2).read((byte[])object, n4, ((Object)object).length - n4)) != -1; n4 += n5) {
                        }
                        if (n4 != ((Object)object).length) {
                            throw new GdxRuntimeException("Error Reading TMX Layer Data: Premature end of tile data");
                        }
                        nArray[i3 * n2 + i4] = BaseTmxMapLoader.unsignedByteToInt((byte)object[0]) | BaseTmxMapLoader.unsignedByteToInt((byte)object[1]) << 8 | BaseTmxMapLoader.unsignedByteToInt((byte)object[2]) << 16 | BaseTmxMapLoader.unsignedByteToInt((byte)object[3]) << 24;
                    }
                }
            }
            catch (IOException iOException) {
                throw new GdxRuntimeException("Error Reading TMX Layer Data - IOException: " + iOException.getMessage());
            }
            finally {
                StreamUtils.closeQuietly((Closeable)object2);
            }
        } else {
            throw new GdxRuntimeException("Unrecognised encoding (" + (String)object2 + ") for TMX Layer Data");
        }
        return nArray;
    }

    protected static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    protected static FileHandle getRelativeFileHandle(FileHandle fileHandle, String object) {
        object = new StringTokenizer((String)object, "\\/");
        fileHandle = fileHandle.parent();
        while (((StringTokenizer)object).hasMoreElements()) {
            String string = ((StringTokenizer)object).nextToken();
            if (string.equals("..")) {
                fileHandle = fileHandle.parent();
                continue;
            }
            fileHandle = fileHandle.child(string);
        }
        return fileHandle;
    }

    /*
     * Unable to fully structure code
     */
    protected void loadTileSet(XmlReader$Element var1_1, FileHandle var2_2, ImageResolver var3_3) {
        if (var1_1.getName().equals("tileset")) {
            var4_4 = var1_1.getIntAttribute("firstgid", 1);
            var5_5 = "";
            var6_7 = 0;
            var7_9 = 0;
            var8_10 = null;
            var9_11 = var1_1.getAttribute("source", null);
            if (var9_11 != null) {
                var10_12 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)var2_2, var9_11);
                try {
                    var1_1 = this.xml.parse((FileHandle)var10_12);
                    var11_13 = var1_1.getChildByName("image");
                    if (var11_13 == null) ** GOTO lbl27
                    var5_5 = var11_13.getAttribute("source");
                    var6_7 = var11_13.getIntAttribute("width", 0);
                    var7_9 = var11_13.getIntAttribute("height", 0);
                    var8_10 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)var10_12, (String)var5_5);
                }
                catch (SerializationException v0) {
                    throw new GdxRuntimeException("Error parsing external tileset.");
                }
            } else {
                var10_12 = var1_1.getChildByName("image");
                if (var10_12 != null) {
                    var5_5 = var10_12.getAttribute("source");
                    var6_7 = var10_12.getIntAttribute("width", 0);
                    var7_9 = var10_12.getIntAttribute("height", 0);
                    var8_10 = BaseTmxMapLoader.getRelativeFileHandle((FileHandle)var2_2, (String)var5_5);
                }
            }
lbl27:
            // 5 sources

            var10_12 = var1_1.get("name", null);
            var11_14 = var1_1.getIntAttribute("tilewidth", 0);
            var12_15 = var1_1.getIntAttribute("tileheight", 0);
            var13_16 = var1_1.getIntAttribute("spacing", 0);
            var14_17 = var1_1.getIntAttribute("margin", 0);
            var15_18 = var1_1.getChildByName("tileoffset");
            var16_19 = 0;
            var17_20 = 0;
            if (var15_18 != null) {
                var16_19 = var15_18.getIntAttribute("x", 0);
                var17_20 = var15_18.getIntAttribute("y", 0);
            }
            var15_18 = new TiledMapTileSet();
            var15_18.setName((String)var10_12);
            var18_21 = var15_18.getProperties();
            var19_22 = var1_1.getChildByName("properties");
            if (var19_22 != null) {
                this.loadProperties((MapProperties)var18_21, var19_22);
            }
            var18_21.put("firstgid", var4_4);
            var18_21 = var1_1.getChildrenByName("tile");
            this.addStaticTiles((FileHandle)var2_2, (ImageResolver)var3_3, (TiledMapTileSet)var15_18, (XmlReader$Element)var1_1, (Array<XmlReader$Element>)var18_21, (String)var10_12, var4_4, var11_14, var12_15, var13_16, var14_17, var9_11, var16_19, var17_20, (String)var5_5, var6_7, var7_9, var8_10);
            var1_1 = new Array<T>();
            var2_2 = var18_21.iterator();
            while (var2_2.hasNext()) {
                var3_3 = (XmlReader$Element)var2_2.next();
                var5_6 = var3_3.getIntAttribute("id", 0);
                var5_5 = var15_18.getTile(var4_4 + var5_6);
                if (var5_5 == null) continue;
                var6_8 = this.createAnimatedTile((TiledMapTileSet)var15_18, (TiledMapTile)var5_5, (XmlReader$Element)var3_3, var4_4);
                if (var6_8 != null) {
                    var1_1.add(var6_8);
                    var5_5 = var6_8;
                }
                this.addTileProperties((TiledMapTile)var5_5, (XmlReader$Element)var3_3);
                this.addTileObjectGroup((TiledMapTile)var5_5, (XmlReader$Element)var3_3);
            }
            var2_2 = var1_1.iterator();
            while (var2_2.hasNext()) {
                var3_3 = (AnimatedTiledMapTile)var2_2.next();
                var15_18.putTile(var3_3.getId(), (TiledMapTile)var3_3);
            }
            this.map.getTileSets().addTileSet((TiledMapTileSet)var15_18);
        }
    }

    protected abstract void addStaticTiles(FileHandle var1, ImageResolver var2, TiledMapTileSet var3, XmlReader$Element var4, Array<XmlReader$Element> var5, String var6, int var7, int var8, int var9, int var10, int var11, String var12, int var13, int var14, String var15, int var16, int var17, FileHandle var18);

    protected void addTileProperties(TiledMapTile tiledMapTile, XmlReader$Element xmlReader$Element) {
        String string = xmlReader$Element.getAttribute("terrain", null);
        if (string != null) {
            tiledMapTile.getProperties().put("terrain", string);
        }
        if ((string = xmlReader$Element.getAttribute("probability", null)) != null) {
            tiledMapTile.getProperties().put("probability", string);
        }
        if ((string = xmlReader$Element.getAttribute("type", null)) != null) {
            tiledMapTile.getProperties().put("type", string);
        }
        if ((xmlReader$Element = xmlReader$Element.getChildByName("properties")) != null) {
            this.loadProperties(tiledMapTile.getProperties(), xmlReader$Element);
        }
    }

    protected void addTileObjectGroup(TiledMapTile tiledMapTile, XmlReader$Element object) {
        if ((object = ((XmlReader$Element)object).getChildByName("objectgroup")) != null) {
            for (XmlReader$Element xmlReader$Element : ((XmlReader$Element)object).getChildrenByName("object")) {
                BaseTmxMapLoader baseTmxMapLoader = this;
                baseTmxMapLoader.loadObject(baseTmxMapLoader.map, tiledMapTile, xmlReader$Element);
            }
        }
    }

    protected AnimatedTiledMapTile createAnimatedTile(TiledMapTileSet tiledMapTileSet, TiledMapTile tiledMapTile, XmlReader$Element object, int n2) {
        if ((object = ((XmlReader$Element)object).getChildByName("animation")) != null) {
            Array<StaticTiledMapTile> array = new Array<StaticTiledMapTile>();
            IntArray intArray = new IntArray();
            for (XmlReader$Element xmlReader$Element : ((XmlReader$Element)object).getChildrenByName("frame")) {
                array.add((StaticTiledMapTile)tiledMapTileSet.getTile(n2 + xmlReader$Element.getIntAttribute("tileid")));
                intArray.add(xmlReader$Element.getIntAttribute("duration"));
            }
            object = new AnimatedTiledMapTile(intArray, array);
            ((AnimatedTiledMapTile)object).setId(tiledMapTile.getId());
            return object;
        }
        return null;
    }

    protected void addStaticTiledMapTile(TiledMapTileSet tiledMapTileSet, TextureRegion object, int n2, float f2, float f3) {
        object = new StaticTiledMapTile((TextureRegion)object);
        object.setId(n2);
        object.setOffsetX(f2);
        object.setOffsetY(this.flipY ? -f3 : f3);
        tiledMapTileSet.putTile(n2, (TiledMapTile)object);
    }
}

